/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.chart;

import java.awt.Point;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import jp.co.sra.jun.opengl.chart.JunChartDataSheet;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StValueHolder;

public class JunChartData
extends JunAbstractObject {
    protected Object[][][] samples = null;
    protected int numberOfKeys = -1;
    protected JunChartDataSheet[] sheets = null;
    protected double[] valueRange = null;
    protected double minimumValue = Double.NaN;
    protected double maximumValue = Double.NaN;
    protected String[] keyLabels = null;

    public JunChartData() {
    }

    public JunChartData(Vector vector) {
        this();
        this.samples_(vector);
    }

    public JunChartData(Vector vector, int n) {
        this();
        this.samples_(vector);
        this.numberOfKeys_(n);
    }

    protected void initialize() {
        super.initialize();
        this.samples = null;
        this.numberOfKeys = -1;
        this.flushCaches();
    }

    public String[] keyLabels() {
        if (this.keyLabels == null) {
            this.keyLabels = this.defaultKeyLabels();
        }
        return this.keyLabels;
    }

    public void keyLabels_(String[] stringArray) {
        this.keyLabels = stringArray;
    }

    public int numberOfKeys() {
        if (this.numberOfKeys < 0) {
            this.numberOfKeys = this.defaultNumberOfKeys();
        }
        return this.numberOfKeys;
    }

    public void numberOfKeys_(int n) {
        this.numberOfKeys = n;
        this.flushCaches();
    }

    public Object[][][] samples() {
        return this.samples;
    }

    public void samples_(Object[][][] objectArray) {
        this.samples = objectArray;
    }

    public void samples_(Vector vector) {
        this.setSamples_(vector);
        this.flushCaches();
    }

    public JunChartDataSheet sheet() {
        if (this.sheets() == null) {
            return null;
        }
        return this.sheets()[0];
    }

    public JunChartDataSheet[] sheets() {
        if (this.sheets == null) {
            if (this.samples == null) {
                return null;
            }
            if (!this.hasValidSamples()) {
                return null;
            }
            int n = this.samples.length;
            this.sheets = new JunChartDataSheet[n];
            for (int i = 0; i < n; ++i) {
                this.sheets[i] = new JunChartDataSheet(this.samples[i], this.numberOfKeys());
            }
        }
        return this.sheets;
    }

    public double intervalOfValueRange() {
        return this.valueRange()[2];
    }

    public double maximumOfValueRange() {
        return this.valueRange()[1];
    }

    public double maximumValue() {
        if (Double.isNaN(this.maximumValue)) {
            final StValueHolder stValueHolder = new StValueHolder(Double.NEGATIVE_INFINITY);
            JunChartDataSheet[] junChartDataSheetArray = this.sheets();
            for (int i = 0; i < junChartDataSheetArray.length; ++i) {
                junChartDataSheetArray[i].valuesDo_(new StBlockClosure(){

                    public Object value_(Object object) {
                        double d = ((Number)object).doubleValue();
                        if (d > stValueHolder._doubleValue()) {
                            stValueHolder.value_(d);
                        }
                        return null;
                    }
                });
            }
            this.maximumValue = stValueHolder._doubleValue();
        }
        return this.maximumValue;
    }

    public double minimumOfValueRange() {
        return this.valueRange()[0];
    }

    public double minimumValue() {
        if (Double.isNaN(this.minimumValue)) {
            final StValueHolder stValueHolder = new StValueHolder(Double.MAX_VALUE);
            JunChartDataSheet[] junChartDataSheetArray = this.sheets();
            for (int i = 0; i < junChartDataSheetArray.length; ++i) {
                junChartDataSheetArray[i].valuesDo_(new StBlockClosure(){

                    public Object value_(Object object) {
                        double d = ((Number)object).doubleValue();
                        if (d < stValueHolder._doubleValue()) {
                            stValueHolder.value_(object);
                        }
                        return null;
                    }
                });
            }
            this.minimumValue = stValueHolder._doubleValue();
        }
        return this.minimumValue;
    }

    public double[] valueRange() {
        if (this.valueRange == null) {
            this.valueRange = this.defaultValueRange();
        }
        return this.valueRange;
    }

    public void valueRange_(double[] dArray) {
        this.valueRange = dArray;
    }

    public void valueRangeFrom_to_(double d, double d2) {
        this.valueRangeFrom_to_by_(d, d2, this.defaultIntervalFrom_to_(d, d2));
    }

    public void valueRangeFrom_to_by_(double d, double d2, double d3) {
        if (d >= d2) {
            return;
        }
        double[] dArray = new double[]{d, d2, d3};
        this.valueRange_(dArray);
    }

    protected double defaultIntervalFrom_to_(double d, double d2) {
        double d3 = d2 - d;
        double d4 = d3 / 10.0;
        if (d3 / (d4 = Math.pow(10.0, Math.floor(Math.log(d4) / Math.log(10.0) / 1.0) + 1.0)) < 5.0) {
            d4 /= 2.0;
        }
        return d4;
    }

    protected String[] defaultKeyLabels() {
        String[] stringArray = new String[this.sheet().rowSize()];
        JunChartDataSheet junChartDataSheet = this.sheet();
        if (junChartDataSheet.keySize() == 1) {
            for (int i = 0; i < junChartDataSheet.rowSize(); ++i) {
                Object object = junChartDataSheet.keyAtPoint_(new Point(i, 0));
                stringArray[i] = object.toString();
            }
        } else {
            for (int i = 0; i < junChartDataSheet.rowSize(); ++i) {
                stringArray[i] = String.valueOf(i);
            }
        }
        return stringArray;
    }

    protected int defaultNumberOfKeys() {
        return 0;
    }

    protected double[] defaultValueRange() {
        double d = this.maximumValue();
        double d2 = this.minimumValue();
        if (d2 > 0.0) {
            d2 = 0.0;
        }
        double[] dArray = new double[]{d2, d, this.defaultIntervalFrom_to_(d2, d)};
        return dArray;
    }

    protected void flushCaches() {
        this.sheets = null;
        this.minimumValue = Double.NaN;
        this.maximumValue = Double.NaN;
    }

    public double normalizeValue_(double d) {
        double[] dArray = new double[]{0.0, 1.0};
        return this.mapNumber_fromRange_toRange_(d, this.valueRange(), dArray);
    }

    public double denormalizeValue_(double d) {
        double[] dArray = new double[]{0.0, 1.0};
        return this.mapNumber_fromRange_toRange_(d, dArray, this.valueRange());
    }

    protected double mapNumber_fromRange_toRange_(double d, double[] dArray, double[] dArray2) {
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray2[0];
        double d5 = dArray2[1];
        return ((d - d2) * d5 - (d3 - d) * d4) / (d3 - d2);
    }

    public void printOn_(Writer writer) throws IOException {
        super.printOn_(writer);
        BufferedWriter bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        bufferedWriter.write(40);
        bufferedWriter.newLine();
        bufferedWriter.write("     samples :  ");
        if (this.samples == null) {
            bufferedWriter.write("null");
        } else {
            for (int i = 0; i < this.samples.length; ++i) {
                bufferedWriter.newLine();
                bufferedWriter.write("        ");
                Object[][] objectArray = this.samples[i];
                for (int j = 0; j < objectArray.length; ++j) {
                    Object[] objectArray2 = objectArray[j];
                    bufferedWriter.write(objectArray2[0].toString());
                    for (int k = 1; k < objectArray2.length; ++k) {
                        bufferedWriter.write(" ");
                        bufferedWriter.write(objectArray2[k].toString());
                    }
                    if (j >= objectArray.length - 1) continue;
                    bufferedWriter.write(", ");
                }
            }
        }
        bufferedWriter.newLine();
        bufferedWriter.write("     numberOfKeys :  ");
        bufferedWriter.write(String.valueOf(this.numberOfKeys));
        bufferedWriter.newLine();
        bufferedWriter.write(41);
        bufferedWriter.flush();
    }

    public boolean hasValidSamples() {
        if (this.samples == null) {
            return false;
        }
        for (int i = 0; i < this.samples.length; ++i) {
            Object[][] objectArray = this.samples[i];
            for (int j = 0; j < objectArray.length; ++j) {
                Object[] objectArray2 = objectArray[j];
                if (this.numberOfKeys <= objectArray2.length) continue;
                return false;
            }
        }
        return true;
    }

    private void setSamples_(Vector vector) {
        int n = vector.size();
        this.samples = new Object[n][][];
        for (int i = 0; i < n; ++i) {
            Vector vector2 = (Vector)vector.elementAt(i);
            int n2 = vector2.size();
            Object[][] objectArrayArray = new Object[n2][];
            vector2.copyInto((Object[])objectArrayArray);
            this.samples[i] = objectArrayArray;
        }
    }
}

