/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.goodies.font.JunFontModel;
import jp.co.sra.jun.opengl.chart.JunChartBand;
import jp.co.sra.jun.opengl.chart.JunChartBar;
import jp.co.sra.jun.opengl.chart.JunChartData;
import jp.co.sra.jun.opengl.chart.JunChartLine;
import jp.co.sra.jun.opengl.chart.JunChartPie;
import jp.co.sra.jun.opengl.chart.JunChartPlot;
import jp.co.sra.jun.opengl.chart.JunChartRadar;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StCheckBoxMenuItem;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuItem;

public abstract class JunChartAbstract
extends JunOpenGLDisplayModel {
    protected JunChartData data;
    protected HashMap visualObjectDictionary;
    protected JunOpenGL3dObject xAxis;
    protected JunOpenGL3dObject yAxis;
    protected JunOpenGL3dObject zAxis;
    protected Color axisColor;
    protected Color labelForegroundColor;
    protected Color labelBackgroundColor;
    protected Color[] colors;
    protected int colorIndex;
    protected double thickness;
    protected double intervalBetweenCharts;
    protected ArrayList extra3dObjects;
    protected double labelHeight;
    protected boolean useScalableLabels;

    public static Class ChartDataClass() {
        return JunChartData.class;
    }

    protected JunChartAbstract() {
    }

    protected JunChartAbstract(Vector vector) {
        this();
        this.data_(new JunChartData(vector));
    }

    protected JunChartAbstract(Vector vector, int n) {
        this();
        this.data_(new JunChartData(vector, n));
    }

    protected JunChartAbstract(JunChartData junChartData) {
        this();
        this.data_(junChartData);
    }

    protected void initialize() {
        super.initialize();
        this.initializeProjector();
        this.data = null;
        this.flushDisplayObject();
        this.flushAxes();
        this.axisColor = null;
        this.labelForegroundColor = null;
        this.labelBackgroundColor = null;
        this.colors = null;
        this.thickness = 0.1;
        this.intervalBetweenCharts = 0.3;
        this.extra3dObjects = null;
        this.labelHeight = 0.0;
        this.useScalableLabels = false;
    }

    protected void initializeLights() {
        for (int i = 0; i < this.displayLights().length; ++i) {
            this.displayLights()[i].beOff();
        }
    }

    protected void initializeProjector() {
        this.defaultEyePoint_(new Jun3dPoint(0.5, 0.5, 100.0));
        this.defaultSightPoint_(new Jun3dPoint(0.5, 0.5, 0.0));
        this.defaultUpVector_(new Jun3dPoint(0.0, 1.0, 0.0));
    }

    public JunChartData data() {
        try {
            if (this.data == null) {
                Class clazz = (Class)JunChartAbstract._Perform(this.getClass(), (String)"ChartDataClass");
                this.data = (JunChartData)((Object)JunChartAbstract._New((Class)clazz));
            }
            return this.data;
        }
        catch (Exception exception) {
            throw new SmalltalkException(exception);
        }
    }

    public void data_(JunChartData junChartData) {
        this.data = junChartData;
    }

    public JunOpenGL3dObject displayObject() {
        if (super.displayObject() == null) {
            super.displayObject_(this.asJunOpenGL3dObject());
        }
        return super.displayObject();
    }

    public ArrayList extra3dObjects() {
        return this.extra3dObjects;
    }

    public void extra3dObjects_(ArrayList arrayList) {
        this.extra3dObjects = arrayList;
    }

    public void extra3dObjects_(JunOpenGL3dObject[] junOpenGL3dObjectArray) {
        ArrayList<JunOpenGL3dObject> arrayList = null;
        if (junOpenGL3dObjectArray != null) {
            arrayList = new ArrayList<JunOpenGL3dObject>(junOpenGL3dObjectArray.length);
            for (int i = 0; i < junOpenGL3dObjectArray.length; ++i) {
                arrayList.add(junOpenGL3dObjectArray[i]);
            }
        }
        this.extra3dObjects_(arrayList);
    }

    public double intervalBetweenCharts() {
        return this.intervalBetweenCharts;
    }

    public void intervalBetweenCharts_(double d) {
        this.intervalBetweenCharts = d;
    }

    public void registerVisualObject_withValue_(JunOpenGL3dObject junOpenGL3dObject, Object object) {
        junOpenGL3dObject.name_(JunOpenGL3dObject.UniqueId());
        this.visualObjectDictionary().put(junOpenGL3dObject.name(), object);
    }

    public Object[][][] samples() {
        return this.data().samples();
    }

    public void samples_(Vector vector) {
        this.data().samples_(vector);
        this.flushDisplayObject();
    }

    public double thickness() {
        return this.thickness;
    }

    public void thickness_(double d) {
        this.thickness = d;
    }

    public Object valueForVisualObject_(JunOpenGL3dObject junOpenGL3dObject) {
        if (junOpenGL3dObject == null) {
            return null;
        }
        return this.visualObjectDictionary.get((Object)junOpenGL3dObject);
    }

    public void valueRangeFrom_to_(double d, double d2) {
        this.data().valueRangeFrom_to_(d, d2);
    }

    public void valueRangeFrom_to_(double d, double d2, double d3) {
        this.data().valueRangeFrom_to_by_(d, d2, d3);
    }

    public HashMap visualObjectDictionary() {
        if (this.visualObjectDictionary == null) {
            this.visualObjectDictionary = new HashMap();
        }
        return this.visualObjectDictionary;
    }

    public Color axisColor() {
        if (this.axisColor == null) {
            this.axisColor = this.defaultAxisColor();
        }
        return this.axisColor;
    }

    public void axisColor_(Color color) {
        this.axisColor = color;
    }

    public void hideXAxis() {
        this.xAxis = null;
        this.updateAxesMenuIndication();
        this.flushDisplayObject();
        this.changed_(JunChartAbstract.$((String)"presentation"));
    }

    public void hideYAxis() {
        this.yAxis = null;
        this.updateAxesMenuIndication();
        this.flushDisplayObject();
        this.changed_(JunChartAbstract.$((String)"presentation"));
    }

    public void hideZAxis() {
        this.zAxis = null;
        this.updateAxesMenuIndication();
        this.flushDisplayObject();
        this.changed_(JunChartAbstract.$((String)"presentation"));
    }

    public Color labelBackgroundColor() {
        if (this.labelBackgroundColor == null) {
            this.labelBackgroundColor = this.defaultLabelBackgroundColor();
        }
        return this.labelBackgroundColor;
    }

    public void labelBackgroundColor_(Color color) {
        this.labelBackgroundColor = color;
    }

    public Color labelForegroundColor() {
        if (this.labelForegroundColor == null) {
            this.labelForegroundColor = this.defaultLabelForegroundColor();
        }
        return this.labelForegroundColor;
    }

    public void labelForegroundColor_(Color color) {
        this.labelForegroundColor = color;
    }

    public double labelHeight() {
        if (this.labelHeight <= 0.0) {
            this.labelHeight = this.defaultLabelHeight();
        }
        return this.labelHeight;
    }

    public void labelHeight_(double d) {
        this.labelHeight = Math.max(0.01, Math.min(d, 1.0));
        if (this.hasXAxis()) {
            this.showXAxisWithLabels();
        }
        if (this.hasXAxis()) {
            this.showYAxisWithLabels();
        }
        if (this.hasZAxis()) {
            // empty if block
        }
    }

    public void showXAxis() {
        this.xAxis = this.createXAxis();
        this.updateAxesMenuIndication();
        this.flushDisplayObject();
        this.changed_(JunChartAbstract.$((String)"presentation"));
    }

    public void showXAxisWithLabels() {
        this.xAxis = new JunOpenGL3dCompoundObject(this.createXAxis(), this.createXAxisLabels());
        this.updateAxesMenuIndication();
        this.flushDisplayObject();
        this.changed_(JunChartAbstract.$((String)"presentation"));
    }

    public void showYAxis() {
        this.yAxis = this.createYAxis();
        this.updateAxesMenuIndication();
        this.flushDisplayObject();
        this.changed_(JunChartAbstract.$((String)"presentation"));
    }

    public void showYAxisWithLabels() {
        this.yAxis = new JunOpenGL3dCompoundObject(this.createYAxis(), this.createYAxisLabels());
        this.updateAxesMenuIndication();
        this.flushDisplayObject();
        this.changed_(JunChartAbstract.$((String)"presentation"));
    }

    public void showZAxis() {
        this.zAxis = this.createZAxis();
        this.updateAxesMenuIndication();
        this.flushDisplayObject();
        this.changed_(JunChartAbstract.$((String)"presentation"));
    }

    public void toggleXAxis() {
        if (this.hasXAxis()) {
            this.hideXAxis();
        } else {
            this.showXAxisWithLabels();
        }
    }

    public void toggleYAxis() {
        if (this.hasYAxis()) {
            this.hideYAxis();
        } else {
            this.showYAxisWithLabels();
        }
    }

    public void toggleZAxis() {
        if (this.hasZAxis()) {
            this.hideZAxis();
        } else {
            this.showZAxis();
        }
    }

    public void useScalableLabels() {
        this.useScalableLabels = true;
        if (this.hasXAxis()) {
            this.showXAxisWithLabels();
        }
        if (this.hasYAxis()) {
            this.showYAxisWithLabels();
        }
    }

    public void useTextureLabels() {
        this.useScalableLabels = false;
        if (this.hasXAxis()) {
            this.showXAxisWithLabels();
        }
        if (this.hasYAxis()) {
            this.showYAxisWithLabels();
        }
    }

    public JunOpenGL3dObject xAxis() {
        return this.xAxis;
    }

    public String[] xAxisLabels() {
        return this.data().keyLabels();
    }

    public void xAxisLabels_(String[] stringArray) {
        this.data().keyLabels_(stringArray);
    }

    public JunOpenGL3dObject yAxis() {
        return this.yAxis;
    }

    public JunOpenGL3dObject zAxis() {
        return this.zAxis;
    }

    public boolean hasXAxis() {
        return this.xAxis() != null;
    }

    public boolean hasYAxis() {
        return this.yAxis() != null;
    }

    public boolean hasZAxis() {
        return this.zAxis() != null;
    }

    public boolean hasScalableLabels() {
        return this.isScalableLabels() && (this.hasXAxis() || this.hasYAxis());
    }

    public boolean hasTexturedLabels() {
        return this.isTexturedLabels() && (this.hasXAxis() || this.hasYAxis());
    }

    public boolean isScalableLabels() {
        return this.useScalableLabels;
    }

    public boolean isTexturedLabels() {
        return !this.isScalableLabels();
    }

    public Color[] colors() {
        if (this.colors == null) {
            this.colors = this.defaultColors();
        }
        return this.colors;
    }

    public void colors_(Color[] colorArray) {
        this.colors = colorArray;
    }

    public Color nextColor() {
        Color[] colorArray = this.colors();
        if (colorArray == null || colorArray.length == 0) {
            return null;
        }
        if (this.colorIndex >= colorArray.length) {
            this.resetColorIndex();
        }
        return this.colors()[this.colorIndex++];
    }

    private void resetColorIndex() {
        this.colorIndex = 0;
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = this.createChart3dObject();
        if (this.xAxis != null) {
            junOpenGL3dCompoundObject.add_(this.xAxis);
        }
        if (this.yAxis != null) {
            junOpenGL3dCompoundObject.add_(this.yAxis);
        }
        if (this.zAxis != null) {
            junOpenGL3dCompoundObject.add_(this.zAxis);
        }
        if (this.extra3dObjects != null) {
            junOpenGL3dCompoundObject.addAll_(this.extra3dObjects);
        }
        return junOpenGL3dCompoundObject;
    }

    protected void _copyAttributes(JunChartAbstract junChartAbstract) {
        junChartAbstract.initialize();
        JunChartData junChartData = junChartAbstract.data();
        junChartData.samples_(this.data().samples());
        junChartData.numberOfKeys_(this.data().numberOfKeys());
        if (this.axisColor != null) {
            junChartAbstract.axisColor_(this.axisColor);
        }
        if (this.labelForegroundColor != null) {
            junChartAbstract.labelForegroundColor_(this.labelForegroundColor);
        }
        if (this.labelBackgroundColor != null) {
            junChartAbstract.labelBackgroundColor_(this.labelBackgroundColor);
        }
        junChartAbstract.intervalBetweenCharts_(this.intervalBetweenCharts);
        junChartAbstract.thickness_(this.thickness);
        if (this.colors != null) {
            junChartAbstract.colors_(this.colors);
        }
        if (this.hasXAxis()) {
            junChartAbstract.showXAxisWithLabels();
        }
        if (this.hasYAxis()) {
            junChartAbstract.showYAxisWithLabels();
        }
        if (this.hasZAxis()) {
            junChartAbstract.showZAxis();
        }
    }

    protected StBlockClosure defaultActionForPickedObject() {
        return new StBlockClosure();
    }

    protected Color defaultAxisColor() {
        return Color.blue;
    }

    protected Color[] defaultColors() {
        if (this.samples() == null) {
            Color[] colorArray = new Color[]{Color.black};
            return colorArray;
        }
        return this.defaultColors_(this.data().sheet().valueSize());
    }

    protected Color[] defaultColors_(int n) {
        Color[] colorArray = new Color[n];
        for (int i = 0; i < n; ++i) {
            colorArray[i] = Color.getHSBColor((float)((double)i / (double)n), 1.0f, 1.0f);
        }
        return colorArray;
    }

    protected Color defaultLabelBackgroundColor() {
        return Color.white;
    }

    protected Color defaultLabelForegroundColor() {
        return Color.black;
    }

    protected double defaultLabelHeight() {
        return 0.05;
    }

    protected void flushAxes() {
        this.xAxis = null;
        this.yAxis = null;
        this.zAxis = null;
    }

    protected void flushDisplayObject() {
        super.flushDisplayObject();
        this.visualObjectDictionary = null;
        this.resetColorIndex();
    }

    public JunOpenGL3dObject pick_with_(Jun2dPoint jun2dPoint, MouseEvent mouseEvent) {
        JunOpenGL3dObject junOpenGL3dObject = super.pick_with_(jun2dPoint, mouseEvent);
        if (junOpenGL3dObject != null) {
            this.pickedObject_(junOpenGL3dObject);
        }
        return junOpenGL3dObject;
    }

    protected void pickedObject_(JunOpenGL3dObject junOpenGL3dObject) {
        this.defaultActionForPickedObject().value_((Object)junOpenGL3dObject);
    }

    public void printOn_(Writer writer) throws IOException {
        super.printOn_(writer);
        BufferedWriter bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        bufferedWriter.write(40);
        bufferedWriter.newLine();
        bufferedWriter.write("     data :  ");
        if (this.data == null) {
            bufferedWriter.write("null");
        } else {
            this.data.printOn_(bufferedWriter);
        }
        bufferedWriter.newLine();
        bufferedWriter.write(41);
        bufferedWriter.flush();
    }

    public String windowTitle() {
        return JunChartAbstract.$String((String)"3D Chart");
    }

    public StMenuBar _menuBar() {
        if (this._menuBar == null) {
            this._menuBar = new StMenuBar();
            this._menuBar.add(this._createFileMenu());
            this._menuBar.add(this._createEditMenu());
            this._menuBar.add(this._createViewMenu());
            this._menuBar.add(this._createLightMenu());
            this._menuBar.add(this._createAxesMenu());
            this._menuBar.add(this._createMiscMenu());
        }
        return this._menuBar;
    }

    protected StMenu _createAxesMenu() {
        StMenu stMenu = new StMenu((Object)JunSystem.$String((String)"Axes"));
        stMenu.add((StMenuItem)new StCheckBoxMenuItem((Object)JunSystem.$String((String)"Show X-Axis"), JunChartAbstract.$((String)"toggleXAxisMenu"), (MenuListener)new MenuPerformer((StObject)this, "toggleXAxis")));
        stMenu.add((StMenuItem)new StCheckBoxMenuItem((Object)JunSystem.$String((String)"Show Y-Axis"), JunChartAbstract.$((String)"toggleYAxisMenu"), (MenuListener)new MenuPerformer((StObject)this, "toggleYAxis")));
        stMenu.add((StMenuItem)new StCheckBoxMenuItem((Object)JunSystem.$String((String)"Show Z-Axis"), JunChartAbstract.$((String)"toggleZAxisMenu"), (MenuListener)new MenuPerformer((StObject)this, "toggleZAxis")));
        return stMenu;
    }

    protected StMenu _createMiscMenu() {
        StMenu stMenu = new StMenu((Object)JunSystem.$String((String)"Misc"), JunChartAbstract.$((String)"miscMenu"));
        StMenu stMenu2 = new StMenu((Object)JunSystem.$String((String)"Texture"), JunChartAbstract.$((String)"textureMenu"));
        stMenu2.add(new StMenuItem((Object)JunSystem.$String((String)"From user..."), JunChartAbstract.$((String)"textureFromUserMenu"), (MenuListener)new MenuPerformer((StObject)this, "textureFromUser")));
        stMenu2.add(new StMenuItem((Object)JunSystem.$String((String)"From file..."), JunChartAbstract.$((String)"textureFromFileMenu"), (MenuListener)new MenuPerformer((StObject)this, "textureFromFile")));
        stMenu2.add(new StMenuItem((Object)JunSystem.$String((String)"Take away"), (MenuListener)new MenuPerformer((StObject)this, "textureTakeAway")));
        stMenu2.addSeparator();
        stMenu2.add((StMenuItem)new StCheckBoxMenuItem((Object)JunSystem.$String((String)"Linear approx."), JunChartAbstract.$((String)"textureLinearMenu"), (MenuListener)new MenuPerformer((StObject)this, "textureLinear")));
        stMenu2.add((StMenuItem)new StCheckBoxMenuItem((Object)JunSystem.$String((String)"Clamp"), JunChartAbstract.$((String)"textureClampMenu"), (MenuListener)new MenuPerformer((StObject)this, "textureClamp")));
        stMenu2.add((StMenuItem)new StCheckBoxMenuItem((Object)JunSystem.$String((String)"Modulate"), JunChartAbstract.$((String)"textureModulateMenu"), (MenuListener)new MenuPerformer((StObject)this, "textureModulate")));
        stMenu2.add((StMenuItem)new StCheckBoxMenuItem((Object)JunSystem.$String((String)"Mipmap"), JunChartAbstract.$((String)"textureMipmapMenu"), (MenuListener)new MenuPerformer((StObject)this, "textureMipmap")));
        stMenu.add((StMenuItem)stMenu2);
        StMenu stMenu3 = new StMenu((Object)JunSystem.$String((String)"Spawn"), JunChartAbstract.$((String)"spawnMenu"));
        stMenu3.add(new StMenuItem((Object)JunSystem.$String((String)"Band Chart"), (MenuListener)new MenuPerformer((StObject)this, "spawnBandChart")));
        stMenu3.add(new StMenuItem((Object)JunSystem.$String((String)"Bar Chart"), (MenuListener)new MenuPerformer((StObject)this, "spawnBarChart")));
        stMenu3.add(new StMenuItem((Object)JunSystem.$String((String)"Pie Chart"), (MenuListener)new MenuPerformer((StObject)this, "spawnPieChart")));
        stMenu3.add(new StMenuItem((Object)JunSystem.$String((String)"Plot Chart"), (MenuListener)new MenuPerformer((StObject)this, "spawnPlotChart")));
        stMenu3.add(new StMenuItem((Object)JunSystem.$String((String)"Line Chart"), (MenuListener)new MenuPerformer((StObject)this, "spawnLineChart")));
        stMenu3.add(new StMenuItem((Object)JunSystem.$String((String)"Radar Chart"), (MenuListener)new MenuPerformer((StObject)this, "spawnRadarChart")));
        stMenu.add((StMenuItem)stMenu3);
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Viewport"), JunChartAbstract.$((String)"viewportMenu"), (MenuListener)new MenuPerformer((StObject)this, "spawnViewport")));
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Bounds"), JunChartAbstract.$((String)"boundsMenu"), (MenuListener)new MenuPerformer((StObject)this, "showBounds")));
        return stMenu;
    }

    public void updateMenuIndication() {
        super.updateMenuIndication();
        this.updateAxesMenuIndication();
    }

    public void updateAxesMenuIndication() {
        StMenu stMenu = (StMenu)this._menuBar().atNameKey_(JunChartAbstract.$((String)"axesMenu"));
        if (stMenu == null) {
            return;
        }
        ((StCheckBoxMenuItem)stMenu.atNameKey_(JunChartAbstract.$((String)"toggleXAxisMenu"))).beSelected(this.hasXAxis());
        ((StCheckBoxMenuItem)stMenu.atNameKey_(JunChartAbstract.$((String)"toggleYAxisMenu"))).beSelected(this.hasYAxis());
        ((StCheckBoxMenuItem)stMenu.atNameKey_(JunChartAbstract.$((String)"toggleZAxisMenu"))).beSelected(this.hasZAxis());
    }

    public void updateMiscMenuIndication() {
        super.updateMiscMenuIndication();
        StMenu stMenu = (StMenu)this._menuBar().atNameKey_(JunChartAbstract.$((String)"miscMenu"));
        if (stMenu == null) {
            return;
        }
        boolean bl = !this.isEmpty();
        StMenuItem stMenuItem = stMenu.atNameKey_(JunChartAbstract.$((String)"spawnMenu"));
        if (stMenuItem != null) {
            stMenuItem.beEnabled(bl);
        }
    }

    public void spawnBandChart() {
        JunChartBand junChartBand = new JunChartBand();
        this._copyAttributes(junChartBand);
        junChartBand.open();
    }

    public void spawnBarChart() {
        JunChartBar junChartBar = new JunChartBar();
        this._copyAttributes(junChartBar);
        junChartBar.open();
    }

    public void spawnLineChart() {
        JunChartLine junChartLine = new JunChartLine();
        this._copyAttributes(junChartLine);
        junChartLine.open();
    }

    public void spawnPieChart() {
        JunChartPie junChartPie = new JunChartPie();
        this._copyAttributes(junChartPie);
        junChartPie.open();
    }

    public void spawnPlotChart() {
        JunChartPlot junChartPlot = new JunChartPlot();
        this._copyAttributes(junChartPlot);
        junChartPlot.open();
    }

    public void spawnRadarChart() {
        JunChartRadar junChartRadar = new JunChartRadar();
        this._copyAttributes(junChartRadar);
        junChartRadar.open();
    }

    protected abstract JunOpenGL3dCompoundObject createChart3dObject();

    protected JunOpenGL3dObject createXAxis() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.name_("x axis");
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[]{new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(1.0, 0.0, 0.0)};
        junOpenGL3dCompoundObject.add_(new JunOpenGL3dPolyline(jun3dPointArray, this.axisColor()));
        Jun3dPoint[] jun3dPointArray2 = new Jun3dPoint[]{new Jun3dPoint(1.0, 0.0, 0.0), new Jun3dPoint(0.95, -0.02, 0.0), new Jun3dPoint(0.95, 0.0, 0.0), new Jun3dPoint(1.0, 0.0, 0.0)};
        junOpenGL3dCompoundObject.add_(new JunOpenGL3dPolygon(jun3dPointArray2, this.axisColor()));
        Jun3dPoint[] jun3dPointArray3 = new Jun3dPoint[]{new Jun3dPoint(1.0, 0.0, 0.0), new Jun3dPoint(0.95, 0.0, -0.02), new Jun3dPoint(0.95, 0.0, 0.0), new Jun3dPoint(1.0, 0.0, 0.0)};
        junOpenGL3dCompoundObject.add_(new JunOpenGL3dPolygon(jun3dPointArray3, this.axisColor()));
        junOpenGL3dCompoundObject.paint_(this.axisColor());
        return junOpenGL3dCompoundObject;
    }

    protected abstract JunOpenGL3dObject createXAxisLabels();

    protected JunOpenGL3dObject createYAxis() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.name_("y axis");
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[]{new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(0.0, 1.0, 0.0)};
        junOpenGL3dCompoundObject.add_(new JunOpenGL3dPolyline(jun3dPointArray, this.axisColor()));
        Jun3dPoint[] jun3dPointArray2 = new Jun3dPoint[]{new Jun3dPoint(0.0, 1.0, 0.0), new Jun3dPoint(-0.02, 0.95, 0.0), new Jun3dPoint(0.0, 0.95, 0.0), new Jun3dPoint(0.0, 1.0, 0.0)};
        junOpenGL3dCompoundObject.add_(new JunOpenGL3dPolygon(jun3dPointArray2, this.axisColor()));
        Jun3dPoint[] jun3dPointArray3 = new Jun3dPoint[]{new Jun3dPoint(0.0, 1.0, 0.0), new Jun3dPoint(0.0, 0.95, -0.02), new Jun3dPoint(0.0, 0.95, 0.0), new Jun3dPoint(0.0, 1.0, 0.0)};
        junOpenGL3dCompoundObject.add_(new JunOpenGL3dPolygon(jun3dPointArray3, this.axisColor()));
        junOpenGL3dCompoundObject.paint_(this.axisColor());
        return junOpenGL3dCompoundObject;
    }

    protected JunOpenGL3dObject createYAxisLabels() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        JunChartData junChartData = this.data();
        double d = junChartData.minimumOfValueRange();
        double d2 = junChartData.maximumOfValueRange();
        double d3 = junChartData.intervalOfValueRange();
        for (double d4 = (Math.floor(d / d3) + 1.0) * d3; d4 <= Math.floor(d2 / d3) * d3; d4 += d3) {
            if (d4 == d || d4 == d2) continue;
            double d5 = junChartData.normalizeValue_(d4);
            Jun3dPoint[] jun3dPointArray = new Jun3dPoint[]{new Jun3dPoint(0.0, d5, 0.0), new Jun3dPoint(-0.05, d5, 0.0)};
            junOpenGL3dCompoundObject.add_(new JunOpenGL3dPolyline(jun3dPointArray, this.axisColor()));
            junOpenGL3dCompoundObject.add_(this.label_rightCenterAt_(String.valueOf(d4), new Jun3dPoint(-0.05, d5, 0.0)));
        }
        return junOpenGL3dCompoundObject;
    }

    protected JunOpenGL3dObject createZAxis() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.name_("z axis");
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[]{new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(0.0, 0.0, 1.0)};
        junOpenGL3dCompoundObject.add_(new JunOpenGL3dPolyline(jun3dPointArray, this.axisColor()));
        Jun3dPoint[] jun3dPointArray2 = new Jun3dPoint[]{new Jun3dPoint(0.0, 0.0, 1.0), new Jun3dPoint(-0.02, 0.0, 0.95), new Jun3dPoint(0.0, 0.0, 0.95), new Jun3dPoint(0.0, 0.0, 1.0)};
        junOpenGL3dCompoundObject.add_(new JunOpenGL3dPolygon(jun3dPointArray2, this.axisColor()));
        Jun3dPoint[] jun3dPointArray3 = new Jun3dPoint[]{new Jun3dPoint(0.0, 0.0, 1.0), new Jun3dPoint(0.0, -0.02, 0.95), new Jun3dPoint(0.0, 0.0, 0.95), new Jun3dPoint(0.0, 0.0, 1.0)};
        junOpenGL3dCompoundObject.add_(new JunOpenGL3dPolygon(jun3dPointArray3, this.axisColor()));
        junOpenGL3dCompoundObject.paint_(this.axisColor());
        return junOpenGL3dCompoundObject;
    }

    protected JunOpenGL3dObject label_rightCenterAt_(String string, Jun3dPoint jun3dPoint) {
        if (this.isScalableLabels()) {
            return this.scalableLabel_rightCenterAt_(string, jun3dPoint);
        }
        return this.texturedLabel_rightCenterAt_(string, jun3dPoint);
    }

    protected JunOpenGL3dObject label_topCenterAt_(String string, Jun3dPoint jun3dPoint) {
        if (this.isScalableLabels()) {
            return this.scalableLabel_topCenterAt_(string, jun3dPoint);
        }
        return this.texturedLabel_topCenterAt_(string, jun3dPoint);
    }

    protected JunOpenGL3dObject scalableLabel_rightCenterAt_(String string, Jun3dPoint jun3dPoint) {
        Font font = JunFontModel.TextStyle(100.0f);
        JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dObject.Text_font_(string, font);
        Jun3dBoundingBox jun3dBoundingBox = junOpenGL3dObject.boundingBox();
        double d = 1.0 / Math.max(jun3dBoundingBox.height() / this.labelHeight(), 1.0);
        junOpenGL3dObject = junOpenGL3dObject.scaledBy_(new Jun3dPoint(d, d, 1.0));
        jun3dBoundingBox = jun3dBoundingBox.scaledBy_(new Jun3dPoint(d, d, 1.0));
        Jun3dPoint jun3dPoint2 = new Jun3dPoint(jun3dBoundingBox.width(), jun3dBoundingBox.height() / 2.0, 0.0);
        Jun3dPoint jun3dPoint3 = new Jun3dPoint(this.labelHeight() / 10.0 * -1.0, 0.0, 0.0);
        junOpenGL3dObject = junOpenGL3dObject.translatedBy_(jun3dPoint.minus_(jun3dPoint2).plus_(jun3dPoint3));
        junOpenGL3dObject.paint_(this.labelForegroundColor());
        return junOpenGL3dObject;
    }

    protected JunOpenGL3dObject scalableLabel_topCenterAt_(String string, Jun3dPoint jun3dPoint) {
        Font font = JunFontModel.TextStyle(100.0f);
        JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dObject.Text_font_(string, font);
        Jun3dBoundingBox jun3dBoundingBox = junOpenGL3dObject.boundingBox();
        double d = 1.0 / Math.max(jun3dBoundingBox.height() / this.labelHeight(), 1.0);
        junOpenGL3dObject = junOpenGL3dObject.scaledBy_(new Jun3dPoint(d, d, 1.0));
        jun3dBoundingBox = jun3dBoundingBox.scaledBy_(new Jun3dPoint(d, d, 1.0));
        Jun3dPoint jun3dPoint2 = new Jun3dPoint(jun3dBoundingBox.width() / 2.0, jun3dBoundingBox.height(), 0.0);
        Jun3dPoint jun3dPoint3 = new Jun3dPoint(0.0, this.labelHeight() / 10.0, 0.0);
        junOpenGL3dObject = junOpenGL3dObject.translatedBy_(jun3dPoint.minus_(jun3dPoint2).plus_(jun3dPoint3));
        junOpenGL3dObject.paint_(this.labelForegroundColor());
        return junOpenGL3dObject;
    }

    protected JunOpenGL3dObject texturedLabel_rightCenterAt_(String string, Jun3dPoint jun3dPoint) {
        JunOpenGLTexture junOpenGLTexture = JunOpenGLTexture.TextureForString_foreColor_backColor_(string, this.labelForegroundColor(), this.labelBackgroundColor());
        double d = this.defaultLabelHeight();
        double d2 = d * (double)junOpenGLTexture.width() / (double)junOpenGLTexture.height();
        double d3 = jun3dPoint.x() - d2;
        double d4 = jun3dPoint.y() - d / 2.0;
        double d5 = jun3dPoint.x();
        double d6 = jun3dPoint.y() + d / 2.0;
        double d7 = jun3dPoint.z();
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[]{new Jun3dPoint(d3, d4, d7), new Jun3dPoint(d5, d4, d7), new Jun3dPoint(d5, d6, d7), new Jun3dPoint(d3, d6, d7)};
        JunOpenGL3dPolygon junOpenGL3dPolygon = new JunOpenGL3dPolygon(jun3dPointArray);
        junOpenGL3dPolygon.paint_(Color.white);
        ((JunOpenGL3dObject)junOpenGL3dPolygon).texture_(junOpenGLTexture);
        return junOpenGL3dPolygon;
    }

    protected JunOpenGL3dObject texturedLabel_topCenterAt_(String string, Jun3dPoint jun3dPoint) {
        JunOpenGLTexture junOpenGLTexture = JunOpenGLTexture.TextureForString_foreColor_backColor_(string, this.labelForegroundColor(), this.labelBackgroundColor());
        double d = this.defaultLabelHeight();
        double d2 = d * (double)junOpenGLTexture.width() / (double)junOpenGLTexture.height();
        double d3 = jun3dPoint.x() - d2 / 2.0;
        double d4 = jun3dPoint.y() - d;
        double d5 = jun3dPoint.x() + d2 / 2.0;
        double d6 = jun3dPoint.y();
        double d7 = jun3dPoint.z();
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[]{new Jun3dPoint(d3, d4, d7), new Jun3dPoint(d5, d4, d7), new Jun3dPoint(d5, d6, d7), new Jun3dPoint(d3, d6, d7)};
        JunOpenGL3dPolygon junOpenGL3dPolygon = new JunOpenGL3dPolygon(jun3dPointArray);
        junOpenGL3dPolygon.paint_(Color.white);
        ((JunOpenGL3dObject)junOpenGL3dPolygon).texture_(junOpenGLTexture);
        return junOpenGL3dPolygon;
    }
}

