/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.octree.editor;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.geometry.surfaces.JunSphereSurface;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.button.JunButtonModel;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.metaball.atoms.JunMetaSphere;
import jp.co.sra.jun.metaball.solid.JunMetaballSolid;
import jp.co.sra.jun.octree.basic.JunOctree;
import jp.co.sra.jun.octree.nodes.JunOctreeNode;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.lights.JunOpenGLLight;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.picking.JunOpenGLObjectPicker;
import jp.co.sra.jun.opengl.picking.JunOpenGLPickingRenderingContext;
import jp.co.sra.jun.opengl.projection.JunOpenGLParallelProjection;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjection;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjector;
import jp.co.sra.jun.opengl.support.JunOpenGLDrawable;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderer;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuItem;

public class JunOctreeEditModel
extends JunOpenGLDisplayModel {
    public static final double ThetaAccuracy = 0.001;
    protected JunOctree[] octrees = null;
    protected Vector selection = null;
    protected JunOpenGLDisplayLight[] displayLights = null;
    protected JunOpenGLProjector displayProjector = null;
    protected Jun3dPoint defaultEyePoint = null;
    protected Jun3dPoint defaultSightPoint = null;
    protected Jun3dPoint defaultUpVector = null;
    protected Double defaultViewFactor = null;
    protected JunButtonModel pickButton = null;
    protected JunButtonModel grabButton = null;
    protected JunButtonModel dragButton = null;
    protected JunButtonModel dollyButton = null;
    protected JunButtonModel focusButton = null;

    public JunOctreeEditModel() {
        this.initialize();
    }

    public JunOctreeEditModel(JunOctree junOctree) {
        this();
        Vector<JunOctree> vector = new Vector<JunOctree>(1);
        vector.addElement(junOctree);
        this.setOctrees_(vector);
    }

    public static JunOctreeEditModel Edit_(JunOctree junOctree) {
        JunOctreeEditModel junOctreeEditModel = new JunOctreeEditModel(junOctree);
        junOctreeEditModel.open();
        return junOctreeEditModel;
    }

    public static JunOctreeEditModel On_(JunOctree junOctree) {
        return new JunOctreeEditModel(junOctree);
    }

    public void addSelection_(JunOctreeNode junOctreeNode) {
        if (!this.selection.contains((Object)junOctreeNode)) {
            this.selection.addElement(junOctreeNode);
        }
    }

    public void altClick_(JunOctreeNode junOctreeNode) {
    }

    public Jun3dBoundingBox boundingBox() {
        if (!this.hasOctree()) {
            return Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(0.0, 0.0, 0.0));
        }
        Jun3dBoundingBox jun3dBoundingBox = this.octrees[0].bounds();
        for (int i = 1; i < this.octrees.length; ++i) {
            jun3dBoundingBox = jun3dBoundingBox.merge_(this.octrees[i].bounds());
        }
        return jun3dBoundingBox;
    }

    public StSymbol buttonState() {
        if (this.pickButton.value()) {
            return JunOctreeEditModel.$((String)"pick");
        }
        if (this.grabButton.value()) {
            return JunOctreeEditModel.$((String)"grab");
        }
        if (this.dragButton.value()) {
            return JunOctreeEditModel.$((String)"drag");
        }
        if (this.focusButton.value()) {
            return JunOctreeEditModel.$((String)"focus");
        }
        return JunOctreeEditModel.$((String)"none");
    }

    public void changeEyePoint() {
        Jun3dPoint jun3dPoint = this.displayProjector().eyePoint();
        float f = (float)jun3dPoint.x();
        float f2 = (float)jun3dPoint.y();
        float f3 = (float)jun3dPoint.z();
        String string = JunDialog.Request_(JunSystem.$String((String)"Input a new eye point.") + " (x, y, z).", "(" + f + "," + f2 + "," + f3 + ")");
        if (string != null) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "(), ");
                f = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                f2 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                f3 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                this.eyePoint_(new Jun3dPoint(f, f2, f3));
            }
            catch (Exception exception) {
                JunDialog.Warn_(string + JunSystem.$String((String)" is invalid point."));
            }
        }
    }

    public void changeSightPoint() {
        Jun3dPoint jun3dPoint = this.displayProjector().sightPoint();
        float f = (float)jun3dPoint.x();
        float f2 = (float)jun3dPoint.y();
        float f3 = (float)jun3dPoint.z();
        String string = JunDialog.Request_(JunSystem.$String((String)"Input a new sight point.") + " (x, y, z).", "(" + f + "," + f2 + "," + f3 + ")");
        if (string != null) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "(), ");
                f = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                f2 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                f3 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                this.sightPoint_(new Jun3dPoint(f, f2, f3));
            }
            catch (Exception exception) {
                JunDialog.Warn_(string + JunSystem.$String((String)" is invalid point."));
            }
        }
    }

    public void changeUpVector() {
        Jun3dPoint jun3dPoint = this.displayProjector().upVector();
        float f = (float)jun3dPoint.x();
        float f2 = (float)jun3dPoint.y();
        float f3 = (float)jun3dPoint.z();
        String string = JunDialog.Request_(JunSystem.$String((String)"Input a new up vector.") + " (x, y, z).", "(" + f + "," + f2 + "," + f3 + ")");
        if (string != null) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "(), ");
                f = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                f2 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                f3 = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                this.upVector_(new Jun3dPoint(f, f2, f3));
            }
            catch (Exception exception) {
                JunDialog.Warn_(string + JunSystem.$String((String)" is invalid point."));
            }
        }
    }

    public void changeViewFactor() {
        double d = this.displayProjector().viewFactor();
        String string = JunDialog.Request_(JunSystem.$String((String)"Input a new view factor."), new Double(d).toString());
        if (string != null) {
            try {
                d = Double.valueOf(string);
                this.viewFactor_(d);
            }
            catch (Exception exception) {
                JunDialog.Warn_(string + JunSystem.$String((String)" is invalid value."));
            }
        }
    }

    public void clearSelection() {
        this.selection = new Vector();
    }

    public void closeUp() {
        JunOpenGLProjection junOpenGLProjection = this.displayProjection();
        double d = junOpenGLProjection.regularHeight() / 2.0;
        double d2 = junOpenGLProjection.sightPoint().distance_(junOpenGLProjection.eyePoint());
        Jun3dLine jun3dLine = new Jun3dLine(junOpenGLProjection.sightPoint(), junOpenGLProjection.eyePoint());
        Jun3dPoint jun3dPoint = jun3dLine.atT_(d / d2);
        junOpenGLProjection.eyePoint_(jun3dPoint);
        junOpenGLProjection.zoomHeight_(this.computeZoomHeight());
        this.displayProjection_(junOpenGLProjection);
        this.changed_(JunOctreeEditModel.$((String)"projection"));
    }

    public void ctrlClick_(JunOctreeNode junOctreeNode) {
    }

    public Jun3dPoint defaultEyePoint() {
        if (!this.hasOctree()) {
            return new Jun3dPoint(10000.0, 10000.0, 10000.0);
        }
        if (this.defaultEyePoint == null) {
            Jun3dBoundingBox jun3dBoundingBox = this.boundingBox();
            double d = jun3dBoundingBox.origin().distance_(jun3dBoundingBox.corner());
            return new Jun3dPoint(d *= 2.0, d, d);
        }
        return this.defaultEyePoint;
    }

    public void defaultEyePoint_(Jun3dPoint jun3dPoint) {
        this.defaultEyePoint = jun3dPoint;
    }

    public Color defaultLightColor() {
        return Color.gray;
    }

    public Jun3dPoint defaultLightPoint() {
        return new Jun3dPoint(0.0, 0.0, 1.0);
    }

    public Jun3dPoint defaultSightPoint() {
        if (!this.hasOctree()) {
            return new Jun3dPoint(0.0, 0.0, 0.0);
        }
        if (this.defaultSightPoint == null) {
            return this.boundingBox().center();
        }
        return this.defaultSightPoint;
    }

    public void defaultSightPoint_(Jun3dPoint jun3dPoint) {
        this.defaultSightPoint = jun3dPoint;
    }

    public Jun3dPoint defaultUpVector() {
        if (this.defaultUpVector == null) {
            return new Jun3dPoint(-1.0, -1.0, 1.0);
        }
        return this.defaultUpVector;
    }

    public void defaultUpVector_(Jun3dPoint jun3dPoint) {
        this.defaultUpVector = jun3dPoint;
    }

    public double defaultViewFactor() {
        if (this.defaultViewFactor == null) {
            return 10.0;
        }
        return this.defaultViewFactor;
    }

    public void defaultViewFactor_(double d) {
        this.defaultViewFactor = new Double(d);
    }

    public JunOpenGLDisplayLight displayLight1() {
        return this.displayLights()[0];
    }

    public JunOpenGLDisplayLight displayLight2() {
        return this.displayLights()[1];
    }

    public JunOpenGLDisplayLight displayLight3() {
        return this.displayLights()[2];
    }

    public JunOpenGLDisplayLight displayLight4() {
        return this.displayLights()[3];
    }

    public JunOpenGLDisplayLight displayLight5() {
        return this.displayLights()[4];
    }

    public JunOpenGLLight[] displayLightCollection() {
        JunOpenGLLight[] junOpenGLLightArray;
        int n;
        Vector<JunOpenGLLight> vector = new Vector<JunOpenGLLight>();
        Jun3dTransformation jun3dTransformation = this.displayProjection().asEyeTransformation().inverse();
        for (n = 0; n < this.displayLights().length; ++n) {
            junOpenGLLightArray = this.displayLights()[n];
            if (!junOpenGLLightArray.isOn()) continue;
            vector.addElement(junOpenGLLightArray.light().transform_(jun3dTransformation));
        }
        n = vector.size();
        junOpenGLLightArray = new JunOpenGLLight[n];
        vector.copyInto((Object[])junOpenGLLightArray);
        return junOpenGLLightArray;
    }

    public JunOpenGLDisplayLight[] displayLights() {
        if (this.displayLights == null) {
            this.displayLights = new JunOpenGLDisplayLight[5];
            this.displayLights[0] = JunOpenGLDisplayLight.ParallelLight_color_position_(true, this.defaultLightColor(), this.defaultLightPoint());
            this.displayLights[1] = new JunOpenGLDisplayLight();
            this.displayLights[2] = new JunOpenGLDisplayLight();
            this.displayLights[3] = new JunOpenGLDisplayLight();
            this.displayLights[4] = JunOpenGLDisplayLight.AmbientLight_color_(true, this.defaultLightColor());
            final JunOctreeEditModel junOctreeEditModel = this;
            for (int i = 0; i < this.displayLights.length; ++i) {
                this.displayLights[i].compute_(new StBlockClosure(){

                    public Object value() {
                        junOctreeEditModel.updateLightMenuIndication();
                        junOctreeEditModel.changed_(1.$((String)"light"));
                        return null;
                    }
                });
            }
        }
        return this.displayLights;
    }

    public JunOpenGLProjection displayProjection() {
        return this.displayProjector().projection();
    }

    public void displayProjection_(JunOpenGLProjection junOpenGLProjection) {
        this.displayProjector().projection_(junOpenGLProjection);
    }

    public JunOpenGLProjector displayProjector() {
        if (this.displayProjector == null) {
            this.displayProjector = new JunOpenGLProjector();
            this.displayProjector.eyePoint_(this.defaultEyePoint());
            this.displayProjector.sightPoint_(this.defaultSightPoint());
            this.displayProjector.upVector_(this.defaultUpVector());
            this.displayProjector.viewFactor_(this.defaultViewFactor());
        }
        return this.displayProjector;
    }

    public void divideSelection() {
        if (!this.selection.isEmpty()) {
            JunOctreeNode[] junOctreeNodeArray = new JunOctreeNode[this.selection.size()];
            this.selection.copyInto((Object[])junOctreeNodeArray);
            Vector<JunOctreeNode> vector = new Vector<JunOctreeNode>(junOctreeNodeArray.length * 8);
            for (int i = 0; i < junOctreeNodeArray.length; ++i) {
                junOctreeNodeArray[i].beDivided();
                JunOctreeNode[] junOctreeNodeArray2 = (JunOctreeNode[])junOctreeNodeArray[i].contents();
                for (int j = 0; j < junOctreeNodeArray2.length; ++j) {
                    if (vector.contains((Object)junOctreeNodeArray2[j])) continue;
                    vector.addElement(junOctreeNodeArray2[j]);
                }
            }
            this.selection = vector;
            this.changed_(JunOctreeEditModel.$((String)"object"));
        }
    }

    public void dolly_(double d) {
        JunOpenGLProjector junOpenGLProjector = this.displayProjector();
        double d2 = d;
        Jun3dLine jun3dLine = new Jun3dLine(junOpenGLProjector.eyePoint(), junOpenGLProjector.sightPoint());
        Jun3dPoint jun3dPoint = jun3dLine.atT_(0.0 + d2);
        Jun3dPoint jun3dPoint2 = jun3dLine.atT_(1.0 + d2);
        junOpenGLProjector.eyePoint_(jun3dPoint);
        junOpenGLProjector.sightPoint_(jun3dPoint2);
        this.changed_(JunOctreeEditModel.$((String)"projection"));
    }

    public JunButtonModel dollyButton() {
        if (this.dollyButton == null) {
            JunButtonModel junButtonModel = new JunButtonModel();
            junButtonModel.value_(false);
            junButtonModel.visual_(JunCursors.DollyCursorImage());
            junButtonModel.action_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunButtonModel junButtonModel;
                    junButtonModel.value_(!(junButtonModel = (JunButtonModel)((Object)object)).value());
                    return junButtonModel;
                }
            });
            this.dollyButton = junButtonModel;
        }
        return this.dollyButton;
    }

    public JunButtonModel dragButton() {
        if (this.dragButton == null) {
            final JunOctreeEditModel junOctreeEditModel = this;
            JunButtonModel junButtonModel = new JunButtonModel();
            junButtonModel.value_(false);
            junButtonModel.visual_(JunCursors.QuartersCursorImage());
            junButtonModel.action_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunButtonModel junButtonModel;
                    junButtonModel.value_(!(junButtonModel = (JunButtonModel)((Object)object)).value());
                    if (junButtonModel.value()) {
                        junOctreeEditModel.focusButton().value_(false);
                        junOctreeEditModel.grabButton().value_(false);
                        junOctreeEditModel.pickButton().value_(false);
                    }
                    junOctreeEditModel.changed_(3.$((String)"state"));
                    return junButtonModel;
                }
            });
            this.dragButton = junButtonModel;
        }
        return this.dragButton;
    }

    public void eraseSelection() {
        if (!this.selection.isEmpty()) {
            JunOctreeNode[] junOctreeNodeArray = new JunOctreeNode[this.selection.size()];
            this.selection.copyInto((Object[])junOctreeNodeArray);
            for (int i = 0; i < junOctreeNodeArray.length; ++i) {
                junOctreeNodeArray[i].beEmpty();
            }
            this.changed_(JunOctreeEditModel.$((String)"object"));
        }
    }

    public void eyePoint_(Jun3dPoint jun3dPoint) {
        this.displayProjector().eyePoint_(jun3dPoint);
        this.changed_(JunOctreeEditModel.$((String)"projection"));
    }

    public void fillSelection() {
        if (!this.selection.isEmpty()) {
            JunOctreeNode[] junOctreeNodeArray = new JunOctreeNode[this.selection.size()];
            this.selection.copyInto((Object[])junOctreeNodeArray);
            for (int i = 0; i < junOctreeNodeArray.length; ++i) {
                junOctreeNodeArray[i].beFilled();
            }
            this.changed_(JunOctreeEditModel.$((String)"object"));
        }
    }

    public void fit() {
        if (this.hasOctree()) {
            this.fitSilently();
            this.changed_(JunOctreeEditModel.$((String)"projection"));
        }
    }

    public void fitSight() {
        if (this.hasOctree()) {
            Jun3dPoint jun3dPoint = this.computeSightPoint();
            this.sightPoint_(jun3dPoint);
        }
    }

    public void fitSilently() {
        if (this.hasOctree()) {
            Jun3dPoint jun3dPoint = this.computeSightPoint();
            this.displayProjector().sightPoint_(jun3dPoint);
            double d = this.computeZoomHeight();
            this.displayProjector().zoomHeight_(d);
        }
    }

    public void fitZoom() {
        if (this.hasOctree()) {
            double d = this.computeZoomHeight();
            this.zoomHeight_(d);
        }
    }

    public void flushProjector() {
        this.displayProjector = null;
    }

    public void focus_to_(Jun2dBoundingBox jun2dBoundingBox, Jun2dBoundingBox jun2dBoundingBox2) {
        JunOpenGLProjection junOpenGLProjection = this.displayProjection();
        Jun3dPoint jun3dPoint = junOpenGLProjection.translateTo3dPointFromPoint_(jun2dBoundingBox.origin().plus_(jun2dBoundingBox.corner()).dividedBy_(2.0));
        Jun3dPoint jun3dPoint2 = junOpenGLProjection.translateTo3dPointFromPoint_(jun2dBoundingBox2.origin().plus_(jun2dBoundingBox2.corner()).dividedBy_(2.0));
        junOpenGLProjection.sightPoint_(junOpenGLProjection.sightPoint().plus_(jun3dPoint2.minus_(jun3dPoint)));
        Jun3dPoint jun3dPoint3 = junOpenGLProjection.translateTo3dPointFromPoint_(new Jun2dPoint(0.0, jun2dBoundingBox.origin().y()));
        Jun3dPoint jun3dPoint4 = junOpenGLProjection.translateTo3dPointFromPoint_(new Jun2dPoint(0.0, jun2dBoundingBox.corner().y()));
        Jun3dPoint jun3dPoint5 = junOpenGLProjection.translateTo3dPointFromPoint_(new Jun2dPoint(jun2dBoundingBox.origin().x(), 0.0));
        Jun3dPoint jun3dPoint6 = junOpenGLProjection.translateTo3dPointFromPoint_(new Jun2dPoint(jun2dBoundingBox.corner().x(), 0.0));
        double d = jun3dPoint3.minus_(jun3dPoint4).length();
        double d2 = jun3dPoint5.minus_(jun3dPoint6).length();
        Jun3dPoint jun3dPoint7 = junOpenGLProjection.translateTo3dPointFromPoint_(new Jun2dPoint(0.0, jun2dBoundingBox2.origin().y()));
        Jun3dPoint jun3dPoint8 = junOpenGLProjection.translateTo3dPointFromPoint_(new Jun2dPoint(0.0, jun2dBoundingBox2.corner().y()));
        Jun3dPoint jun3dPoint9 = junOpenGLProjection.translateTo3dPointFromPoint_(new Jun2dPoint(jun2dBoundingBox2.origin().x(), 0.0));
        Jun3dPoint jun3dPoint10 = junOpenGLProjection.translateTo3dPointFromPoint_(new Jun2dPoint(jun2dBoundingBox2.corner().x(), 0.0));
        double d3 = jun3dPoint7.minus_(jun3dPoint8).length();
        double d4 = jun3dPoint9.minus_(jun3dPoint10).length();
        double d5 = junOpenGLProjection.regularHeight() * d3 / d;
        double d6 = d5 * d4 / d3;
        double d7 = d5;
        if (d2 / d * d5 < d6) {
            double d8 = d2 * d5 / (d * d6);
            d7 = d5 * d8;
        }
        if (d * 0.01 < d3 && d3 * 0.01 < d) {
            junOpenGLProjection.zoomHeight_(d7);
        }
        this.displayProjection_(junOpenGLProjection);
        this.changed_(JunOctreeEditModel.$((String)"projection"));
    }

    public JunButtonModel focusButton() {
        if (this.focusButton == null) {
            final JunOctreeEditModel junOctreeEditModel = this;
            JunButtonModel junButtonModel = new JunButtonModel();
            junButtonModel.value_(false);
            junButtonModel.visual_(JunCursors.GlassCursorImage());
            junButtonModel.action_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunButtonModel junButtonModel;
                    junButtonModel.value_(!(junButtonModel = (JunButtonModel)((Object)object)).value());
                    if (junButtonModel.value()) {
                        junOctreeEditModel.grabButton().value_(false);
                        junOctreeEditModel.dragButton().value_(false);
                        junOctreeEditModel.pickButton().value_(false);
                    }
                    junOctreeEditModel.changed_(4.$((String)"state"));
                    return junButtonModel;
                }
            });
            this.focusButton = junButtonModel;
        }
        return this.focusButton;
    }

    public void grab_(Jun2dPoint jun2dPoint) {
        this.grab_(jun2dPoint, false);
    }

    public void grab_(Jun2dPoint jun2dPoint, boolean bl) {
        if (this.hasOctree()) {
            Jun2dPoint jun2dPoint2 = new Jun2dPoint(0.0, 0.0);
            Jun2dPoint jun2dPoint3 = bl ? new Jun2dPoint(jun2dPoint.x() / 10.0, jun2dPoint.y() / 10.0) : new Jun2dPoint(jun2dPoint.x(), jun2dPoint.y());
            this.grab_xy_(jun2dPoint2, jun2dPoint3);
        }
    }

    public void grab_xy_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        if (this.hasOctree()) {
            JunOpenGLProjection junOpenGLProjection = this.displayProjection();
            JunSphereSurface junSphereSurface = this.grabSphere();
            Jun3dPoint jun3dPoint = this.grab3dPoint_(new Jun2dPoint(jun2dPoint.x(), jun2dPoint.y()));
            Jun3dPoint jun3dPoint2 = this.grab3dPoint_(new Jun2dPoint(jun2dPoint2.x(), jun2dPoint2.y()));
            JunAngle junAngle = new Jun3dLine(junSphereSurface.center(), jun3dPoint2).angleWithLine_(new Jun3dLine(junSphereSurface.center(), jun3dPoint));
            if (Math.abs(junAngle.rad()) > 0.001) {
                Jun3dLine jun3dLine = new Jun3dLine(junSphereSurface.center(), junSphereSurface.center().minus_(jun3dPoint.minus_(junSphereSurface.center()).product_(jun3dPoint2.minus_(junSphereSurface.center()))));
                Jun3dTransformation jun3dTransformation = Jun3dTransformation.Rotate_around_(junAngle, jun3dLine);
                Jun3dTransformation jun3dTransformation2 = Jun3dTransformation.Rotate_around_(junAngle.mul_(-1.0), jun3dLine);
                Jun3dPoint jun3dPoint3 = junOpenGLProjection.sightPoint().plus_(junOpenGLProjection.unitUpVector());
                junOpenGLProjection.eyePoint_(jun3dTransformation2.applyTo_(junOpenGLProjection.eyePoint()));
                junOpenGLProjection.upVector_(jun3dTransformation.applyTo_(jun3dPoint3).minus_(junOpenGLProjection.sightPoint()));
                this.displayProjection_(junOpenGLProjection);
                this.changed_(JunOctreeEditModel.$((String)"projection"));
            }
        }
    }

    public Jun3dPoint grab3dPoint_(Jun2dPoint jun2dPoint) {
        JunOpenGLParallelProjection junOpenGLParallelProjection;
        Jun3dLine jun3dLine;
        JunOpenGLProjection junOpenGLProjection = this.displayProjection();
        JunSphereSurface junSphereSurface = this.grabSphere();
        Jun3dPoint[] jun3dPointArray = junSphereSurface.crossPointsWithLine_(jun3dLine = new Jun3dLine((junOpenGLParallelProjection = junOpenGLProjection.asParallelProjection()).translateTo3dPointInNearBoundaryPlaneFromPoint_(jun2dPoint), junOpenGLParallelProjection.translateTo3dPointInFarBoundaryPlaneFromPoint_(jun2dPoint)));
        if (jun3dPointArray.length == 0) {
            return junOpenGLParallelProjection.translateTo3dPointFromPoint_(jun2dPoint);
        }
        return jun3dPointArray[0];
    }

    public JunButtonModel grabButton() {
        if (this.grabButton == null) {
            final JunOctreeEditModel junOctreeEditModel = this;
            JunButtonModel junButtonModel = new JunButtonModel();
            junButtonModel.value_(false);
            junButtonModel.visual_(JunCursors.HandCursorImage());
            junButtonModel.action_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunButtonModel junButtonModel;
                    junButtonModel.value_(!(junButtonModel = (JunButtonModel)((Object)object)).value());
                    if (junButtonModel.value()) {
                        junOctreeEditModel.focusButton().value_(false);
                        junOctreeEditModel.dragButton().value_(false);
                        junOctreeEditModel.pickButton().value_(false);
                    }
                    junOctreeEditModel.changed_(5.$((String)"state"));
                    return junButtonModel;
                }
            });
            this.grabButton = junButtonModel;
        }
        return this.grabButton;
    }

    public JunSphereSurface grabSphere() {
        JunOpenGLProjection junOpenGLProjection = this.displayProjection();
        JunSphereSurface junSphereSurface = new JunSphereSurface(junOpenGLProjection.sightPoint(), junOpenGLProjection.regularHeight() / 2.0);
        return junSphereSurface;
    }

    public boolean hasOctree() {
        return this.octrees != null && this.octrees.length > 0;
    }

    public void initialize() {
        this.octrees = new JunOctree[0];
        this.displayLights = null;
        this.displayProjector = null;
        this.selection = new Vector();
        this.dollyButton = null;
        this.pickButton = null;
        this.grabButton = null;
        this.dragButton = null;
    }

    public void look_xy_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        if (this.hasOctree()) {
            JunOpenGLProjection junOpenGLProjection = this.displayProjection();
            Jun3dPoint jun3dPoint = this.grab3dPoint_(new Jun2dPoint(jun2dPoint.x(), jun2dPoint.y()));
            Jun3dPoint jun3dPoint2 = this.grab3dPoint_(new Jun2dPoint(jun2dPoint2.x(), jun2dPoint2.y()));
            junOpenGLProjection.eyePoint_(junOpenGLProjection.eyePoint().minus_(jun3dPoint2.minus_(jun3dPoint)));
            this.displayProjection_(junOpenGLProjection);
            this.changed_(JunOctreeEditModel.$((String)"projection"));
        }
    }

    public void meltWithAccuracy() {
        if (this.hasOctree()) {
            String string = JunDialog.Request_(JunSystem.$String((String)"Accuracy?"), "1.0d");
            if (string == null || string.length() == 0) {
                return;
            }
            double d = Double.valueOf(string);
            if (d < -7.0) {
                return;
            }
            this.meltWithAccuracy_(d);
            this.changed_(JunOctreeEditModel.$((String)"object"));
        }
    }

    public void meltWithDepth() {
        if (this.hasOctree()) {
            String string = JunDialog.Request_(JunSystem.$String((String)"Depth?"), "1");
            if (string == null || string.length() == 0) {
                return;
            }
            int n = Math.round(Float.valueOf(string).floatValue());
            if (n < 1) {
                return;
            }
            this.meltWithDepth_(n);
            this.changed_(JunOctreeEditModel.$((String)"object"));
        }
    }

    public JunApplicationModel newModel() {
        try {
            JunOctree junOctree = (JunOctree)((Object)JunOctreeEditModel._PerformWith(((Object)((Object)this.octrees[0])).getClass(), (String)"Bounds_", (Object)((Object)Jun3dBoundingBox.Origin_extent_(Jun3dPoint.Zero(), Jun3dPoint.Unity()))));
            return JunOctreeEditModel.Edit_(junOctree);
        }
        catch (Exception exception) {
            throw new SmalltalkException(exception);
        }
    }

    public Frame open() {
        this.flushProjector();
        this.fitSilently();
        this.updateMenuIndication();
        return super.open();
    }

    public void openLight1() {
        JunOpenGLDisplayLight junOpenGLDisplayLight = this.displayLight1();
        Window[] windowArray = junOpenGLDisplayLight.builder().windows();
        for (int i = 0; i < windowArray.length; ++i) {
            if (windowArray[i].isShowing()) {
                windowArray[i].toFront();
                continue;
            }
            windowArray[i].setVisible(true);
        }
        if (windowArray.length == 0) {
            junOpenGLDisplayLight.openPositionLight();
        }
    }

    public void openLight2() {
        JunOpenGLDisplayLight junOpenGLDisplayLight = this.displayLight2();
        Window[] windowArray = junOpenGLDisplayLight.builder().windows();
        for (int i = 0; i < windowArray.length; ++i) {
            if (windowArray[i].isShowing()) {
                windowArray[i].toFront();
                continue;
            }
            windowArray[i].setVisible(true);
        }
        if (windowArray.length == 0) {
            junOpenGLDisplayLight.openPositionLight();
        }
    }

    public void openLight3() {
        JunOpenGLDisplayLight junOpenGLDisplayLight = this.displayLight3();
        Window[] windowArray = junOpenGLDisplayLight.builder().windows();
        for (int i = 0; i < windowArray.length; ++i) {
            if (windowArray[i].isShowing()) {
                windowArray[i].toFront();
                continue;
            }
            windowArray[i].setVisible(true);
        }
        if (windowArray.length == 0) {
            junOpenGLDisplayLight.openPositionLight();
        }
    }

    public void openLight4() {
        JunOpenGLDisplayLight junOpenGLDisplayLight = this.displayLight4();
        Window[] windowArray = junOpenGLDisplayLight.builder().windows();
        for (int i = 0; i < windowArray.length; ++i) {
            if (windowArray[i].isShowing()) {
                windowArray[i].toFront();
                continue;
            }
            windowArray[i].setVisible(true);
        }
        if (windowArray.length == 0) {
            junOpenGLDisplayLight.openPositionLight();
        }
    }

    public void openLight5() {
        JunOpenGLDisplayLight junOpenGLDisplayLight = this.displayLight5();
        Window[] windowArray = junOpenGLDisplayLight.builder().windows();
        for (int i = 0; i < windowArray.length; ++i) {
            if (windowArray[i].isShowing()) {
                windowArray[i].toFront();
                continue;
            }
            windowArray[i].setVisible(true);
        }
        if (windowArray.length == 0) {
            junOpenGLDisplayLight.openAmbientLight();
        }
    }

    public void pan() {
        this.zoom_(0.5);
    }

    public JunOpenGL3dObject pick_with_(Jun2dPoint jun2dPoint, MouseEvent mouseEvent) {
        if (this.hasOctree()) {
            JunOctreeNode junOctreeNode = this.pickTipAt_(jun2dPoint);
            if (junOctreeNode == null) {
                if (!this.selection.isEmpty()) {
                    this.clearSelection();
                    this.changed_(JunOctreeEditModel.$((String)"selection"));
                }
            } else if (mouseEvent.isShiftDown()) {
                if (this.selection.contains((Object)junOctreeNode)) {
                    this.removeSelection_(junOctreeNode);
                    this.changed_(JunOctreeEditModel.$((String)"selection"));
                } else {
                    this.addSelection_(junOctreeNode);
                    this.changed_(JunOctreeEditModel.$((String)"selection"));
                }
            } else if (mouseEvent.isControlDown()) {
                this.ctrlClick_(junOctreeNode);
            } else if (mouseEvent.isAltDown()) {
                this.altClick_(junOctreeNode);
            } else {
                this.clearSelection();
                this.addSelection_(junOctreeNode);
                this.changed_(JunOctreeEditModel.$((String)"selection"));
            }
        }
        return null;
    }

    public JunButtonModel pickButton() {
        if (this.pickButton == null) {
            final JunOctreeEditModel junOctreeEditModel = this;
            JunButtonModel junButtonModel = new JunButtonModel();
            junButtonModel.value_(false);
            junButtonModel.visual_(JunCursors.NormalCursorImage());
            junButtonModel.action_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunButtonModel junButtonModel;
                    junButtonModel.value_(!(junButtonModel = (JunButtonModel)((Object)object)).value());
                    if (junButtonModel.value()) {
                        junOctreeEditModel.focusButton().value_(false);
                        junOctreeEditModel.dragButton().value_(false);
                        junOctreeEditModel.grabButton().value_(false);
                    }
                    junOctreeEditModel.changed_(6.$((String)"state"));
                    return junButtonModel;
                }
            });
            this.pickButton = junButtonModel;
        }
        return this.pickButton;
    }

    public void quitDoing() {
        Window[] windowArray = this.builder().windows();
        for (int i = 0; i < windowArray.length; ++i) {
            windowArray[i].dispose();
        }
    }

    public void release() {
        if (this.displayLights() != null) {
            for (int i = 0; i < this.displayLights().length; ++i) {
            }
        }
        super.release();
    }

    public void removeSelection_(JunOctreeNode junOctreeNode) {
        this.selection.removeElement((Object)junOctreeNode);
    }

    public void renderOn_(final JunOpenGLRenderingContext junOpenGLRenderingContext) {
        junOpenGLRenderingContext.clear();
        junOpenGLRenderingContext.cullFaceBack();
        JunOpenGLLight[] junOpenGLLightArray = this.displayLightCollection();
        if (!this.hasOctree()) {
            this.displayProjector().projectOn_(junOpenGLRenderingContext);
        } else {
            int n;
            this.displayProjector().project_withLights_on_(null, junOpenGLLightArray, junOpenGLRenderingContext);
            junOpenGLRenderingContext.paint_(Color.black);
            junOpenGLRenderingContext.lineWidth_(4.0f);
            for (n = 0; n < this.octrees.length; ++n) {
                this.octrees[n].originExtentNodesDo_(new StBlockClosure(){

                    public Object value_value_value_(Object object, Object object2, Object object3) {
                        Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)object);
                        Jun3dPoint jun3dPoint2 = (Jun3dPoint)((Object)object2);
                        final JunOctreeNode junOctreeNode = (JunOctreeNode)((Object)object3);
                        if (JunOctreeEditModel.this.selection.contains((Object)junOctreeNode)) {
                            junOpenGLRenderingContext.productTransformation_while_(Jun3dTransformation.Scale_(jun3dPoint2).product_(Jun3dTransformation.Translate_(jun3dPoint)), new StBlockClosure(){

                                public Object value() {
                                    junOctreeNode.renderWireframeOn_(junOpenGLRenderingContext);
                                    return null;
                                }
                            });
                        }
                        return null;
                    }
                });
            }
            junOpenGLRenderingContext.pointSize_(5.0f);
            for (n = 0; n < this.octrees.length; ++n) {
                this.octrees[n].originExtentTipsDo_(new StBlockClosure(){

                    public Object value_value_value_(Object object, Object object2, Object object3) {
                        Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)object);
                        Jun3dPoint jun3dPoint2 = (Jun3dPoint)((Object)object2);
                        final JunOctreeNode junOctreeNode = (JunOctreeNode)((Object)object3);
                        junOpenGLRenderingContext.productTransformation_while_(Jun3dTransformation.Scale_(jun3dPoint2).product_(Jun3dTransformation.Translate_(jun3dPoint)), new StBlockClosure(){

                            public Object value() {
                                if (!junOctreeNode.isEmpty()) {
                                    junOpenGLRenderingContext.paint_(Color.white);
                                    junOctreeNode.renderPolygonOn_(junOpenGLRenderingContext);
                                } else {
                                    junOpenGLRenderingContext.paint_(Color.black);
                                    junOctreeNode.renderVertexOn_(junOpenGLRenderingContext);
                                }
                                return null;
                            }
                        });
                        return null;
                    }
                });
            }
            junOpenGLRenderingContext.flush();
        }
    }

    public void resetView() {
        this.flushProjector();
        this.fit();
        this.updateMenuIndication();
    }

    public void selectAll() {
        final JunOctreeEditModel junOctreeEditModel = this;
        this.clearSelection();
        for (int i = 0; i < this.octrees.length; ++i) {
            this.octrees[i].originExtentTipsDo_(new StBlockClosure(){

                public Object value_value_value_(Object object, Object object2, Object object3) {
                    junOctreeEditModel.addSelection_((JunOctreeNode)((Object)object3));
                    return null;
                }
            });
        }
        this.changed_(JunOctreeEditModel.$((String)"selection"));
        this.updateMenuIndication();
    }

    public void sightPoint_(Jun3dPoint jun3dPoint) {
        this.displayProjector().sightPoint_(jun3dPoint);
        this.changed_(JunOctreeEditModel.$((String)"projection"));
    }

    public void simplify() {
        if (this.hasOctree()) {
            for (int i = 0; i < this.octrees.length; ++i) {
                this.octrees[i].beCompact();
            }
        }
        this.clearSelection();
        this.changed_(JunOctreeEditModel.$((String)"object"));
    }

    public void slide_xy_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        if (this.hasOctree()) {
            JunOpenGLProjection junOpenGLProjection = this.displayProjection();
            Jun3dPoint jun3dPoint = this.grab3dPoint_(new Jun2dPoint(jun2dPoint.x(), jun2dPoint.y()));
            Jun3dPoint jun3dPoint2 = this.grab3dPoint_(new Jun2dPoint(jun2dPoint2.x(), jun2dPoint2.y()));
            junOpenGLProjection.sightPoint_(junOpenGLProjection.sightPoint().minus_(jun3dPoint2.minus_(jun3dPoint)));
            junOpenGLProjection.eyePoint_(junOpenGLProjection.eyePoint().minus_(jun3dPoint2.minus_(jun3dPoint)));
            this.displayProjection_(junOpenGLProjection);
            this.changed_(JunOctreeEditModel.$((String)"projection"));
        }
    }

    public JunOpenGL3dObject spawningObject() {
        if (this.hasOctree()) {
            Vector<JunOpenGL3dObject> vector = new Vector<JunOpenGL3dObject>();
            for (int i = 0; i < this.octrees.length; ++i) {
                vector.addElement(this.octrees[i].asJunOpenGL3dObject());
            }
            return new JunOpenGL3dCompoundObject(vector);
        }
        return null;
    }

    public void spawnOpenGLObject() {
        JunOpenGLDisplayModel junOpenGLDisplayModel = this.spawningObject().show();
        junOpenGLDisplayModel.displayProjection_((JunOpenGLProjection)this.displayProjection().copy());
        junOpenGLDisplayModel.changed_(JunOctreeEditModel.$((String)"object"));
    }

    public void spawnSelection() {
        if (!this.selection.isEmpty()) {
            final Vector vector = new Vector(this.selection.size());
            for (int i = 0; i < this.octrees.length; ++i) {
                this.octrees[i].originExtentNodesDo_(new StBlockClosure(){

                    public Object value_value_value_(Object object, Object object2, Object object3) {
                        if (JunOctreeEditModel.this.selection.contains(object3)) {
                            Jun3dBoundingBox jun3dBoundingBox = Jun3dBoundingBox.Origin_extent_((Jun3dPoint)((Object)object), (Jun3dPoint)((Object)object2));
                            JunOctree junOctree = JunOctree.Bounds_(jun3dBoundingBox);
                            vector.addElement(junOctree);
                        }
                        return null;
                    }
                });
            }
            JunOctreeEditModel junOctreeEditModel = new JunOctreeEditModel();
            junOctreeEditModel.open();
            junOctreeEditModel.displayProjection_((JunOpenGLProjection)this.displayProjection().copy());
            junOctreeEditModel.setOctrees_(vector);
            junOctreeEditModel.changed_(JunOctreeEditModel.$((String)"object"));
        }
    }

    public void unselectAll() {
        this.clearSelection();
        this.changed_(JunOctreeEditModel.$((String)"selection"));
    }

    public void upVector_(Jun3dPoint jun3dPoint) {
        this.displayProjector().upVector_(jun3dPoint);
        this.changed_(JunOctreeEditModel.$((String)"projection"));
    }

    public void viewFactor_(double d) {
        this.displayProjector().viewFactor_(d);
        this.changed_(JunOctreeEditModel.$((String)"projection"));
    }

    public void zoom() {
        this.zoom_(2.0);
    }

    public void zoom_(double d) {
        double d2 = d;
        this.displayProjector().zoom_(d2);
        this.changed_(JunOctreeEditModel.$((String)"projection"));
    }

    public void zoomHeight_(double d) {
        this.displayProjector().zoomHeight_(d);
        this.changed_(JunOctreeEditModel.$((String)"projection"));
    }

    protected Jun3dPoint computeSightPoint() {
        return this.boundingBox().center();
    }

    protected double computeZoomHeight() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.displayProjection().distance();
        Jun3dPoint jun3dPoint = this.displayProjection().translateTo3dPointFromPoint_depth_(new Jun2dPoint(0.0, -1.0), d3);
        Jun3dPoint jun3dPoint2 = this.displayProjection().translateTo3dPointFromPoint_depth_(new Jun2dPoint(0.0, 1.0), d3);
        Jun3dPoint jun3dPoint3 = this.displayProjection().translateTo3dPointFromPoint_depth_(new Jun2dPoint(1.0, 0.0), d3);
        Jun3dPoint jun3dPoint4 = this.displayProjection().translateTo3dPointFromPoint_depth_(new Jun2dPoint(-1.0, 0.0), d3);
        JunPlane junPlane = new JunPlane(this.displayProjection().eyePoint(), jun3dPoint4, jun3dPoint3);
        JunPlane junPlane2 = new JunPlane(this.displayProjection().eyePoint(), jun3dPoint, jun3dPoint2);
        if (this.hasOctree()) {
            for (int i = 0; i < this.octrees.length; ++i) {
                JunOctree junOctree = this.octrees[i];
                Jun3dPoint jun3dPoint5 = junOctree.origin();
                Jun3dPoint jun3dPoint6 = junOctree.corner();
                Jun3dPoint[] jun3dPointArray = new Jun3dPoint[]{new Jun3dPoint(jun3dPoint5.x(), jun3dPoint5.y(), jun3dPoint5.z()), new Jun3dPoint(jun3dPoint6.x(), jun3dPoint5.y(), jun3dPoint5.z()), new Jun3dPoint(jun3dPoint5.x(), jun3dPoint6.y(), jun3dPoint5.z()), new Jun3dPoint(jun3dPoint6.x(), jun3dPoint6.y(), jun3dPoint5.z()), new Jun3dPoint(jun3dPoint5.x(), jun3dPoint5.y(), jun3dPoint6.z()), new Jun3dPoint(jun3dPoint6.x(), jun3dPoint5.y(), jun3dPoint6.z()), new Jun3dPoint(jun3dPoint5.x(), jun3dPoint6.y(), jun3dPoint6.z()), new Jun3dPoint(jun3dPoint6.x(), jun3dPoint6.y(), jun3dPoint6.z())};
                for (int j = 0; j < 8; ++j) {
                    double d4 = junPlane2.distanceFromPoint_(jun3dPointArray[j]);
                    double d5 = junPlane.distanceFromPoint_(jun3dPointArray[j]);
                    if (d4 > d) {
                        d = d4;
                    }
                    if (!(d5 > d2)) continue;
                    d2 = d5;
                }
            }
        }
        double d6 = 2.5;
        double d7 = d > d2 ? d * d6 : d2 * d6;
        return d7;
    }

    protected void meltWithAccuracy_(final double d) {
        final Vector vector = (Vector)this.selection.clone();
        final JunMetaballSolid junMetaballSolid = this.metaballSolidOrder_withoutAll_(4, vector);
        for (int i = 0; i < this.octrees.length; ++i) {
            this.octrees[i].originExtentNodesDo_(new StBlockClosure(){

                public Object value_value_value_(Object object, Object object2, Object object3) {
                    if (vector.contains(object3)) {
                        ((JunOctreeNode)((Object)object3)).origin_extent_accuracy_block_((Jun3dPoint)((Object)object), (Jun3dPoint)((Object)object2), d, new StBlockClosure(){

                            public Object value_(Object object) {
                                junMetaballSolid.valueAt_((Jun3dPoint)((Object)object));
                                return null;
                            }
                        });
                    }
                    return null;
                }
            });
        }
    }

    protected void meltWithDepth_(final int n) {
        final Vector vector = (Vector)this.selection.clone();
        final JunMetaballSolid junMetaballSolid = this.metaballSolidOrder_withoutAll_(3, vector);
        for (int i = 0; i < this.octrees.length; ++i) {
            this.octrees[i].originExtentNodesDo_(new StBlockClosure(){

                public Object value_value_value_(Object object, Object object2, Object object3) {
                    if (vector.contains(object3)) {
                        ((JunOctreeNode)((Object)object3)).origin_extent_depth_block_((Jun3dPoint)((Object)object), (Jun3dPoint)((Object)object2), n + 1, new StBlockClosure(){

                            public Object value_(Object object) {
                                junMetaballSolid.valueAt_((Jun3dPoint)((Object)object));
                                return null;
                            }
                        });
                    }
                    return null;
                }
            });
        }
    }

    protected JunMetaballSolid metaballSolidOrder_withoutAll_(final int n, Vector vector) {
        final JunMetaballSolid junMetaballSolid = new JunMetaballSolid();
        for (int i = 0; i < this.octrees.length; ++i) {
            this.octrees[i].originExtentNodesWithoutAll_do_(vector, new StBlockClosure(){

                public Object value_value_value_(Object object, Object object2, Object object3) {
                    Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)object2);
                    JunOctreeNode junOctreeNode = (JunOctreeNode)((Object)object3);
                    if (junOctreeNode.isTip()) {
                        double d = jun3dPoint.x() * jun3dPoint.y() * jun3dPoint.z() * 3.0 / 4.0 / Math.PI;
                        d = Math.pow(d, 0.3333333333333333);
                        double d2 = junOctreeNode.isFilled() ? 1.0 : -1.0;
                        double d3 = d * d2;
                        JunMetaSphere junMetaSphere = JunMetaSphere.Center_order_weight_(jun3dPoint, n, d3);
                        junMetaballSolid.add_(junMetaSphere);
                    }
                    return null;
                }
            });
        }
        return junMetaballSolid;
    }

    protected JunOctreeNode pickTipAt_(Jun2dPoint jun2dPoint) {
        Jun3dPoint jun3dPoint = this.displayProjection().translateTo3dPointFromPoint_(jun2dPoint);
        double d = jun3dPoint.minus_(this.displayProjection().translateTo3dPointFromPoint_(jun2dPoint.plus_(new Jun2dPoint(0.0, -0.01)))).length();
        JunOpenGLProjection junOpenGLProjection = (JunOpenGLProjection)this.displayProjection().copy();
        junOpenGLProjection.sightPoint_(jun3dPoint);
        if (this.displayProjection().isParallel()) {
            junOpenGLProjection.eyePoint_(junOpenGLProjection.eyePoint().plus_(jun3dPoint).minus_(this.displayProjection().sightPoint()));
        }
        junOpenGLProjection.zoomHeight_(d * 5.0);
        return this.pickTipProjection_(junOpenGLProjection);
    }

    protected JunOctreeNode pickTipProjection_(final JunOpenGLProjection junOpenGLProjection) {
        final int[] nArray = new int[2];
        final ArrayList arrayList = new ArrayList();
        JunOpenGLObjectPicker junOpenGLObjectPicker = new JunOpenGLObjectPicker();
        junOpenGLObjectPicker.setRenderer(new JunOpenGLRenderer(){

            public void renderOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
                final JunOpenGLPickingRenderingContext junOpenGLPickingRenderingContext = (JunOpenGLPickingRenderingContext)junOpenGLRenderingContext;
                junOpenGLPickingRenderingContext.projection_(junOpenGLProjection);
                nArray[1] = -1;
                nArray[0] = junOpenGLPickingRenderingContext.selectNearestObjectWhile_(new StBlockClosure(){

                    public Object value() {
                        for (int i = 0; i < (this).JunOctreeEditModel.this.octrees.length; ++i) {
                            (this).JunOctreeEditModel.this.octrees[i].originExtentTipsDo_(new StBlockClosure(){

                                public Object value_value_value_(Object object, Object object2, Object object3) {
                                    Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)object);
                                    Jun3dPoint jun3dPoint2 = (Jun3dPoint)((Object)object2);
                                    final JunOctreeNode junOctreeNode = (JunOctreeNode)((Object)object3);
                                    int[] nArray = nArray;
                                    nArray[1] = nArray[1] + 1;
                                    arrayList.add(junOctreeNode);
                                    junOpenGLPickingRenderingContext.setId_(nArray[1]);
                                    junOpenGLPickingRenderingContext.productTransformation_while_(Jun3dTransformation.Scale_(jun3dPoint2).product_(Jun3dTransformation.Translate_(jun3dPoint)), new StBlockClosure(){

                                        public Object value() {
                                            if (junOctreeNode.isFilled()) {
                                                junOctreeNode.renderPolygonOn_(junOpenGLPickingRenderingContext);
                                            } else {
                                                junOctreeNode.renderVertexOn_(junOpenGLPickingRenderingContext);
                                            }
                                            return null;
                                        }
                                    });
                                    return null;
                                }
                            });
                        }
                        return null;
                    }
                });
            }

            public void superimposeOn_(Graphics graphics, JunOpenGLDrawable junOpenGLDrawable) {
            }
        });
        return nArray[0] >= 0 ? (JunOctreeNode)((Object)arrayList.get(nArray[0])) : null;
    }

    protected void setOctrees_(Vector vector) {
        if (vector == null || vector.isEmpty()) {
            this.octrees = new JunOctree[0];
        } else {
            this.octrees = new JunOctree[vector.size()];
            vector.copyInto((Object[])this.octrees);
        }
        this.clearSelection();
    }

    protected String windowTitle() {
        return JunSystem.$String((String)"Octree Editor");
    }

    public StMenuBar _menuBar() {
        if (this._menuBar == null) {
            this._menuBar = new StMenuBar();
            this._menuBar.add(this._createFileMenu());
            this._menuBar.add(this._createEditMenu());
            this._menuBar.add(this._createManipulateMenu());
            this._menuBar.add(this._createLightMenu());
            this._menuBar.add(this._createMiscMenu());
        }
        return this._menuBar;
    }

    protected StMenu _createFileMenu() {
        StMenu stMenu = new StMenu((Object)JunSystem.$String((String)"File"), JunOctreeEditModel.$((String)"fileMenu"));
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"New"), (MenuListener)new MenuPerformer((StObject)this, "newModel")));
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Quit"), (MenuListener)new MenuPerformer((StObject)this, "quitDoing")));
        return stMenu;
    }

    protected StMenu _createEditMenu() {
        StMenu stMenu = new StMenu((Object)JunSystem.$String((String)"Edit"), JunOctreeEditModel.$((String)"editMenu"));
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Select all"), (MenuListener)new MenuPerformer((StObject)this, "selectAll")));
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Unselect all"), (MenuListener)new MenuPerformer((StObject)this, "unselectAll")));
        return stMenu;
    }

    protected StMenu _createManipulateMenu() {
        StMenu stMenu = new StMenu((Object)JunSystem.$String((String)"Manipulate"), JunOctreeEditModel.$((String)"manipulateMenu"));
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Divide"), (MenuListener)new MenuPerformer((StObject)this, "divideSelection")));
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Erase"), (MenuListener)new MenuPerformer((StObject)this, "eraseSelection")));
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Fill"), (MenuListener)new MenuPerformer((StObject)this, "fillSelection")));
        StMenu stMenu2 = new StMenu((Object)JunSystem.$String((String)"Melt"));
        stMenu2.add(new StMenuItem((Object)(JunSystem.$String((String)"Accuracy") + "..."), (MenuListener)new MenuPerformer((StObject)this, "meltWithAccuracy")));
        stMenu2.add(new StMenuItem((Object)(JunSystem.$String((String)"Depth") + "..."), (MenuListener)new MenuPerformer((StObject)this, "meltWithDepth")));
        stMenu.add((StMenuItem)stMenu2);
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Simplify"), (MenuListener)new MenuPerformer((StObject)this, "simplify")));
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Spawn"), (MenuListener)new MenuPerformer((StObject)this, "spawnSelection")));
        return stMenu;
    }

    protected StMenu _createMiscMenu() {
        StMenu stMenu = new StMenu((Object)JunSystem.$String((String)"Misc"), JunOctreeEditModel.$((String)"miscMenu"));
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Viewfinder"), (MenuListener)new MenuPerformer((StObject)this, "spawnOpenGLObject")));
        return stMenu;
    }
}

