/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.graphics.navigator;

import java.io.File;
import java.util.Arrays;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.graphics.list.JunFileList;
import jp.co.sra.jun.graphics.navigator.JunFileNavigator;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterViewAwt;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterViewSwing;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;

public class JunFileRequester
extends JunFileNavigator {
    protected StValueHolder fileType;
    protected JunFileModel.FileType[] fileTypes;
    protected StSymbol requestType;
    protected StValueHolder tailFileNameHolder;

    protected void initialize() {
        super.initialize();
        this.fileType = null;
        this.fileTypes = null;
        this.requestType = null;
        this.tailFileNameHolder = null;
        this.compute_(new StBlockClosure(){

            public Object value_(Object object) {
                File file = (File)object;
                JunFileRequester junFileRequester = JunFileRequester.this;
                if (file != null && file.exists() && (junFileRequester.requestType() == 1.$((String)"newFile") && !file.isDirectory() || junFileRequester.requestType() == 1.$((String)"newDirectory") && file.isDirectory()) && !file.isDirectory()) {
                    junFileRequester.tailFileName_(file.getName());
                }
                return null;
            }
        });
    }

    public File currentFile() {
        File file = super.currentFile();
        if (this.requestType() == JunFileRequester.$((String)"oldFile") || this.requestType() == JunFileRequester.$((String)"oldDirectory")) {
            if (file == null) {
                file = JunFileList._RootFile;
            }
        } else if ((this.requestType() == JunFileRequester.$((String)"newFile") || this.requestType() == JunFileRequester.$((String)"newDirectory")) && this.tailFileName().length() > 0) {
            if (file != null && !file.isDirectory()) {
                file = file.getParentFile();
            }
            file = new File(file, this.tailFileName());
        }
        return file;
    }

    public StValueHolder fileType() {
        if (this.fileType == null) {
            this.fileType = new StValueHolder((Object)this.fileTypes()[0]);
            this.fileType.compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunFileRequester.this.filePatterns_(((JunFileModel.FileType)object).extensions());
                    return null;
                }
            });
        }
        return this.fileType;
    }

    public JunFileModel.FileType[] fileTypes() {
        if (this.fileTypes == null) {
            this.fileTypes = this.defaultFileTypes();
        }
        return this.fileTypes;
    }

    public void fileTypes_(JunFileModel.FileType[] fileTypeArray) {
        this.fileTypes = fileTypeArray;
    }

    public StSymbol requestType() {
        if (this.requestType == null) {
            this.requestType = JunFileRequester.$((String)"oldFile");
        }
        return this.requestType;
    }

    public void requestType_(StSymbol stSymbol) {
        if (!Arrays.asList(JunFileRequester.$((String)"oldFile"), JunFileRequester.$((String)"oldDirectory"), JunFileRequester.$((String)"newFile"), JunFileRequester.$((String)"newDirectory")).contains(stSymbol)) {
            return;
        }
        if (stSymbol != this.requestType()) {
            this.requestType = stSymbol;
            if (stSymbol == JunFileRequester.$((String)"oldDirectory") || stSymbol == JunFileRequester.$((String)"newDirectory")) {
                this.filePatterns_(new String[0]);
            }
        }
    }

    public String tailFileName() {
        return (String)this.tailFileNameHolder().value();
    }

    public void tailFileName_(String string) {
        this.tailFileNameHolder().value_((Object)string);
    }

    protected StValueHolder tailFileNameHolder() {
        if (this.tailFileNameHolder == null) {
            this.tailFileNameHolder = new StValueHolder((Object)new String());
            this.tailFileNameHolder.compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunFileRequester.this.updateTailFileName();
                    return null;
                }
            });
        }
        return this.tailFileNameHolder;
    }

    public StView defaultView() {
        if (JunFileRequester.GetDefaultViewMode() == 0) {
            return new JunFileRequesterViewAwt(this);
        }
        return new JunFileRequesterViewSwing(this);
    }

    protected JunFileModel.FileType[] defaultFileTypes() {
        JunFileModel.FileType[] fileTypeArray = this.requestType() == JunFileRequester.$((String)"oldDirectory") || this.requestType() == JunFileRequester.$((String)"newDirectory") ? new JunFileModel.FileType[]{new JunFileModel.FileType(JunFileRequester.$String((String)"Directories"), new String[0])} : new JunFileModel.FileType[]{JunFileModel.FileType.All(JunFileRequester.$String((String)"All files")), new JunFileModel.FileType(JunFileRequester.$String((String)"Text files"), JunSystem.DefaultTextExtensionPatterns()), new JunFileModel.FileType(JunFileRequester.$String((String)"Image files"), JunSystem.DefaultImageExtensionPatterns()), new JunFileModel.FileType(JunFileRequester.$String((String)"Movie files"), JunSystem.DefaultMovieExtensionPatterns()), new JunFileModel.FileType(JunFileRequester.$String((String)"Sound files"), JunSystem.DefaultSoundExtensionPatterns())};
        return fileTypeArray;
    }

    protected void fileTypeChanged(int n) {
        this.fileType().value_((Object)this.fileTypes()[n]);
    }

    protected void updateTailFileName() {
    }
}

