/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.graphics.framework;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import jp.co.sra.jun.graphics.framework.JunGraphicController;
import jp.co.sra.jun.graphics.framework.JunGraphicModel;
import jp.co.sra.jun.graphics.framework.JunGraphicView;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StViewJPanel;

public class JunGraphicViewSwing
extends JunAbstractViewJPanel
implements JunGraphicView {
    protected StViewJPanel canvas;
    protected JScrollPane scrollPane;

    public JunGraphicViewSwing(JunGraphicModel junGraphicModel) {
        super(junGraphicModel);
    }

    protected void initialize() {
        super.initialize();
        this.canvas = null;
        this.scrollPane = null;
    }

    protected void buildComponent() {
        this.setLayout(new BorderLayout());
        this.add(this.scrollPane(), "Center");
        this.setPreferredSize(new Dimension(200, 150));
    }

    public JunGraphicModel getGraphicModel() {
        return (JunGraphicModel)this.model();
    }

    protected void displayCanvasOn_(Graphics graphics) {
        if (!this.canvas().isShowing()) {
            return;
        }
        Rectangle rectangle = this.canvas().getBounds();
        graphics.setColor(this.canvas().getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        StDisplayable stDisplayable = this.getGraphicModel().displayObject();
        if (stDisplayable != null) {
            stDisplayable.displayOn_(graphics);
        }
    }

    public void _setupKeyboard(final Window window) {
        KeyListener keyListener = this.getGraphicModel()._keyListener();
        if (keyListener == null) {
            return;
        }
        this.addKeyListener(keyListener);
        window.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Component component = window.getFocusOwner();
                        if (component == null || component != JunGraphicViewSwing.this) {
                            JunGraphicViewSwing.this.requestFocus();
                        }
                    }
                });
            }
        });
    }

    public void makeVisible(Rectangle rectangle) {
        this.canvas().scrollRectToVisible(rectangle);
    }

    public Point scrollOffset() {
        return this.scrollPane().getViewport().getViewPosition();
    }

    public void scrollTo_(Point point) {
        if (this.scrollOffset().equals(point)) {
            return;
        }
        this.scrollPane().getViewport().setViewPosition(point);
    }

    public void update_(DependentEvent dependentEvent) {
        StSymbol stSymbol = dependentEvent.getAspect();
        if (stSymbol == JunGraphicViewSwing.$((String)"redisplay")) {
            this.updateCanvasSize();
            return;
        }
        if (stSymbol == JunGraphicViewSwing.$((String)"selection") && dependentEvent.getParameter() instanceof Rectangle) {
            this.getGraphicModel().recomposeIn_((Rectangle)dependentEvent.getParameter());
            this.canvas().repaint();
            return;
        }
        this.getGraphicModel().recomposeIn_(new Rectangle(new Point(0, 0), this.canvas().getSize()));
        super.update_(dependentEvent);
    }

    protected void updateCanvasSize() {
        this.getGraphicModel().recomposeIn_(this.scrollPane().getViewport().getViewRect());
        if (this.getGraphicModel().displayObject() != null) {
            this.canvas().setPreferredSize(this.getGraphicModel().displayObject().bounds().getSize());
        }
        this.scrollPane().getViewport().doLayout();
        this.canvas().repaint();
    }

    public StViewJPanel canvas() {
        if (this.canvas == null) {
            this.canvas = new StViewJPanel((StModel)this.getGraphicModel()){

                protected StController defaultController() {
                    return new JunGraphicController();
                }

                public void displayOn_(Graphics graphics) {
                    JunGraphicViewSwing.this.displayCanvasOn_(graphics);
                }
            };
            this.canvas.setBackground(Color.white);
        }
        return this.canvas;
    }

    protected JScrollPane scrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane((Component)this.canvas(), 22, 32);
            this.scrollPane.getHorizontalScrollBar().setFocusable(false);
            this.scrollPane.getVerticalScrollBar().setFocusable(false);
            this.scrollPane.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    JunGraphicViewSwing.this.updateCanvasSize();
                }
            });
        }
        return this.scrollPane;
    }
}

