/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.graphics.framework;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.SwingUtilities;
import jp.co.sra.jun.graphics.framework.JunGraphicController;
import jp.co.sra.jun.graphics.framework.JunGraphicModel;
import jp.co.sra.jun.graphics.framework.JunGraphicView;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StViewCanvas;

public class JunGraphicViewAwt
extends JunAbstractViewPanel
implements JunGraphicView {
    protected StViewCanvas canvas;
    protected ScrollPane scrollPane;

    public JunGraphicViewAwt(JunGraphicModel junGraphicModel) {
        super(junGraphicModel);
    }

    protected void initialize() {
        super.initialize();
        this.canvas = null;
        this.scrollPane = null;
    }

    protected void buildComponent() {
        this.setLayout(new BorderLayout());
        this.add(this.scrollPane(), "Center");
        this.scrollPane().setSize(200, 150);
    }

    public JunGraphicModel getGraphicModel() {
        return (JunGraphicModel)this.model();
    }

    protected void displayCanvasOn_(Graphics graphics) {
        if (!this.canvas().isShowing()) {
            return;
        }
        Rectangle rectangle = this.canvas().getBounds();
        graphics.setColor(this.canvas().getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        StDisplayable stDisplayable = this.getGraphicModel().displayObject();
        if (stDisplayable != null) {
            stDisplayable.displayOn_(graphics);
        }
    }

    public void _setupKeyboard(final Window window) {
        KeyListener keyListener = this.getGraphicModel()._keyListener();
        if (keyListener == null) {
            return;
        }
        this.addKeyListener(keyListener);
        window.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Component component = window.getFocusOwner();
                        if (component == null || component != JunGraphicViewAwt.this) {
                            JunGraphicViewAwt.this.requestFocus();
                        }
                    }
                });
            }
        });
    }

    public void makeVisible(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(this.scrollPane().getScrollPosition(), this.scrollPane().getViewportSize());
        if (rectangle2.contains(rectangle)) {
            return;
        }
        Point point = this.scrollPane().getScrollPosition();
        if (rectangle.x + rectangle.width >= rectangle2.x + rectangle2.width) {
            point.x = rectangle.x - (rectangle2.width - rectangle.width);
        }
        if (rectangle.x <= rectangle2.x || rectangle.width >= rectangle2.width) {
            point.x = rectangle.x;
        }
        if (rectangle.y + rectangle.height >= rectangle2.y + rectangle2.height) {
            point.y = rectangle.y - (rectangle2.height - rectangle.height);
        }
        if (rectangle.y <= rectangle2.y || rectangle.height >= rectangle2.height) {
            point.y = rectangle.y;
        }
        this.scrollPane().setScrollPosition(point);
    }

    public Point scrollOffset() {
        return this.scrollPane().getScrollPosition();
    }

    public void scrollTo_(Point point) {
        if (this.scrollOffset().equals(point)) {
            return;
        }
        this.scrollPane().setScrollPosition(point);
    }

    public void update_(DependentEvent dependentEvent) {
        StSymbol stSymbol = dependentEvent.getAspect();
        if (stSymbol == JunGraphicViewAwt.$((String)"redisplay")) {
            this.updateCanvasSize();
            return;
        }
        if (stSymbol == JunGraphicViewAwt.$((String)"selection") && dependentEvent.getParameter() instanceof Rectangle) {
            this.getGraphicModel().recomposeIn_((Rectangle)dependentEvent.getParameter());
            this.canvas().repaint();
            return;
        }
        this.getGraphicModel().recomposeIn_(new Rectangle(new Point(0, 0), this.canvas().getSize()));
        super.update_(dependentEvent);
    }

    protected void updateCanvasSize() {
        this.getGraphicModel().recomposeIn_(new Rectangle(new Point(0, 0), this.scrollPane().getViewportSize()));
        if (this.getGraphicModel().displayObject() != null) {
            this.canvas().setSize(this.getGraphicModel().displayObject().bounds().getSize());
        }
        this.scrollPane().doLayout();
    }

    public StViewCanvas canvas() {
        if (this.canvas == null) {
            this.canvas = new StViewCanvas((StModel)this.getGraphicModel()){

                protected StController defaultController() {
                    return new JunGraphicController();
                }

                public void displayOn_(Graphics graphics) {
                    JunGraphicViewAwt.this.displayCanvasOn_(graphics);
                }
            };
            this.canvas.setBackground(Color.white);
        }
        return this.canvas;
    }

    protected ScrollPane scrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new ScrollPane(1);
            this.scrollPane.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    JunGraphicViewAwt.this.updateCanvasSize();
                }
            });
            this.scrollPane.add((Component)this.canvas());
            this.updateCanvasSize();
        }
        return this.scrollPane;
    }
}

