/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.wheels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import jp.co.sra.jun.goodies.wheels.JunThumbWheel;
import jp.co.sra.jun.goodies.wheels.JunThumbWheelController;
import jp.co.sra.jun.goodies.wheels.JunThumbWheelView;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StModel;

public class JunThumbWheelViewSwing
extends JunAbstractViewJPanel
implements JunThumbWheelView {
    protected Image[] thumbWheelImages;
    protected int currentIndex;
    protected boolean isVertical;

    public JunThumbWheelViewSwing(JunThumbWheel junThumbWheel) {
        super(junThumbWheel);
        this.isVertical = junThumbWheel.verticalFlag();
    }

    public JunThumbWheelViewSwing(JunThumbWheel junThumbWheel, boolean bl) {
        super(junThumbWheel);
        this.setVertical(bl);
    }

    protected void buildComponent() {
        Rectangle rectangle = this.thumbWheelArea();
        rectangle = this.getModel().verticalFlag() ? new Rectangle(rectangle.x - 3, rectangle.y - 6, rectangle.width + 6, rectangle.height + 12) : new Rectangle(rectangle.x - 6, rectangle.y - 3, rectangle.width + 12, rectangle.height + 6);
        this.setPreferredSize(rectangle.getSize());
    }

    protected StController defaultController() {
        return new JunThumbWheelController();
    }

    protected StModel defaultModel() {
        return new JunThumbWheel();
    }

    public JunThumbWheel getModel() {
        return (JunThumbWheel)this.model();
    }

    public void setModel(JunThumbWheel junThumbWheel) {
        this.model_((StModel)junThumbWheel);
    }

    protected Image currentImage() {
        return this.thumbWheelImages()[this.currentIndex()];
    }

    protected int currentIndex() {
        return this.currentIndex;
    }

    protected int decreaseIndex() {
        this.currentIndex = this.currentIndex <= 0 ? this.thumbWheelImages().length - 1 : --this.currentIndex;
        return this.currentIndex;
    }

    protected int increaseIndex() {
        this.currentIndex = this.currentIndex >= this.thumbWheelImages().length - 1 ? 0 : ++this.currentIndex;
        return this.currentIndex;
    }

    public Rectangle thumbWheelArea() {
        Image image = this.currentImage();
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        Dimension dimension = this.getSize();
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        int n3 = rectangle.x + (rectangle.width - n) / 2;
        int n4 = rectangle.y + (rectangle.height - n2) / 2;
        return new Rectangle(n3, n4, n, n2);
    }

    protected Image[] thumbWheelImages() {
        if (this.thumbWheelImages == null) {
            this.thumbWheelImages = this.isVertical() ? VerticalThumbWheelImages : HorizontalThumbWheelImages;
        }
        return this.thumbWheelImages;
    }

    public void setVertical(boolean bl) {
        this.getModel().verticalFlag_(bl);
        this.thumbWheelImages = null;
        this.isVertical = bl;
        this.buildComponent();
    }

    public void displayOn_(Graphics graphics) {
        if (!this.isShowing()) {
            return;
        }
        Rectangle rectangle = this.thumbWheelArea();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        Rectangle rectangle2 = this.isVertical() ? new Rectangle(rectangle.x - 3, rectangle.y - 6, rectangle.width + 6, rectangle.height + 12) : new Rectangle(rectangle.x - 6, rectangle.y - 3, rectangle.width + 12, rectangle.height + 6);
        graphics.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        graphics.setColor(new Color(76, 76, 76));
        graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle2.x + 2, rectangle2.y + 2, rectangle2.width - 4, rectangle2.height - 4);
        graphics.setColor(new Color(178, 178, 178));
        graphics.drawRect(rectangle2.x + 1, rectangle2.y + 1, rectangle2.width - 2, rectangle2.height - 2);
        this.displayCurrentImageOn_(graphics);
    }

    protected void displayCurrentImageOn_(Graphics graphics) {
        Rectangle rectangle = this.thumbWheelArea();
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.drawImage(this.currentImage(), rectangle.x, rectangle.y, null);
    }

    public void rotateDelta_(Point point) {
        double d;
        if (this.isVertical()) {
            int n = this.currentImage().getHeight(null) / 2;
            double d2 = n;
            if (point.y > n) {
                point.y = n;
            }
            d = Math.atan((double)point.y / d2) / Math.PI * 180.0;
        } else {
            int n = this.currentImage().getWidth(null) / 2;
            double d3 = n;
            if (point.x > n) {
                point.x = n;
            }
            d = Math.atan((double)point.x / d3) / Math.PI * 180.0;
        }
        if (d == 0.0) {
            return;
        }
        if (this.model().respondsTo_("angularValue")) {
            try {
                this.model().perform_with_("angularValue_", (Object)new Double(d));
            }
            catch (Exception exception) {
                throw new SmalltalkException(exception);
            }
        } else {
            this.update_(new DependentEvent((Object)this, JunThumbWheelViewSwing.$((String)"value"), (Object)new Double(d)));
        }
    }

    public boolean isHorizontal() {
        return !this.isVertical();
    }

    public boolean isVertical() {
        if (this.getModel() != null) {
            boolean bl = this.getModel().verticalFlag();
            if (bl != this.isVertical) {
                this.thumbWheelImages = null;
            }
            this.isVertical = bl;
        } else {
            this.isVertical = false;
        }
        return this.isVertical;
    }

    public void update_(DependentEvent dependentEvent) {
        if (!this.isShowing()) {
            return;
        }
        if (dependentEvent.getAspect() == JunThumbWheelViewSwing.$((String)"value")) {
            this.updateValue_(((Number)dependentEvent.getParameter()).doubleValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateValue_(double d) {
        Graphics graphics = this.getGraphics();
        try {
            int n = (int)Math.abs(d) / 10 + 1;
            if (d > 0.0) {
                for (int i = 0; i < n; ++i) {
                    this.increaseIndex();
                    this.displayCurrentImageOn_(graphics);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    this.decreaseIndex();
                    this.displayCurrentImageOn_(graphics);
                }
            }
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
    }
}

