/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.wavelet;

import jp.co.sra.jun.goodies.wavelet.JunDiscreteWaveletTransformation;
import jp.co.sra.jun.goodies.wavelet.JunWaveletTransformation;

public class JunDiscreteWavelet1dTransformation
extends JunDiscreteWaveletTransformation {
    protected double[] sourceCoefficients;
    protected double[] scalingCoefficients;
    protected double[] waveletCoefficients;
    protected double[] recomposedCoefficients;

    public JunDiscreteWavelet1dTransformation(double[] dArray) {
        this.sourceCoefficients_(dArray);
    }

    public JunDiscreteWavelet1dTransformation(double[] dArray, double[] dArray2) {
        this.scalingCoefficients_(dArray);
        this.waveletCoefficients_(dArray2);
    }

    protected void initialize() {
        super.initialize();
        this.sourceCoefficients = null;
        this.scalingCoefficients = null;
        this.waveletCoefficients = null;
        this.recomposedCoefficients = null;
    }

    public double[] recomposedCoefficients() {
        if (this.recomposedCoefficients == null) {
            this.computeRecomposedCoefficients();
        }
        return this.recomposedCoefficients;
    }

    public double[] scalingCoefficients() {
        if (this.scalingCoefficients == null) {
            this.computeScalingAndWaveletCoefficients();
        }
        return this.scalingCoefficients;
    }

    public void scalingCoefficients_(double[] dArray) {
        this.scalingCoefficients = dArray;
        this.recomposedCoefficients = null;
    }

    public double[] sourceCoefficients() {
        return this.sourceCoefficients;
    }

    public void sourceCoefficients_(double[] dArray) {
        this.sourceCoefficients = dArray;
        this.scalingCoefficients = null;
        this.recomposedCoefficients = null;
    }

    public double[] waveletCoefficients() {
        if (this.waveletCoefficients == null) {
            this.computeScalingAndWaveletCoefficients();
        }
        return this.waveletCoefficients;
    }

    public void waveletCoefficients_(double[] dArray) {
        this.waveletCoefficients = dArray;
        this.recomposedCoefficients = null;
    }

    public JunWaveletTransformation applyTo_(Object object) {
        if (!(object instanceof double[])) {
            throw new IllegalArgumentException("anObject must be a double[].");
        }
        this.sourceCoefficients_((double[])object);
        this.scalingCoefficients();
        this.waveletCoefficients();
        return this;
    }

    public JunWaveletTransformation transform_(JunWaveletTransformation junWaveletTransformation) {
        if (!(junWaveletTransformation instanceof JunDiscreteWavelet1dTransformation)) {
            throw new IllegalArgumentException("anObject must be a JunDiscreteWavelet1dTransformation.");
        }
        JunDiscreteWavelet1dTransformation junDiscreteWavelet1dTransformation = (JunDiscreteWavelet1dTransformation)junWaveletTransformation;
        return (JunWaveletTransformation)((Object)JunDiscreteWavelet1dTransformation._New(((Object)((Object)this)).getClass(), (Object)(junDiscreteWavelet1dTransformation.sourceCoefficients() == null ? junDiscreteWavelet1dTransformation.recomposedCoefficients() : null)));
    }

    protected void computeRecomposedCoefficients() {
        if (this.scalingCoefficients == null) {
            return;
        }
        if (this.waveletCoefficients == null) {
            return;
        }
        int n = this.scalingCoefficients.length;
        this.recomposedCoefficients = new double[n * 2];
        int n2 = Math.max(1024, n);
        for (int i = 0; i < n; ++i) {
            int n3 = i;
            int n4 = n3 * 2;
            this.recomposedCoefficients[n4] = 0.0;
            this.recomposedCoefficients[n4 + 1] = 0.0;
            int n5 = 0;
            while (n5 < this.daubechieScalingSequence.length / 2) {
                int n6 = n5++;
                int n7 = n6 * 2;
                int n8 = (n3 - n6 + n2) % n;
                double d = this.scalingCoefficients[n8];
                double d2 = this.waveletCoefficients[n8];
                this.recomposedCoefficients[n4] = this.recomposedCoefficients[n4] + this.daubechieScalingSequence[n7] * d + this.daubechieWaveletSequence[n7] * d2;
                this.recomposedCoefficients[n4 + 1] = this.recomposedCoefficients[n4 + 1] + this.daubechieScalingSequence[n7 + 1] * d + this.daubechieWaveletSequence[n7 + 1] * d2;
            }
        }
    }

    protected void computeScalingAndWaveletCoefficients() {
        if (this.sourceCoefficients == null) {
            return;
        }
        int n = this.sourceCoefficients.length;
        int n2 = n / 2;
        this.scalingCoefficients = new double[n2];
        this.waveletCoefficients = new double[n2];
        for (int i = 0; i < n2; ++i) {
            this.scalingCoefficients[i] = 0.0;
            this.waveletCoefficients[i] = 0.0;
            for (int j = 0; j < this.daubechieScalingSequence.length; ++j) {
                int n3 = (j + 2 * i) % n;
                double d = this.sourceCoefficients[n3];
                this.scalingCoefficients[i] = this.scalingCoefficients[i] + this.daubechieScalingSequence[j] * d;
                this.waveletCoefficients[i] = this.waveletCoefficients[i] + this.daubechieWaveletSequence[j] * d;
            }
        }
    }
}

