/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.utilities.JunStringUtility;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.smalltalk.StObject;

public class JunTextFileToHtmlFile
extends StObject {
    protected File textFile;
    private char startingChar;

    public static JunTextFileToHtmlFile Request() {
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunTextFileToHtmlFile.$String((String)"Text files"), new String[]{"*.txt", "*.TXT"}), JunFileModel.FileType.All(JunTextFileToHtmlFile.$String((String)"All files"))};
        File file = JunFileRequesterDialog.Request(JunTextFileToHtmlFile.$String((String)"Select a file"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        return new JunTextFileToHtmlFile(file);
    }

    public JunTextFileToHtmlFile(File file) {
        this.initialize();
        this.textFile_(file);
    }

    protected void initialize() {
        this.textFile = null;
    }

    public File textFile() {
        return this.textFile;
    }

    public void textFile_(File file) {
        this.textFile = file;
    }

    public File htmlFile() {
        if (this.textFile() == null) {
            return null;
        }
        File file = this.textFile().getParentFile();
        String string = this.textFile().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return new File(file, string + ".html");
    }

    protected String titleString() {
        if (this.textFile() == null) {
            return "";
        }
        String string = this.textFile().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert() {
        File file = this.htmlFile();
        if (file == null) {
            return;
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            JunCursors junCursors = new JunCursors(JunCursors.WriteCursor());
            try {
                junCursors._show();
                this.beginConversion_(printWriter);
                this.doConversion_(printWriter);
                this.endConversion_(printWriter);
            }
            finally {
                junCursors._restore();
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
        }
    }

    protected void beginConversion_(PrintWriter printWriter) {
        printWriter.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        printWriter.println("<HTML lang=\"ja\">");
        printWriter.println("<HEAD>");
        printWriter.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=Shift_JIS\">");
        printWriter.println("<TITLE>" + this.titleString() + "</TITLE>");
        printWriter.println("</HEAD>");
        printWriter.println("<BODY bgcolor=\"#ffffff\">");
    }

    protected void endConversion_(PrintWriter printWriter) {
        printWriter.println("</BODY>");
        printWriter.println("</HTML>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConversion_(PrintWriter printWriter) {
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(this.textFile()));
            printWriter.println("<PRE>");
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf("http://");
                if (n >= 0) {
                    printWriter.println(this.htmlAnchorTagString_startingAt_(string, n));
                    continue;
                }
                printWriter.println(JunStringUtility.HtmlCanonicalString_(string));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
        finally {
            printWriter.println("</PRE>");
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String htmlAnchorTagString_startingAt_(String string, int n) {
        int n2;
        this.startingChar = (char)(n > 0 ? (int)string.charAt(n - 1) : 65535);
        for (n2 = n; n2 < string.length() && !this.isSeparatorCharacter(string.charAt(n2)); ++n2) {
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, n));
        stringBuffer.append("<A HREF=\"");
        stringBuffer.append(string.substring(n, n2));
        stringBuffer.append("\">");
        stringBuffer.append(string.substring(n, n2));
        stringBuffer.append("</A>");
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    private boolean isSeparatorCharacter(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        switch (c) {
            case '\u3000': 
            case '\u3001': 
            case '\u3002': 
            case '\uff0c': 
            case '\uff0e': {
                return true;
            }
        }
        if (this.startingChar != '\uffff') {
            if (this.startingChar == '(' && c == ')') {
                return true;
            }
            if (this.startingChar == '[' && c == ']') {
                return true;
            }
            if (this.startingChar == '<' && c == '>') {
                return true;
            }
            if (this.startingChar == '{' && c == '}') {
                return true;
            }
            if (this.startingChar == '\u3008' && c == '\u3009') {
                return true;
            }
            if (this.startingChar == '\u300a' && c == '\u300b') {
                return true;
            }
            if (this.startingChar == '\u300c' && c == '\u300d') {
                return true;
            }
            if (this.startingChar == '\u300e' && c == '\u300f') {
                return true;
            }
            if (this.startingChar == '\u3010' && c == '\u3011') {
                return true;
            }
            if (this.startingChar == '\u3014' && c == '\u3015') {
                return true;
            }
            if (this.startingChar == '\u2018' && c == '\u2019') {
                return true;
            }
            if (this.startingChar == '\u201c' && c == '\u201d') {
                return true;
            }
            if (this.startingChar == '\u226a' && c == '\u226b') {
                return true;
            }
            if (this.startingChar == '\uff08' && c == '\uff09') {
                return true;
            }
            if (this.startingChar == '\uff1c' && c == '\uff1e') {
                return true;
            }
            if (this.startingChar == '\uff3b' && c == '\uff3d') {
                return true;
            }
            if (this.startingChar == '\uff5b' && c == '\uff5d') {
                return true;
            }
        }
        return false;
    }
}

