/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.tables;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.goodies.tables.JunAdjacencyTable;
import jp.co.sra.jun.goodies.tables.JunAttributeTable;
import jp.co.sra.jun.goodies.tables.JunReferenceTable;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;

public class JunAdjacencyMatrix
extends JunAbstractObject {
    protected boolean isUndirectedGraph;
    protected JunAdjacencyTable adjacencyTable;
    protected Object[] cachedNodes;
    protected Object[] cachedArcs;
    protected Object[] cachedRoots;
    protected HashMap cachedNodeToArcs;

    public JunAdjacencyMatrix() {
    }

    public JunAdjacencyMatrix(JunLispList junLispList) {
        this();
        this.fromLispList(junLispList);
    }

    protected void initialize() {
        super.initialize();
        this.isUndirectedGraph = false;
        this.adjacencyTable = new JunAdjacencyTable();
        this.flushCachedAll();
    }

    public void beDirectedGraph() {
        if (this.isDirectedGraph()) {
            return;
        }
        this.isUndirectedGraph = false;
    }

    public void beUndirectedGraph() {
        if (this.isUndirectedGraph()) {
            return;
        }
        this.isUndirectedGraph = true;
        Object[] objectArray = this.arcs();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = ((Object[])objectArray[i])[0];
            Object object2 = ((Object[])objectArray[i])[2];
            JunAttributeTable junAttributeTable = (JunAttributeTable)((Object)((Object[])objectArray[i])[1]);
            JunAttributeTable junAttributeTable2 = this.adjacencyTable.at_with_(object2, object);
            JunAttributeTable junAttributeTable3 = junAttributeTable;
            if (junAttributeTable != null && junAttributeTable2 != null) {
                junAttributeTable3 = junAttributeTable.merge_(junAttributeTable2);
            }
            this.adjacencyTable.at_with_put_(object, object2, junAttributeTable3);
            this.adjacencyTable.at_with_put_(object2, object, junAttributeTable3);
        }
        this.flushCachedAll();
    }

    public int numberOfNodes() {
        return this.nodes().length;
    }

    public int numberOfArcs() {
        int n = this.arcs().length;
        if (this.isUndirectedGraph()) {
            n /= 2;
        }
        return n;
    }

    public int numberOfRoots() {
        return this.roots().length;
    }

    public int minimumNumberOfArcs() {
        return 0;
    }

    public int maximumNumberOfArcs() {
        int n = this.size() * (this.size() - 1);
        if (this.isUndirectedGraph()) {
            n /= 2;
        }
        return n;
    }

    public int size() {
        return this.adjacencyTable.size();
    }

    public Object[] nodes() {
        if (this.cachedNodes == null) {
            TreeSet treeSet = new TreeSet(new Comparator(){

                public int compare(Object object, Object object2) {
                    if (object instanceof Comparable) {
                        return ((Comparable)object).compareTo(object2);
                    }
                    if (object2 instanceof Comparable) {
                        return ((Comparable)object2).compareTo(object) * -1;
                    }
                    return object.toString().compareTo(object2.toString());
                }
            });
            treeSet.addAll(this.adjacencyTable.keys());
            this.cachedNodes = treeSet.toArray(new Object[treeSet.size()]);
        }
        return this.cachedNodes;
    }

    public Object[] nodesBreadthFirst() {
        return this.nodesBreadthFirst_(null);
    }

    public Object[] nodesBreadthFirst_(Object object) {
        final ArrayList arrayList = new ArrayList(this.numberOfNodes());
        this.nodesBreadthFirstDo_startNode_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                arrayList.add(object);
                return null;
            }
        }, object);
        return arrayList.toArray();
    }

    public Object[] nodesDepthFirst() {
        return this.nodesDepthFirst_(null);
    }

    public Object[] nodesDepthFirst_(Object object) {
        final ArrayList arrayList = new ArrayList(this.numberOfNodes());
        this.nodesDepthFirstDo_startNode_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                arrayList.add(object);
                return null;
            }
        }, object);
        return arrayList.toArray();
    }

    public Object[] nodesPartialOrder() {
        return this.nodesPartialOrder_(null);
    }

    public Object[] nodesPartialOrder_(Object object) {
        final ArrayList arrayList = new ArrayList(this.numberOfNodes());
        this.nodesPartialOrderDo_startNode_(new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                arrayList.add(object);
                return null;
            }
        }, object);
        return arrayList.toArray();
    }

    public Object[] nodesTopologicalSort() {
        return this.nodesPartialOrder();
    }

    public Object[] nodesTopologicalSort_(Object object) {
        return this.nodesPartialOrder_(object);
    }

    public Object[] roots() {
        if (this.cachedRoots == null) {
            if (this.isEmpty()) {
                this.cachedRoots = new Object[0];
            } else {
                HashSet<Object> hashSet = new HashSet<Object>();
                Object[] objectArray = this.arcs();
                for (int i = 0; i < objectArray.length; ++i) {
                    hashSet.add(((Object[])objectArray[i])[2]);
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Object[] objectArray2 = this.nodes();
                for (int i = 0; i < objectArray2.length; ++i) {
                    if (hashSet.contains(objectArray2[i])) continue;
                    arrayList.add(objectArray2[i]);
                }
                this.cachedRoots = arrayList.toArray();
            }
        }
        return this.cachedRoots;
    }

    public Map shortestPaths() {
        HashMap<Object, Map> hashMap = new HashMap<Object, Map>(this.numberOfNodes());
        Object[] objectArray = this.nodes();
        for (int i = 0; i < objectArray.length; ++i) {
            hashMap.put(objectArray[i], this.shortestPathFrom_(objectArray[i]));
        }
        return hashMap;
    }

    public Map shortestPathFrom_(Object object) {
        return (Map)this.visitDijkstra_(object).at_(JunAdjacencyMatrix.$((String)"distanceTable"));
    }

    public Object[] reachableNodesFrom_(final Object object) {
        final ArrayList arrayList = new ArrayList(this.numberOfNodes());
        this.visitDepthFirst_nodeDo_arcDo_(object, new StBlockClosure(){

            public Object value_value_value_(Object object4, Object object2, Object object3) {
                if (!object4.equals(object)) {
                    arrayList.add(object4);
                }
                return null;
            }
        }, new StBlockClosure());
        return arrayList.toArray();
    }

    public Object[] arcs() {
        if (this.cachedArcs == null) {
            TreeSet<Object[]> treeSet = new TreeSet<Object[]>(new Comparator(){

                public int compare(Object object, Object object2) {
                    Object[] objectArray = (Object[])object;
                    Object[] objectArray2 = (Object[])object2;
                    Object object3 = objectArray[0];
                    Object object4 = objectArray2[0];
                    Object object5 = objectArray[2];
                    Object object6 = objectArray2[2];
                    Object object7 = object3;
                    Object object8 = object4;
                    if (object3.equals(object4)) {
                        object7 = object5;
                        object8 = object6;
                    }
                    if (object7 instanceof Comparable) {
                        return ((Comparable)object7).compareTo(object8);
                    }
                    if (object8 instanceof Comparable) {
                        return ((Comparable)object8).compareTo(object7) * -1;
                    }
                    return object7.toString().compareTo(object8.toString());
                }
            });
            Iterator iterator = this.adjacencyTable.entries().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Object k = entry.getKey();
                Iterator iterator2 = ((JunReferenceTable)((Object)entry.getValue())).entries().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry2 = (Map.Entry)iterator2.next();
                    Object k2 = entry2.getKey();
                    JunAttributeTable junAttributeTable = this.adjacencyTable.at_with_(k, k2);
                    if (junAttributeTable == null) continue;
                    treeSet.add(new Object[]{k, junAttributeTable, k2});
                }
            }
            this.cachedArcs = treeSet.toArray(new Object[treeSet.size()]);
        }
        return this.cachedArcs;
    }

    public Object[] arcsOf_(Object object) {
        Object[] objectArray;
        if (this.cachedNodeToArcs == null) {
            this.cachedNodeToArcs = new HashMap();
        }
        if ((objectArray = (Object[])this.cachedNodeToArcs.get(object)) == null) {
            TreeSet<Object> treeSet = new TreeSet<Object>(new Comparator(){

                public int compare(Object object, Object object2) {
                    Object object3 = ((Object[])object)[2];
                    Object object4 = ((Object[])object2)[2];
                    if (object3 instanceof Comparable) {
                        return ((Comparable)object3).compareTo(object4);
                    }
                    if (object4 instanceof Comparable) {
                        return ((Comparable)object4).compareTo(object4) * -1;
                    }
                    return object3.toString().compareTo(object4.toString());
                }
            });
            treeSet.addAll(Arrays.asList(this.downArcsOfNode_(object)));
            objectArray = treeSet.toArray();
            this.cachedNodeToArcs.put(object, objectArray);
        }
        return objectArray;
    }

    public Object[] downArcsOfNode_(Object object) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Object[] objectArray = this.arcs();
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2 = (Object[])objectArray[i];
            if (!objectArray2[0].equals(object)) continue;
            arrayList.add(objectArray2);
        }
        return arrayList.toArray();
    }

    public Object[] upArcsOfNode_(Object object) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Object[] objectArray = this.arcs();
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2 = (Object[])objectArray[i];
            if (!objectArray2[2].equals(object)) continue;
            arrayList.add(objectArray2);
        }
        return arrayList.toArray();
    }

    public JunAttributeTable between_and_(Object object, Object object2) {
        return this.adjacencyTable.at_with_(object, object2);
    }

    public JunReferenceTable add_(Object object) {
        JunReferenceTable junReferenceTable = this.adjacencyTable.add_(object);
        if (junReferenceTable != null) {
            this.flushCachedNodes();
        }
        return junReferenceTable;
    }

    public Object remove_(Object object) {
        Object object2 = this.adjacencyTable.remove_(object);
        if (object2 != null) {
            this.flushCachedAll();
            object2 = object;
        }
        return object2;
    }

    public Boolean connect_with_(Object object, Object object2) {
        Boolean bl = this.adjacencyTable.connect_with_undirected_(object, object2, this.isUndirectedGraph());
        if (bl != null && bl.booleanValue()) {
            this.flushCachedAll();
        }
        return bl;
    }

    public Boolean connect_with_attribute_(Object object, Object object2, Map.Entry entry) {
        return this.connect_with_key_value_(object, object2, entry.getKey(), entry.getValue());
    }

    public Boolean connect_with_key_value_(Object object, Object object2, Object object3, Object object4) {
        Boolean bl = this.connect_with_(object, object2);
        if (bl != null) {
            JunAttributeTable junAttributeTable = this.adjacencyTable.at_with_(object, object2);
            junAttributeTable.at_put_(object3, object4);
            if (this.isUndirectedGraph()) {
                junAttributeTable = this.adjacencyTable.at_with_(object2, object);
                junAttributeTable.at_put_(object3, object4);
            }
        }
        return bl;
    }

    public Boolean connect_with_cost_(Object object, Object object2, int n) {
        return this.connect_with_key_value_(object, object2, JunAdjacencyMatrix.$((String)"cost"), new Integer(Math.max(n, 0)));
    }

    public Boolean disconnect_with_(Object object, Object object2) {
        Boolean bl = this.adjacencyTable.disconnect_with_undirected_(object, object2, this.isUndirectedGraph());
        if (bl != null && bl.booleanValue()) {
            this.flushCachedAll();
        }
        return bl;
    }

    public JunAttributeTable visitBreadthFirst_nodeDo_arcDo_(Object object, StBlockClosure stBlockClosure, StBlockClosure stBlockClosure2) {
        JunAttributeTable junAttributeTable = new JunAttributeTable();
        junAttributeTable.at_put_(JunAdjacencyMatrix.$((String)"nodeSequenceNumber"), new Integer(0));
        junAttributeTable.at_put_(JunAdjacencyMatrix.$((String)"arcSequenceNumber"), new Integer(0));
        junAttributeTable.at_put_(JunAdjacencyMatrix.$((String)"nodesBreadthFirst"), new ArrayList(this.numberOfNodes()));
        junAttributeTable.at_put_(JunAdjacencyMatrix.$((String)"arcsBreadthFirst"), new ArrayList(this.numberOfArcs()));
        junAttributeTable.at_put_(JunAdjacencyMatrix.$((String)"closedPath"), new ArrayList());
        HashMap<Object, StSymbol> hashMap = new HashMap<Object, StSymbol>();
        for (int i = 0; i < this.nodes().length; ++i) {
            hashMap.put(this.nodes()[i], JunAdjacencyMatrix.$((String)"unvisited"));
        }
        junAttributeTable.at_put_(JunAdjacencyMatrix.$((String)"visitingTable"), hashMap);
        LinkedList linkedList = new LinkedList();
        if (object == null) {
            Object object2;
            int n;
            for (n = 0; n < this.roots().length; ++n) {
                object2 = this.roots()[n];
                if (((HashMap)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"visitingTable"))).get(object2) != JunAdjacencyMatrix.$((String)"unvisited")) continue;
                this.visitBreadthFirst_fromNode_graphQueue_nodeDo_arcDo_(junAttributeTable, object2, linkedList, stBlockClosure, stBlockClosure2);
            }
            for (n = 0; n < this.nodes().length; ++n) {
                object2 = this.nodes()[n];
                if (((HashMap)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"visitingTable"))).get(object2) != JunAdjacencyMatrix.$((String)"unvisited")) continue;
                this.visitBreadthFirst_fromNode_graphQueue_nodeDo_arcDo_(junAttributeTable, object2, linkedList, stBlockClosure, stBlockClosure2);
            }
        } else if (((HashMap)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"visitingTable"))).get(object) == JunAdjacencyMatrix.$((String)"unvisited")) {
            this.visitBreadthFirst_fromNode_graphQueue_nodeDo_arcDo_(junAttributeTable, object, linkedList, stBlockClosure, stBlockClosure2);
        }
        return junAttributeTable;
    }

    protected void visitBreadthFirst_fromNode_graphQueue_nodeDo_arcDo_(JunAttributeTable junAttributeTable, Object object, LinkedList linkedList, StBlockClosure stBlockClosure, StBlockClosure stBlockClosure2) {
        ArrayList arrayList = (ArrayList)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"nodesBreadthFirst"));
        ArrayList arrayList2 = (ArrayList)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"arcsBreadthFirst"));
        ArrayList arrayList3 = (ArrayList)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"closedPath"));
        HashMap hashMap = (HashMap)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"visitingTable"));
        hashMap.put(object, JunAdjacencyMatrix.$((String)"entered"));
        linkedList.add(new Object[]{object, new Integer(0)});
        while (!linkedList.isEmpty()) {
            Object[] objectArray = (Object[])linkedList.removeFirst();
            Object object2 = objectArray[0];
            int n = ((Number)objectArray[1]).intValue();
            junAttributeTable.at_put_(JunAdjacencyMatrix.$((String)"nodeSequenceNumber"), new Integer(((Number)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"nodeSequenceNumber"))).intValue() + 1));
            Object[] objectArray2 = new Object[]{object2, new Integer(n), junAttributeTable.at_(JunAdjacencyMatrix.$((String)"nodeSequenceNumber"))};
            arrayList.add(objectArray2);
            stBlockClosure.value_value_value_(objectArray2[0], objectArray2[1], objectArray2[2]);
            hashMap.put(object2, JunAdjacencyMatrix.$((String)"visited"));
            Object[] objectArray3 = this.arcsOf_(object2);
            for (int i = 0; i < objectArray3.length; ++i) {
                Object[] objectArray4 = (Object[])objectArray3[i];
                Object object3 = objectArray4[2];
                junAttributeTable.at_put_(JunAdjacencyMatrix.$((String)"arcSequenceNumber"), new Integer(((Number)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"arcSequenceNumber"))).intValue() + 1));
                objectArray2 = new Object[]{objectArray4, new Integer(n), junAttributeTable.at_(JunAdjacencyMatrix.$((String)"arcSequenceNumber"))};
                arrayList2.add(objectArray2);
                stBlockClosure2.value_value_value_(objectArray2[0], objectArray2[1], objectArray2[2]);
                if (hashMap.get(object3) == JunAdjacencyMatrix.$((String)"unvisited")) {
                    linkedList.add(new Object[]{object3, new Integer(n + 1)});
                    hashMap.put(object3, JunAdjacencyMatrix.$((String)"entered"));
                    continue;
                }
                arrayList3.add(object3);
            }
        }
    }

    public JunAttributeTable visitDepthFirst_nodeDo_arcDo_(Object object, StBlockClosure stBlockClosure, StBlockClosure stBlockClosure2) {
        int n;
        JunAttributeTable junAttributeTable = new JunAttributeTable();
        junAttributeTable.at_put_(JunAdjacencyMatrix.$((String)"nodeSequenceNumber"), new Integer(0));
        junAttributeTable.at_put_(JunAdjacencyMatrix.$((String)"arcSequenceNumber"), new Integer(0));
        junAttributeTable.at_put_(JunAdjacencyMatrix.$((String)"nodesDepthFirst"), new ArrayList(this.numberOfNodes()));
        junAttributeTable.at_put_(JunAdjacencyMatrix.$((String)"arcsDepthFirst"), new ArrayList(this.numberOfArcs()));
        junAttributeTable.at_put_(JunAdjacencyMatrix.$((String)"topologicalSort"), new ArrayList(this.numberOfNodes()));
        junAttributeTable.at_put_(JunAdjacencyMatrix.$((String)"closedPath"), new ArrayList());
        HashMap<Object, StSymbol> hashMap = new HashMap<Object, StSymbol>();
        for (n = 0; n < this.nodes().length; ++n) {
            hashMap.put(this.nodes()[n], JunAdjacencyMatrix.$((String)"unvisited"));
        }
        junAttributeTable.at_put_(JunAdjacencyMatrix.$((String)"visitingTable"), hashMap);
        if (object == null) {
            Object object2;
            for (n = 0; n < this.roots().length; ++n) {
                object2 = this.roots()[n];
                if (((HashMap)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"visitingTable"))).get(object2) != JunAdjacencyMatrix.$((String)"unvisited")) continue;
                this.visitDepthFirst_fromNode_indentLevel_nodeDo_arcDo_(junAttributeTable, object2, 0, stBlockClosure, stBlockClosure2);
            }
            for (n = 0; n < this.nodes().length; ++n) {
                object2 = this.nodes()[n];
                if (((HashMap)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"visitingTable"))).get(object2) != JunAdjacencyMatrix.$((String)"unvisited")) continue;
                this.visitDepthFirst_fromNode_indentLevel_nodeDo_arcDo_(junAttributeTable, object2, 0, stBlockClosure, stBlockClosure2);
            }
        } else if (((HashMap)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"visitingTable"))).get(object) == JunAdjacencyMatrix.$((String)"unvisited")) {
            this.visitDepthFirst_fromNode_indentLevel_nodeDo_arcDo_(junAttributeTable, object, 0, stBlockClosure, stBlockClosure2);
        }
        return junAttributeTable;
    }

    protected void visitDepthFirst_fromNode_indentLevel_nodeDo_arcDo_(JunAttributeTable junAttributeTable, Object object, int n, StBlockClosure stBlockClosure, StBlockClosure stBlockClosure2) {
        ArrayList arrayList = (ArrayList)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"nodesDepthFirst"));
        ArrayList arrayList2 = (ArrayList)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"arcsDepthFirst"));
        ArrayList arrayList3 = (ArrayList)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"topologicalSort"));
        ArrayList arrayList4 = (ArrayList)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"closedPath"));
        HashMap hashMap = (HashMap)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"visitingTable"));
        junAttributeTable.at_put_(JunAdjacencyMatrix.$((String)"nodeSequenceNumber"), new Integer(((Number)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"nodeSequenceNumber"))).intValue() + 1));
        Object[] objectArray = new Object[]{object, new Integer(n), junAttributeTable.at_(JunAdjacencyMatrix.$((String)"nodeSequenceNumber"))};
        arrayList.add(objectArray);
        stBlockClosure.value_value_value_(objectArray[0], objectArray[1], objectArray[2]);
        hashMap.put(object, JunAdjacencyMatrix.$((String)"visited"));
        Object[] objectArray2 = this.arcsOf_(object);
        for (int i = 0; i < objectArray2.length; ++i) {
            Object[] objectArray3 = (Object[])objectArray2[i];
            Object object2 = objectArray3[2];
            junAttributeTable.at_put_(JunAdjacencyMatrix.$((String)"arcSequenceNumber"), new Integer(((Number)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"arcSequenceNumber"))).intValue() + 1));
            objectArray = new Object[]{objectArray3, new Integer(n), junAttributeTable.at_(JunAdjacencyMatrix.$((String)"arcSequenceNumber"))};
            arrayList2.add(objectArray);
            stBlockClosure2.value_value_value_(objectArray[0], objectArray[1], objectArray[2]);
            if (hashMap.get(object2) == JunAdjacencyMatrix.$((String)"unvisited")) {
                this.visitDepthFirst_fromNode_indentLevel_nodeDo_arcDo_(junAttributeTable, object2, n + 1, stBlockClosure, stBlockClosure2);
                continue;
            }
            arrayList4.add(object2);
        }
        arrayList3.add(object);
    }

    public JunAttributeTable visitDijkstra_(Object object) {
        return this.visitDijkstra_attributeSymbol_(object, JunAdjacencyMatrix.$((String)"cost"));
    }

    public JunAttributeTable visitDijkstra_attributeSymbol_(Object object, StSymbol stSymbol) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Object[] objectArray = this.nodes();
        for (int i = 0; i < objectArray.length; ++i) {
            hashMap.put(objectArray[i], null);
        }
        JunAttributeTable junAttributeTable = new JunAttributeTable();
        junAttributeTable.at_put_(JunAdjacencyMatrix.$((String)"distanceTable"), hashMap);
        junAttributeTable.at_put_(JunAdjacencyMatrix.$((String)"visitedNodes"), new HashSet());
        junAttributeTable.at_put_(JunAdjacencyMatrix.$((String)"unvisitedNodes"), new HashSet());
        if (object != null) {
            this.visitDijkstra_fromNode_attributeSymbol_(junAttributeTable, object, stSymbol);
        }
        return junAttributeTable;
    }

    protected void visitDijkstra_fromNode_attributeSymbol_(JunAttributeTable junAttributeTable, Object object, StSymbol stSymbol) {
        Iterator iterator;
        Object object2;
        Collection collection = (Collection)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"visitedNodes"));
        Collection collection2 = (Collection)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"unvisitedNodes"));
        Map map = (Map)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"distanceTable"));
        map.put(object, new Integer(0));
        collection.add(object);
        Object[] objectArray = this.reachableNodesFrom_(object);
        for (int i = 0; i < objectArray.length; ++i) {
            map.put(objectArray[i], null);
            collection2.add(objectArray[i]);
        }
        Object[] objectArray2 = this.arcsOf_(object);
        for (int i = 0; i < objectArray2.length; ++i) {
            object2 = (Object[])objectArray2[i];
            iterator = object2[2];
            JunAttributeTable junAttributeTable2 = (JunAttributeTable)((Object)object2[1]);
            int n = 1;
            if (junAttributeTable2.at_(stSymbol) != null) {
                n = ((Number)junAttributeTable2.at_(stSymbol)).intValue();
                n = Math.max(n, 0);
            }
            map.put(iterator, new Integer(n));
        }
        while (!collection2.isEmpty()) {
            Object e = null;
            object2 = null;
            iterator = collection2.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                Number number = (Number)map.get(e2);
                if (number == null) continue;
                if (object2 == null) {
                    object2 = number;
                    e = e2;
                    continue;
                }
                if (number.intValue() >= ((Number)object2).intValue()) continue;
                object2 = number;
                e = e2;
            }
            if (e == null) {
                e = collection2.iterator().next();
            }
            collection2.remove(e);
            collection.add(e);
            objectArray2 = this.arcsOf_(e);
            for (int i = 0; i < objectArray2.length; ++i) {
                Number number;
                Number number2;
                Object[] objectArray3 = (Object[])objectArray2[i];
                Object object3 = objectArray3[2];
                if (!collection2.contains(object3)) continue;
                JunAttributeTable junAttributeTable3 = (JunAttributeTable)((Object)objectArray3[1]);
                int n = 1;
                if (junAttributeTable3.at_(stSymbol) != null) {
                    n = ((Number)junAttributeTable3.at_(stSymbol)).intValue();
                    n = Math.max(n, 0);
                }
                if ((number2 = (Number)map.get(object3)) == null) {
                    number = (Number)map.get(e);
                    if (number != null) {
                        n += number.intValue();
                    }
                } else {
                    number = (Number)map.get(e);
                    n = number == null ? Math.min(number2.intValue(), n) : Math.min(number2.intValue(), n + number.intValue());
                }
                map.put(object3, new Integer(n));
            }
        }
    }

    public void nodesBreadthFirstDo_(StBlockClosure stBlockClosure) {
        this.nodesBreadthFirstDo_startNode_(stBlockClosure, null);
    }

    public void nodesBreadthFirstDo_startNode_(StBlockClosure stBlockClosure, Object object) {
        JunAttributeTable junAttributeTable = this.visitBreadthFirst_nodeDo_arcDo_(object, new StBlockClosure(), new StBlockClosure());
        ArrayList arrayList = (ArrayList)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"nodesBreadthFirst"));
        for (int i = 0; i < arrayList.size(); ++i) {
            Object[] objectArray = (Object[])arrayList.get(i);
            stBlockClosure.value_value_value_(objectArray[0], objectArray[1], objectArray[2]);
        }
    }

    public void nodesDepthFirstDo_(StBlockClosure stBlockClosure) {
        this.nodesDepthFirstDo_startNode_(stBlockClosure, null);
    }

    public void nodesDepthFirstDo_startNode_(StBlockClosure stBlockClosure, Object object) {
        JunAttributeTable junAttributeTable = this.visitDepthFirst_nodeDo_arcDo_(object, new StBlockClosure(), new StBlockClosure());
        ArrayList arrayList = (ArrayList)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"nodesDepthFirst"));
        for (int i = 0; i < arrayList.size(); ++i) {
            Object[] objectArray = (Object[])arrayList.get(i);
            stBlockClosure.value_value_value_(objectArray[0], objectArray[1], objectArray[2]);
        }
    }

    public void nodesPartialOrderDo_(StBlockClosure stBlockClosure) {
        this.nodesPartialOrderDo_startNode_(stBlockClosure, null);
    }

    public void nodesPartialOrderDo_startNode_(StBlockClosure stBlockClosure, Object object) {
        final HashMap hashMap = new HashMap(this.size());
        JunAttributeTable junAttributeTable = this.visitDepthFirst_nodeDo_arcDo_(object, new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                hashMap.put(object, new Object[]{object2, object3});
                return null;
            }
        }, new StBlockClosure());
        ArrayList arrayList = (ArrayList)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"topologicalSort"));
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            Object[] objectArray = (Object[])hashMap.get(e);
            Object object2 = objectArray[0];
            Object object3 = objectArray[1];
            stBlockClosure.value_value_value_(e, object2, object3);
        }
    }

    public void nodesTopologicalSortDo_(StBlockClosure stBlockClosure) {
        this.nodesPartialOrderDo_(stBlockClosure);
    }

    public void nodesTopologicalSortDo_startNode_(StBlockClosure stBlockClosure, Object object) {
        this.nodesPartialOrderDo_startNode_(stBlockClosure, object);
    }

    public void arcsBreadthFirstDo_(StBlockClosure stBlockClosure) {
        this.arcsBreadthFirstDo_startNode_(stBlockClosure, null);
    }

    public void arcsBreadthFirstDo_startNode_(StBlockClosure stBlockClosure, Object object) {
        JunAttributeTable junAttributeTable = this.visitBreadthFirst_nodeDo_arcDo_(object, new StBlockClosure(), new StBlockClosure());
        ArrayList arrayList = (ArrayList)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"arcsBreadthFirst"));
        for (int i = 0; i < arrayList.size(); ++i) {
            Object[] objectArray = (Object[])arrayList.get(i);
            stBlockClosure.value_value_value_(objectArray[0], objectArray[1], objectArray[2]);
        }
    }

    public void arcsDepthFirstDo_(StBlockClosure stBlockClosure) {
        this.arcsDepthFirstDo_startNode_(stBlockClosure, null);
    }

    public void arcsDepthFirstDo_startNode_(StBlockClosure stBlockClosure, Object object) {
        JunAttributeTable junAttributeTable = this.visitDepthFirst_nodeDo_arcDo_(object, new StBlockClosure(), new StBlockClosure());
        ArrayList arrayList = (ArrayList)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"arcsDepthFirst"));
        for (int i = 0; i < arrayList.size(); ++i) {
            Object[] objectArray = (Object[])arrayList.get(i);
            stBlockClosure.value_value_value_(objectArray[0], objectArray[1], objectArray[2]);
        }
    }

    protected void flushCachedAll() {
        this.flushCachedNodes();
        this.flushCachedArcs();
    }

    protected void flushCachedNodes() {
        this.cachedNodes = null;
        this.cachedRoots = null;
    }

    protected void flushCachedArcs() {
        this.cachedArcs = null;
        this.cachedRoots = null;
        this.cachedNodeToArcs = null;
    }

    public boolean isDirectedGraph() {
        return !this.isUndirectedGraph();
    }

    public boolean isUndirectedGraph() {
        return this.isUndirectedGraph;
    }

    public boolean isEmpty() {
        return this.adjacencyTable.isEmpty();
    }

    public boolean isIsomorphicTo_(JunAdjacencyMatrix junAdjacencyMatrix) {
        if (junAdjacencyMatrix == null) {
            return false;
        }
        if (this.isEmpty() && junAdjacencyMatrix.isEmpty()) {
            return true;
        }
        if (this.numberOfNodes() != junAdjacencyMatrix.numberOfNodes()) {
            return false;
        }
        if (this.numberOfArcs() != junAdjacencyMatrix.numberOfArcs()) {
            return false;
        }
        if (this.numberOfRoots() != junAdjacencyMatrix.numberOfRoots()) {
            return false;
        }
        if (this.numberOfArcs() == 0 && junAdjacencyMatrix.numberOfArcs() == 0) {
            return true;
        }
        Object[] objectArray = this.nodes();
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2 = junAdjacencyMatrix.nodes();
            for (int j = 0; j < objectArray2.length; ++j) {
                if (this.downArcsOfNode_(objectArray[i]).length != junAdjacencyMatrix.downArcsOfNode_(objectArray2[j]).length || this.upArcsOfNode_(objectArray[i]).length != junAdjacencyMatrix.upArcsOfNode_(objectArray2[j]).length || !this.privateIsomorphicTo_with_and_(junAdjacencyMatrix, objectArray[i], objectArray2[j])) continue;
                return true;
            }
        }
        return false;
    }

    public void _updateUniqueNumbers(Map map) {
        Map.Entry[] entryArray = this.adjacencyTable.adjacencies();
        for (int i = 0; i < entryArray.length; ++i) {
            StSymbol stSymbol = (StSymbol)entryArray[i].getKey();
            JunReferenceTable junReferenceTable = (JunReferenceTable)((Object)entryArray[i].getValue());
            StSymbol stSymbol2 = (StSymbol)map.get(stSymbol);
            this.adjacencyTable.removeKey_(stSymbol);
            this.adjacencyTable.at_put_(stSymbol2, (Object)junReferenceTable);
            Map.Entry[] entryArray2 = junReferenceTable.references();
            for (int j = 0; j < entryArray2.length; ++j) {
                stSymbol = (StSymbol)entryArray2[j].getKey();
                JunAttributeTable junAttributeTable = (JunAttributeTable)((Object)entryArray2[j].getValue());
                stSymbol2 = (StSymbol)map.get(stSymbol);
                junReferenceTable.removeKey_(stSymbol);
                junReferenceTable.at_put_(stSymbol2, (Object)junAttributeTable);
            }
        }
        this.flushCachedAll();
    }

    public void printOn_(Writer writer) throws IOException {
        int n;
        writer.write(40);
        writer.write(this._className().toString());
        writer.write(" (nodes");
        Object[] objectArray = this.nodes();
        int n2 = objectArray.length;
        if (n2 <= this.printMax()) {
            for (n = 0; n < n2; ++n) {
                this.printNodeOn_(objectArray[n], writer);
            }
        } else {
            for (n = 0; n < this.printMax() / 2; ++n) {
                this.printNodeOn_(objectArray[n], writer);
            }
            writer.write(" ...");
            for (n = n2 - this.printMax() / 2; n < n2; ++n) {
                this.printNodeOn_(objectArray[n], writer);
            }
        }
        writer.write(41);
        writer.write(" (arcs");
        Object[] objectArray2 = this.arcs();
        n2 = objectArray2.length;
        if (n2 <= this.printMax()) {
            for (int i = 0; i < n2; ++i) {
                this.printArcOn_((Object[])objectArray2[i], writer);
            }
        } else {
            int n3;
            for (n3 = 0; n3 < this.printMax() / 2; ++n3) {
                this.printArcOn_((Object[])objectArray2[n3], writer);
            }
            writer.write(" ...");
            for (n3 = n2 - this.printMax() / 2; n3 < n2; ++n3) {
                this.printArcOn_((Object[])objectArray2[n3], writer);
            }
        }
        writer.write(41);
        writer.write(41);
    }

    protected void printNodeOn_(Object object, Writer writer) throws IOException {
        writer.write(32);
        writer.write(object.toString());
    }

    protected void printArcOn_(Object[] objectArray, Writer writer) throws IOException {
        writer.write(" (");
        writer.write(objectArray[0].toString());
        writer.write("=>");
        writer.write(objectArray[2].toString());
        writer.write(41);
    }

    protected int printMax() {
        return 100;
    }

    public StSymbol kindName() {
        return this._className();
    }

    public void fromLispList(JunLispList junLispList) {
        this.undirectedGraphFromLispList(junLispList);
        this.adjacencyTableFromLispList(junLispList);
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons = new JunLispCons(this.kindName());
        junLispCons.add_((Object)this.undirectedGraphToLispList());
        junLispCons.add_((Object)this.adjacencyTableToLispList());
        return junLispCons;
    }

    protected void undirectedGraphFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = junLispList._findSublistWithHead(JunAdjacencyMatrix.$((String)"undirectedGraph"));
        if (junLispCons == null) {
            return;
        }
        Boolean bl = (Boolean)((JunLispList)junLispCons).tail();
        if (bl.booleanValue()) {
            this.beUndirectedGraph();
        } else {
            this.beDirectedGraph();
        }
    }

    protected JunLispCons undirectedGraphToLispList() {
        return new JunLispCons(JunAdjacencyMatrix.$((String)"undirectedGraph"), this.isUndirectedGraph);
    }

    protected void adjacencyTableFromLispList(JunLispList junLispList) {
        JunLispCons junLispCons = junLispList._findSublistWithHead(JunAdjacencyMatrix.$((String)"adjacencyTable"));
        if (junLispCons == null) {
            return;
        }
        this.adjacencyTable = new JunAdjacencyTable((JunLispList)((Object)((JunLispList)junLispCons).tail()));
    }

    protected JunLispCons adjacencyTableToLispList() {
        return new JunLispCons(JunAdjacencyMatrix.$((String)"adjacencyTable"), (Object)this.adjacencyTable.toLispList());
    }

    protected boolean privateIsomorphicTo_with_and_(JunAdjacencyMatrix junAdjacencyMatrix, Object object, Object object2) {
        Map.Entry entry;
        Object object3;
        final ArrayList arrayList = new ArrayList(this.numberOfNodes());
        JunAttributeTable junAttributeTable = this.visitDepthFirst_nodeDo_arcDo_(object, new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                arrayList.add(object2);
                return null;
            }
        }, new StBlockClosure());
        final ArrayList<Object> arrayList2 = new ArrayList<Object>(junAdjacencyMatrix.numberOfNodes());
        JunAttributeTable junAttributeTable2 = junAdjacencyMatrix.visitDepthFirst_nodeDo_arcDo_(object2, new StBlockClosure(){

            public Object value_value_value_(Object object, Object object2, Object object3) {
                arrayList2.add(object2);
                return null;
            }
        }, new StBlockClosure());
        if (!((Object)arrayList).equals(arrayList2)) {
            return false;
        }
        arrayList.clear();
        Iterator iterator = ((Map)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"visitingTable"))).entrySet().iterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            if (object3.getValue() != JunAdjacencyMatrix.$((String)"unvisited")) continue;
            arrayList.add(object3);
        }
        arrayList2.clear();
        iterator = ((Map)junAttributeTable2.at_(JunAdjacencyMatrix.$((String)"visitingTable"))).entrySet().iterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            if (object3.getValue() != JunAdjacencyMatrix.$((String)"unvisited")) continue;
            arrayList2.add(object3);
        }
        if (arrayList.size() != arrayList2.size()) {
            return false;
        }
        arrayList.clear();
        iterator = ((Map)junAttributeTable.at_(JunAdjacencyMatrix.$((String)"visitingTable"))).entrySet().iterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            if (object3.getValue() != JunAdjacencyMatrix.$((String)"visited")) continue;
            arrayList.add(object3);
        }
        arrayList2.clear();
        iterator = ((Map)junAttributeTable2.at_(JunAdjacencyMatrix.$((String)"visitingTable"))).entrySet().iterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            if (object3.getValue() != JunAdjacencyMatrix.$((String)"visited")) continue;
            arrayList2.add(object3);
        }
        object3 = (JunAdjacencyMatrix)this.copy();
        JunAdjacencyMatrix junAdjacencyMatrix2 = (JunAdjacencyMatrix)junAdjacencyMatrix.copy();
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            ((JunAdjacencyMatrix)((Object)object3)).remove_(entry.getKey());
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            junAdjacencyMatrix2.remove_(entry.getKey());
        }
        return ((JunAdjacencyMatrix)((Object)object3)).isIsomorphicTo_(junAdjacencyMatrix2);
    }
}

