/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.spirodesign;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.spirodesign.JunSpiroObject;
import jp.co.sra.smalltalk.StColorValue;

public class JunSpiroPen
extends JunSpiroObject {
    protected Collection penPoints;
    protected boolean isRainbow;
    public static int DefaultTickAngle = 6;

    public JunSpiroPen() {
    }

    public JunSpiroPen(Jun2dPoint jun2dPoint) {
        this.point_(jun2dPoint);
    }

    public JunSpiroPen(Jun2dPoint jun2dPoint, Color color, int n) {
        this.point_(jun2dPoint);
        this.color_(color);
        this.width_(n);
    }

    public JunSpiroPen(Collection collection) {
        this.points_(collection);
    }

    public JunSpiroPen(Collection collection, Color color, int n) {
        this.points_(collection);
        this.color_(color);
        this.width_(n);
    }

    protected void initialize() {
        super.initialize();
        this.penPoints = null;
        this.isRainbow = false;
    }

    public Rectangle mark() {
        Rectangle rectangle = new Rectangle(0, 0, Math.max(this.defaultMarkExtent().width, this.width()), Math.max(this.defaultMarkExtent().height, this.width()));
        rectangle.translate((int)Math.round(this.point().x() - rectangle.getCenterX()), (int)Math.round(this.point().y() - rectangle.getCenterY()));
        return rectangle;
    }

    public Rectangle[] marks() {
        return new Rectangle[]{this.mark()};
    }

    public Jun2dPoint point() {
        return this.isEmpty() ? new Jun2dPoint(0.0, 0.0) : this.points()[this.points().length - 1];
    }

    public void point_(Jun2dPoint jun2dPoint) {
        ArrayList<Jun2dPoint> arrayList = new ArrayList<Jun2dPoint>(1);
        arrayList.add(jun2dPoint);
        this.points_(arrayList);
    }

    public Jun2dPoint[] points() {
        if (this.penPoints == null) {
            this.penPoints = new ArrayList();
        }
        return this.penPoints.toArray(new Jun2dPoint[this.penPoints.size()]);
    }

    public void points_(Collection collection) {
        this.penPoints = collection;
    }

    public boolean rainbow() {
        return this.isRainbow;
    }

    public void rainbow_(boolean bl) {
        this.isRainbow = bl;
    }

    public Rectangle boundingBox() {
        if (this.isEmpty()) {
            return super.boundingBox();
        }
        Jun2dPoint[] jun2dPointArray = this.points();
        Rectangle rectangle = new Rectangle(jun2dPointArray[0]._toPoint(), new Dimension(0, 0));
        for (int i = 1; i < jun2dPointArray.length; ++i) {
            rectangle.add(jun2dPointArray[i]._toPoint());
        }
        return rectangle;
    }

    public Color defaultColor() {
        return Color.getHSBColor(0.083333336f, 0.75f, 0.9f);
    }

    public Dimension defaultMarkExtent() {
        return new Dimension(7, 7);
    }

    public int defaultTickAngle() {
        return DefaultTickAngle;
    }

    public int defaultReinbowNumber() {
        return Math.round(360.0f / Math.max((float)this.defaultTickAngle(), 1.0f) / 3.0f);
    }

    public int defaultWidth() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayOn_at_with_Marks_(Graphics graphics, Point point, boolean bl) {
        block14: {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                if (bl) {
                    graphics2D.translate(point.x, point.y);
                    try {
                        Rectangle[] rectangleArray = this.marks();
                        for (int i = 0; i < rectangleArray.length; ++i) {
                            Rectangle rectangle = rectangleArray[i];
                            graphics2D.setColor(Color.black);
                            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                            graphics2D.setColor(Color.white);
                            Rectangle rectangle2 = new Rectangle(rectangle);
                            rectangle2.grow(-1, -1);
                            graphics2D.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                            graphics2D.setColor(this.color());
                            rectangle2 = new Rectangle(rectangle);
                            rectangle2.grow(-2, -2);
                            graphics2D.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        }
                        break block14;
                    }
                    finally {
                        graphics2D.translate(-point.x, -point.y);
                    }
                }
                if (!this.isEmpty()) {
                    this.applyAttributesToGraphicsContext_(graphics2D);
                    if (this.isRainbow()) {
                        Jun2dPoint[] jun2dPointArray = this.points();
                        for (int i = 0; i < jun2dPointArray.length - 1; ++i) {
                            graphics2D.setColor(Color.getHSBColor((float)(i % this.defaultReinbowNumber()) / (float)this.defaultReinbowNumber(), StColorValue._GetSaturation((Color)this.color()), StColorValue._GetBrightness((Color)this.color())));
                            graphics2D.drawLine((int)Math.round(jun2dPointArray[i].x() + (double)point.x), (int)Math.round(jun2dPointArray[i].y() + (double)point.y), (int)Math.round(jun2dPointArray[i + 1].x() + (double)point.x), (int)Math.round(jun2dPointArray[i + 1].y() + (double)point.y));
                        }
                    } else {
                        Jun2dPoint[] jun2dPointArray = this.points();
                        int[] nArray = new int[jun2dPointArray.length];
                        int[] nArray2 = new int[jun2dPointArray.length];
                        for (int i = 0; i < jun2dPointArray.length; ++i) {
                            nArray[i] = (int)Math.round(jun2dPointArray[i].x()) + point.x;
                            nArray2[i] = (int)Math.round(jun2dPointArray[i].y()) + point.y;
                        }
                        graphics2D.drawPolyline(nArray, nArray2, nArray.length);
                    }
                }
            }
            finally {
                if (graphics2D != null) {
                    graphics2D.dispose();
                    graphics2D = null;
                }
            }
        }
    }

    public boolean isEmpty() {
        return this.points().length == 0;
    }

    public boolean isRainbow() {
        return this.rainbow();
    }
}

