/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.spirodesign;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.nib.JunNibChoiceWithColor;
import jp.co.sra.jun.goodies.spirodesign.JunSpiroCircle;
import jp.co.sra.jun.goodies.spirodesign.JunSpiroDesign;
import jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel;
import jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAnimationThread;
import jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignTestExamples;
import jp.co.sra.jun.goodies.spirodesign.JunSpiroPen;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StInputState;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StCheckBoxMenuItem;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

public class JunSpiroDesignModel
extends JunSpiroDesignAbstractModel {
    protected List spiroDesignCollection;
    protected transient JunSpiroDesignAnimationThread spiroDesignProcess;
    protected boolean spiroDesignState;
    protected JunNibChoiceWithColor nibChoice;
    protected transient StPopupMenu _popupMenu;

    public JunSpiroDesignModel() {
    }

    public JunSpiroDesignModel(JunSpiroDesign junSpiroDesign) {
        this(new JunSpiroDesign[]{junSpiroDesign});
    }

    public JunSpiroDesignModel(JunSpiroDesign[] junSpiroDesignArray) {
        this.setSpiroDesigns_(junSpiroDesignArray);
    }

    protected void initialize() {
        super.initialize();
        this.spiroDesignCollection = null;
        this.spiroDesignProcess = null;
        this.spiroDesignState = false;
        this.nibChoice = null;
        this._popupMenu = null;
    }

    public void noticeOfWindowClose(WindowEvent windowEvent) {
        this.endAnimation();
        this.nibChoice().closeRequest();
        super.noticeOfWindowClose(windowEvent);
    }

    public JunSpiroCircle moonCircle() {
        return this.spiroDesign().moonCircle();
    }

    public JunSpiroDesign spiroDesign() {
        return (JunSpiroDesign)((Object)this.getSpiroDesigns().get(this.getSpiroDesigns().size() - 1));
    }

    public JunSpiroDesign[] spiroDesigns() {
        return this.getSpiroDesigns().toArray(new JunSpiroDesign[this.getSpiroDesigns().size()]);
    }

    public List getSpiroDesigns() {
        if (this.spiroDesignCollection == null) {
            this.spiroDesignCollection = new ArrayList();
            this.spiroDesignCollection.add(new JunSpiroDesign());
        }
        return this.spiroDesignCollection;
    }

    public JunSpiroPen spiroPen() {
        return this.spiroDesign().spiroPen();
    }

    public JunSpiroCircle teraCircle() {
        return this.spiroDesign().teraCircle();
    }

    public JunNibChoiceWithColor nibChoice() {
        if (this.nibChoice == null) {
            this.nibChoice = new JunNibChoiceWithColor(new double[]{1.0, 2.0, 3.0, 4.0, 5.0}, this.spiroPen().width(), this.spiroPen().color(), JunSpiroDesignModel.$((String)"rectangle"));
            this.nibChoice.compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    Object[] objectArray = (Object[])object;
                    JunSpiroDesignModel.this.spiroDesign().color_width_((Color)objectArray[2], ((Number)objectArray[1]).intValue());
                    JunSpiroDesignModel.this.changed_(1.$((String)"spiroDesign"));
                    return null;
                }
            });
        }
        return this.nibChoice;
    }

    public Rectangle boundingBox() {
        return this.preferredBounds();
    }

    public Rectangle bounds() {
        return this.preferredBounds();
    }

    public Rectangle preferredBounds() {
        Rectangle rectangle = null;
        JunSpiroDesign[] junSpiroDesignArray = this.spiroDesigns();
        for (int i = 0; i < junSpiroDesignArray.length; ++i) {
            if (rectangle == null) {
                rectangle = new Rectangle(junSpiroDesignArray[i].boundingBox());
                continue;
            }
            rectangle.add(junSpiroDesignArray[i].boundingBox());
        }
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, 0, 0);
        }
        return rectangle;
    }

    public void displayOn_at_(Graphics graphics, Point point) {
        JunSpiroDesign[] junSpiroDesignArray = this.spiroDesigns();
        for (int i = 0; i < junSpiroDesignArray.length; ++i) {
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle == null) {
                rectangle = this.boundingBox();
            }
            Rectangle rectangle2 = junSpiroDesignArray[i].bounds();
            rectangle2.translate(point.x, point.y);
            if (!rectangle.intersects(rectangle2)) continue;
            if (junSpiroDesignArray[i] == this.spiroDesign()) {
                junSpiroDesignArray[i].displayOn_at_(graphics, point);
                continue;
            }
            junSpiroDesignArray[i].spiroPen().displayOn_at_with_Marks_(graphics, point, false);
        }
    }

    public void displayOn_at_withParts_(Graphics graphics, Point point, boolean bl) {
        JunSpiroDesign[] junSpiroDesignArray = this.spiroDesigns();
        for (int i = 0; i < junSpiroDesignArray.length; ++i) {
            JunSpiroPen junSpiroPen = (JunSpiroPen)junSpiroDesignArray[i].spiroPen().copy();
            junSpiroPen.points_(junSpiroDesignArray[i].spiroLocus());
            junSpiroPen.displayOn_at_with_Marks_(graphics, point, bl);
        }
    }

    public StMenu updateMenuIndication_(StMenu stMenu) {
        if (stMenu == null) {
            return null;
        }
        StMenuItem stMenuItem = stMenu.atNameKey_(JunSpiroDesignModel.$((String)"startAnimation"));
        if (stMenuItem != null) {
            if (this.isActiveSpiroDesignProcess()) {
                stMenuItem.beEnabled(false);
            } else {
                stMenuItem.beEnabled(true);
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunSpiroDesignModel.$((String)"pauseAnimation"))) != null) {
            if (this.isActiveSpiroDesignProcess()) {
                stMenuItem.beEnabled(true);
            } else {
                stMenuItem.beEnabled(false);
            }
            if (this.isSuspendSpiroDesignProcess()) {
                stMenuItem.label_((Object)JunSpiroDesignModel.$String((String)"Resume animation"));
            } else {
                stMenuItem.label_((Object)JunSpiroDesignModel.$String((String)"Pause animation"));
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunSpiroDesignModel.$((String)"endAnimation"))) != null) {
            if (this.isActiveSpiroDesignProcess()) {
                stMenuItem.beEnabled(true);
            } else {
                stMenuItem.beEnabled(false);
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunSpiroDesignModel.$((String)"beInscribe"))) != null) {
            if (this.isActiveSpiroDesignProcess()) {
                stMenuItem.beEnabled(false);
            } else if (this.spiroDesign().isInscribe()) {
                stMenuItem.beEnabled(false);
            } else {
                stMenuItem.beEnabled(true);
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunSpiroDesignModel.$((String)"beCircumscribe"))) != null) {
            if (this.isActiveSpiroDesignProcess()) {
                stMenuItem.beEnabled(false);
            } else if (this.spiroDesign().isCircumscribe()) {
                stMenuItem.beEnabled(false);
            } else {
                stMenuItem.beEnabled(true);
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunSpiroDesignModel.$((String)"toggleRainbow"))) != null) {
            if (this.spiroDesign().isRainbow()) {
                ((StCheckBoxMenuItem)stMenuItem).beOn();
            } else {
                ((StCheckBoxMenuItem)stMenuItem).beOff();
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunSpiroDesignModel.$((String)"pushSpiroDesign"))) != null) {
            if (this.isActiveSpiroDesignProcess()) {
                stMenuItem.beEnabled(false);
            } else if (this.spiroDesigns().length <= 0) {
                stMenuItem.beEnabled(false);
            } else {
                stMenuItem.beEnabled(true);
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunSpiroDesignModel.$((String)"addSpiroDesign"))) != null) {
            if (this.isActiveSpiroDesignProcess()) {
                stMenuItem.beEnabled(false);
            } else {
                stMenuItem.beEnabled(true);
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunSpiroDesignModel.$((String)"removeSpiroDesign"))) != null) {
            if (this.isActiveSpiroDesignProcess()) {
                stMenuItem.beEnabled(false);
            } else if (this.spiroDesigns().length <= 0) {
                stMenuItem.beEnabled(false);
            } else {
                stMenuItem.beEnabled(true);
            }
        }
        return stMenu;
    }

    public void addSpiroDesign() {
        this.spiroDesign().spiroPen().points_(this.spiroDesign().spiroLocus());
        this.getSpiroDesigns().add(StInputState.Default().shiftDown() || StInputState.Default().altDown() ? JunSpiroDesignTestExamples.ExampleSpiroDesign() : new JunSpiroDesign());
        this.changed_(JunSpiroDesignModel.$((String)"spiroDesign"));
    }

    public void beCircumscribe() {
        this.spiroDesign().beCircumscribe();
        this.changed_(JunSpiroDesignModel.$((String)"spiroDesign"));
    }

    public void beInscribe() {
        this.spiroDesign().beInscribe();
        this.changed_(JunSpiroDesignModel.$((String)"spiroDesign"));
    }

    public void choiceNib() {
        JunNibChoiceWithColor junNibChoiceWithColor = this.nibChoice();
        Window[] windowArray = junNibChoiceWithColor.builder().windows();
        for (int i = 0; i < windowArray.length; ++i) {
            if (windowArray[i].isShowing()) {
                windowArray[i].toFront();
                continue;
            }
            windowArray[i].setVisible(true);
        }
        if (windowArray.length == 0) {
            StView stView = this.getView();
            if (stView == null) {
                junNibChoiceWithColor.open();
            } else {
                Rectangle rectangle = stView.topComponent().getBounds();
                Rectangle rectangle2 = new Rectangle(0, 0, rectangle.width, rectangle.height);
                rectangle2.translate(rectangle.x + rectangle.width - rectangle2.x, rectangle.y - rectangle2.y);
                junNibChoiceWithColor.openAt_(rectangle2.getLocation());
            }
        }
        junNibChoiceWithColor.nibWidth_nibColor_(this.spiroDesign().spiroPen().width(), this.spiroDesign().spiroPen().color());
    }

    public synchronized void endAnimation() {
        if (this.isActiveSpiroDesignProcess()) {
            try {
                if (this.spiroDesignProcess.isAlive()) {
                    this.spiroDesignProcess.animationStop();
                }
            }
            catch (ThreadDeath threadDeath) {
                // empty catch block
            }
        }
        this.spiroDesignProcess = null;
        this.spiroDesignState = false;
        this.spiroDesign().animationState_(false);
        this.changed_(JunSpiroDesignModel.$((String)"spiroDesign"));
    }

    public synchronized void pauseAnimation() {
        if (this.isActiveSpiroDesignProcess()) {
            if (this.isSuspendSpiroDesignProcess()) {
                try {
                    this.spiroDesignProcess.animationResume();
                    this.spiroDesignState = true;
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    exception.printStackTrace();
                    this.endAnimation();
                }
            } else {
                try {
                    JunSpiroDesignModel junSpiroDesignModel = this;
                    junSpiroDesignModel.spiroDesignProcess.yield();
                    this.spiroDesignProcess.animationSuspend();
                    this.spiroDesignState = false;
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    exception.printStackTrace();
                    this.endAnimation();
                }
            }
        }
        this.changed_(JunSpiroDesignModel.$((String)"spiroDesign"));
    }

    public void pushSpiroDesign() {
        if (this.spiroDesigns().length <= 1) {
            return;
        }
        JunSpiroDesign junSpiroDesign = this.spiroDesign();
        junSpiroDesign.spiroPen().points_(junSpiroDesign.spiroLocus());
        if (!this.getSpiroDesigns().remove((Object)junSpiroDesign)) {
            return;
        }
        this.getSpiroDesigns().add(0, junSpiroDesign);
        this.spiroDesign().spiroPen().point_(this.spiroDesign().spiroPen().points()[0]);
        this.changed_(JunSpiroDesignModel.$((String)"spiroDesign"));
    }

    public void removeSpiroDesign() {
        if (this.spiroDesigns().length <= 1) {
            return;
        }
        if (!JunDialog.Confirm_(JunSpiroDesignModel.$String((String)"Really remove?"), true)) {
            return;
        }
        this.getSpiroDesigns().remove((Object)this.spiroDesign());
        this.spiroDesign().spiroPen().point_(this.spiroDesign().spiroPen().points()[0]);
        this.changed_(JunSpiroDesignModel.$((String)"spiroDesign"));
    }

    public synchronized void startAnimation() {
        this.endAnimation();
        this.spiroDesignProcess = new JunSpiroDesignAnimationThread(this.spiroDesign(), this.getSpiroDesignViews(), null){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    super.run();
                }
                finally {
                    JunSpiroDesignModel.this.endAnimation();
                }
            }
        };
        this.spiroDesignProcess.setPriority(4);
        this.spiroDesignProcess.start();
        this.spiroDesignState = true;
    }

    public void toggleRainbow() {
        this.spiroDesign().toggleRainbow();
        this.changed_(JunSpiroDesignModel.$((String)"spiroDesign"));
    }

    public JunSpiroDesign selectSpiroDesign_(JunSpiroDesign junSpiroDesign) {
        if (junSpiroDesign == null) {
            return null;
        }
        this.spiroDesign().spiroPen().points_(this.spiroDesign().spiroLocus());
        if (!this.getSpiroDesigns().remove((Object)junSpiroDesign)) {
            return null;
        }
        this.getSpiroDesigns().add(junSpiroDesign);
        this.spiroDesign().spiroPen().point_(new Jun2dPoint(this.spiroDesign().spiroPen().points()[0]));
        this.nibChoice().nibWidth_nibColor_(this.spiroDesign().spiroPen().width(), this.spiroDesign().spiroPen().color());
        return null;
    }

    public JunSpiroDesign whichSpiroDesign_(Point point) {
        JunSpiroDesign[] junSpiroDesignArray = this.spiroDesigns();
        for (int i = junSpiroDesignArray.length - 1; i >= 0; --i) {
            if (!junSpiroDesignArray[i].containsPoint_(point)) continue;
            return junSpiroDesignArray[i];
        }
        return null;
    }

    public void centerOfMoonCircle_(Jun2dPoint jun2dPoint) {
        Rectangle rectangle = this.spiroDesign().bounds();
        this.spiroDesign().centerOfMoonCircle_(jun2dPoint);
        Rectangle rectangle2 = this.spiroDesign().bounds();
        rectangle.add(rectangle2);
        this.changed_with_(JunSpiroDesignModel.$((String)"invalidate"), rectangle);
    }

    public void centerOfTeraCircle_(Jun2dPoint jun2dPoint) {
        Rectangle rectangle = this.spiroDesign().bounds();
        this.spiroDesign().centerOfTeraCircle_(jun2dPoint);
        Rectangle rectangle2 = this.spiroDesign().bounds();
        rectangle.add(rectangle2);
        this.changed_with_(JunSpiroDesignModel.$((String)"invalidate"), rectangle);
    }

    public void pointOfSpiroPen_(Jun2dPoint jun2dPoint) {
        Rectangle rectangle = this.spiroDesign().bounds();
        this.spiroDesign().pointOfSpiroPen_(jun2dPoint);
        Rectangle rectangle2 = this.spiroDesign().bounds();
        rectangle.add(rectangle2);
        this.changed_with_(JunSpiroDesignModel.$((String)"invalidate"), rectangle);
    }

    public void radiusOfMoonCircle_(double d) {
        Rectangle rectangle = this.spiroDesign().bounds();
        this.spiroDesign().radiusOfMoonCircle_(d);
        Rectangle rectangle2 = this.spiroDesign().bounds();
        rectangle.add(rectangle2);
        this.changed_with_(JunSpiroDesignModel.$((String)"invalidate"), rectangle);
    }

    public void radiusOfTeraCircle_(double d) {
        Rectangle rectangle = this.spiroDesign().bounds();
        this.spiroDesign().radiusOfTeraCircle_(d);
        Rectangle rectangle2 = this.spiroDesign().bounds();
        rectangle.add(rectangle2);
        this.changed_with_(JunSpiroDesignModel.$((String)"invalidate"), rectangle);
    }

    protected void setSpiroDesigns_(JunSpiroDesign[] junSpiroDesignArray) {
        this.spiroDesignCollection = Arrays.asList(junSpiroDesignArray);
    }

    public boolean isActiveSpiroDesignProcess() {
        return this.spiroDesignProcess != null;
    }

    public boolean isSuspendSpiroDesignProcess() {
        return this.isActiveSpiroDesignProcess() && !this.spiroDesignState;
    }

    public StPopupMenu _popupMenu() {
        if (this._popupMenu == null) {
            this._popupMenu = new StPopupMenu();
            this._popupMenu.add(new StMenuItem((Object)JunSpiroDesignModel.$String((String)"Start animation"), JunSpiroDesignModel.$((String)"startAnimation"), (MenuListener)new MenuPerformer((StObject)this, "startAnimation")));
            this._popupMenu.add(new StMenuItem((Object)JunSpiroDesignModel.$String((String)"Pause animation"), JunSpiroDesignModel.$((String)"pauseAnimation"), (MenuListener)new MenuPerformer((StObject)this, "pauseAnimation")));
            this._popupMenu.add(new StMenuItem((Object)JunSpiroDesignModel.$String((String)"End animation"), JunSpiroDesignModel.$((String)"endAnimation"), (MenuListener)new MenuPerformer((StObject)this, "endAnimation")));
            this._popupMenu.addSeparator();
            this._popupMenu.add(new StMenuItem((Object)JunSpiroDesignModel.$String((String)"Inscribe"), JunSpiroDesignModel.$((String)"beInscribe"), (MenuListener)new MenuPerformer((StObject)this, "beInscribe")));
            this._popupMenu.add(new StMenuItem((Object)JunSpiroDesignModel.$String((String)"Circumscribe"), JunSpiroDesignModel.$((String)"beCircumscribe"), (MenuListener)new MenuPerformer((StObject)this, "beCircumscribe")));
            this._popupMenu.addSeparator();
            this._popupMenu.add((StMenuItem)new StCheckBoxMenuItem((Object)JunSpiroDesignModel.$String((String)"Rainbow"), JunSpiroDesignModel.$((String)"toggleRainbow"), (MenuListener)new MenuPerformer((StObject)this, "toggleRainbow")));
            this._popupMenu.add(new StMenuItem((Object)JunSpiroDesignModel.$String((String)"Choice nib"), JunSpiroDesignModel.$((String)"choiceNib"), (MenuListener)new MenuPerformer((StObject)this, "choiceNib")));
            this._popupMenu.add(new StMenuItem((Object)JunSpiroDesignModel.$String((String)"Spawn as image"), JunSpiroDesignModel.$((String)"spawnAsImage"), (MenuListener)new MenuPerformer((StObject)this, "spawnAsImage")));
            this._popupMenu.addSeparator();
            this._popupMenu.add(new StMenuItem((Object)JunSpiroDesignModel.$String((String)"Push"), JunSpiroDesignModel.$((String)"pushSpiroDesign"), (MenuListener)new MenuPerformer((StObject)this, "pushSpiroDesign")));
            this._popupMenu.add(new StMenuItem((Object)JunSpiroDesignModel.$String((String)"Add"), JunSpiroDesignModel.$((String)"addSpiroDesign"), (MenuListener)new MenuPerformer((StObject)this, "addSpiroDesign")));
            this._popupMenu.add(new StMenuItem((Object)JunSpiroDesignModel.$String((String)"Remove"), JunSpiroDesignModel.$((String)"removeSpiroDesign"), (MenuListener)new MenuPerformer((StObject)this, "removeSpiroDesign")));
        }
        return (StPopupMenu)this.updateMenuIndication_((StMenu)this._popupMenu);
    }
}

