/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.spirodesign;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.spirodesign.JunSpiroDesign;
import jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel;
import jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignView;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.smalltalk.StView;

public class JunSpiroDesignController
extends JunAbstractController {
    protected transient Point previus;
    protected transient int dragType;
    protected static final int DRAG_NONE = 0;
    protected static final int DRAG_SPIRO_PEN = 1;
    protected static final int DRAG_CENTER_OF_MOON_CIRCLE = 2;
    protected static final int DRAG_CENTER_OF_TERA_CIRCLE = 3;
    protected static final int DRAG_RADIUS_OF_MOON_CIRCLE = 4;
    protected static final int DRAG_RADIUS_OF_TERA_CIRCLE = 5;
    protected static final int DRAG_SCROLL = 6;

    public void initialize() {
        super.initialize();
        this.previus = null;
        this.dragType = 0;
    }

    protected void dragCenterOfMoonCircle_(MouseEvent mouseEvent) {
        Point point = this.getView().convertViewPointToModelPoint_(mouseEvent.getPoint());
        if (!this.previus.equals(point)) {
            this.getModel().centerOfMoonCircle_(new Jun2dPoint(point));
            this.previus = point;
        }
    }

    protected void dragCenterOfTeraCircle_(MouseEvent mouseEvent) {
        Point point = this.getView().convertViewPointToModelPoint_(mouseEvent.getPoint());
        if (!this.previus.equals(point)) {
            this.getModel().centerOfTeraCircle_(new Jun2dPoint(point));
            this.previus = point;
        }
    }

    protected void dragRadiusOfMoonCircle_(MouseEvent mouseEvent) {
        Point point = this.getView().convertViewPointToModelPoint_(mouseEvent.getPoint());
        if (!this.previus.equals(point)) {
            this.getModel().radiusOfMoonCircle_(this.getModel().moonCircle().center().distance_(new Jun2dPoint(point)));
            this.previus = point;
        }
    }

    protected void dragRadiusOfTeraCircle_(MouseEvent mouseEvent) {
        Point point = this.getView().convertViewPointToModelPoint_(mouseEvent.getPoint());
        if (!this.previus.equals(point)) {
            this.getModel().radiusOfTeraCircle_(this.getModel().teraCircle().center().distance_(new Jun2dPoint(point)));
            this.previus = point;
        }
    }

    protected void dragScroll_(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (!point.equals(this.previus)) {
            this.getView().scrollBy_(new Point(point.x - this.previus.x, point.y - this.previus.y));
            this.previus = point;
        }
    }

    protected void dragSpiroPen_(MouseEvent mouseEvent) {
        Point point = this.getView().convertViewPointToModelPoint_(mouseEvent.getPoint());
        if (!this.previus.equals(point)) {
            this.getModel().pointOfSpiroPen_(new Jun2dPoint(point));
            this.previus = point;
        }
    }

    public JunSpiroDesignAbstractModel getModel() {
        return (JunSpiroDesignAbstractModel)this.model();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || mouseEvent.isMetaDown()) {
            super.mousePressed(mouseEvent);
            return;
        }
        if (this.spiroPenHasCursor()) {
            this.previus = this.getView().convertViewPointToModelPoint_(mouseEvent.getPoint());
            this.dragType = 1;
            return;
        }
        if (this.centerOfMoonCircleHasCursor()) {
            this.previus = this.getView().convertViewPointToModelPoint_(mouseEvent.getPoint());
            this.dragType = 2;
            return;
        }
        if (this.centerOfTeraCircleHasCursor()) {
            this.previus = this.getView().convertViewPointToModelPoint_(mouseEvent.getPoint());
            this.dragType = 3;
            return;
        }
        if (this.radiusOfMoonCircleHasCursor()) {
            this.previus = this.getView().convertViewPointToModelPoint_(mouseEvent.getPoint());
            this.dragType = 4;
            return;
        }
        if (this.radiusOfTeraCircleHasCursor()) {
            this.previus = this.getView().convertViewPointToModelPoint_(mouseEvent.getPoint());
            this.dragType = 5;
            return;
        }
        JunSpiroDesign junSpiroDesign = this.whichSpiroDesign();
        if (junSpiroDesign == null) {
            this.previus = mouseEvent.getPoint();
            this.dragType = 6;
            this.getView().toComponent().setCursor(JunCursors.Quarters2Cursor());
        } else {
            this.selectSpiroDesign_(junSpiroDesign);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || mouseEvent.isMetaDown()) {
            super.mousePressed(mouseEvent);
            return;
        }
        this.dragType = 0;
        this.previus = null;
        this.mouseMoved(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        switch (this.dragType) {
            case 1: {
                this.dragSpiroPen_(mouseEvent);
                break;
            }
            case 2: {
                this.dragCenterOfMoonCircle_(mouseEvent);
                break;
            }
            case 3: {
                this.dragCenterOfTeraCircle_(mouseEvent);
                break;
            }
            case 4: {
                this.dragRadiusOfMoonCircle_(mouseEvent);
                break;
            }
            case 5: {
                this.dragRadiusOfTeraCircle_(mouseEvent);
                break;
            }
            case 6: {
                this.dragScroll_(mouseEvent);
                break;
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.spiroPenHasCursor() || this.teraCircleHasCursor() || this.moonCircleHasCursor()) {
            this.getView().toComponent().setCursor(JunCursors.CrossCursor());
        } else {
            this.getView().toComponent().setCursor(new Cursor(0));
        }
    }

    public JunSpiroDesign selectSpiroDesign_(JunSpiroDesign junSpiroDesign) {
        if (junSpiroDesign == null) {
            return null;
        }
        return this.getModel().selectSpiroDesign_(junSpiroDesign);
    }

    public JunSpiroDesign whichSpiroDesign() {
        if (this.getModel().isActiveSpiroDesignProcess()) {
            return null;
        }
        return this.getModel().whichSpiroDesign_(this.getView().convertViewPointToModelPoint_(this.cursorPoint()));
    }

    public boolean centerOfTeraCircleHasCursor() {
        return this.indexOfTeraCircleMarks() == 0;
    }

    public boolean centerOfMoonCircleHasCursor() {
        return this.indexOfMoonCircleMarks() == 0;
    }

    public boolean moonCircleHasCursor() {
        return this.indexOfMoonCircleMarks() >= 0;
    }

    public boolean radiusOfMoonCircleHasCursor() {
        return this.indexOfMoonCircleMarks() > 0;
    }

    public boolean radiusOfTeraCircleHasCursor() {
        return this.indexOfTeraCircleMarks() > 0;
    }

    public boolean spiroPenHasCursor() {
        return this.indexOfSpiroPenMarks() >= 0;
    }

    public boolean teraCircleHasCursor() {
        return this.indexOfTeraCircleMarks() >= 0;
    }

    protected void buildListener(StView stView) {
        Component component = stView.toComponent();
        component.addMouseListener((MouseListener)((Object)this));
        component.addMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public JunSpiroDesignView getView() {
        return (JunSpiroDesignView)this.view();
    }

    protected int indexOfMoonCircleMarks() {
        if (this.getModel().isActiveSpiroDesignProcess()) {
            return -1;
        }
        Point point = this.getView().convertViewPointToModelPoint_(this.cursorPoint());
        Rectangle[] rectangleArray = this.getModel().moonCircle().marks();
        if (rectangleArray == null || rectangleArray.length == 0) {
            return -1;
        }
        for (int i = 0; i < rectangleArray.length; ++i) {
            if (!rectangleArray[i].contains(point)) continue;
            return i;
        }
        return -1;
    }

    protected int indexOfSpiroPenMarks() {
        if (this.getModel().isActiveSpiroDesignProcess()) {
            return -1;
        }
        Point point = this.getView().convertViewPointToModelPoint_(this.cursorPoint());
        Rectangle[] rectangleArray = this.getModel().spiroPen().marks();
        if (rectangleArray == null || rectangleArray.length == 0) {
            return -1;
        }
        for (int i = 0; i < rectangleArray.length; ++i) {
            if (!rectangleArray[i].contains(point)) continue;
            return i;
        }
        return -1;
    }

    protected int indexOfTeraCircleMarks() {
        if (this.getModel().isActiveSpiroDesignProcess()) {
            return -1;
        }
        Point point = this.getView().convertViewPointToModelPoint_(this.cursorPoint());
        Rectangle[] rectangleArray = this.getModel().teraCircle().marks();
        if (rectangleArray == null || rectangleArray.length == 0) {
            return -1;
        }
        for (int i = 0; i < rectangleArray.length; ++i) {
            if (!rectangleArray[i].contains(point)) continue;
            return i;
        }
        return -1;
    }
}

