/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.prolog;

import java.awt.Cursor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.prolog.JunPrologBody;
import jp.co.sra.jun.goodies.prolog.JunPrologBoolean;
import jp.co.sra.jun.goodies.prolog.JunPrologClause;
import jp.co.sra.jun.goodies.prolog.JunPrologDefinition;
import jp.co.sra.jun.goodies.prolog.JunPrologEntity;
import jp.co.sra.jun.goodies.prolog.JunPrologInterpreterView;
import jp.co.sra.jun.goodies.prolog.JunPrologInterpreterViewAwt;
import jp.co.sra.jun.goodies.prolog.JunPrologInterpreterViewSwing;
import jp.co.sra.jun.goodies.prolog.JunPrologList;
import jp.co.sra.jun.goodies.prolog.JunPrologNumber;
import jp.co.sra.jun.goodies.prolog.JunPrologObject;
import jp.co.sra.jun.goodies.prolog.JunPrologParser;
import jp.co.sra.jun.goodies.prolog.JunPrologString;
import jp.co.sra.jun.goodies.prolog.JunPrologStructure;
import jp.co.sra.jun.goodies.prolog.JunPrologSymbol;
import jp.co.sra.jun.goodies.prolog.JunPrologVariable;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StReadStream;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;

public class JunPrologInterpreter
extends JunApplicationModel {
    protected static Hashtable SystemPredicates;
    protected Hashtable systemPredicates;
    protected Hashtable userPredicates;
    protected StSymbol status;
    protected JunPrologList definition;
    protected JunPrologList question;
    protected JunPrologList questionEnv;
    protected JunPrologList clause;
    protected JunPrologList clauseEnv;
    protected JunPrologList queue;
    protected JunPrologList queueEnv;
    protected int envCounter;
    protected JunPrologList valueEnv;
    protected JunPrologList unbindList;
    protected JunPrologList cutBack;
    protected JunPrologList backTrack;
    protected StBlockClosure resolveAction;
    protected JunPrologList definitionStack;
    protected Hashtable tracePredicates;
    protected int traceCounter;
    protected PrintStream textCollector;
    protected boolean verbose;
    protected StValueHolder textValue;

    protected static void FlushSystemPredicates() {
        SystemPredicates = null;
    }

    protected void initialize() {
        this.systemPredicates = new Hashtable();
        this.userPredicates = new Hashtable();
        this.tracePredicates = new Hashtable();
        this.textCollector = new PrintStream(new ByteArrayOutputStream());
        this.verbose = false;
        this.makeSystemPredicates();
    }

    public PrintStream textCollector() {
        return this.textCollector;
    }

    public void textCollector_(PrintStream printStream) {
        this.textCollector = printStream;
    }

    public boolean confirm_(String string) {
        return JunDialog.Confirm_(string, false);
    }

    public boolean refute_action_(String string, StBlockClosure stBlockClosure) {
        StReadStream stReadStream = new StReadStream(string);
        return this.consult_action_(stReadStream, stBlockClosure);
    }

    public StValueHolder textValue() {
        if (this.textValue == null) {
            this.textValue = new StValueHolder((Object)new String());
        }
        return this.textValue;
    }

    protected void bind_env_and_env_(JunPrologEntity junPrologEntity, JunPrologList junPrologList, JunPrologEntity junPrologEntity2, JunPrologList junPrologList2) {
        JunPrologList junPrologList3 = new JunPrologList(this.fetchValue_env_(junPrologEntity2, junPrologList2), this.valueEnv);
        junPrologList3 = junPrologEntity.cons_(junPrologList3).cons_(junPrologList.cdr());
        junPrologList.cdr_(junPrologList3);
        this.unbindList = junPrologList.cons_(this.unbindList);
    }

    protected JunPrologEntity binding_env_(JunPrologEntity junPrologEntity, JunPrologList junPrologList) {
        JunPrologList junPrologList2 = (JunPrologList)junPrologList.cdr();
        if (junPrologList2 == null) {
            return null;
        }
        return junPrologList2.assoc_(junPrologEntity);
    }

    protected JunPrologEntity fetchValue_env_(JunPrologEntity junPrologEntity, JunPrologList junPrologList) {
        JunPrologEntity junPrologEntity2 = junPrologEntity;
        JunPrologList junPrologList2 = junPrologList;
        while (true) {
            this.valueEnv = junPrologList2;
            if (junPrologEntity2 == null || !junPrologEntity2.isJunPrologVariable()) break;
            JunPrologEntity junPrologEntity3 = this.binding_env_(junPrologEntity2, junPrologList2);
            if (junPrologEntity3 == null) {
                return junPrologEntity2;
            }
            junPrologEntity3 = junPrologEntity3.cdr();
            junPrologEntity2 = junPrologEntity3.car();
            junPrologList2 = (JunPrologList)junPrologEntity3.cdr();
        }
        return junPrologEntity2;
    }

    protected boolean noValue_env_(JunPrologEntity junPrologEntity, JunPrologList junPrologList) {
        if (junPrologEntity.isJunPrologVariable()) {
            JunPrologEntity junPrologEntity2 = this.binding_env_(junPrologEntity, junPrologList);
            if (junPrologEntity2 == null) {
                return true;
            }
            junPrologEntity2 = junPrologEntity2.cdr();
            return this.noValue_env_(junPrologEntity2.car(), (JunPrologList)junPrologEntity2.cdr());
        }
        return false;
    }

    protected JunPrologList nullEnv() {
        ++this.envCounter;
        return new JunPrologList(new JunPrologNumber(this.envCounter), null);
    }

    protected void unbindFrom_to_(JunPrologList junPrologList, JunPrologList junPrologList2) {
        for (JunPrologEntity junPrologEntity = junPrologList; junPrologEntity != junPrologList2; junPrologEntity = ((JunPrologEntity)junPrologEntity).cdr()) {
            JunPrologEntity junPrologEntity2 = ((JunPrologEntity)junPrologEntity).car();
            JunPrologEntity junPrologEntity3 = junPrologEntity2.cdr();
            junPrologEntity3.car().cdr().cdr_(null);
            junPrologEntity2.cdr_(junPrologEntity3.cdr());
        }
    }

    protected void builtInCut() {
        this.backTrack = (JunPrologList)this.cutBack.car();
        this.clause = (JunPrologList)this.clause.cdr();
        this.status = JunPrologInterpreter.$((String)"loop");
    }

    protected void builtInFail() {
        this.status = JunPrologInterpreter.$((String)"back");
    }

    protected void builtInPredicate_(JunPrologSymbol junPrologSymbol) {
        if (junPrologSymbol.isJunPrologCut()) {
            this.builtInCut();
        } else if (junPrologSymbol.isJunPrologTrue()) {
            this.builtInTrue();
        } else if (junPrologSymbol.isJunPrologFail()) {
            this.builtInFail();
        } else if (junPrologSymbol.isJunPrologSend()) {
            this.builtInSend();
        } else if (junPrologSymbol.isJunPrologVar()) {
            this.builtInVar();
        } else {
            throw SmalltalkException.Error((String)"Unexpected built-in predicate");
        }
    }

    protected void builtInSend() {
        JunPrologEntity junPrologEntity;
        JunPrologEntity junPrologEntity2 = this.expression_env_(this.clause.car().cdr(), this.clauseEnv);
        JunPrologEntity junPrologEntity3 = junPrologEntity2.car();
        junPrologEntity2 = junPrologEntity2.cdr();
        JunPrologSymbol junPrologSymbol = (JunPrologSymbol)junPrologEntity2.car();
        junPrologEntity2 = junPrologEntity2.cdr();
        JunPrologList junPrologList = (JunPrologList)junPrologEntity2.car();
        junPrologEntity2 = junPrologEntity2.cdr();
        JunPrologEntity junPrologEntity4 = null;
        if (junPrologEntity2 != null) {
            if (junPrologEntity2.cdr() == null) {
                junPrologEntity4 = ((JunPrologList)this.clause.car().cdr()).nth_(4);
            } else {
                this.status = JunPrologInterpreter.$((String)"back");
                return;
            }
        }
        if (((Object)((Object)(junPrologEntity = this.receiver_selector_arguments_(junPrologEntity3, junPrologSymbol, junPrologList)))).equals((Object)JunPrologSymbol.Cut())) {
            this.builtInCut();
            this.status = JunPrologInterpreter.$((String)"back");
            return;
        }
        if (junPrologEntity4 == null) {
            if (junPrologEntity != JunPrologBoolean.FALSE) {
                junPrologEntity = JunPrologBoolean.TRUE;
            }
            if (junPrologEntity == JunPrologBoolean.TRUE) {
                this.clause = (JunPrologClause)this.clause.cdr();
                this.status = JunPrologInterpreter.$((String)"loop");
                return;
            }
            this.status = JunPrologInterpreter.$((String)"back");
            return;
        }
        if (this.unify_env_and_env_(junPrologEntity4, this.clauseEnv, junPrologEntity, this.nullEnv())) {
            this.clause = (JunPrologClause)this.clause.cdr();
            this.status = JunPrologInterpreter.$((String)"loop");
            return;
        }
        this.status = JunPrologInterpreter.$((String)"back");
    }

    protected void builtInTrue() {
        this.clause = (JunPrologClause)this.clause.cdr();
        this.status = JunPrologInterpreter.$((String)"loop");
    }

    protected void builtInVar() {
        JunPrologEntity junPrologEntity = this.clause.car().cdr().car();
        if (this.noValue_env_(junPrologEntity, this.clauseEnv)) {
            this.clause = (JunPrologList)this.clause.cdr();
            this.status = JunPrologInterpreter.$((String)"loop");
        } else {
            this.status = JunPrologInterpreter.$((String)"back");
        }
    }

    protected void call_(JunPrologStructure junPrologStructure) {
        if (junPrologStructure.cdr() == null) {
            this.callVariable_((JunPrologVariable)junPrologStructure.car());
            return;
        }
        JunPrologStructure junPrologStructure2 = (JunPrologStructure)this.expression_env_(junPrologStructure, this.clauseEnv);
        if (!this.unify_env_and_env_(junPrologStructure, this.clauseEnv, junPrologStructure2, this.clauseEnv)) {
            throw SmalltalkException.Error((String)"Unexpected unify structure");
        }
        JunPrologEntity junPrologEntity = junPrologStructure2.car();
        if (junPrologEntity.isJunPrologVariable()) {
            this.status = JunPrologInterpreter.$((String)"back");
            return;
        }
        this.clause = (JunPrologClause)this.clause.cdr();
        this.clause = (JunPrologClause)junPrologStructure2.cons_(this.clause);
        this.status = JunPrologInterpreter.$((String)"loop");
    }

    protected void callVariable_(JunPrologVariable junPrologVariable) {
        JunPrologEntity junPrologEntity;
        JunPrologEntity junPrologEntity2 = this.expression_env_(junPrologVariable, this.clauseEnv);
        if (!this.unify_env_and_env_(junPrologVariable, this.clauseEnv, junPrologEntity2, this.clauseEnv)) {
            throw SmalltalkException.Error((String)"Unexpected unify forn clause");
        }
        if (!junPrologEntity2.consp()) {
            junPrologEntity2 = new JunPrologStructure((JunPrologString)junPrologEntity2, null);
        }
        if (!junPrologEntity2.car().consp()) {
            junPrologEntity2 = new JunPrologClause((JunPrologStructure)junPrologEntity2, null);
        }
        if ((junPrologEntity = (junPrologEntity2 = new JunPrologClause((JunPrologStructure)junPrologEntity2.car(), JunPrologBody.FromList_((JunPrologList)junPrologEntity2.cdr()))).car().car()).isJunPrologVariable()) {
            this.status = JunPrologInterpreter.$((String)"back");
            return;
        }
        this.clause = (JunPrologClause)this.clause.cdr();
        junPrologEntity2 = ((JunPrologList)junPrologEntity2).reverse();
        while (junPrologEntity2.consp()) {
            this.clause = (JunPrologClause)junPrologEntity2.car().cons_(this.clause);
            junPrologEntity2 = junPrologEntity2.cdr();
        }
        this.status = JunPrologInterpreter.$((String)"loop");
    }

    protected JunPrologEntity receiver_selector_arguments_(JunPrologEntity junPrologEntity, JunPrologSymbol junPrologSymbol, JunPrologList junPrologList) {
        Object object = junPrologEntity;
        if (junPrologEntity instanceof JunPrologSymbol && ((JunPrologSymbol)junPrologEntity).isJunPrologSelf()) {
            object = this;
        }
        String string = junPrologSymbol.string();
        JunPrologList junPrologList2 = junPrologList;
        Object object2 = null;
        if (junPrologList2 == null) {
            try {
                object2 = object.perform_(string);
            }
            catch (Exception exception) {
                throw new SmalltalkException(exception);
            }
        }
        int n = junPrologList2.length();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = junPrologList2.car() instanceof JunPrologObject ? ((JunPrologObject)junPrologList2.car()).object() : junPrologList2.car();
            junPrologList2 = (JunPrologList)junPrologList2.cdr();
        }
        try {
            object2 = object.perform_withArguments_(string, objectArray);
        }
        catch (Exception exception) {
            throw new SmalltalkException(exception);
        }
        JunPrologEntity junPrologEntity2 = null;
        if (object2 instanceof JunPrologEntity) {
            junPrologEntity2 = (JunPrologEntity)((Object)object2);
        } else if (object2 instanceof Boolean) {
            junPrologEntity2 = (Boolean)object2 != false ? JunPrologBoolean.TRUE : JunPrologBoolean.FALSE;
        } else if (object2 instanceof Number) {
            junPrologEntity2 = new JunPrologNumber((Number)object2);
        } else {
            throw new SmalltalkException("not implemented yet");
        }
        return junPrologEntity2;
    }

    protected void outputAnswer_(Hashtable hashtable) {
        Object[] objectArray = hashtable.keySet().toArray();
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (i > 0) {
                this.textCollector.println();
            }
            this.textCollector.print(object);
            this.textCollector.print(" = ");
            this.textCollector.print(((JunPrologEntity)((Object)hashtable.get(object))).printJunPrologString());
            this.textCollector.print(' ');
        }
    }

    protected void outputTime_(long l) {
        if (this.verbose) {
            int n = this.envCounter - 1;
            String string = "<";
            string = string + String.valueOf(l) + " milliseconds, ";
            string = string + String.valueOf(n) + " goals";
            this.textCollector.println(string);
        }
    }

    protected boolean outputVariables_(Hashtable hashtable) {
        this.outputAnswer_(hashtable);
        boolean bl = this.confirm_(JunSystem.$String((String)"All right?"));
        if (bl) {
            this.textCollector.println();
        } else {
            this.textCollector.println(";");
        }
        return bl;
    }

    protected Hashtable collectVariables() {
        Hashtable hashtable = new Hashtable();
        this.collectVariables_to_(this.question, hashtable);
        return hashtable;
    }

    protected void collectVariables_to_(JunPrologEntity junPrologEntity, Hashtable hashtable) {
        if (junPrologEntity != null && junPrologEntity.isJunPrologVariable() && ((JunPrologString)junPrologEntity).string().charAt(0) != '~') {
            String string = new String(junPrologEntity.printJunPrologString());
            if (hashtable.get(string) != null) {
                return;
            }
            JunPrologEntity junPrologEntity2 = this.represent_env_(junPrologEntity, this.questionEnv);
            if (junPrologEntity2 == null) {
                junPrologEntity2 = new JunPrologObject(null);
            }
            hashtable.put(string, junPrologEntity2);
        }
        if (junPrologEntity == null || !junPrologEntity.consp()) {
            return;
        }
        this.collectVariables_to_(junPrologEntity.car(), hashtable);
        this.collectVariables_to_(junPrologEntity.cdr(), hashtable);
    }

    protected JunPrologEntity expression_env_(JunPrologEntity junPrologEntity, JunPrologList junPrologList) {
        if (junPrologEntity != null && junPrologEntity.isJunPrologVariable()) {
            JunPrologEntity junPrologEntity2 = this.binding_env_(junPrologEntity, junPrologList);
            if (junPrologEntity2 == null) {
                return junPrologEntity;
            }
            junPrologEntity2 = junPrologEntity2.cdr();
            return this.expression_env_(junPrologEntity2.car(), (JunPrologList)junPrologEntity2.cdr());
        }
        if (junPrologEntity == null || !junPrologEntity.consp()) {
            return junPrologEntity;
        }
        JunPrologEntity junPrologEntity3 = this.expression_env_(junPrologEntity.car(), junPrologList);
        JunPrologEntity junPrologEntity4 = this.expression_env_(junPrologEntity.cdr(), junPrologList);
        return ((JunPrologList)junPrologEntity)._newInstanceWith(junPrologEntity3, junPrologEntity4);
    }

    protected JunPrologEntity represent_env_(JunPrologEntity junPrologEntity, JunPrologList junPrologList) {
        if (junPrologEntity != null && junPrologEntity.isJunPrologVariable()) {
            JunPrologEntity junPrologEntity2 = this.binding_env_(junPrologEntity, junPrologList);
            if (junPrologEntity2 == null) {
                return this.variableRepresent_env_((JunPrologVariable)junPrologEntity, junPrologList);
            }
            junPrologEntity2 = junPrologEntity2.cdr();
            return this.represent_env_(junPrologEntity2.car(), (JunPrologList)junPrologEntity2.cdr());
        }
        if (junPrologEntity == null || !junPrologEntity.consp()) {
            return junPrologEntity;
        }
        JunPrologEntity junPrologEntity3 = this.represent_env_(junPrologEntity.car(), junPrologList);
        JunPrologEntity junPrologEntity4 = this.represent_env_(junPrologEntity.cdr(), junPrologList);
        return ((JunPrologList)junPrologEntity)._newInstanceWith(junPrologEntity3, junPrologEntity4);
    }

    protected JunPrologVariable variableRepresent_env_(JunPrologVariable junPrologVariable, JunPrologList junPrologList) {
        return JunPrologVariable.Install_(junPrologVariable.string() + junPrologList.car().printString());
    }

    protected boolean resolve_(JunPrologClause junPrologClause) {
        return this.resolve_action_(junPrologClause, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean resolve_action_(JunPrologList junPrologList, StBlockClosure stBlockClosure) {
        this.question = this.clause = junPrologList;
        this.resolveAction = stBlockClosure == null ? new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(JunPrologInterpreter.this.outputVariables_((Hashtable)object));
            }
        } : stBlockClosure;
        JunCursors junCursors = new JunCursors(JunCursors.ExecuteCursor());
        try {
            junCursors._show();
            this.resolveInitialize();
            this.resolveLoop();
            boolean bl = this.resolveTerminate();
            return bl;
        }
        finally {
            junCursors._restore();
        }
    }

    protected void resolveInitialize() {
        this.status = JunPrologInterpreter.$((String)"loop");
        this.envCounter = 0;
        this.questionEnv = this.clauseEnv = this.nullEnv();
        this.valueEnv = null;
        this.queueEnv = null;
        this.queue = null;
        this.backTrack = null;
        this.cutBack = null;
        this.unbindList = null;
        this.definitionStack = null;
        this.traceCounter = 0;
    }

    protected boolean resolveLoop() {
        long l = 0L;
        long l2 = System.currentTimeMillis();
        do {
            if (this.status == JunPrologInterpreter.$((String)"loop")) {
                this.loop();
            }
            if (this.status == JunPrologInterpreter.$((String)"next")) {
                this.next();
            }
            if (this.status == JunPrologInterpreter.$((String)"back")) {
                this.back();
            }
            if (this.status != JunPrologInterpreter.$((String)"succ")) continue;
            l2 = System.currentTimeMillis() - l2;
            this.outputTime_(l += l2);
            Hashtable hashtable = this.collectVariables();
            if (hashtable.isEmpty()) {
                return true;
            }
            if (((Boolean)this.resolveAction.value_((Object)hashtable)).booleanValue()) {
                return true;
            }
            this.status = JunPrologInterpreter.$((String)"back");
            l2 = System.currentTimeMillis();
        } while (this.status != JunPrologInterpreter.$((String)"fail"));
        l2 = System.currentTimeMillis() - l2;
        this.outputTime_(l += l2);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean resolveTerminate() {
        JunCursors junCursors = new JunCursors(Cursor.getPredefinedCursor(3));
        try {
            junCursors._show();
            this.deallocateEnv_(this.questionEnv);
        }
        finally {
            junCursors._restore();
        }
        if (this.status == JunPrologInterpreter.$((String)"succ")) {
            this.textCollector.println("yes");
            return true;
        }
        if (this.status == JunPrologInterpreter.$((String)"fail")) {
            this.textCollector.println("no");
            return false;
        }
        throw SmalltalkException.Error((String)"Unexpected status");
    }

    protected void loop() {
        JunPrologEntity junPrologEntity;
        if (this.clause == null) {
            if (this.queue == null) {
                this.status = JunPrologInterpreter.$((String)"succ");
                return;
            }
            this.clause = (JunPrologList)this.queue.car();
            this.clauseEnv = (JunPrologList)this.queueEnv.car();
            this.queue = (JunPrologList)this.queue.cdr();
            this.queueEnv = (JunPrologList)this.queueEnv.cdr();
            this.cutBack = (JunPrologList)this.cutBack.cdr();
            this.status = JunPrologInterpreter.$((String)"loop");
            return;
        }
        JunPrologEntity junPrologEntity2 = this.clause.car();
        if (!junPrologEntity2.consp()) {
            junPrologEntity2 = new JunPrologStructure((JunPrologString)junPrologEntity2, null);
            this.clause.car_(junPrologEntity2);
        }
        if ((junPrologEntity = junPrologEntity2.car()).isJunPrologVariable()) {
            this.call_((JunPrologStructure)this.clause.car());
            return;
        }
        if (((JunPrologSymbol)junPrologEntity).isBuiltInPredicate()) {
            this.builtInPredicate_((JunPrologSymbol)junPrologEntity);
            return;
        }
        this.definition = (JunPrologList)((Object)this.userPredicates.get((Object)junPrologEntity));
        if (this.definition == null) {
            this.definition = (JunPrologList)((Object)this.systemPredicates.get((Object)junPrologEntity));
            if (this.definition == null) {
                this.status = JunPrologInterpreter.$((String)"back");
                return;
            }
        }
        this.status = JunPrologInterpreter.$((String)"next");
    }

    protected void next() {
        JunPrologList junPrologList = this.nullEnv();
        if (this.definition.cdr() == null) {
            if (!this.unify_env_and_env_(this.clause.car().cdr(), this.clauseEnv, this.definition.car().car().cdr(), junPrologList)) {
                this.status = JunPrologInterpreter.$((String)"back");
                return;
            }
            this.queue = new JunPrologList(this.clause.cdr(), this.queue);
            this.queueEnv = this.clauseEnv.cons_(this.queueEnv);
            this.clause = (JunPrologList)this.definition.car().cdr();
            this.clauseEnv = junPrologList;
            this.cutBack = new JunPrologList(this.backTrack, this.cutBack);
            this.status = JunPrologInterpreter.$((String)"loop");
            return;
        }
        JunPrologList junPrologList2 = this.backTrack;
        Object[] objectArray = new Object[]{this.clause, this.clauseEnv, this.queue, this.queueEnv, this.cutBack, this.definition.cdr(), this.unbindList};
        this.backTrack = new JunPrologList(new JunPrologObject(objectArray), junPrologList2);
        if (!this.unify_env_and_env_(this.clause.car().cdr(), this.clauseEnv, this.definition.car().car().cdr(), junPrologList)) {
            this.status = JunPrologInterpreter.$((String)"back");
            return;
        }
        this.queue = new JunPrologList(this.clause.cdr(), this.queue);
        this.queueEnv = this.clauseEnv.cons_(this.queueEnv);
        this.clause = (JunPrologList)this.definition.car().cdr();
        this.clauseEnv = junPrologList;
        this.cutBack = new JunPrologList(junPrologList2, this.cutBack);
        this.status = JunPrologInterpreter.$((String)"loop");
    }

    protected void back() {
        if (this.backTrack == null) {
            this.status = JunPrologInterpreter.$((String)"fail");
            return;
        }
        Object[] objectArray = (Object[])((JunPrologObject)this.backTrack.car()).object();
        this.backTrack = (JunPrologList)this.backTrack.cdr();
        this.clause = (JunPrologList)((Object)objectArray[0]);
        this.clauseEnv = (JunPrologList)((Object)objectArray[1]);
        this.queue = (JunPrologList)((Object)objectArray[2]);
        this.queueEnv = (JunPrologList)((Object)objectArray[3]);
        this.cutBack = (JunPrologList)((Object)objectArray[4]);
        this.definition = (JunPrologList)((Object)objectArray[5]);
        JunPrologList junPrologList = (JunPrologList)((Object)objectArray[6]);
        this.unbindFrom_to_(this.unbindList, junPrologList);
        this.unbindList = junPrologList;
        this.status = JunPrologInterpreter.$((String)"next");
    }

    public boolean nl() {
        this.textCollector.println();
        return true;
    }

    public synchronized boolean remove() {
        Enumeration enumeration = this.userPredicates.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.userPredicates.remove(k);
            this.tracePredicates.remove(k);
        }
        return true;
    }

    public boolean write_(Object object) {
        if (object instanceof JunPrologEntity) {
            this.textCollector.print(((JunPrologEntity)((Object)object)).printJunPrologString());
        } else {
            this.textCollector.print(object.toString());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean consult_action_(StReadStream stReadStream, StBlockClosure stBlockClosure) {
        Object[] objectArray = this.getCondition();
        try {
            Object object;
            JunPrologParser junPrologParser = new JunPrologParser();
            boolean bl = true;
            while ((object = junPrologParser.parse_(stReadStream)) != JunPrologInterpreter.$((String)"eof")) {
                Object object2;
                JunPrologList junPrologList = (JunPrologList)((Object)object);
                JunPrologClause junPrologClause = (JunPrologClause)junPrologList.cdr();
                if (junPrologList.car() == JunPrologBoolean.TRUE) {
                    object2 = new StringWriter(20);
                    junPrologClause.questionPrintJunPrologOn_((Writer)object2);
                    this.textCollector.println(((StringWriter)object2).toString());
                    bl = this.resolve_action_(junPrologClause, stBlockClosure);
                    continue;
                }
                object2 = junPrologClause.car().car();
                JunPrologDefinition junPrologDefinition = (JunPrologDefinition)((Object)this.tracePredicates.get(object2));
                if (junPrologDefinition == null) {
                    junPrologDefinition = (JunPrologDefinition)((Object)this.userPredicates.get(object2));
                }
                if (junPrologDefinition == null) {
                    junPrologDefinition = JunPrologDefinition.FromList_(new JunPrologList(junPrologClause, null));
                    this.userPredicates.put(object2, junPrologDefinition);
                    continue;
                }
                junPrologDefinition.nconc_(new JunPrologList(junPrologClause, null));
            }
            boolean bl2 = bl;
            return bl2;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.putCondition_(objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean systemReconsult_(StReadStream stReadStream) {
        Object[] objectArray = this.getCondition();
        try {
            JunPrologClause junPrologClause;
            Object object;
            Object object2;
            Hashtable<JunPrologEntity, JunPrologDefinition> hashtable = new Hashtable<JunPrologEntity, JunPrologDefinition>();
            JunPrologParser junPrologParser = new JunPrologParser();
            while ((object2 = junPrologParser.parse_(stReadStream)) != JunPrologInterpreter.$((String)"eof")) {
                object = (JunPrologList)((Object)object2);
                junPrologClause = (JunPrologClause)((JunPrologList)((Object)object)).cdr();
                if (((JunPrologList)((Object)object)).car() == JunPrologBoolean.TRUE) {
                    this.resolve_(junPrologClause);
                    continue;
                }
                JunPrologEntity junPrologEntity = junPrologClause.car().car();
                JunPrologDefinition junPrologDefinition = (JunPrologDefinition)((Object)hashtable.get((Object)junPrologEntity));
                if (junPrologDefinition == null) {
                    junPrologDefinition = JunPrologDefinition.FromList_(new JunPrologList(junPrologClause, null));
                    hashtable.put(junPrologEntity, junPrologDefinition);
                } else {
                    junPrologDefinition.nconc_(new JunPrologList(junPrologClause, null));
                }
                this.systemPredicates.put(junPrologEntity, junPrologDefinition);
            }
            object = hashtable.keys();
            while (object.hasMoreElements()) {
                junPrologClause = object.nextElement();
                this.systemPredicates.put(junPrologClause, hashtable.get((Object)junPrologClause));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.putCondition_(objectArray);
        }
    }

    protected boolean unify_env_and_env_(JunPrologEntity junPrologEntity, JunPrologList junPrologList, JunPrologEntity junPrologEntity2, JunPrologList junPrologList2) {
        JunPrologEntity junPrologEntity3 = junPrologEntity;
        JunPrologEntity junPrologEntity4 = junPrologEntity2;
        while (junPrologList != junPrologList2 || !((Object)((Object)junPrologEntity)).equals((Object)junPrologEntity2)) {
            if (junPrologEntity3 != null && junPrologEntity3.isJunPrologVariable()) {
                JunPrologEntity junPrologEntity5 = this.binding_env_(junPrologEntity3, junPrologList);
                if (junPrologEntity5 != null) {
                    this.valueEnv = junPrologList;
                    junPrologEntity5 = junPrologEntity5.cdr();
                    junPrologEntity3 = this.fetchValue_env_(junPrologEntity5.car(), (JunPrologList)junPrologEntity5.cdr());
                    return this.unify_env_and_env_(junPrologEntity3, this.valueEnv, junPrologEntity4, junPrologList2);
                }
                if (junPrologEntity4 != null && junPrologEntity4.isJunPrologVariable() && (junPrologEntity5 = this.binding_env_(junPrologEntity4, junPrologList2)) != null) {
                    this.valueEnv = junPrologList2;
                    junPrologEntity5 = junPrologEntity5.cdr();
                    junPrologEntity4 = this.fetchValue_env_(junPrologEntity5.car(), (JunPrologList)junPrologEntity5.cdr());
                    return this.unify_env_and_env_(junPrologEntity3, junPrologList, junPrologEntity4, this.valueEnv);
                }
                this.bind_env_and_env_(junPrologEntity3, junPrologList, junPrologEntity4, junPrologList2);
                return true;
            }
            if (junPrologEntity4 != null && junPrologEntity4.isJunPrologVariable()) {
                JunPrologEntity junPrologEntity6 = this.binding_env_(junPrologEntity4, junPrologList2);
                if (junPrologEntity6 != null) {
                    this.valueEnv = junPrologList2;
                    junPrologEntity6 = junPrologEntity6.cdr();
                    junPrologEntity4 = this.fetchValue_env_(junPrologEntity6.car(), (JunPrologList)junPrologEntity6.cdr());
                    return this.unify_env_and_env_(junPrologEntity3, junPrologList, junPrologEntity4, this.valueEnv);
                }
                this.bind_env_and_env_(junPrologEntity4, junPrologList2, junPrologEntity3, junPrologList);
                return true;
            }
            if (junPrologEntity3 == null) {
                return junPrologEntity4 == null;
            }
            if (!junPrologEntity3.consp()) {
                return ((Object)((Object)junPrologEntity3)).equals((Object)junPrologEntity4);
            }
            if (junPrologEntity4 == null) {
                return junPrologEntity3 == null;
            }
            if (!junPrologEntity4.consp()) {
                return ((Object)((Object)junPrologEntity4)).equals((Object)junPrologEntity3);
            }
            if (!this.unify_env_and_env_(junPrologEntity3.car(), junPrologList, junPrologEntity4.car(), junPrologList2)) {
                return false;
            }
            junPrologEntity3 = junPrologEntity3.cdr();
            junPrologEntity4 = junPrologEntity4.cdr();
        }
        return true;
    }

    public boolean doIt(Object object) {
        JunPrologInterpreterView junPrologInterpreterView = (JunPrologInterpreterView)object;
        StReadStream stReadStream = new StReadStream(junPrologInterpreterView.getSelectedText());
        return this.consult_action_(stReadStream, null);
    }

    public StView defaultView() {
        if (JunPrologInterpreter.GetDefaultViewMode() == 0) {
            return new JunPrologInterpreterViewAwt(this);
        }
        return new JunPrologInterpreterViewSwing(this);
    }

    protected String windowTitle() {
        return JunPrologInterpreter.$String((String)"Prolog");
    }

    protected void deallocateEnv_(JunPrologEntity junPrologEntity) {
        for (JunPrologEntity junPrologEntity2 = junPrologEntity.cdr(); junPrologEntity2 != null && junPrologEntity2.consp(); junPrologEntity2 = junPrologEntity2.cdr()) {
            JunPrologEntity junPrologEntity3 = junPrologEntity2.car();
            JunPrologEntity junPrologEntity4 = junPrologEntity3.cdr().cdr();
            junPrologEntity3.cdr().cdr_(null);
            if (junPrologEntity4 == null || !junPrologEntity4.consp()) continue;
            this.deallocateEnv_(junPrologEntity4);
        }
    }

    protected Object[] getCondition() {
        Object[] objectArray = new Object[]{this.status, this.definition, this.question, this.questionEnv, this.clause, this.clauseEnv, this.queue, this.queueEnv, this.valueEnv, this.unbindList, this.cutBack, this.backTrack, this.resolveAction, this.definitionStack};
        return objectArray;
    }

    protected void putCondition_(Object[] objectArray) {
        this.status = (StSymbol)objectArray[0];
        this.definition = (JunPrologList)((Object)objectArray[1]);
        this.question = (JunPrologClause)((Object)objectArray[2]);
        this.questionEnv = (JunPrologList)((Object)objectArray[3]);
        this.clause = (JunPrologClause)((Object)objectArray[4]);
        this.clauseEnv = (JunPrologList)((Object)objectArray[5]);
        this.queue = (JunPrologList)((Object)objectArray[6]);
        this.queueEnv = (JunPrologList)((Object)objectArray[7]);
        this.valueEnv = (JunPrologList)((Object)objectArray[8]);
        this.unbindList = (JunPrologList)((Object)objectArray[9]);
        this.cutBack = (JunPrologList)((Object)objectArray[10]);
        this.backTrack = (JunPrologList)((Object)objectArray[11]);
        this.resolveAction = (StBlockClosure)objectArray[12];
        this.definitionStack = (JunPrologList)((Object)objectArray[13]);
    }

    protected void makeSystemPredicates() {
        if (SystemPredicates == null) {
            this.systemPredicatesNo0();
            this.systemPredicatesNo1();
            this.systemPredicatesNo2();
            this.systemPredicatesNo3();
            this.systemPredicatesNo4();
            this.systemPredicatesNo5();
            this.systemPredicatesNo6();
            this.systemPredicatesNo7();
            this.systemPredicatesNo8();
            this.systemPredicatesNo9();
            SystemPredicates = this.systemPredicates;
        } else {
            this.systemPredicates = SystemPredicates;
        }
    }

    private void systemPredicatesNo0() {
        String string = "";
        string = string + "! :- builtin.";
        string = string + "true :- builtin.";
        string = string + "fail :- builtin.";
        string = string + "ver(X) :- builtin.";
        string = string + "send(X,Y,Z) :- builtin.";
        string = string + "send(X,Y,Z,A) :- builtin.";
        this.systemReconsult_(new StReadStream(string));
    }

    private void systemPredicatesNo1() {
        String string = "";
        string = string + "repeat.";
        string = string + "repeat :- repeat.";
        string = string + "nonvar(X) :- var(X), !, fail.";
        string = string + "nonvar(X).";
        string = string + "integer(X) :- send(self,integer_,[X]).";
        string = string + "float(X) :- send(self,float_,[X]).";
        string = string + "double(X) :- send(self,double_,[X]).";
        string = string + "number(X) :- send(self,number_,[X]).";
        string = string + "symbol(X) :- send(self,symbol_,[X]).";
        string = string + "string(X) :- send(self,string:,[X]).";
        string = string + "list(X) :- send(self,list_,[X]).";
        string = string + "dotp(X) :- send(self,dotp_,[X]).";
        string = string + "atom(X) :- symbol(X).";
        string = string + "atom(X) :- nonvar(X), =(X,[]).";
        string = string + "atom(X) :- string(X).";
        string = string + "atomic(X) :- atom(X).";
        string = string + "atomic(X) :- number(X).";
        string = string + "structure(X) :- nonvar(X), not(atomic(X)).";
        this.systemReconsult_(new StReadStream(string));
    }

    private void systemPredicatesNo2() {
        String string = "";
        string = string + "==(X,Y) :- send(X,=,[Y]).";
        string = string + "\\==(X,Y) :- ==(X,Y), !, fail.";
        string = string + "\\==(X,Y).";
        string = string + "=(X,X).";
        string = string + "\\=(X,Y) :- =(X,Y), !, fail.";
        string = string + "\\=(X,Y).";
        string = string + ">(X,Y) :- send(X,>,[Y]).";
        string = string + ">=(X,Y) :- send(X,>=,[Y]).";
        string = string + "<(X,Y) :- send(X,<,[Y]).";
        string = string + "=<(X,Y) :- send(X,<=,[Y]).";
        this.systemReconsult_(new StReadStream(string));
    }

    private void systemPredicatesNo3() {
        String string = "";
        string = string + "+(X,Y,Z) :- send(X,+,[Y],Z).";
        string = string + "-(X,Y,Z) :- send(X,-,[Y],Z).";
        string = string + "*(X,Y,Z) :- send(X,*,[Y],Z).";
        string = string + "//(X,Y,Z) :- send(X,//,[Y],Z).";
        string = string + "/(X,Y,Z) :- send(X,/,[Y],Z).";
        string = string + "\\\\(X,Y,Z) :- send(X,\\\\,[Y],Z).";
        string = string + "is(Z,+(X,Y)) :- nonvar(Z), nonvar(X), nonvar(Y), send(X,+,[Y],Z).";
        string = string + "is(Z,+(X,Y)) :- var(Z), nonvar(X), nonvar(Y), send(X,+,[Y],Z).";
        string = string + "is(Z,+(X,Y)) :- var(X), nonvar(Y), nonvar(Z), send(Z,-,[Y],X).";
        string = string + "is(Z,+(X,Y)) :- var(Y), nonvar(Z), nonvar(X), send(Z,-,[X],Y).";
        string = string + "is(Z,-(X,Y)) :- nonvar(Z), nonvar(X), nonvar(Y), send(X,-,[Y],Z).";
        string = string + "is(Z,-(X,Y)) :- var(Z), nonvar(X), nonvar(Y), send(X,-,[Y],Z).";
        string = string + "is(Z,-(X,Y)) :- var(X), nonvar(Y), nonvar(Z), send(Z,+,[Y],X).";
        string = string + "is(Z,-(X,Y)) :- var(Y), nonvar(Z), nonvar(X), send(X,-,[Z],Y).";
        string = string + "is(Z,*(X,Y)) :- nonvar(Z), nonvar(X), nonvar(Y), send(X,*,[Y],Z).";
        string = string + "is(Z,*(X,Y)) :- var(Z), nonvar(X), nonvar(Y), send(X,*,[Y],Z).";
        string = string + "is(Z,*(X,Y)) :- var(X), nonvar(Y), nonvar(Z), send(Z,/,[Y],X).";
        string = string + "is(Z,*(X,Y)) :- var(Y), nonvar(Z), nonvar(X), send(Z,/,[X],Y).";
        string = string + "is(Z,/(X,Y)) :- nonvar(Z), nonvar(X), nonvar(Y), send(X,/,[Y],Z).";
        string = string + "is(Z,/(X,Y)) :- var(Z), nonvar(X), nonvar(Y), send(X,/,[Y],Z).";
        string = string + "is(Z,/(X,Y)) :- var(X), nonvar(Y), nonvar(Z), send(Z,*,[Y],X).";
        string = string + "is(Z,/(X,Y)) :- var(Y), nonvar(Z), nonvar(X), send(X,/,[Z],Y).";
        string = string + "is(X,Y) :- =(X,Y).";
        this.systemReconsult_(new StReadStream(string));
    }

    private void systemPredicatesNo4() {
        String string = "";
        string = string + "listing :- send(self,userListing,[]).";
        string = string + "listing(X) :- send(self,userListing:,[X]).";
        string = string + "systemListing :- send(self,systemListing,[]).";
        string = string + "systemListing(X) :- send(self,systemListing:,[X]).";
        string = string + "editing :- send(self,editting,[]).";
        string = string + "consult :- send(self,consult,[]).";
        string = string + "consult(X) :- nonvar(X), send(self,consultFile:,[X]).";
        string = string + "reconsult :- send(self,reconsult,[]).";
        string = string + "reconsult(X) :- nonvar(X), send(self,reconsultFile:,[X]).";
        string = string + "saving :- send(self,saving,[]).";
        string = string + "saving(X) :- send(self,saving:,[X]).";
        string = string + "userPredicates(X) :- send(self,userPredicates,[],X).";
        string = string + "systemPredicates(X) :- send(self,systemPredicates,[],X).";
        string = string + "predicates([X|Y]) :- userPredicates(X), systemPredicates(Y).";
        string = string + "functor(T,F,A) :- nonvar(T), !, send(self,functorArityOf:,[T],[F|A]).";
        string = string + "functor(T,F,A) :- number(F), !, =(0,A),=(T,F).";
        string = string + "functor(T,F,A) :- atom(F), =<(0,A), '~addvar'([F],A,L), =..(T,L).";
        string = string + "'~addvar'(L,0,M) :- !, =(L,M).";
        string = string + "'~addvar'(L,NVars,M) :- -(NVars, 1, N), append(L,[FreeV],LV), '~addvar'(LV,N,M).";
        string = string + "arg(Nth,S,T) :- integer(Nth), <(0,Nth), structure(S), =..(S,[F|L]), nth(L,Nth,T).";
        string = string + "=..(X,Y) :- send(self,univ:,[['X'|'Y']]).";
        string = string + "name(X,Y) :- atomic(X), list(Y), !, send(self,symToList:,[X],Y).";
        string = string + "name(X,Y) :- atomic(X), !, send(self,symToStr:,[X],Y).";
        string = string + "name(X,Y) :- var(X), !, nonvar(Y), send(self, strToSym:,[Y],X).";
        string = string + "remove :- send(self,remove,[]).";
        string = string + "remove(X) :- send(self,remove:,[X]).";
        string = string + "clause(X) :- send(self,clauseSet:,[X]), repeat, send(self,clause:,[X],X).";
        string = string + "asserta(X) :- send(self,asserta:,[X]).";
        string = string + "assert(X) :- send(self,assertz:,[X]).";
        string = string + "assertz(X) :- send(self,assertz:,[X]).";
        string = string + "retract(X) :- repeat, send(self,retract:,[X],X).";
        this.systemReconsult_(new StReadStream(string));
    }

    private void systemPredicatesNo5() {
        String string = "";
        string = string + "call(G) :- G.";
        string = string + "not(G) :- G, !, fail.";
        string = string + "not(G).";
        string = string + "or(X,Y) :- call(X).";
        string = string + "or(X,Y) :- call(Y).";
        string = string + "and(X,Y) :- call(X), call(Y).";
        this.systemReconsult_(new StReadStream(string));
    }

    private void systemPredicatesNo6() {
        String string = "";
        string = string + "read(X) :- send(self,read,[],X).";
        string = string + "read(X,M) :- send(self,read_,[M],X).";
        string = string + "write(X) :- send(self,write_,[X]).";
        string = string + "nl :- send(self,nl,[]).";
        string = string + "tab(X) :- number(X), send(self,tab:,[X]).";
        string = string + "clear :- send(self,clear,[]).";
        this.systemReconsult_(new StReadStream(string));
    }

    private void systemPredicatesNo7() {
        String string = "";
        string = string + "verbose(X) :- send(self,verbose:,[X]).";
        string = string + "gc :- send(self,gc,[]).";
        string = string + "inspect(X) :- send(X,inspect,[]).";
        string = string + "spy(X) :- send(self,spy:,[X]).";
        string = string + "nospy(X) :- send(self,nospy:,[X]).";
        string = string + "trace :- send(self,trace,[]).";
        string = string + "notrace :- send(self,notrace,[]).";
        this.systemReconsult_(new StReadStream(string));
    }

    private void systemPredicatesNo8() {
        String string = "";
        string = string + "append([],X,X).";
        string = string + "append([A|X],Y,[A|Z]) :- append(X,Y,Z).";
        string = string + "member(X,[X|Y]).";
        string = string + "member(X,[Y|Z]) :- member(X,Z).";
        string = string + "reverse([],[]).";
        string = string + "reverse([H|T],L) :- reverse(T,Z), append(Z,[H],L).";
        string = string + "length(X,Y) :- send(self,length:,[X],Y).";
        string = string + "nth([X|Y],1,Z) :- !, =(X,Z).";
        string = string + "nth([X|Y],N,Z) :- -(N,1,PN), nth(Y,PN,Z).";
        string = string + "printlist(L) :- send(self,listPrint:,[L]).";
        string = string + "lispAppend(X,Y,Z) :- send(X,append:,[Y],Z).";
        string = string + "lispReverse(X,Y) :- send(X,reverse,[],Y).";
        string = string + "lispMember(X,Y) :- send(Y,member:,[X],A), \\=(A,[]).";
        string = string + "lispMember(X,Y,Z) :- send(Y,member:,[X],Z).";
        string = string + "lispAssoc(X,Y) :- send(Y,assoc:,[X],A), \\=(A,[]).";
        string = string + "lispAssoc(X,Y,Z) :- send(Y,assoc:,[X],Z).";
        string = string + "lispNconc(X,Y,Z) :- send(X,nconc:,[Y],Z).";
        this.systemReconsult_(new StReadStream(string));
    }

    private void systemPredicatesNo9() {
        String string = "";
        string = string + "% User System Predicates";
        this.systemReconsult_(new StReadStream(string));
    }
}

