/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.plotter;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.pen.JunPenTransformation;
import jp.co.sra.jun.goodies.plotter.JunPlotterView;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.smalltalk.StView;

public class JunPlotterController
extends JunAbstractController
implements MouseListener,
MouseMotionListener {
    private Point _previousPoint;
    private Point _lastDownPoint;

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || mouseEvent.isMetaDown()) {
            super.mousePressed(mouseEvent);
            return;
        }
        this._previousPoint = this._lastDownPoint;
        this._lastDownPoint = mouseEvent.getPoint();
        this.view().toComponent().setCursor(Cursor.getPredefinedCursor(1));
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || mouseEvent.isMetaDown()) {
            super.mouseReleased(mouseEvent);
            return;
        }
        this.view().toComponent().setCursor(Cursor.getPredefinedCursor(0));
        this._previousPoint = null;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isMetaDown()) {
            this.scrollView_(mouseEvent.getPoint());
        }
    }

    public void resetView() {
        this.plotterView().viewingTransformation_(null);
    }

    public void scrollView_(Point point) {
        JunPenTransformation junPenTransformation = JunPenTransformation.Unity();
        junPenTransformation = junPenTransformation.product_(this.plotterView().viewingTransformation());
        if (this._previousPoint == null) {
            this._previousPoint = point;
        } else if (this._previousPoint != point) {
            JunPenTransformation junPenTransformation2 = JunPenTransformation.Translate_((Object)new Jun2dPoint(point.x - this._previousPoint.x, point.y - this._previousPoint.y));
            junPenTransformation = junPenTransformation.product_(junPenTransformation2);
            this.plotterView().viewingTransformation_(junPenTransformation);
            this._previousPoint = point;
        }
    }

    public void zoomIn() {
        JunPenTransformation junPenTransformation = JunPenTransformation.Unity();
        junPenTransformation = junPenTransformation.product_(this.plotterView().viewingTransformation());
        junPenTransformation = junPenTransformation.product_(JunPenTransformation.Scale_(new Double(2.0)));
        this.plotterView().viewingTransformation_(junPenTransformation);
    }

    public void zoomOut() {
        JunPenTransformation junPenTransformation = JunPenTransformation.Unity();
        junPenTransformation = junPenTransformation.product_(this.plotterView().viewingTransformation());
        junPenTransformation = junPenTransformation.product_(JunPenTransformation.Scale_(new Double(0.5)));
        this.plotterView().viewingTransformation_(junPenTransformation);
    }

    public JunPlotterView plotterView() {
        return (JunPlotterView)this.view();
    }

    protected void buildListener(StView stView) {
        Component component = (Component)stView;
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }
}

