/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.multimedia;

import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.movie.framework.JunMovieHandle;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaExtraModel;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaImageModel;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaMovieModel;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaTextModel;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaViewerViewAwt;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaViewerViewSwing;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StInputState;
import jp.co.sra.smalltalk.StView;

public class JunMultiMediaViewer
extends JunApplicationModel {
    protected JunFileModel fileModel;
    protected JunMultiMediaImageModel imageModel;
    protected JunMultiMediaMovieModel movieModel;
    protected JunMultiMediaTextModel textModel;
    protected JunMultiMediaExtraModel extraModel;
    protected boolean isMoviePlay;

    protected void initialize() {
        super.initialize();
        this.fileModel = null;
        this.imageModel = null;
        this.movieModel = null;
        this.textModel = null;
        this.extraModel = null;
        this.isMoviePlay = false;
    }

    public void release() {
        this.fileModel().release();
        this.movieModel().release();
        this.imageModel().release();
        this.textModel().release();
        this.extraModel().release();
        super.release();
    }

    public JunFileModel fileModel() {
        if (this.fileModel == null) {
            int n;
            HashSet<String> hashSet = new HashSet<String>();
            String[] stringArray = JunSystem.DefaultImageExtensionPatterns();
            for (n = 0; n < stringArray.length; ++n) {
                hashSet.add(stringArray[n]);
            }
            stringArray = JunSystem.DefaultMovieExtensionPatterns();
            for (n = 0; n < stringArray.length; ++n) {
                hashSet.add(stringArray[n]);
            }
            stringArray = JunSystem.DefaultSoundExtensionPatterns();
            for (n = 0; n < stringArray.length; ++n) {
                hashSet.add(stringArray[n]);
            }
            stringArray = JunSystem.DefaultTextExtensionPatterns();
            for (n = 0; n < stringArray.length; ++n) {
                hashSet.add(stringArray[n]);
            }
            stringArray = JunSystem.DefaultExtraExtensionPatterns();
            for (n = 0; n < stringArray.length; ++n) {
                hashSet.add(stringArray[n]);
            }
            String[] stringArray2 = hashSet.toArray(new String[hashSet.size()]);
            JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunSystem.$String((String)"Multi-media files"), stringArray2), JunFileModel.FileType.All(JunSystem.$String((String)"All files"))};
            this.fileModel = new JunFileModel();
            this.fileModel.fileTypes_(fileTypeArray);
            this.fileModel.compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunMultiMediaViewer.this.checkFile_((File)object);
                    return null;
                }
            });
        }
        return this.fileModel;
    }

    public JunMultiMediaImageModel imageModel() {
        if (this.imageModel == null) {
            this.imageModel = new JunMultiMediaImageModel();
        }
        return this.imageModel;
    }

    public JunMultiMediaMovieModel movieModel() {
        if (this.movieModel == null) {
            this.movieModel = new JunMultiMediaMovieModel();
            this.movieModel.trackerModel().loop();
        }
        return this.movieModel;
    }

    public JunMultiMediaTextModel textModel() {
        if (this.textModel == null) {
            this.textModel = new JunMultiMediaTextModel();
        }
        return this.textModel;
    }

    public JunMultiMediaExtraModel extraModel() {
        if (this.extraModel == null) {
            this.extraModel = new JunMultiMediaExtraModel();
        }
        return this.extraModel;
    }

    public StView defaultView() {
        if (JunMultiMediaViewer.GetDefaultViewMode() == 0) {
            return new JunMultiMediaViewerViewAwt(this);
        }
        return new JunMultiMediaViewerViewSwing(this);
    }

    protected String windowTitle() {
        return JunMultiMediaViewer.$String((String)"Multi-Media Viewer");
    }

    public void noticeOfWindowClose(WindowEvent windowEvent) {
        this.fileModel().closeRequest();
        this.movieModel().closeRequest();
        this.imageModel().closeRequest();
        this.textModel().closeRequest();
        this.extraModel().closeRequest();
        this.release();
        super.noticeOfWindowClose(windowEvent);
    }

    protected void checkFile_(File file) {
        String string;
        this.isMoviePlay = this.movieModel().isPlay();
        this.imageModel().beInvisible();
        this.movieModel().beInvisible();
        this.textModel().beInvisible();
        this.extraModel().beInvisible();
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            return;
        }
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        String string3 = string = n < 0 ? "" : string2.substring(n + 1).toLowerCase();
        if (Arrays.asList(JunSystem.DefaultMovieExtensions()).contains(string) || Arrays.asList(JunSystem.DefaultSoundExtensions()).contains(string)) {
            JunMovieHandle junMovieHandle = JunMovieHandle.Filename_(file);
            if (junMovieHandle == null) {
                return;
            }
            this.movieModel().movieHandle_(junMovieHandle);
            this.movieModel().normalSize();
            this.movieModel().beVisible();
            this.movieModel().goto_(this.movieModel().now());
            if (this.movieModel().isIntervalNotEmpty()) {
                this.movieModel().trackerModel().firstMarker_(this.movieModel().trackerModel().firstMarker());
                this.movieModel().trackerModel().lastMarker_(this.movieModel().trackerModel().lastMarker());
            }
            if (this.isMoviePlay) {
                this.movieModel().start();
            }
        } else if (Arrays.asList(JunSystem.DefaultImageExtensions()).contains(string)) {
            this.imageModel().visual_(new JunMultiMediaImageModel(file).visual());
            this.imageModel().beVisible();
        } else if (Arrays.asList(JunSystem.DefaultTextExtensions()).contains(string)) {
            this.textModel().textHolder().value_(new JunMultiMediaTextModel(file).textHolder().value());
            this.textModel().beVisible();
        } else if (StInputState.Default().altDown()) {
            int n2 = 0x400000;
            long l = file.length();
            Object object = l > (long)n2 && JunDialog.Confirm_(JunMultiMediaViewer.$String((String)"The file is large: <1p> bytes.", null, (Object)new Long(l)) + "\n" + JunMultiMediaViewer.$String((String)"Would you like to use dump on the head?")) ? new JunMultiMediaTextModel(file, n2).textHolder().value() : new JunMultiMediaTextModel(file).textHolder().value();
            this.textModel().textHolder().value_(object);
            this.textModel().beVisible();
        } else {
            this.extraModel().file_(file);
            this.extraModel().beVisible();
        }
    }
}

