/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.multimedia;

import java.awt.Dimension;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import jp.co.sra.jun.goodies.dump.JunDumpModel;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaTextView;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaTextViewAwt;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaTextViewSwing;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaViewable;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.smalltalk.DependentListener;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;

public class JunMultiMediaTextModel
extends JunApplicationModel
implements JunMultiMediaViewable {
    protected static final int DefaultCheckingSize = 1024;
    protected StValueHolder textHolder;

    public JunMultiMediaTextModel() {
    }

    public JunMultiMediaTextModel(File file) {
        this(file, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JunMultiMediaTextModel(File file, long l) {
        this();
        String string;
        if (file.exists()) {
            long l2 = file.length();
            if (JunMultiMediaTextModel.CanReadAsText_(file) && (l <= 0L || l2 <= l)) {
                BufferedReader bufferedReader = null;
                BufferedWriter bufferedWriter = null;
                try {
                    int n;
                    StringWriter stringWriter = new StringWriter();
                    bufferedWriter = new BufferedWriter(stringWriter);
                    bufferedReader = new BufferedReader(new FileReader(file));
                    while ((n = bufferedReader.read()) >= 0) {
                        bufferedWriter.write(n);
                    }
                    bufferedWriter.flush();
                    string = stringWriter.toString();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    string = fileNotFoundException.toString();
                }
                catch (IOException iOException) {
                    string = iOException.toString();
                }
                finally {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (bufferedWriter != null) {
                            bufferedWriter.flush();
                            bufferedWriter.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            } else {
                JunDumpModel junDumpModel = new JunDumpModel(file, 0, 1024);
                string = (String)junDumpModel.textModel().value();
                if (l2 > 1024L) {
                    string = string + "...";
                }
            }
        } else {
            string = "Unexpected text file";
        }
        this.textHolder_(new StValueHolder((Object)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean CanReadAsText_(File file) {
        int n;
        if (!file.exists()) {
            return false;
        }
        if (!file.canRead()) {
            return false;
        }
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            for (int i = 1024; (n = inputStream.read()) >= 0 && i > 0; --i) {
                if (n != 0 && Character.isDefined((char)n)) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            n = 0;
            return n != 0;
        }
        catch (IOException iOException) {
            n = 0;
            return n != 0;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public void beInvisible() {
        DependentListener[] dependentListenerArray = this.dependents();
        for (int i = 0; i < dependentListenerArray.length; ++i) {
            if (!(dependentListenerArray[i] instanceof JunMultiMediaTextView)) continue;
            ((JunMultiMediaTextView)dependentListenerArray[i]).toComponent().setVisible(false);
        }
    }

    public void beVisible() {
        DependentListener[] dependentListenerArray = this.dependents();
        for (int i = 0; i < dependentListenerArray.length; ++i) {
            if (!(dependentListenerArray[i] instanceof JunMultiMediaTextView)) continue;
            ((JunMultiMediaTextView)dependentListenerArray[i]).toComponent().setVisible(true);
        }
    }

    public StView defaultView() {
        if (JunMultiMediaTextModel.GetDefaultViewMode() == 0) {
            return new JunMultiMediaTextViewAwt(this);
        }
        return new JunMultiMediaTextViewSwing(this);
    }

    public boolean isEmbedded() {
        StView stView = this.getView();
        return stView == null || !(stView.toComponent().getParent() instanceof Window);
    }

    public StValueHolder textHolder() {
        if (this.textHolder == null) {
            this.textHolder = new StValueHolder((Object)new String());
        }
        return this.textHolder;
    }

    public void textHolder_(StValueHolder stValueHolder) {
        this.textHolder = stValueHolder;
    }

    protected void initialize() {
        super.initialize();
        this.textHolder = null;
    }

    protected void setSize_(Dimension dimension) {
        if (this.isEmbedded()) {
            return;
        }
        super.setSize_(dimension);
    }

    protected String windowTitle() {
        return JunMultiMediaTextModel.$String((String)"Text");
    }
}

