/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.multimedia;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.File;
import java.net.MalformedURLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import jp.co.sra.jun.goodies.display.JunDisplayModel;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.icon.JunOpaqueImageIcons;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaExtraView;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaExtraViewAwt;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaExtraViewSwing;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaViewable;
import jp.co.sra.jun.goodies.tips.JunURL;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.DependentListener;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

public class JunMultiMediaExtraModel
extends JunDisplayModel
implements JunMultiMediaViewable {
    protected File file;
    protected StPopupMenu _popupMenu;

    public JunMultiMediaExtraModel() {
    }

    public JunMultiMediaExtraModel(File file) {
        this.file_(file);
    }

    protected void initialize() {
        super.initialize();
        this.file = null;
    }

    public File file() {
        return this.file;
    }

    public void file_(File file) {
        this.file = file;
        if (this.file.exists()) {
            this.visual_(this.iconImage());
        }
        this.updateWindowTitle();
        this.updateMenuIndication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StImage iconImage() {
        StImage stImage = null;
        String string = this.file().getName();
        int n = string.lastIndexOf(46);
        stImage = n >= 0 ? ((string = string.substring(n + 1).toLowerCase()).equals("pdf") ? JunMultiMediaExtraModel.PdfIcon() : (string.equals("doc") ? JunMultiMediaExtraModel.DocIcon() : (string.equals("xls") ? JunMultiMediaExtraModel.XlsIcon() : (string.equals("ppt") ? JunMultiMediaExtraModel.PptIcon() : JunMultiMediaExtraModel.Icon(string))))) : JunMultiMediaExtraModel.OtherIcon();
        string = this.file().getName();
        string = string + '\n';
        string = string + JunMultiMediaExtraModel.FileSizeString_(this.file());
        string = string + '\n';
        string = string + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date(this.file().lastModified()));
        StComposedText stComposedText = new StComposedText(string);
        stComposedText.centered();
        int n2 = Math.max(stImage.width(), stComposedText.width());
        int n3 = stImage.height() + stComposedText.height();
        StImage stImage2 = new StImage(n2, n3);
        Graphics graphics = null;
        try {
            graphics = stImage2.image().getGraphics();
            StRectangle stRectangle = new StRectangle(stImage.bounds());
            stImage.displayOn_at_(graphics, stRectangle.align_with_(stRectangle.topCenter(), new Point(n2 / 2, 0)).origin());
            graphics.setColor(Color.black);
            StRectangle stRectangle2 = new StRectangle(stComposedText.bounds());
            stComposedText.displayOn_at_(graphics, stRectangle2.align_with_(stRectangle2.bottomCenter(), new Point(n2 / 2, n3)).origin());
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
        return stImage2;
    }

    public StView defaultView() {
        if (JunMultiMediaExtraModel.GetDefaultViewMode() == 0) {
            return new JunMultiMediaExtraViewAwt(this);
        }
        return new JunMultiMediaExtraViewSwing(this);
    }

    public void setWindowLabel() {
    }

    protected String windowTitle() {
        return JunMultiMediaExtraModel.$String((String)"Extra");
    }

    public StPopupMenu _popupMenu() {
        if (this._popupMenu == null) {
            StPopupMenu stPopupMenu = new StPopupMenu();
            stPopupMenu.add(new StMenuItem((Object)JunMultiMediaExtraModel.$String((String)"Open"), (MenuListener)new MenuPerformer((StObject)this, "openExtraFile")));
            this._popupMenu = stPopupMenu;
        }
        return this._popupMenu;
    }

    public void openExtraFile() {
        try {
            JunURL.Browse_(this.file().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    public void beInvisible() {
        this.beVisible(false);
    }

    public void beVisible() {
        this.beVisible(true);
    }

    protected void beVisible(boolean bl) {
        DependentListener[] dependentListenerArray = this.dependents();
        for (int i = 0; i < dependentListenerArray.length; ++i) {
            if (!(dependentListenerArray[i] instanceof JunMultiMediaExtraView)) continue;
            ((JunMultiMediaExtraView)dependentListenerArray[i]).toComponent().setVisible(bl);
        }
    }

    public static StImage Icon(String string) {
        return JunMultiMediaExtraModel.Icon(string, Color.black);
    }

    public static StImage Icon(String string, Color color) {
        return JunMultiMediaExtraModel.Icon(string, color, JunMultiMediaExtraModel.OtherIcon());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StImage Icon(String string, Color color, StImage stImage) {
        StImage stImage2 = new StImage(stImage.bounds().getSize());
        Graphics2D graphics2D = null;
        try {
            graphics2D = (Graphics2D)stImage2.image().getGraphics();
            stImage.displayOn_((Graphics)graphics2D);
            graphics2D.setColor(color);
            Font font = graphics2D.getFont().deriveFont(1);
            StComposedText stComposedText = new StComposedText(string, font);
            int n = (stImage2.width() - stComposedText.width()) / 2;
            int n2 = (stImage2.height() - stComposedText.height()) / 2;
            stComposedText.displayOn_at_((Graphics)graphics2D, new Point(n, n2));
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
        return stImage2;
    }

    public static StImage OtherIcon() {
        return JunOpaqueImageIcons.OtherFigure64x64();
    }

    public static StImage DocIcon() {
        return JunMultiMediaExtraModel.Icon("doc", StColorValue.Blend((Color)Color.blue, (Color)Color.gray));
    }

    public static StImage PdfIcon() {
        return JunMultiMediaExtraModel.Icon("pdf", Color.red);
    }

    public static StImage PptIcon() {
        return JunMultiMediaExtraModel.Icon("ppt", StColorValue.Blend((Color)Color.red, (Color)Color.gray));
    }

    public static StImage XlsIcon() {
        return JunMultiMediaExtraModel.Icon("xls", StColorValue.Blend((Color)Color.green, (Color)Color.gray));
    }

    public static String FileSizeString_(File file) {
        String string = "";
        if (file != null && file.exists()) {
            long l = file.length();
            string = new DecimalFormat("#,###").format(l);
            string = string + " bytes ( ";
            string = string + new DecimalFormat("0.00").format((double)l / 1048576.0);
            string = string + " MB )";
        }
        return string;
    }

    public static JunMultiMediaExtraModel Request() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(JunSystem.DefaultTextExtensionPatterns()));
        arrayList.addAll(Arrays.asList(JunSystem.DefaultImageExtensionPatterns()));
        arrayList.addAll(Arrays.asList(JunSystem.DefaultMovieExtensionPatterns()));
        arrayList.addAll(Arrays.asList(JunSystem.DefaultSoundExtensionPatterns()));
        arrayList.addAll(Arrays.asList(JunSystem.DefaultExtraExtensionPatterns()));
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunMultiMediaExtraModel.$String((String)"Multi-media files"), stringArray), JunFileModel.FileType.All(JunMultiMediaExtraModel.$String((String)"All files"))};
        File file = JunFileRequesterDialog.Request(JunMultiMediaExtraModel.$String((String)"Select a file."), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return null;
        }
        return new JunMultiMediaExtraModel(file);
    }
}

