/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.movie.support;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.jun.goodies.image.streams.JunJpegImageStream;
import jp.co.sra.jun.goodies.movie.support.JunImagesToMovie;
import jp.co.sra.jun.goodies.movie.support.JunScreenRecorderViewAwt;
import jp.co.sra.jun.goodies.movie.support.JunScreenRecorderViewSwing;
import jp.co.sra.jun.goodies.progress.JunProgress;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.SystemInterface;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

public class JunScreenRecorder
extends JunApplicationModel
implements Runnable {
    protected File file;
    protected Rectangle movieArea;
    protected Dimension movieExtent;
    protected int watchTick = 1000;
    protected boolean watchState = false;
    protected volatile Thread watchThread = null;
    protected File imagesFile;
    protected int imagesCount;
    protected volatile boolean watchDone;

    public Rectangle getMovieArea() {
        if (this.movieArea == null) {
            this.movieArea = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        }
        return this.movieArea;
    }

    public void setMovieArea(Rectangle rectangle) {
        this.movieArea = rectangle;
        this.changed_(JunScreenRecorder.$((String)"movieArea"));
        if (this.movieExtent != null) {
            this.setMovieExtent(new Dimension(this.movieExtent.width, this.movieArea.height * this.movieExtent.width / this.movieArea.width));
        }
    }

    public Dimension getMovieExtent() {
        if (this.movieExtent == null) {
            this.movieExtent = new Dimension(320, 240);
        }
        return this.movieExtent;
    }

    public void setMovieExtent(Dimension dimension) {
        this.movieExtent = dimension;
        this.changed_(JunScreenRecorder.$((String)"movieExtent"));
    }

    public int getWatchTick() {
        return this.watchTick;
    }

    public void setWatchTick(int n) {
        this.watchTick = n;
        this.changed_(JunScreenRecorder.$((String)"watchTick"));
    }

    public boolean getWatchState() {
        return this.watchState;
    }

    public StView defaultView() {
        if (JunScreenRecorder.GetDefaultViewMode() == 0) {
            return new JunScreenRecorderViewAwt(this);
        }
        return new JunScreenRecorderViewSwing(this);
    }

    protected StPopupMenu _createAreaPopupMenu() {
        StPopupMenu stPopupMenu = new StPopupMenu();
        stPopupMenu.add(new StMenuItem((Object)JunScreenRecorder.$String((String)"From user..."), (MenuListener)new MenuPerformer((StObject)this, "areaFromYou")));
        stPopupMenu.addSeparator();
        stPopupMenu.add(new StMenuItem((Object)JunScreenRecorder.$String((String)"Whole screen"), (MenuListener)new MenuPerformer((StObject)this, "areaWholeScreen")));
        return stPopupMenu;
    }

    protected StPopupMenu _createSizePopupMenu() {
        StPopupMenu stPopupMenu = new StPopupMenu();
        stPopupMenu.add(new StMenuItem((Object)"320@240 (half)", (MenuListener)new MenuPerformer((StObject)this, "sizeHalf")));
        stPopupMenu.add(new StMenuItem((Object)"160@120 (quart)", (MenuListener)new MenuPerformer((StObject)this, "sizeQuart")));
        stPopupMenu.add(new StMenuItem((Object)"640@480 (full)", (MenuListener)new MenuPerformer((StObject)this, "sizeFull")));
        stPopupMenu.addSeparator();
        stPopupMenu.add(new StMenuItem((Object)"area (as is)", (MenuListener)new MenuPerformer((StObject)this, "sizeAsIs")));
        stPopupMenu.add(new StMenuItem((Object)"area / 2", (MenuListener)new MenuPerformer((StObject)this, "sizeDiv2")));
        stPopupMenu.add(new StMenuItem((Object)"area / 4", (MenuListener)new MenuPerformer((StObject)this, "sizeDiv4")));
        stPopupMenu.add(new StMenuItem((Object)"area / 8", (MenuListener)new MenuPerformer((StObject)this, "sizeDiv8")));
        return stPopupMenu;
    }

    protected StPopupMenu _createSpeedPopupMenu() {
        StPopupMenu stPopupMenu = new StPopupMenu();
        stPopupMenu.add(new StMenuItem((Object)"100 msec. (10 frames per sec.)", (MenuListener)new MenuPerformer((StObject)this, "speed100msec")));
        stPopupMenu.add(new StMenuItem((Object)"200 msec. (5 frames per sec.)", (MenuListener)new MenuPerformer((StObject)this, "speed200msec")));
        stPopupMenu.add(new StMenuItem((Object)"500 msec. (2 frames per sec.)", (MenuListener)new MenuPerformer((StObject)this, "speed500msec")));
        stPopupMenu.add(new StMenuItem((Object)"1 sec. (1 frame per sec.)", (MenuListener)new MenuPerformer((StObject)this, "speed1sec")));
        stPopupMenu.add(new StMenuItem((Object)"2 sec. (30 frames per min.)", (MenuListener)new MenuPerformer((StObject)this, "speed2sec")));
        stPopupMenu.add(new StMenuItem((Object)"5 sec. (12 frames per min.)", (MenuListener)new MenuPerformer((StObject)this, "speed5sec")));
        stPopupMenu.add(new StMenuItem((Object)"10 sec. (6 frames per min.)", (MenuListener)new MenuPerformer((StObject)this, "speed10sec")));
        stPopupMenu.add(new StMenuItem((Object)"15 sec. (4 frames per min.)", (MenuListener)new MenuPerformer((StObject)this, "speed15sec")));
        stPopupMenu.add(new StMenuItem((Object)"20 sec. (3 frames per min.)", (MenuListener)new MenuPerformer((StObject)this, "speed20sec")));
        stPopupMenu.add(new StMenuItem((Object)"30 sec. (2 frames per min.)", (MenuListener)new MenuPerformer((StObject)this, "speed30sec")));
        stPopupMenu.add(new StMenuItem((Object)"1 min. (1 frame per min.)", (MenuListener)new MenuPerformer((StObject)this, "speed1min")));
        return stPopupMenu;
    }

    public String getRecordButtonLabel() {
        return !this.watchState ? JunScreenRecorder.$String((String)"Record") : JunScreenRecorder.$String((String)"Stop");
    }

    public String getAreaButtonLabel() {
        Rectangle rectangle = this.getMovieArea();
        return JunScreenRecorder.$String((String)"Snap Area") + ": (" + rectangle.x + "@" + rectangle.y + " corner: " + (rectangle.x + rectangle.width) + "@" + (rectangle.y + rectangle.height) + ")";
    }

    public String getSizeButtonLabel() {
        Dimension dimension = this.getMovieExtent();
        return JunScreenRecorder.$String((String)"Snap Size") + ": (" + dimension.width + "@" + dimension.height + ")";
    }

    public String getSpeedButtonLabel() {
        String string = JunScreenRecorder.$String((String)"Recording Speed") + ": ";
        if (this.watchTick < 1000) {
            return string + this.watchTick + " msec.";
        }
        if (this.watchTick < 60000) {
            return string + this.watchTick / 1000 + " sec.";
        }
        return string + this.watchTick / 60000 + " min.";
    }

    public void areaWholeScreen() {
        this.setMovieArea(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
    }

    public void areaFromYou() {
        Rectangle rectangle = SystemInterface._RectangleFromUser();
        if (rectangle != null) {
            this.setMovieArea(rectangle);
        }
    }

    public void sizeHalf() {
        this.setMovieExtent(new Dimension(320, 240));
    }

    public void sizeQuart() {
        this.setMovieExtent(new Dimension(160, 120));
    }

    public void sizeFull() {
        this.setMovieExtent(new Dimension(640, 480));
    }

    public void sizeAsIs() {
        this.setMovieExtent(this.getMovieArea().getSize());
    }

    public void sizeDiv2() {
        Dimension dimension = this.getMovieArea().getSize();
        this.setMovieExtent(new Dimension(dimension.width / 2, dimension.height / 2));
    }

    public void sizeDiv4() {
        Dimension dimension = this.getMovieArea().getSize();
        this.setMovieExtent(new Dimension(dimension.width / 4, dimension.height / 4));
    }

    public void sizeDiv8() {
        Dimension dimension = this.getMovieArea().getSize();
        this.setMovieExtent(new Dimension(dimension.width / 8, dimension.height / 8));
    }

    public void speed100msec() {
        this.setWatchTick(100);
    }

    public void speed200msec() {
        this.setWatchTick(200);
    }

    public void speed500msec() {
        this.setWatchTick(500);
    }

    public void speed1sec() {
        this.setWatchTick(1000);
    }

    public void speed2sec() {
        this.setWatchTick(2000);
    }

    public void speed5sec() {
        this.setWatchTick(5000);
    }

    public void speed10sec() {
        this.setWatchTick(10000);
    }

    public void speed15sec() {
        this.setWatchTick(15000);
    }

    public void speed20sec() {
        this.setWatchTick(20000);
    }

    public void speed30sec() {
        this.setWatchTick(30000);
    }

    public void speed1min() {
        this.setWatchTick(60000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ObjectOutputStream objectOutputStream;
        Thread thread = Thread.currentThread();
        try {
            this.imagesFile = File.createTempFile("images", ".tmp");
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.imagesFile));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.watchDone = false;
        this.imagesCount = 0;
        while (this.watchThread == thread) {
            int[] nArray;
            SystemInterface systemInterface;
            SystemInterface systemInterface2 = systemInterface = SystemInterface.Current();
            synchronized (systemInterface2) {
                Rectangle rectangle = this.getMovieArea();
                nArray = systemInterface.utilImageOfArea(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            try {
                objectOutputStream.writeObject(nArray);
                objectOutputStream.reset();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.watchDone = true;
                return;
            }
            ++this.imagesCount;
            try {
                Thread.sleep(this.watchTick);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            objectOutputStream.writeObject(null);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.watchDone = true;
    }

    public void makeMovieFile() throws Exception {
        new JunProgress().doWithStopButton_(new StBlockClosure(){

            public Object value_(Object object) {
                final JunProgress junProgress = (JunProgress)((Object)object);
                junProgress.message_(1.$String((String)"make movie..."));
                new JunImagesToMovie(JunScreenRecorder.this.file, JunScreenRecorder.this.getMovieExtent()).do_(new StBlockClosure(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object value_(Object object) {
                        JunImagesToMovie junImagesToMovie = (JunImagesToMovie)((Object)object);
                        ObjectInputStream objectInputStream = null;
                        int n = 0;
                        try {
                            int[] nArray;
                            objectInputStream = new ObjectInputStream(new FileInputStream((this).JunScreenRecorder.this.imagesFile));
                            while ((nArray = (int[])objectInputStream.readObject()) != null) {
                                Dimension dimension = JunScreenRecorder.this.getMovieArea().getSize();
                                junImagesToMovie.addPixels_width_height_milliseconds_(nArray, dimension.width, dimension.height, (this).JunScreenRecorder.this.watchTick);
                                junProgress.value_((float)(++n) / (float)(this).JunScreenRecorder.this.imagesCount);
                            }
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            classNotFoundException.printStackTrace();
                        }
                        catch (RuntimeException runtimeException) {
                        }
                        finally {
                            if (objectInputStream != null) {
                                try {
                                    objectInputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        return null;
                    }
                });
                return null;
            }
        });
        this.imagesFile.delete();
        this.imagesFile = null;
    }

    public void recordButtonPressed() {
        if (!this.watchState && this.watchThread == null) {
            this.watchState = true;
            this.changed_(JunScreenRecorder.$((String)"watchState"));
            JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunScreenRecorder.$String((String)"<1p> files", null, (Object)JunScreenRecorder.$String((String)"Movie")), new String[]{"*.mov", "*.MOV"})};
            this.file = JunFileRequesterDialog.RequestNewFile(JunScreenRecorder.$String((String)"Input a <1p> file.", null, (Object)"MOV"), new File(this.defaultBaseName() + ".mov"), fileTypeArray, fileTypeArray[0]);
            if (this.file != null) {
                this.watchThread = new Thread(this);
                this.watchThread.start();
            } else {
                this.watchState = false;
                this.changed_(JunScreenRecorder.$((String)"watchState"));
            }
        } else if (this.watchState && this.watchThread != null) {
            Thread thread = this.watchThread;
            this.watchThread = null;
            thread.interrupt();
            while (!this.watchDone) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                this.makeMovieFile();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.watchState = false;
            this.changed_(JunScreenRecorder.$((String)"watchState"));
        }
    }

    public void snapButtonPressed() {
        StImage stImage = StImage._OfArea((Rectangle)this.getMovieArea());
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunScreenRecorder.$String((String)"<1p> files", null, (Object)"JPEG"), new String[]{"*.jpg", "*.JPG"})};
        File file = JunFileRequesterDialog.RequestNewFile(JunScreenRecorder.$String((String)"Input a <1p> file.", null, (Object)"JPEG"), new File(this.defaultBaseName() + ".jpg"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            JunImageStream junImageStream = JunJpegImageStream.On_(fileOutputStream);
            junImageStream.nextPutImage_(stImage);
            junImageStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected String windowTitle() {
        return JunScreenRecorder.$String((String)"Screen Recorder");
    }
}

