/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.movie.support;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import jp.co.sra.jun.goodies.bulletinboard.JunBulletinBoard;
import jp.co.sra.jun.goodies.bulletinboard.JunBulletinBoardViewSwing;
import jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer;
import jp.co.sra.jun.goodies.movie.support.JunImagesToMovie;
import jp.co.sra.jun.goodies.utilities.JunImageUtility;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;

public class JunImagesToMovieTestExamples
extends JunTestExamples {
    public static boolean Example1() {
        final Rectangle rectangle = new Rectangle(0, 0, 320, 240);
        final Point point = new Point(4, 3);
        File file = new File("Screen.mov");
        JunImagesToMovie.File_extent_do_(file, rectangle.getSize(), new StBlockClosure(){

            public Object value_(Object object) {
                JunImagesToMovie junImagesToMovie = (JunImagesToMovie)((Object)object);
                Rectangle rectangle2 = JunSystem.ScreenBoundingBox();
                while (rectangle2.contains(rectangle)) {
                    System.out.println(rectangle);
                    StImage stImage = StImage._OfArea((Rectangle)rectangle);
                    junImagesToMovie.add_milliseconds_(stImage, 20);
                    rectangle.translate(point.x, point.y);
                }
                return null;
            }
        });
        JunMoviePlayer junMoviePlayer = new JunMoviePlayer(file);
        if (junMoviePlayer == null) {
            return false;
        }
        junMoviePlayer.open();
        return true;
    }

    public static boolean Example2() {
        final Rectangle rectangle = new Rectangle(0, 0, 320, 240);
        final Point point = new Point(4, 3);
        Dimension dimension = JunSystem.ScreenBoundingBox().getSize();
        Dimension dimension2 = new Dimension(dimension.width - rectangle.width, dimension.height - rectangle.height);
        final int n = Math.min(dimension2.width / point.x, dimension2.height / point.y);
        File file = new File("Screen.mov");
        final JunImagesToMovie junImagesToMovie = new JunImagesToMovie(file, new Dimension(180, 120));
        junImagesToMovie.do_(new StBlockClosure(){

            public Object value() {
                junImagesToMovie.background_(Color.gray);
                for (int i = 0; i < n; ++i) {
                    System.out.print(i);
                    System.out.print(' ');
                    System.out.println("(" + rectangle + ")");
                    StImage stImage = StImage._OfArea((Rectangle)rectangle);
                    junImagesToMovie.add_milliseconds_(stImage, 20);
                    rectangle.translate(point.x, point.y);
                }
                return null;
            }
        });
        JunMoviePlayer junMoviePlayer = new JunMoviePlayer(file);
        if (junMoviePlayer == null) {
            return false;
        }
        junMoviePlayer.open();
        return true;
    }

    public static boolean Example3() {
        final JunBulletinBoard junBulletinBoard = new JunBulletinBoard();
        String string = "Eclipse VisualJ++ VisualAge ...";
        for (int i = 0; i < string.length(); ++i) {
            junBulletinBoard.color_(new Color(Color.HSBtoRGB((float)i / (float)string.length(), 1.0f, 1.0f)));
            junBulletinBoard.add_(string.charAt(i));
        }
        final JunBulletinBoardViewSwing junBulletinBoardViewSwing = new JunBulletinBoardViewSwing(junBulletinBoard);
        junBulletinBoardViewSwing.controller_(null);
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add((Component)((Object)junBulletinBoardViewSwing));
        jFrame.setResizable(false);
        jFrame.setBounds(100, 250, 200, 74);
        jFrame.pack();
        jFrame.setVisible(true);
        final Rectangle rectangle = new Rectangle(junBulletinBoardViewSwing.getLocationOnScreen().x, junBulletinBoardViewSwing.getLocationOnScreen().y, junBulletinBoardViewSwing.getWidth(), junBulletinBoardViewSwing.getHeight());
        File file = new File("BulletinBoard.mov");
        JunImagesToMovie.File_extent_do_(file, rectangle.getSize(), new StBlockClosure(){

            public Object value_(Object object) {
                JunImagesToMovie junImagesToMovie = (JunImagesToMovie)((Object)object);
                for (int i = 0; i < (junBulletinBoard.width() + junBulletinBoardViewSwing.getWidth()) / junBulletinBoardViewSwing.displaySpeed(); ++i) {
                    BufferedImage bufferedImage = JunImageUtility.FromDisplay_(rectangle);
                    junImagesToMovie.add_(new StImage((Image)bufferedImage));
                    junBulletinBoardViewSwing.repaint();
                }
                return null;
            }
        });
        jFrame.setVisible(false);
        jFrame.invalidate();
        JunMoviePlayer junMoviePlayer = new JunMoviePlayer(file);
        if (junMoviePlayer == null) {
            return false;
        }
        junMoviePlayer.open();
        return true;
    }

    public static boolean Example4() {
        File file = JunFileRequesterDialog.RequestDirectory(JunImagesToMovieTestExamples.$String((String)"Select a directory."));
        if (file == null) {
            return false;
        }
        String string = "*.jpg";
        int n = 15;
        String string2 = new File("ImageSequence.mov").getAbsolutePath();
        try {
            JunImagesToMovie.ImageSequenceDirectory_jpegImageFileNamePattern_framesPerSecond_movieFile_(file, string, n, new File(string2));
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
            return false;
        }
        JunMoviePlayer junMoviePlayer = new JunMoviePlayer(new File(string2));
        if (junMoviePlayer == null) {
            return false;
        }
        junMoviePlayer.open();
        return true;
    }

    public static void main(String[] stringArray) {
        new JunImagesToMovieTestExamples();
    }
}

