/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.movie.support;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import jp.co.sra.jun.goodies.animation.JunCartoonMovie;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.jun.goodies.image.streams.JunJpegImageStream;
import jp.co.sra.jun.goodies.image.support.JunImageAdjuster;
import jp.co.sra.jun.goodies.image.support.JunImageProcessor;
import jp.co.sra.jun.goodies.utilities.JunStringUtility;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.qt4jun.JunQTInterface;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;

public class JunImagesToMovie
extends JunAbstractObject {
    protected static final int TIME_SCALE = 600;
    protected File file;
    protected Dimension extent;
    protected Color background;
    protected int movie;
    protected int track;
    protected int media;

    public static JunImagesToMovie File_extent_do_(File file, Dimension dimension, StBlockClosure stBlockClosure) {
        JunImagesToMovie junImagesToMovie = new JunImagesToMovie(file, dimension);
        junImagesToMovie.do_(stBlockClosure);
        return junImagesToMovie;
    }

    public JunImagesToMovie(File file, Dimension dimension) {
        this.file_(file);
        this.extent_(dimension);
    }

    public JunImagesToMovie(String string, Dimension dimension) {
        this(new File(string), dimension);
    }

    protected void initialize() {
        super.initialize();
        this.file = null;
        this.extent = null;
        this.background = null;
        this.movie = Integer.MIN_VALUE;
        this.track = Integer.MIN_VALUE;
        this.media = Integer.MIN_VALUE;
    }

    public Color background() {
        if (this.background == null) {
            this.background = Color.white;
        }
        return this.background;
    }

    public void background_(Color color) {
        this.background = color;
    }

    public Dimension extent() {
        return this.extent;
    }

    public void extent_(Dimension dimension) {
        this.extent = dimension;
    }

    public File file() {
        return this.file;
    }

    public void file_(File file) {
        this.file = file;
    }

    public String filename() {
        return this.file == null ? null : this.file.getAbsolutePath();
    }

    public StImage add_(StImage stImage) {
        return this.add_milliseconds_(stImage, 33);
    }

    public StImage add_duration_(StImage stImage, int n) {
        if (this.extent == null) {
            return null;
        }
        if (this.media <= 0) {
            return null;
        }
        StImage stImage2 = this.adjustedImage_(stImage);
        this.addPixels_width_height_duration_(stImage2.getPixels(), stImage2.width(), stImage2.height(), n);
        return stImage2;
    }

    public StImage add_milliseconds_(StImage stImage, int n) {
        return this.add_duration_(stImage, n * 600 / 1000);
    }

    public StImage addImage_(StImage stImage) {
        return this.add_(stImage);
    }

    public StImage addImage_framesPerSecond_(StImage stImage, int n) {
        return this.addImage_keepTime_(stImage, 1000 / Math.min(Math.max(1, n), 1000));
    }

    public StImage addImage_keepTime_(StImage stImage, int n) {
        return this.add_milliseconds_(stImage, n);
    }

    public void addPixels_width_height_duration_(int[] nArray, int n, int n2, int n3) {
        JunQTInterface junQTInterface = JunQTInterface.Interface();
        junQTInterface.qtAddMediaSampleImage(this.media, nArray, n, n2, this.extent.width, this.extent.height, 512, 1919706400, n3);
    }

    public void addPixels_width_height_milliseconds_(int[] nArray, int n, int n2, int n3) {
        this.addPixels_width_height_duration_(nArray, n, n2, n3 * 600 / 1000);
    }

    public StImage adjustedImage_(StImage stImage) {
        if (this.extent == null) {
            return stImage;
        }
        StImage stImage2 = stImage;
        StImage stImage3 = null;
        if (stImage2.bounds().getSize().equals(this.extent())) {
            stImage3 = stImage2;
        } else {
            Rectangle rectangle = new Rectangle(0, 0, this.extent().width, this.extent().height);
            stImage2 = JunImageAdjuster.AdjustImage_extent_keepAspect_(stImage2, rectangle.getSize(), true);
            stImage3 = new StImage(rectangle.getSize());
            JunImageProcessor.Fill_color_(stImage3, this.background());
            Rectangle rectangle2 = stImage2.bounds();
            rectangle2.translate((rectangle.width - stImage2.bounds().width) / 2, (rectangle.height - stImage2.bounds().height) / 2);
            stImage3.copy_from_in_rule_(rectangle2, new Point(0, 0), stImage2, 3);
        }
        return stImage3;
    }

    public void do_(StBlockClosure stBlockClosure) {
        JunQTInterface junQTInterface = JunQTInterface.Interface();
        int[] nArray = junQTInterface.qtCreateMovieFile(this.filename(), 1414942532, -1, Integer.MIN_VALUE + 0x10000000);
        if (nArray != null) {
            if (nArray[0] == 0) {
                int n;
                int n2 = nArray[1];
                this.movie = nArray[2];
                this.track = junQTInterface.qtNewMovieTrack(this.movie, junQTInterface.qtFixRatio(this.extent.width, 1), junQTInterface.qtFixRatio(this.extent.height, 1), 0);
                if (junQTInterface.qtGetMoviesError() == 0) {
                    this.media = junQTInterface.qtNewTrackMedia(this.track, 1986618469, 600, 0, 0);
                    if (junQTInterface.qtGetMoviesError() == 0) {
                        n = junQTInterface.qtBeginMediaEdits(this.media);
                        if (n == 0) {
                            if (stBlockClosure.numArgs() == 0) {
                                stBlockClosure.value();
                            } else {
                                stBlockClosure.value_((Object)this);
                            }
                            n = junQTInterface.qtEndMediaEdits(this.media);
                            if (n == 0) {
                                int n3 = junQTInterface.qtGetMediaDuration(this.media);
                                n = junQTInterface.qtInsertMediaIntoTrack(this.track, 0, 0, n3, 65536);
                            }
                        }
                    }
                }
                n = junQTInterface.qtAddMovieResource(this.movie, n2, -1, null);
                n = junQTInterface.qtCloseMovieFile(n2);
                junQTInterface.qtDisposeMovie(this.movie);
            }
        }
    }

    public static JunCartoonMovie ImageSequenceDirectory_jpegImageFileNamePattern_framesPerSecond_(File file, String string, int n) throws IOException {
        JunCartoonMovie junCartoonMovie = new JunCartoonMovie(file, string, n);
        junCartoonMovie.open();
        return junCartoonMovie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ImageSequenceDirectory_jpegImageFileNamePattern_framesPerSecond_movieFile_(File file, final String string, final int n, File file2) throws IOException {
        if (!file.exists()) {
            throw new IOException(file.getPath() + " does not exist.");
        }
        if (!file.isDirectory()) {
            throw new IOException(file.getPath() + " is not a directory.");
        }
        final File[] fileArray = file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string2) {
                return JunStringUtility.StringMatch_and_(string2, string);
            }
        });
        if (fileArray == null || fileArray.length == 0) {
            throw new IOException("No image in " + file.getPath());
        }
        JunCursors junCursors = new JunCursors(JunCursors.ReadCursor());
        try {
            junCursors._show();
            StImage stImage = null;
            JunImageStream junImageStream = null;
            try {
                junImageStream = JunJpegImageStream.On_(new FileInputStream(fileArray[0]));
                stImage = junImageStream.nextImage();
            }
            finally {
                if (junImageStream != null) {
                    junImageStream.close();
                }
            }
            final JunImagesToMovie junImagesToMovie = new JunImagesToMovie(file2, new Dimension(stImage.width(), stImage.height()));
            junImagesToMovie.addImage_framesPerSecond_(stImage, n);
            junImagesToMovie.do_(new StBlockClosure(){

                public Object value() {
                    for (int i = 1; i < fileArray.length; ++i) {
                        JunImageStream junImageStream = null;
                        try {
                            junImageStream = JunJpegImageStream.On_(new FileInputStream(fileArray[i]));
                            junImagesToMovie.addImage_framesPerSecond_(junImageStream.nextImage(), n);
                            continue;
                        }
                        catch (IOException iOException) {
                            throw new RuntimeException(iOException);
                        }
                        finally {
                            if (junImageStream != null) {
                                try {
                                    junImageStream.close();
                                }
                                catch (IOException iOException) {
                                    throw new RuntimeException(iOException);
                                }
                            }
                        }
                    }
                    return null;
                }
            });
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof IOException) {
                throw (IOException)runtimeException.getCause();
            }
            throw runtimeException;
        }
        finally {
            junCursors._restore();
        }
    }
}

