/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.milliseconds;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.StringTokenizer;
import jp.co.sra.jun.goodies.milliseconds.JunMillisecondViewAwt;
import jp.co.sra.jun.goodies.milliseconds.JunMillisecondViewSwing;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

public class JunMillisecondModel
extends JunApplicationModel {
    protected long originalValue;
    protected long millisecondValue;
    protected int msecs;
    protected int seconds;
    protected int minutes;
    protected int hours;
    protected StBlockClosure validateBlock;
    protected StPopupMenu _popupMenu;

    public JunMillisecondModel() {
        this.initialize();
    }

    public JunMillisecondModel(int n, int n2, int n3, int n4) {
        long l = 3600000 * Math.max(0, n);
        long l2 = 60000 * Math.max(0, Math.min(n2, 59));
        long l3 = 1000 * Math.max(0, Math.min(n3, 59));
        long l4 = Math.max(0, Math.min(n4, 999));
        this.milliseconds_(l + l2 + l3 + l4);
    }

    public JunMillisecondModel(long l) {
        this.initialize_(l);
    }

    public static String ConvertMillisecondsToString_(long l) {
        long l2 = l % 1000L;
        long l3 = l / 1000L;
        int n = (int)(l3 % 60L);
        int n2 = (int)(l3 / 60L % 60L);
        int n3 = (int)(l3 / 3600L);
        StringBuffer stringBuffer = new StringBuffer();
        if (n3 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n3);
        stringBuffer.append(':');
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
        stringBuffer.append(':');
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
        stringBuffer.append('.');
        if (l2 < 100L) {
            stringBuffer.append('0');
        }
        if (l2 < 10L) {
            stringBuffer.append('0');
        }
        stringBuffer.append(l2);
        return stringBuffer.toString();
    }

    public static long ConvertStringToMilliseconds_(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n\f:.");
        long l = Integer.valueOf(stringTokenizer.nextToken()) * 3600 * 1000;
        long l2 = Integer.valueOf(stringTokenizer.nextToken()) * 60 * 1000;
        long l3 = Integer.valueOf(stringTokenizer.nextToken()) * 1000;
        int n = 0;
        if (stringTokenizer.hasMoreElements()) {
            n = Integer.valueOf(stringTokenizer.nextToken());
        }
        return l + l2 + l3 + (long)n;
    }

    public void copyValue() {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.printString()), null);
    }

    public StView defaultView() {
        if (JunMillisecondModel.GetDefaultViewMode() == 0) {
            return new JunMillisecondViewAwt(this);
        }
        return new JunMillisecondViewSwing(this);
    }

    public void hourDown() {
        this.milliseconds_(this.milliseconds() - 3600000L);
    }

    public int hours() {
        return this.hours;
    }

    public void hours_(int n) {
        if (n < 0) {
            return;
        }
        long l = new JunMillisecondModel(n, this.minutes(), this.seconds(), this.msecs()).milliseconds();
        this.milliseconds_(l);
    }

    public void hourUp() {
        this.milliseconds_(this.milliseconds() + 3600000L);
    }

    public long milliseconds() {
        return this.millisecondValue;
    }

    public void milliseconds_(long l) {
        long l2;
        long l3 = this.milliseconds();
        Long l4 = (Long)this.validateBlock().value_value_((Object)new Long(l3), (Object)new Long(l));
        if (l4 == null) {
            return;
        }
        this.millisecondValue = l2 = l4.longValue();
        this.msecs = (int)(this.millisecondValue % 1000L);
        l2 = this.millisecondValue / 1000L;
        this.seconds = (int)(l2 % 60L);
        this.minutes = (int)(l2 / 60L % 60L);
        this.hours = (int)(l2 / 3600L);
        if (l3 != this.millisecondValue) {
            this.changed_(JunMillisecondModel.$((String)"value"));
        }
    }

    public void minuteDown() {
        this.milliseconds_(this.milliseconds() - 60000L);
    }

    public int minutes() {
        return this.minutes;
    }

    public void minutes_(int n) {
        if (n < 0 || 60 < n) {
            return;
        }
        long l = new JunMillisecondModel(this.hours(), n, this.seconds(), this.msecs()).milliseconds();
        this.milliseconds_(l);
    }

    public void minuteUp() {
        this.milliseconds_(this.milliseconds() + 60000L);
    }

    public void msecDown() {
        this.milliseconds_(this.milliseconds() - 1L);
    }

    public int msecs() {
        return this.msecs;
    }

    public void msecs_(int n) {
        if (n < 0 || 999 < n) {
            return;
        }
        long l = new JunMillisecondModel(this.hours(), this.minutes(), this.seconds(), n).milliseconds();
        this.milliseconds_(l);
    }

    public void msecUp() {
        this.milliseconds_(this.milliseconds() + 1L);
    }

    public void nowValue() {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        int n4 = calendar.get(14);
        long l = new JunMillisecondModel(n, n2, n3, n4).milliseconds();
        this.milliseconds_(l);
    }

    public long original() {
        return this.originalValue;
    }

    public void originalValue() {
        this.milliseconds_(this.original());
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write(JunMillisecondModel.ConvertMillisecondsToString_(this.milliseconds()));
    }

    public void secondDown() {
        this.milliseconds_(this.milliseconds() - 1000L);
    }

    public int seconds() {
        return this.seconds;
    }

    public void seconds_(int n) {
        if (n < 0 || 60 < n) {
            return;
        }
        long l = new JunMillisecondModel(this.hours(), this.minutes(), n, this.msecs()).milliseconds();
        this.milliseconds_(l);
    }

    public void secondUp() {
        this.milliseconds_(this.milliseconds() + 1000L);
    }

    public StBlockClosure validateBlock() {
        if (this.validateBlock == null) {
            this.validateBlock = new StBlockClosure(){

                public Object value_value_(Object object, Object object2) {
                    return object2;
                }
            };
        }
        return this.validateBlock;
    }

    public void validateBlock_(StBlockClosure stBlockClosure) {
        this.validateBlock = stBlockClosure;
    }

    protected void initialize() {
        this.initialize_(0L);
    }

    protected void initialize_(long l) {
        super.initialize();
        this.originalValue = l;
        this.milliseconds_(l);
        this.validateBlock = null;
        this._popupMenu = null;
    }

    public StPopupMenu _popupMenu() {
        if (this._popupMenu == null) {
            this._popupMenu = new StPopupMenu();
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Copy"), (MenuListener)new MenuPerformer((StObject)this, "copyValue")));
            this._popupMenu.addSeparator();
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Now"), (MenuListener)new MenuPerformer((StObject)this, "nowValue")));
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Original msec"), (MenuListener)new MenuPerformer((StObject)this, "originalValue")));
            this._popupMenu.addSeparator();
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Hour down"), (MenuListener)new MenuPerformer((StObject)this, "hourDown")));
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Hour up"), (MenuListener)new MenuPerformer((StObject)this, "hourUp")));
            this._popupMenu.addSeparator();
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Minute down"), (MenuListener)new MenuPerformer((StObject)this, "minuteDown")));
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Minute up"), (MenuListener)new MenuPerformer((StObject)this, "minuteUp")));
            this._popupMenu.addSeparator();
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Second down"), (MenuListener)new MenuPerformer((StObject)this, "secondDown")));
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Second up"), (MenuListener)new MenuPerformer((StObject)this, "secondDown")));
            this._popupMenu.addSeparator();
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Msec down"), (MenuListener)new MenuPerformer((StObject)this, "msecDown")));
            this._popupMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Msec up"), (MenuListener)new MenuPerformer((StObject)this, "msecUp")));
        }
        return this._popupMenu;
    }

    protected String windowTitle() {
        return JunSystem.$String((String)"Milliseconds");
    }
}

