/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.lisp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.Stack;
import java.util.Vector;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispInterpreterView;
import jp.co.sra.jun.goodies.lisp.JunLispInterpreterViewAwt;
import jp.co.sra.jun.goodies.lisp.JunLispInterpreterViewSwing;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.goodies.lisp.JunLispNil;
import jp.co.sra.jun.goodies.lisp.JunLispParser;
import jp.co.sra.jun.goodies.lisp.JunLispScannerTable;
import jp.co.sra.jun.goodies.lisp.JunLispTable;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StAssociation;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StReadStream;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;

public class JunLispInterpreter
extends JunApplicationModel {
    protected JunLispTable lispTable;
    protected Stack bindStack;
    protected StBlockClosure failBlock;
    protected PrintStream textCollector;
    protected StValueHolder textValue;

    public JunLispInterpreter() {
        this.initialize();
    }

    public static Object Evaluate_(Object object) {
        JunLispInterpreter junLispInterpreter = new JunLispInterpreter();
        StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_(Object object) {
                throw SmalltalkException.Error((String)((String)object));
            }
        };
        return junLispInterpreter.evaluateTopLevel_ifFail_(object, stBlockClosure);
    }

    public static Object Evaluate_ifFail_(Object object, StBlockClosure stBlockClosure) {
        JunLispInterpreter junLispInterpreter = new JunLispInterpreter();
        return junLispInterpreter.evaluateTopLevel_ifFail_(object, stBlockClosure);
    }

    public static Object EvaluateFrom_(Object object) {
        JunLispInterpreter junLispInterpreter = new JunLispInterpreter();
        StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_(Object object) {
                throw SmalltalkException.Error((String)((String)object));
            }
        };
        return junLispInterpreter.evaluateTopLevel_ifFail_(JunLispParser.Parse_(object), stBlockClosure);
    }

    public static Object EvaluateFrom_ifFail_(Object object, StBlockClosure stBlockClosure) {
        JunLispInterpreter junLispInterpreter = new JunLispInterpreter();
        return junLispInterpreter.evaluateTopLevel_ifFail_(JunLispParser.Parse_(object), stBlockClosure);
    }

    public static void Initialize() {
        JunLispInterpreter.InitializeFont();
    }

    public static void InitializeFont() {
    }

    public static String PrintString_(Object object) {
        try {
            StringWriter stringWriter = new StringWriter();
            if (object instanceof JunLispCons) {
                ((JunLispCons)((Object)object)).printOn_level_(stringWriter, 0);
            } else {
                JunLispCons.Cell().printOn_object_(stringWriter, object);
            }
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
    }

    public void bind_value_(Object object, Object object2) {
        this.lispTable.intern_(object);
        Object object3 = this.lispTable.getprop_key_(object, JunLispInterpreter.$((String)"apval"));
        this.bindStack.push(new StAssociation(object, object3));
        this.putprop_key_value_(object, JunLispInterpreter.$((String)"apval"), object2);
    }

    public void bindMark() {
        this.bindStack.push(new StAssociation(null, null));
    }

    public StView defaultView() {
        if (JunLispInterpreter.GetDefaultViewMode() == 0) {
            return new JunLispInterpreterViewAwt(this);
        }
        return new JunLispInterpreterViewSwing(this);
    }

    public Object doIt(Object object) {
        JunLispInterpreterView junLispInterpreterView = (JunLispInterpreterView)object;
        StReadStream stReadStream = new StReadStream(junLispInterpreterView.getSelectedText());
        Object object2 = JunLispNil.NullList();
        while (!stReadStream.atEnd()) {
            object2 = this.execute_(stReadStream);
            this.skipSeparators_(stReadStream);
        }
        return object2;
    }

    public Object evaluate_(Object object) {
        if (object instanceof JunLispList) {
            return this.listEvaluate_((JunLispList)((Object)object));
        }
        if (object instanceof StSymbol) {
            StSymbol stSymbol = (StSymbol)object;
            if (stSymbol == JunLispInterpreter.$((String)"t")) {
                return stSymbol;
            }
            this.lispTable.intern_(object);
            Object object2 = this.lispTable.getprop_key_(object, JunLispInterpreter.$((String)"apval"));
            if (object2 == null) {
                return this.fatal_(this.printString_(object) + " is unbound atom");
            }
            return object2;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluateTopLevel_(Object object) {
        this.failBlock = new StBlockClosure(){

            public Object value_(Object object) {
                JunLispInterpreter.this.textCollector.println(object);
                return JunLispNil.NullList();
            }
        };
        JunCursors junCursors = new JunCursors(JunCursors.ExecuteCursor());
        try {
            junCursors._show();
            Object object2 = this.evaluate_(object);
            return object2;
        }
        finally {
            junCursors._restore();
        }
    }

    public Object evaluateTopLevel_ifFail_(Object object, StBlockClosure stBlockClosure) {
        this.failBlock = stBlockClosure;
        return this.evaluate_(object);
    }

    public Object execute_(StReadStream stReadStream) {
        this.skipSeparators_(stReadStream);
        int n = stReadStream.position() + 1;
        Object object = JunLispParser.Parse_(stReadStream);
        int n2 = stReadStream.position();
        String string = stReadStream.contents().substring(n, n2);
        this.textCollector.println("> " + string);
        Object object2 = this.evaluateTopLevel_(object);
        this.textCollector.println(this.printString_(object2));
        return object2;
    }

    public Object exprEval_arguList_(JunLispList junLispList, JunLispList junLispList2) {
        Object object;
        Object object2 = new Integer(-1);
        JunLispList junLispList3 = (JunLispCons)junLispList;
        Object object3 = ((JunLispCons)junLispList3).head();
        junLispList3 = (JunLispList)((Object)((JunLispCons)junLispList3).tail());
        junLispList3 = (JunLispList)((Object)((JunLispCons)junLispList3).tail());
        JunLispList junLispList4 = (JunLispList)((Object)((JunLispCons)junLispList3).head());
        junLispList3 = (JunLispList)((Object)((JunLispCons)junLispList3).tail());
        if (junLispList2.length() != junLispList4.length()) {
            return this.fatal_("too few or many arguments " + this.printString_((Object)junLispList2) + " vs " + this.printString_((Object)junLispList4) + " for " + object3.toString());
        }
        this.bindMark();
        Object object4 = junLispList2;
        while (object4 instanceof JunLispCons) {
            object = ((JunLispCons)((Object)object4)).head();
            Object object5 = ((JunLispCons)junLispList4).head();
            this.bind_value_(object5, this.evaluate_(object));
            junLispList4 = (JunLispList)((Object)((JunLispCons)junLispList4).tail());
            object4 = ((JunLispCons)((Object)object4)).tail();
        }
        object4 = junLispList3;
        while (object4 instanceof JunLispCons) {
            object = ((JunLispCons)((Object)object4)).head();
            object2 = this.evaluate_(object);
            object4 = ((JunLispCons)((Object)object4)).tail();
        }
        this.unbind();
        return object2;
    }

    public Object fatal_(String string) {
        while (this.bindStack.empty()) {
            StAssociation stAssociation = (StAssociation)this.bindStack.pop();
            if (stAssociation.key() == null) continue;
            if (stAssociation.value() != null) {
                this.putprop_key_value_(stAssociation.key(), JunLispInterpreter.$((String)"apval"), stAssociation.value());
                continue;
            }
            this.remprop_key_(stAssociation.key(), JunLispInterpreter.$((String)"apval"));
        }
        return this.failBlock.value_((Object)("*** Error: " + string));
    }

    public Object fexprEval_arguList_(JunLispList junLispList, JunLispList junLispList2) {
        Object object = new Integer(-1);
        JunLispList junLispList3 = (JunLispCons)junLispList;
        Object object2 = ((JunLispCons)junLispList3).head();
        junLispList3 = (JunLispList)((Object)((JunLispCons)junLispList3).tail());
        junLispList3 = (JunLispList)((Object)((JunLispCons)junLispList3).tail());
        JunLispList junLispList4 = (JunLispList)((Object)((JunLispCons)junLispList3).head());
        junLispList3 = (JunLispList)((Object)((JunLispCons)junLispList3).tail());
        if (junLispList4.length() != 1) {
            return this.fatal_("too few or many arguments " + this.printString_((Object)junLispList4) + " for " + this.printString_(object2));
        }
        this.bindMark();
        Object object3 = ((JunLispCons)junLispList4).head();
        this.bind_value_(object3, (Object)junLispList2);
        Object object4 = junLispList3;
        while (object4 instanceof JunLispCons) {
            Object object5 = ((JunLispCons)((Object)object4)).head();
            object = this.evaluate_(object5);
            object4 = ((JunLispCons)((Object)object4)).tail();
        }
        this.unbind();
        return object;
    }

    public Object fsubrAdd_(JunLispList junLispList) {
        Object object = junLispList;
        Object object2 = JunLispNil.NullList();
        while (object instanceof JunLispCons) {
            Object object3 = ((JunLispCons)((Object)object)).head();
            Object object4 = this.evaluate_(object3);
            if (!(object4 instanceof Number)) {
                return this.fatal_("unexpected argument " + this.printString_(object4) + " for + ");
            }
            if (object2 instanceof JunLispNil) {
                object2 = object4;
            } else if (object2 instanceof Integer) {
                if (object4 instanceof Integer) {
                    object2 = new Integer((Integer)object2 + (Integer)object4);
                } else if (object4 instanceof Long) {
                    object2 = new Long((long)((Integer)object2).intValue() + (Long)object4);
                } else if (object4 instanceof Double) {
                    object2 = new Double((double)((Integer)object2).intValue() + (Double)object4);
                } else if (object4 instanceof Float) {
                    object2 = new Float((float)((Integer)object2).intValue() + ((Float)object4).floatValue());
                }
            } else if (object2 instanceof Long) {
                if (object4 instanceof Integer) {
                    object2 = new Long((Long)object2 + (long)((Integer)object4).intValue());
                } else if (object4 instanceof Long) {
                    object2 = new Long((Long)object2 + (Long)object4);
                } else if (object4 instanceof Double) {
                    object2 = new Double((double)((Long)object2).longValue() + (Double)object4);
                } else if (object4 instanceof Float) {
                    object2 = new Float((float)((Long)object2).longValue() + ((Float)object4).floatValue());
                }
            } else if (object2 instanceof Double) {
                if (object4 instanceof Integer) {
                    object2 = new Double((Double)object2 + (double)((Integer)object4).intValue());
                } else if (object4 instanceof Long) {
                    object2 = new Double((Double)object2 + (double)((Long)object4).longValue());
                } else if (object4 instanceof Double) {
                    object2 = new Double((Double)object2 + (Double)object4);
                } else if (object4 instanceof Float) {
                    object2 = new Double((Double)object2 + (double)((Float)object4).floatValue());
                }
            } else if (object2 instanceof Float) {
                if (object4 instanceof Integer) {
                    object2 = new Float(((Float)object2).floatValue() + (float)((Integer)object4).intValue());
                } else if (object4 instanceof Long) {
                    object2 = new Float(((Float)object2).floatValue() + (float)((Long)object4).longValue());
                } else if (object4 instanceof Double) {
                    object2 = new Double((double)((Float)object2).floatValue() + (Double)object4);
                } else if (object4 instanceof Float) {
                    object2 = new Float(((Float)object2).floatValue() + ((Float)object4).floatValue());
                }
            }
            object = ((JunLispCons)((Object)object)).tail();
        }
        return object2;
    }

    public Object fsubrCond_(JunLispList junLispList) {
        Object object = junLispList;
        while (object instanceof JunLispCons) {
            JunLispList junLispList2 = (JunLispList)((Object)((JunLispCons)((Object)object)).head());
            Object object2 = junLispList2 instanceof JunLispNil ? JunLispNil.NullList() : ((JunLispCons)junLispList2).head();
            if (!(this.evaluate_(object2) instanceof JunLispNil)) {
                Object object3 = JunLispNil.NullList();
                if (junLispList2 instanceof JunLispCons && ((JunLispCons)junLispList2).tail() instanceof JunLispCons) {
                    Object object4 = ((JunLispCons)junLispList2).tail();
                    while (object4 instanceof JunLispCons) {
                        Object object5 = ((JunLispCons)((Object)object4)).head();
                        object3 = this.evaluate_(object5);
                        object4 = ((JunLispCons)((Object)object4)).tail();
                    }
                }
                return object3;
            }
            object = ((JunLispCons)((Object)object)).tail();
        }
        return JunLispNil.NullList();
    }

    public Object fsubrDefun_(JunLispList junLispList) {
        Object object = ((JunLispCons)junLispList).head();
        if (!(object instanceof StSymbol)) {
            return this.fatal_("unexpected function name " + this.printString_(object) + " for defun");
        }
        Object object2 = ((JunLispCons)((Object)((JunLispCons)junLispList).tail())).head();
        if (object2 instanceof StSymbol) {
            if (object2 == JunLispInterpreter.$((String)"lambda")) {
                this.putprop_key_value_(object, JunLispInterpreter.$((String)"expr"), (Object)junLispList);
                return object;
            }
            if (object2 == JunLispInterpreter.$((String)"nlambda")) {
                this.putprop_key_value_(object, JunLispInterpreter.$((String)"fexpr"), (Object)junLispList);
                return object;
            }
        }
        JunLispList junLispList2 = JunLispCons.Head_tail_(object, (Object)JunLispCons.Head_tail_(JunLispInterpreter.$((String)"lambda"), ((JunLispCons)junLispList).tail()));
        this.putprop_key_value_(object, JunLispInterpreter.$((String)"expr"), (Object)junLispList2);
        return object;
    }

    public Object fsubrDiv_(JunLispList junLispList) {
        Object object = junLispList;
        Object object2 = JunLispNil.NullList();
        while (object instanceof JunLispCons) {
            Object object3 = ((JunLispCons)((Object)object)).head();
            Object object4 = this.evaluate_(object3);
            if (!(object4 instanceof Number)) {
                return this.fatal_("unexpected argument " + this.printString_(object4) + " for / ");
            }
            if (object2 instanceof JunLispNil) {
                object2 = object4;
            } else if (object2 instanceof Integer) {
                if (object4 instanceof Integer) {
                    object2 = new Integer((Integer)object2 / (Integer)object4);
                } else if (object4 instanceof Long) {
                    object2 = new Long((long)((Integer)object2).intValue() / (Long)object4);
                } else if (object4 instanceof Double) {
                    object2 = new Double((double)((Integer)object2).intValue() / (Double)object4);
                } else if (object4 instanceof Float) {
                    object2 = new Float((float)((Integer)object2).intValue() / ((Float)object4).floatValue());
                }
            } else if (object2 instanceof Long) {
                if (object4 instanceof Integer) {
                    object2 = new Long((Long)object2 / (long)((Integer)object4).intValue());
                } else if (object4 instanceof Long) {
                    object2 = new Long((Long)object2 / (Long)object4);
                } else if (object4 instanceof Double) {
                    object2 = new Double((double)((Long)object2).longValue() / (Double)object4);
                } else if (object4 instanceof Float) {
                    object2 = new Float((float)((Long)object2).longValue() / ((Float)object4).floatValue());
                }
            } else if (object2 instanceof Double) {
                if (object4 instanceof Integer) {
                    object2 = new Double((Double)object2 / (double)((Integer)object4).intValue());
                } else if (object4 instanceof Long) {
                    object2 = new Double((Double)object2 / (double)((Long)object4).longValue());
                } else if (object4 instanceof Double) {
                    object2 = new Double((Double)object2 / (Double)object4);
                } else if (object4 instanceof Float) {
                    object2 = new Double((Double)object2 / (double)((Float)object4).floatValue());
                }
            } else if (object2 instanceof Float) {
                if (object4 instanceof Integer) {
                    object2 = new Float(((Float)object2).floatValue() / (float)((Integer)object4).intValue());
                } else if (object4 instanceof Long) {
                    object2 = new Float(((Float)object2).floatValue() / (float)((Long)object4).longValue());
                } else if (object4 instanceof Double) {
                    object2 = new Double((double)((Float)object2).floatValue() / (Double)object4);
                } else if (object4 instanceof Float) {
                    object2 = new Float(((Float)object2).floatValue() / ((Float)object4).floatValue());
                }
            }
            object = ((JunLispCons)((Object)object)).tail();
        }
        return object2;
    }

    public Object fsubrDo_(JunLispList junLispList) {
        Object object;
        JunLispList junLispList2 = (JunLispList)((Object)((JunLispCons)junLispList).head());
        JunLispList junLispList3 = (JunLispList)((Object)((JunLispCons)junLispList).tail());
        this.bindMark();
        Object object2 = junLispList2;
        while (object2 instanceof JunLispCons) {
            object = ((JunLispCons)((Object)object2)).head();
            this.bind_value_(object, (Object)JunLispNil.NullList());
            object2 = ((JunLispCons)((Object)object2)).tail();
        }
        object = JunLispNil.NullList();
        object2 = junLispList3;
        while (object2 instanceof JunLispCons) {
            Object object3 = ((JunLispCons)((Object)object2)).head();
            object = this.evaluate_(object3);
            object2 = ((JunLispCons)((Object)object2)).tail();
        }
        this.unbind();
        return object;
    }

    public Object fsubrEval_arguList_(JunLispList junLispList, JunLispList junLispList2) {
        StSymbol stSymbol = (StSymbol)((JunLispCons)((Object)((JunLispCons)junLispList).tail())).head();
        if (stSymbol == JunLispInterpreter.$((String)"fsubrAdd:")) {
            return this.fsubrAdd_(junLispList2);
        }
        if (stSymbol == JunLispInterpreter.$((String)"fsubrCond:")) {
            return this.fsubrCond_(junLispList2);
        }
        if (stSymbol == JunLispInterpreter.$((String)"fsubrDefun:")) {
            return this.fsubrDefun_(junLispList2);
        }
        if (stSymbol == JunLispInterpreter.$((String)"fsubrDiv:")) {
            return this.fsubrDiv_(junLispList2);
        }
        if (stSymbol == JunLispInterpreter.$((String)"fsubrDo:")) {
            return this.fsubrDo_(junLispList2);
        }
        if (stSymbol == JunLispInterpreter.$((String)"fsubrldiv:")) {
            return this.fsubrldiv_(junLispList2);
        }
        if (stSymbol == JunLispInterpreter.$((String)"fsubrIf:")) {
            return this.fsubrIf_(junLispList2);
        }
        if (stSymbol == JunLispInterpreter.$((String)"fsubrMlt:")) {
            return this.fsubrMlt_(junLispList2);
        }
        if (stSymbol == JunLispInterpreter.$((String)"fsubrMod:")) {
            return this.fsubrMod_(junLispList2);
        }
        if (stSymbol == JunLispInterpreter.$((String)"fsubrProgn:")) {
            return this.fsubrProgn_(junLispList2);
        }
        if (stSymbol == JunLispInterpreter.$((String)"fsubrQuote:")) {
            return this.fsubrQuote_(junLispList2);
        }
        if (stSymbol == JunLispInterpreter.$((String)"fsubrRead:")) {
            return this.fsubrRead_(junLispList2);
        }
        if (stSymbol == JunLispInterpreter.$((String)"fsubrRepeat:")) {
            return this.fsubrRepeat_(junLispList2);
        }
        if (stSymbol == JunLispInterpreter.$((String)"fsubrSend:")) {
            return this.fsubrSend_(junLispList2);
        }
        if (stSymbol == JunLispInterpreter.$((String)"fsubrSetq:")) {
            return this.fsubrSetq_(junLispList2);
        }
        if (stSymbol == JunLispInterpreter.$((String)"fsubrSub:")) {
            return this.fsubrSub_(junLispList2);
        }
        if (stSymbol == JunLispInterpreter.$((String)"fsubrWhile:")) {
            return this.fsubrWhile_(junLispList2);
        }
        return this.fatal_("Unknown method " + stSymbol.toString());
    }

    public Object fsubrIf_(JunLispList junLispList) {
        Object object;
        Object object2 = ((JunLispCons)junLispList).head();
        Object object3 = ((JunLispCons)((Object)((JunLispCons)junLispList).tail())).head();
        JunLispList junLispList2 = (JunLispList)((Object)((JunLispCons)((Object)((JunLispCons)junLispList).tail())).tail());
        JunLispList junLispList3 = JunLispNil.NullList();
        JunLispList junLispList4 = JunLispNil.NullList();
        boolean bl = true;
        Object object4 = junLispList2;
        while (object4 instanceof JunLispCons) {
            object = ((JunLispCons)((Object)object4)).head();
            if (object instanceof StSymbol && object == JunLispInterpreter.$((String)"else")) {
                bl = false;
                object4 = ((JunLispCons)((Object)object4)).tail();
                continue;
            }
            if (bl) {
                junLispList3 = JunLispCons.Head_tail_(object, (Object)junLispList3);
            } else {
                junLispList4 = JunLispCons.Head_tail_(object, (Object)junLispList4);
            }
            object4 = ((JunLispCons)((Object)object4)).tail();
        }
        if (!(object3 instanceof StSymbol)) {
            return this.fatal_("unexpected   format for if ");
        }
        if (object3 != JunLispInterpreter.$((String)"then")) {
            return this.fatal_("unexpected   format for if ");
        }
        junLispList3 = ((JunLispCons)junLispList3).reverse();
        junLispList4 = ((JunLispCons)junLispList4).reverse();
        object = JunLispNil.NullList();
        if (this.evaluate_(object2) instanceof JunLispNil) {
            object4 = junLispList4;
            while (object4 instanceof JunLispCons) {
                Object object5 = ((JunLispCons)((Object)object4)).head();
                object = this.evaluate_(object5);
                object4 = ((JunLispCons)((Object)object4)).tail();
            }
        } else {
            object4 = junLispList3;
            while (object4 instanceof JunLispCons) {
                Object object6 = ((JunLispCons)((Object)object4)).head();
                object = this.evaluate_(object6);
                object4 = ((JunLispCons)((Object)object4)).tail();
            }
        }
        return object;
    }

    public Object fsubrldiv_(JunLispList junLispList) {
        double d = -1.0;
        Object object = junLispList;
        Object object2 = JunLispNil.NullList();
        while (object instanceof JunLispCons) {
            Object object3 = ((JunLispCons)((Object)object)).head();
            Object object4 = this.evaluate_(object3);
            if (!(object4 instanceof Number)) {
                return this.fatal_("unexpected argument " + this.printString_(object4) + " for // ");
            }
            if (object2 instanceof JunLispNil) {
                object2 = object4;
            } else {
                if (object2 instanceof Integer) {
                    if (object4 instanceof Integer) {
                        d = (double)((Integer)object2).intValue() / (double)((Integer)object4).intValue();
                    } else if (object4 instanceof Long) {
                        d = (double)((Integer)object2).intValue() / (double)((Long)object4).longValue();
                    } else if (object4 instanceof Double) {
                        d = (double)((Integer)object2).intValue() / (Double)object4;
                    } else if (object4 instanceof Float) {
                        d = (double)((Integer)object2).intValue() / (double)((Float)object4).floatValue();
                    }
                } else if (object2 instanceof Long) {
                    if (object4 instanceof Integer) {
                        d = (double)((Long)object2).longValue() / (double)((Integer)object4).intValue();
                    } else if (object4 instanceof Long) {
                        d = (double)((Long)object2).longValue() / (double)((Long)object4).longValue();
                    } else if (object4 instanceof Double) {
                        d = (double)((Long)object2).longValue() / (Double)object4;
                    } else if (object4 instanceof Float) {
                        d = (double)((Long)object2).longValue() / (double)((Float)object4).floatValue();
                    }
                } else if (object2 instanceof Double) {
                    if (object4 instanceof Integer) {
                        d = (Double)object2 / (double)((Integer)object4).intValue();
                    } else if (object4 instanceof Long) {
                        d = (Double)object2 / (double)((Long)object4).longValue();
                    } else if (object4 instanceof Double) {
                        d = (Double)object2 / (Double)object4;
                    } else if (object4 instanceof Float) {
                        d = (Double)object2 / (double)((Float)object4).floatValue();
                    }
                } else if (object2 instanceof Float) {
                    if (object4 instanceof Integer) {
                        d = (double)((Float)object2).floatValue() / (double)((Integer)object4).intValue();
                    } else if (object4 instanceof Long) {
                        d = (double)((Float)object2).floatValue() / (double)((Long)object4).longValue();
                    } else if (object4 instanceof Double) {
                        d = (double)((Float)object2).floatValue() / (Double)object4;
                    } else if (object4 instanceof Float) {
                        d = (double)((Float)object2).floatValue() / (double)((Float)object4).floatValue();
                    }
                }
                object2 = d >= 0.0 ? new Integer((int)d) : (d < (double)((int)d) ? new Integer((int)d - 1) : new Integer((int)d));
            }
            object = ((JunLispCons)((Object)object)).tail();
        }
        return object2;
    }

    public Object fsubrMlt_(JunLispList junLispList) {
        Object object = JunLispNil.NullList();
        Object object2 = junLispList;
        while (object2 instanceof JunLispCons) {
            Object object3 = ((JunLispCons)((Object)object2)).head();
            Object object4 = this.evaluate_(object3);
            if (!(object4 instanceof Number)) {
                return this.fatal_("unexpected argument " + this.printString_(object4) + " for * ");
            }
            if (object instanceof JunLispNil) {
                object = object4;
            } else if (object instanceof Integer) {
                if (object4 instanceof Integer) {
                    object = new Integer((Integer)object * (Integer)object4);
                } else if (object4 instanceof Long) {
                    object = new Long((long)((Integer)object).intValue() * (Long)object4);
                } else if (object4 instanceof Double) {
                    object = new Double((double)((Integer)object).intValue() * (Double)object4);
                } else if (object4 instanceof Float) {
                    object = new Float((float)((Integer)object).intValue() * ((Float)object4).floatValue());
                }
            } else if (object instanceof Long) {
                if (object4 instanceof Integer) {
                    object = new Long((Long)object * (long)((Integer)object4).intValue());
                } else if (object4 instanceof Long) {
                    object = new Long((Long)object * (Long)object4);
                } else if (object4 instanceof Double) {
                    object = new Double((double)((Long)object).longValue() * (Double)object4);
                } else if (object4 instanceof Float) {
                    object = new Float((float)((Long)object).longValue() * ((Float)object4).floatValue());
                }
            } else if (object instanceof Double) {
                if (object4 instanceof Integer) {
                    object = new Double((Double)object * (double)((Integer)object4).intValue());
                } else if (object4 instanceof Long) {
                    object = new Double((Double)object * (double)((Long)object4).longValue());
                } else if (object4 instanceof Double) {
                    object = new Double((Double)object * (Double)object4);
                } else if (object4 instanceof Float) {
                    object = new Double((Double)object * (double)((Float)object4).floatValue());
                }
            } else if (object instanceof Float) {
                if (object4 instanceof Integer) {
                    object = new Float(((Float)object).floatValue() * (float)((Integer)object4).intValue());
                } else if (object4 instanceof Long) {
                    object = new Float(((Float)object).floatValue() * (float)((Long)object4).longValue());
                } else if (object4 instanceof Double) {
                    object = new Double((double)((Float)object).floatValue() * (Double)object4);
                } else if (object4 instanceof Float) {
                    object = new Float(((Float)object).floatValue() * ((Float)object4).floatValue());
                }
            }
            object2 = ((JunLispCons)((Object)object2)).tail();
        }
        return object;
    }

    public Object fsubrMod_(JunLispList junLispList) {
        Object object = JunLispNil.NullList();
        Object object2 = junLispList;
        while (object2 instanceof JunLispCons) {
            Object object3 = ((JunLispCons)((Object)object2)).head();
            Object object4 = this.evaluate_(object3);
            if (!(object4 instanceof Number)) {
                return this.fatal_("unexpected argument " + this.printString_(object4) + " for \\");
            }
            if (object instanceof JunLispNil) {
                object = object4;
            } else if (object instanceof Integer) {
                if (object4 instanceof Integer) {
                    object = new Integer((Integer)object % (Integer)object4);
                } else if (object4 instanceof Long) {
                    object = new Long((long)((Integer)object).intValue() % (Long)object4);
                } else if (object4 instanceof Double) {
                    object = new Double((double)((Integer)object).intValue() % (Double)object4);
                } else if (object4 instanceof Float) {
                    object = new Float((float)((Integer)object).intValue() % ((Float)object4).floatValue());
                }
            } else if (object instanceof Long) {
                if (object4 instanceof Integer) {
                    object = new Long((Long)object % (long)((Integer)object4).intValue());
                } else if (object4 instanceof Long) {
                    object = new Long((Long)object % (Long)object4);
                } else if (object4 instanceof Double) {
                    object = new Double((double)((Long)object).longValue() % (Double)object4);
                } else if (object4 instanceof Float) {
                    object = new Float((float)((Long)object).longValue() % ((Float)object4).floatValue());
                }
            } else if (object instanceof Double) {
                if (object4 instanceof Integer) {
                    object = new Double((Double)object % (double)((Integer)object4).intValue());
                } else if (object4 instanceof Long) {
                    object = new Double((Double)object % (double)((Long)object4).longValue());
                } else if (object4 instanceof Double) {
                    object = new Double((Double)object % (Double)object4);
                } else if (object4 instanceof Float) {
                    object = new Double((Double)object % (double)((Float)object4).floatValue());
                }
            } else if (object instanceof Float) {
                if (object4 instanceof Integer) {
                    object = new Float(((Float)object).floatValue() % (float)((Integer)object4).intValue());
                } else if (object4 instanceof Long) {
                    object = new Float(((Float)object).floatValue() % (float)((Long)object4).longValue());
                } else if (object4 instanceof Double) {
                    object = new Double((double)((Float)object).floatValue() % (Double)object4);
                } else if (object4 instanceof Float) {
                    object = new Float(((Float)object).floatValue() % ((Float)object4).floatValue());
                }
            }
            object2 = ((JunLispCons)((Object)object2)).tail();
        }
        return object;
    }

    public Object fsubrProgn_(JunLispList junLispList) {
        Object object = JunLispNil.NullList();
        Object object2 = junLispList;
        while (object2 instanceof JunLispCons) {
            Object object3 = ((JunLispCons)((Object)object2)).head();
            object = this.evaluate_(object3);
            object2 = ((JunLispCons)((Object)object2)).tail();
        }
        return object;
    }

    public Object fsubrQuote_(JunLispList junLispList) {
        if (junLispList instanceof JunLispCons) {
            return ((JunLispCons)junLispList).head();
        }
        return ((JunLispNil)junLispList).head();
    }

    public Object fsubrRead_(JunLispList junLispList) {
        Object object;
        String string = "          " + JunSystem.$String((String)"Input an S expression.") + "          ";
        String string2 = "";
        if (junLispList instanceof JunLispCons) {
            Object object2;
            object = (JunLispCons)junLispList;
            if (object.length() >= 1) {
                object2 = this.evaluate_(object.nth_(1));
                string = object2 instanceof String ? (String)object2 : this.printString_(object2);
            }
            if (object.length() >= 2) {
                object2 = this.evaluate_(object.nth_(2));
                string2 = object2 instanceof String ? (String)object2 : this.printString_(string2);
            }
        }
        if (((String)(object = JunDialog.Request_(string, string2))).length() == 0) {
            return JunLispNil.NullList();
        }
        return JunLispParser.Parse_(new StReadStream((String)object));
    }

    public Object fsubrRepeat_(JunLispList junLispList) {
        Object object;
        JunLispList junLispList2 = ((JunLispCons)junLispList).reverse();
        Object object2 = ((JunLispCons)junLispList2).head();
        Object object3 = ((JunLispCons)((Object)((JunLispCons)junLispList2).tail())).head();
        JunLispList junLispList3 = ((JunLispCons)((Object)((JunLispCons)((Object)((JunLispCons)junLispList2).tail())).tail())).reverse();
        if (!(object3 instanceof StSymbol)) {
            return this.fatal_("unexpected format for repeat");
        }
        if (object3 != JunLispInterpreter.$((String)"until")) {
            return this.fatal_("unexpected format for repeat");
        }
        Object object4 = JunLispNil.NullList();
        Object object5 = junLispList3;
        while (object5 instanceof JunLispCons) {
            object = ((JunLispCons)((Object)object5)).head();
            object4 = this.evaluate_(object);
            object5 = ((JunLispCons)((Object)object5)).tail();
        }
        while (!(this.evaluate_(object2) instanceof JunLispNil)) {
            object5 = junLispList3;
            while (object5 instanceof JunLispCons) {
                object = ((JunLispCons)((Object)object5)).head();
                object4 = this.evaluate_(object);
                object5 = ((JunLispCons)((Object)object5)).tail();
            }
        }
        return object4;
    }

    public Object fsubrSend_(JunLispList junLispList) {
        JunLispList junLispList2 = junLispList;
        Object object = this.evaluate_(junLispList2.head());
        if (!(object instanceof StObject)) {
            return this.fatal_("unexpected receiver " + object.getClass() + " for send");
        }
        Object object2 = this.evaluate_((junLispList2 = (JunLispList)((Object)junLispList2.tail())).head());
        if (!(object2 instanceof StSymbol)) {
            return this.fatal_("unexpected selector " + object2 + " for send");
        }
        junLispList2 = (JunLispList)((Object)junLispList2.tail());
        Vector<Object> vector = new Vector<Object>();
        while (junLispList2 instanceof JunLispCons) {
            vector.addElement(this.evaluate_(junLispList2.head()));
            junLispList2 = (JunLispList)((Object)junLispList2.tail());
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        try {
            return ((StObject)object).perform_withArguments_(object2.toString(), objectArray);
        }
        catch (Exception exception) {
            throw new SmalltalkException(exception);
        }
    }

    public Object fsubrSetq_(JunLispList junLispList) {
        Object object = junLispList;
        Object object2 = JunLispNil.NullList();
        while (object instanceof JunLispCons) {
            Object object3 = ((JunLispCons)((Object)object)).head();
            if (!(object3 instanceof StSymbol)) {
                return this.fatal_("unexpected variable " + this.printString_(object3) + " for setq");
            }
            object = ((JunLispCons)((Object)object)).tail();
            object2 = this.evaluate_(((JunLispCons)((Object)object)).head());
            this.putprop_key_value_(object3, JunLispInterpreter.$((String)"apval"), object2);
            object = ((JunLispCons)((Object)object)).tail();
        }
        return object2;
    }

    public Object fsubrSub_(JunLispList junLispList) {
        Object object = JunLispNil.NullList();
        Object object2 = junLispList;
        while (object2 instanceof JunLispCons) {
            Object object3 = ((JunLispCons)((Object)object2)).head();
            Object object4 = this.evaluate_(object3);
            if (!(object4 instanceof Number)) {
                return this.fatal_("unexpected argument " + this.printString_(object4) + " for - ");
            }
            if (object instanceof JunLispNil) {
                object = object4;
            } else if (object instanceof Integer) {
                if (object4 instanceof Integer) {
                    object = new Integer((Integer)object - (Integer)object4);
                } else if (object4 instanceof Long) {
                    object = new Long((long)((Integer)object).intValue() - (Long)object4);
                } else if (object4 instanceof Double) {
                    object = new Double((double)((Integer)object).intValue() - (Double)object4);
                } else if (object4 instanceof Float) {
                    object = new Float((float)((Integer)object).intValue() - ((Float)object4).floatValue());
                }
            } else if (object instanceof Long) {
                if (object4 instanceof Integer) {
                    object = new Long((Long)object - (long)((Integer)object4).intValue());
                } else if (object4 instanceof Long) {
                    object = new Long((Long)object - (Long)object4);
                } else if (object4 instanceof Double) {
                    object = new Double((double)((Long)object).longValue() - (Double)object4);
                } else if (object4 instanceof Float) {
                    object = new Float((float)((Long)object).longValue() - ((Float)object4).floatValue());
                }
            } else if (object instanceof Double) {
                if (object4 instanceof Integer) {
                    object = new Double((Double)object - (double)((Integer)object4).intValue());
                } else if (object4 instanceof Long) {
                    object = new Double((Double)object - (double)((Long)object4).longValue());
                } else if (object4 instanceof Double) {
                    object = new Double((Double)object - (Double)object4);
                } else if (object4 instanceof Float) {
                    object = new Double((Double)object - (double)((Float)object4).floatValue());
                }
            } else if (object instanceof Float) {
                if (object4 instanceof Integer) {
                    object = new Float(((Float)object).floatValue() - (float)((Integer)object4).intValue());
                } else if (object4 instanceof Long) {
                    object = new Float(((Float)object).floatValue() - (float)((Long)object4).longValue());
                } else if (object4 instanceof Double) {
                    object = new Double((double)((Float)object).floatValue() - (Double)object4);
                } else if (object4 instanceof Float) {
                    object = new Float(((Float)object).floatValue() - ((Float)object4).floatValue());
                }
            }
            object2 = ((JunLispCons)((Object)object2)).tail();
        }
        return object;
    }

    public Object fsubrWhile_(JunLispList junLispList) {
        Object object = ((JunLispCons)junLispList).head();
        Object object2 = ((JunLispCons)((Object)((JunLispCons)junLispList).tail())).head();
        JunLispList junLispList2 = (JunLispList)((Object)((JunLispCons)((Object)((JunLispCons)junLispList).tail())).tail());
        if (!(object2 instanceof StSymbol)) {
            return this.fatal_("unexpected format for while");
        }
        if (object2 != JunLispInterpreter.$((String)"do")) {
            return this.fatal_("unexpected format for while");
        }
        Object object3 = JunLispNil.NullList();
        while (!(this.evaluate_(object) instanceof JunLispNil)) {
            Object object4 = junLispList2;
            while (object4 instanceof JunLispCons) {
                Object object5 = ((JunLispCons)((Object)object4)).head();
                object3 = this.evaluate_(object5);
                object4 = ((JunLispCons)((Object)object4)).tail();
            }
        }
        return object3;
    }

    public Object getprop_key_(Object object, Object object2) {
        this.lispTable.intern_(object);
        Object object3 = this.lispTable.getprop_key_(object, object2);
        if (object3 == null) {
            return JunLispNil.NullList();
        }
        return object3;
    }

    public void initialize() {
        this.lispTable = new JunLispTable();
        this.bindStack = new Stack();
        this.failBlock = new StBlockClosure(){

            public Object value_(Object object) {
                throw SmalltalkException.Error((String)((String)object));
            }
        };
        this.initializeSubrFunctions();
        this.initializeFsubrFunctions();
        this.initializeExprFunctions();
        this.initializeFexprFunctions();
        this.textCollector = new PrintStream(new ByteArrayOutputStream());
    }

    public void initializeExprFunctions() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\n");
        stringBuffer.append("% Expr Functions \n");
        stringBuffer.append("(progn \n\n");
        stringBuffer.append("\t% ++ \n");
        stringBuffer.append("\t(defun ++ lambda (x) \n");
        stringBuffer.append("\t\t(+ x 1)) \n\n");
        stringBuffer.append("\t% -- \n");
        stringBuffer.append("\t(defun -- lambda (x) \n");
        stringBuffer.append("\t\t(- x 1)) \n\n");
        stringBuffer.append("\t% assoc \n");
        stringBuffer.append("\t(defun assoc lambda (x a) \n");
        stringBuffer.append("\t\t(cond  \n");
        stringBuffer.append("\t\t\t((null a) nil) \n");
        stringBuffer.append("\t\t\t((equal x (car (car a))) (car a)) \n");
        stringBuffer.append("\t\t\t(t (assoc x (cdr a))))) \n\n");
        stringBuffer.append("\t% copy \n");
        stringBuffer.append("\t(defun copy lambda (x) \n");
        stringBuffer.append("\t\t(cond \n");
        stringBuffer.append("\t\t\t((null x) nil) \n");
        stringBuffer.append("\t\t\t(t (cons (car x) (copy (cdr x)))))) \n\n");
        stringBuffer.append("\t% mapc \n");
        stringBuffer.append("\t(defun mapc lambda (f x) \n");
        stringBuffer.append("\t\t(cond \n");
        stringBuffer.append("\t\t\t((null x) nil) \n");
        stringBuffer.append("\t\t\t(t (progn \n");
        stringBuffer.append("\t\t\t\t(eval (cons f (cons `(car x) nil))) \n");
        stringBuffer.append("\t\t\t\t(mapc f (cdr x)))))) \n\n");
        stringBuffer.append("\t% mapcar \n");
        stringBuffer.append("\t(defun mapcar lambda (f x) \n");
        stringBuffer.append("\t\t(cond \n");
        stringBuffer.append("\t\t\t((null x) nil) \n");
        stringBuffer.append("\t\t\t(t (cons \n");
        stringBuffer.append("\t\t\t\t(eval (cons f (cons `(car x) nil))) \n");
        stringBuffer.append("\t\t\t\t(mapcar f (cdr x)))))) \n\n");
        stringBuffer.append("\t) % end ");
        this.evaluateTopLevel_(JunLispParser.Parse_(stringBuffer.toString()));
    }

    public void initializeFexprFunctions() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\n");
        stringBuffer.append("% Expr Functions \n");
        stringBuffer.append("(progn  \n\n");
        stringBuffer.append("\t% and \n");
        stringBuffer.append("\t(defun and nlambda (x) \n");
        stringBuffer.append("\t\t(do\t(list) \n");
        stringBuffer.append("\t\t\t(setq list x) \n");
        stringBuffer.append("\t\t\t(while \n");
        stringBuffer.append("\t\t\t\t(if (null list) then nil else (eval (car list))) \n");
        stringBuffer.append("\t\t\t\tdo \n");
        stringBuffer.append("\t\t\t\t(setq list (cdr list))) \n");
        stringBuffer.append("\t\t\t(if (null list) then t else nil))) \n\n");
        stringBuffer.append("\t% list \n");
        stringBuffer.append("\t(defun list nlambda (x) \n");
        stringBuffer.append("\t\t(mapcar `eval x)) \n\n");
        stringBuffer.append("\t% or \n");
        stringBuffer.append("\t(defun or nlambda (x) \n");
        stringBuffer.append("\t\t(do\t(list) \n");
        stringBuffer.append("\t\t\t(setq list x) \n");
        stringBuffer.append("\t\t\t(while \n");
        stringBuffer.append("\t\t\t\t(if (null list) then nil else (not (eval (car list)))) \n");
        stringBuffer.append("\t\t\t\tdo \n");
        stringBuffer.append("\t\t\t\t(setq list (cdr list))) \n");
        stringBuffer.append("\t\t\t(if (null list) then nil else t))) \n\n");
        stringBuffer.append("\t) % end");
        this.evaluateTopLevel_(JunLispParser.Parse_(stringBuffer.toString()));
    }

    public void initializeFsubrFunctions() {
        this.setFsubrFunc_(new Object[]{JunLispInterpreter.$((String)"*"), JunLispInterpreter.$((String)"fsubrMlt:")});
        this.setFsubrFunc_(new Object[]{JunLispInterpreter.$((String)"+"), JunLispInterpreter.$((String)"fsubrAdd:")});
        this.setFsubrFunc_(new Object[]{JunLispInterpreter.$((String)"-"), JunLispInterpreter.$((String)"fsubrSub:")});
        this.setFsubrFunc_(new Object[]{JunLispInterpreter.$((String)"/"), JunLispInterpreter.$((String)"fsubrDiv:")});
        this.setFsubrFunc_(new Object[]{JunLispInterpreter.$((String)"//"), JunLispInterpreter.$((String)"fsubrldiv:")});
        this.setFsubrFunc_(new Object[]{JunLispInterpreter.$((String)"cond"), JunLispInterpreter.$((String)"fsubrCond:")});
        this.setFsubrFunc_(new Object[]{JunLispInterpreter.$((String)"defun"), JunLispInterpreter.$((String)"fsubrDefun:")});
        this.setFsubrFunc_(new Object[]{JunLispInterpreter.$((String)"do"), JunLispInterpreter.$((String)"fsubrDo:")});
        this.setFsubrFunc_(new Object[]{JunLispInterpreter.$((String)"if"), JunLispInterpreter.$((String)"fsubrIf:")});
        this.setFsubrFunc_(new Object[]{JunLispInterpreter.$((String)"progn"), JunLispInterpreter.$((String)"fsubrProgn:")});
        this.setFsubrFunc_(new Object[]{JunLispInterpreter.$((String)"quote"), JunLispInterpreter.$((String)"fsubrQuote:")});
        this.setFsubrFunc_(new Object[]{JunLispInterpreter.$((String)"read"), JunLispInterpreter.$((String)"fsubrRead:")});
        this.setFsubrFunc_(new Object[]{JunLispInterpreter.$((String)"repeat"), JunLispInterpreter.$((String)"fsubrRepeat:")});
        this.setFsubrFunc_(new Object[]{JunLispInterpreter.$((String)"send"), JunLispInterpreter.$((String)"fsubrSend:")});
        this.setFsubrFunc_(new Object[]{JunLispInterpreter.$((String)"setq"), JunLispInterpreter.$((String)"fsubrSetq:")});
        this.setFsubrFunc_(new Object[]{JunLispInterpreter.$((String)"while"), JunLispInterpreter.$((String)"fsubrWhile:")});
        this.setFsubrFunc_(new Object[]{JunLispInterpreter.$((String)"\\\\"), JunLispInterpreter.$((String)"fsubrMod:")});
    }

    public void initializeSubrFunctions() {
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"<"), JunLispInterpreter.$((String)"subrLt:"), new Integer(2)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"<="), JunLispInterpreter.$((String)"subrLe:"), new Integer(2)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"="), JunLispInterpreter.$((String)"subrEqual:"), new Integer(2)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"=="), JunLispInterpreter.$((String)"subrEq:"), new Integer(2)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)">"), JunLispInterpreter.$((String)"subrGt:"), new Integer(2)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)">="), JunLispInterpreter.$((String)"subrGe:"), new Integer(2)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"append"), JunLispInterpreter.$((String)"subrAppend:"), new Integer(2)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"atom"), JunLispInterpreter.$((String)"subrAtom:"), new Integer(1)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"car"), JunLispInterpreter.$((String)"subrCar:"), new Integer(1)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"cdr"), JunLispInterpreter.$((String)"subrCdr:"), new Integer(1)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"cons"), JunLispInterpreter.$((String)"subrCons:"), new Integer(2)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"consp"), JunLispInterpreter.$((String)"subrConsp:"), new Integer(1)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"dtpr"), JunLispInterpreter.$((String)"subrConsp:"), new Integer(1)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"doublep"), JunLispInterpreter.$((String)"subrDoublep:"), new Integer(1)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"eq"), JunLispInterpreter.$((String)"subrEq:"), new Integer(2)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"equal"), JunLispInterpreter.$((String)"subrEqual:"), new Integer(2)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"eval"), JunLispInterpreter.$((String)"subrEval:"), new Integer(1)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"exprs"), JunLispInterpreter.$((String)"subrExprs"), new Integer(0)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"fexprs"), JunLispInterpreter.$((String)"subrFexprs"), new Integer(0)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"floatp"), JunLispInterpreter.$((String)"subrFloatp:"), new Integer(1)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"fsubrs"), JunLispInterpreter.$((String)"subrFsubrs"), new Integer(0)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"gc"), JunLispInterpreter.$((String)"subrGc"), new Integer(0)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"gensym"), JunLispInterpreter.$((String)"subrGensym"), new Integer(0)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"getprop"), JunLispInterpreter.$((String)"subrGetprop:"), new Integer(2)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"integerp"), JunLispInterpreter.$((String)"subrIntegerp:"), new Integer(1)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"last"), JunLispInterpreter.$((String)"subrLast:"), new Integer(1)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"length"), JunLispInterpreter.$((String)"subrLength:"), new Integer(1)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"listp"), JunLispInterpreter.$((String)"subrListp:"), new Integer(1)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"member"), JunLispInterpreter.$((String)"subrMember:"), new Integer(2)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"memq"), JunLispInterpreter.$((String)"subrMemq:"), new Integer(2)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"nconc"), JunLispInterpreter.$((String)"subrNconc:"), new Integer(2)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"neq"), JunLispInterpreter.$((String)"subrNeq:"), new Integer(2)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"nequal"), JunLispInterpreter.$((String)"subrNequal:"), new Integer(2)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"not"), JunLispInterpreter.$((String)"subrNull:"), new Integer(1)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"nth"), JunLispInterpreter.$((String)"subrNth:"), new Integer(2)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"null"), JunLispInterpreter.$((String)"subrNull:"), new Integer(1)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"numberp"), JunLispInterpreter.$((String)"subrNumberp:"), new Integer(1)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"oblist"), JunLispInterpreter.$((String)"subrOblist"), new Integer(0)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"pp"), JunLispInterpreter.$((String)"subrPp:"), new Integer(1)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"princ"), JunLispInterpreter.$((String)"subrPrinc:"), new Integer(1)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"print"), JunLispInterpreter.$((String)"subrPrint:"), new Integer(1)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"putprop"), JunLispInterpreter.$((String)"subrPutprop:"), new Integer(3)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"remprop"), JunLispInterpreter.$((String)"subrRemprop:"), new Integer(2)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"reverse"), JunLispInterpreter.$((String)"subrReverse:"), new Integer(1)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"rplaca"), JunLispInterpreter.$((String)"subrRplaca:"), new Integer(2)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"placd"), JunLispInterpreter.$((String)"subrPlacd:"), new Integer(2)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"stringp"), JunLispInterpreter.$((String)"subrStringp:"), new Integer(1)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"subrs"), JunLispInterpreter.$((String)"subrSubrs"), new Integer(0)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"symbolp"), JunLispInterpreter.$((String)"subrSymbolp:"), new Integer(1)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"terpri"), JunLispInterpreter.$((String)"subrTerpri"), new Integer(0)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"~="), JunLispInterpreter.$((String)"subrNequal:"), new Integer(2)});
        this.setSubrFunc_(new Object[]{JunLispInterpreter.$((String)"~~"), JunLispInterpreter.$((String)"subrNeq:"), new Integer(2)});
    }

    public Object putprop_key_value_(Object object, Object object2, Object object3) {
        this.lispTable.intern_(object);
        return this.lispTable.putprop_key_value_(object, object2, object3);
    }

    public Object remprop_key_(Object object, Object object2) {
        this.lispTable.intern_(object);
        Object object3 = this.lispTable.remprop_key_(object, object2);
        if (object3 == null) {
            return JunLispNil.NullList();
        }
        return object3;
    }

    protected void setFsubrFunc_(Object[] objectArray) {
        Object object = objectArray[0];
        this.putprop_key_value_(JunLispInterpreter.$((String)object.toString()), JunLispInterpreter.$((String)"fsubr"), (Object)JunLispCons.List_(objectArray));
    }

    protected void setSubrFunc_(Object[] objectArray) {
        Object object = objectArray[0];
        this.putprop_key_value_(JunLispInterpreter.$((String)object.toString()), JunLispInterpreter.$((String)"subr"), (Object)JunLispCons.List_(objectArray));
    }

    protected void skipSeparators_(StReadStream stReadStream) {
        while (!stReadStream.atEnd()) {
            char c = stReadStream.peek();
            StSymbol stSymbol = JunLispScannerTable.ScannerTable().at_(c);
            if (stSymbol != JunLispInterpreter.$((String)"xDelimiter")) break;
            stReadStream.next();
        }
    }

    public Object subrAppend_(Object[] objectArray) {
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        if (!(object instanceof JunLispCons)) {
            return this.fatal_("unexpected argument " + this.printString_(object) + " for append");
        }
        if (!(object2 instanceof JunLispList)) {
            return this.fatal_("unexpected argument " + this.printString_(object2) + " for append");
        }
        return ((JunLispCons)((Object)object)).append_((JunLispList)((Object)object2));
    }

    public Object subrAtom_(Object[] objectArray) {
        Object object = objectArray[0];
        if (!(object instanceof JunLispCons)) {
            return JunLispInterpreter.$((String)"t");
        }
        return JunLispNil.NullList();
    }

    public Object subrCar_(Object[] objectArray) {
        Object object = objectArray[0];
        if (object instanceof JunLispCons) {
            return ((JunLispCons)((Object)object)).head();
        }
        if (object instanceof JunLispNil) {
            return JunLispNil.NullList();
        }
        return this.fatal_("unexpceted argument " + this.printString_(object) + " for car");
    }

    public Object subrCdr_(Object[] objectArray) {
        Object object = objectArray[0];
        if (object instanceof JunLispCons) {
            return ((JunLispCons)((Object)object)).tail();
        }
        if (object instanceof JunLispNil) {
            return JunLispNil.NullList();
        }
        return this.fatal_("unexpceted argument " + this.printString_(object) + " for car");
    }

    public Object subrCons_(Object[] objectArray) {
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        return JunLispCons.Head_tail_(object, object2);
    }

    public Object subrConsp_(Object[] objectArray) {
        Object object = objectArray[0];
        if (object instanceof JunLispCons) {
            return JunLispInterpreter.$((String)"t");
        }
        return JunLispNil.NullList();
    }

    public Object subrDoublep_(Object[] objectArray) {
        Object object = objectArray[0];
        if (object instanceof Double) {
            return JunLispInterpreter.$((String)"t");
        }
        return JunLispNil.NullList();
    }

    public Object subrEq_(Object[] objectArray) {
        JunLispNil junLispNil = objectArray[0] == objectArray[1] ? JunLispInterpreter.$((String)"t") : JunLispNil.NullList();
        return junLispNil;
    }

    public Object subrEqual_(Object[] objectArray) {
        JunLispNil junLispNil = objectArray[0].equals(objectArray[1]) ? JunLispInterpreter.$((String)"t") : JunLispNil.NullList();
        return junLispNil;
    }

    public Object subrEval_(Object[] objectArray) {
        Object object = objectArray[0];
        return this.evaluate_(object);
    }

    public Object subrEval_arguList_(JunLispList junLispList, JunLispList junLispList2) {
        Object object = ((JunLispCons)junLispList).head();
        StSymbol stSymbol = (StSymbol)((JunLispCons)((Object)((JunLispCons)junLispList).tail())).head();
        int n = ((Number)((JunLispCons)((Object)((JunLispCons)((Object)((JunLispCons)junLispList).tail())).tail())).head()).intValue();
        Object[] objectArray = new Object[n];
        JunLispList junLispList3 = junLispList2;
        for (int i = 0; i < n; ++i) {
            if (junLispList3.nullList()) {
                return this.fatal_("too few arguments for " + this.printString_(object));
            }
            objectArray[i] = this.evaluate_(((JunLispCons)junLispList3).head());
            junLispList3 = (JunLispList)((Object)((JunLispCons)junLispList3).tail());
        }
        if (!junLispList3.nullList()) {
            return this.fatal_("too many arguments for " + this.printString_(object));
        }
        if (n == 0) {
            try {
                return this.perform_(stSymbol.toString());
            }
            catch (Exception exception) {
                throw new SmalltalkException(exception);
            }
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrAppend:")) {
            return this.subrAppend_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrAtom:")) {
            return this.subrAtom_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrCar:")) {
            return this.subrCar_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrCdr:")) {
            return this.subrCdr_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrCons:")) {
            return this.subrCons_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrConsp:")) {
            return this.subrConsp_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrDoublep:")) {
            return this.subrDoublep_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrEq:")) {
            return this.subrEq_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrEqual:")) {
            return this.subrEqual_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrEval:")) {
            return this.subrEval_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrFloatp:")) {
            return this.subrFloatp_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrGe:")) {
            return this.subrGe_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrGetprop:")) {
            return this.subrGetprop_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrGt:")) {
            return this.subrGt_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrIntegerp:")) {
            return this.subrIntegerp_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrLast:")) {
            return this.subrLast_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrLe:")) {
            return this.subrLe_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrLength:")) {
            return this.subrLength_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrListp:")) {
            return this.subrListp_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrLt:")) {
            return this.subrLt_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrMember:")) {
            return this.subrMember_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrMemq:")) {
            return this.subrMemq_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrNconc:")) {
            return this.subrNconc_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrNeq:")) {
            return this.subrNeq_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrNequal:")) {
            return this.subrNequal_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrNth:")) {
            return this.subrNth_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrNull:")) {
            return this.subrNull_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrNumberp:")) {
            return this.subrNumberp_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrPp:")) {
            return this.subrPp_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrPrinc:")) {
            return this.subrPrinc_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrPutprop:")) {
            return this.subrPutprop_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrRemprop:")) {
            return this.subrRemprop_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrReverse:")) {
            return this.subrReverse_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrRplaca:")) {
            return this.subrRplaca_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrRplacd:")) {
            return this.subrRplacd_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrStringp:")) {
            return this.subrStringp_(objectArray);
        }
        if (stSymbol == JunLispInterpreter.$((String)"subrSymbolp:")) {
            return this.subrSymbolp_(objectArray);
        }
        return this.fatal_("Unknown method " + stSymbol.toString());
    }

    public Object subrExprs() {
        JunLispList junLispList;
        JunLispList junLispList2 = JunLispNil.NullList();
        JunLispList junLispList3 = this.subrOblist();
        Object object = junLispList = ((JunLispCons)junLispList3).reverse();
        while (object instanceof JunLispCons) {
            Object object2 = ((JunLispCons)((Object)object)).head();
            JunLispList junLispList4 = (JunLispList)((Object)this.getprop_key_(object2, JunLispInterpreter.$((String)"expr")));
            if (!junLispList4.nullList()) {
                junLispList2 = JunLispCons.Head_tail_(object2, (Object)junLispList2);
            }
            object = ((JunLispCons)((Object)object)).tail();
        }
        return junLispList2;
    }

    public Object subrFexprs() {
        JunLispList junLispList;
        JunLispList junLispList2 = JunLispNil.NullList();
        JunLispList junLispList3 = this.subrOblist();
        Object object = junLispList = ((JunLispCons)junLispList3).reverse();
        while (object instanceof JunLispCons) {
            Object object2 = ((JunLispCons)((Object)object)).head();
            JunLispList junLispList4 = (JunLispList)((Object)this.getprop_key_(object2, JunLispInterpreter.$((String)"fexpr")));
            if (!junLispList4.nullList()) {
                junLispList2 = JunLispCons.Head_tail_(object2, (Object)junLispList2);
            }
            object = ((JunLispCons)((Object)object)).tail();
        }
        return junLispList2;
    }

    public Object subrFloatp_(Object[] objectArray) {
        Object object = objectArray[0];
        if (object instanceof Float) {
            return JunLispInterpreter.$((String)"t");
        }
        return JunLispNil.NullList();
    }

    public Object subrFsubrs() {
        JunLispList junLispList;
        JunLispList junLispList2 = JunLispNil.NullList();
        JunLispList junLispList3 = this.subrOblist();
        Object object = junLispList = ((JunLispCons)junLispList3).reverse();
        while (object instanceof JunLispCons) {
            Object object2 = ((JunLispCons)((Object)object)).head();
            JunLispList junLispList4 = (JunLispList)((Object)this.getprop_key_(object2, JunLispInterpreter.$((String)"fsubr")));
            if (!junLispList4.nullList()) {
                junLispList2 = JunLispCons.Head_tail_(object2, (Object)junLispList2);
            }
            object = ((JunLispCons)((Object)object)).tail();
        }
        return junLispList2;
    }

    public Object subrGc() {
        System.gc();
        return JunLispInterpreter.$((String)"t");
    }

    public Object subrGe_(Object[] objectArray) {
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        if (object instanceof JunLispList) {
            return this.fatal_("unexpected argument " + this.printString_(object) + " for >= ");
        }
        if (object2 instanceof JunLispList) {
            return this.fatal_("unexpected argument " + this.printString_(object2) + " for >= ");
        }
        if (object instanceof Number && object2 instanceof Number && ((Number)object).longValue() >= ((Number)object2).longValue()) {
            return JunLispInterpreter.$((String)"t");
        }
        if (object instanceof String && object2 instanceof String && ((String)object).compareTo((String)object2) >= 0) {
            return JunLispInterpreter.$((String)"t");
        }
        return JunLispNil.NullList();
    }

    public Object subrGensym() {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long l = System.currentTimeMillis();
        String string = "#id" + l;
        return JunLispInterpreter.$((String)string);
    }

    public Object subrGetprop_(Object[] objectArray) {
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        if (!(object instanceof StSymbol)) {
            return this.fatal_("unexpected argument " + this.printString_(object) + " for getprop");
        }
        if (!(object2 instanceof StSymbol)) {
            return this.fatal_("unexpected argument " + this.printString_(object2) + " for getprop");
        }
        return this.getprop_key_((StSymbol)object, (StSymbol)object2);
    }

    public Object subrGt_(Object[] objectArray) {
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        if (object instanceof JunLispList) {
            return this.fatal_("unexpected argument " + this.printString_(object) + " for > ");
        }
        if (object2 instanceof JunLispList) {
            return this.fatal_("unexpected argument " + this.printString_(object2) + " for > ");
        }
        if (object instanceof Number && object2 instanceof Number && ((Number)object).longValue() > ((Number)object2).longValue()) {
            return JunLispInterpreter.$((String)"t");
        }
        if (object instanceof String && object2 instanceof String && ((String)object).compareTo((String)object2) > 0) {
            return JunLispInterpreter.$((String)"t");
        }
        return JunLispNil.NullList();
    }

    public Object subrIntegerp_(Object[] objectArray) {
        Object object = objectArray[0];
        if (object instanceof Integer) {
            return JunLispInterpreter.$((String)"t");
        }
        return JunLispNil.NullList();
    }

    public Object subrLast_(Object[] objectArray) {
        Object object = objectArray[0];
        if (object instanceof JunLispCons) {
            return ((JunLispCons)((Object)object)).last();
        }
        return this.fatal_("unexpected argument " + this.printString_(object) + " for last");
    }

    public Object subrLe_(Object[] objectArray) {
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        if (object instanceof JunLispList) {
            return this.fatal_("unexpected argument " + this.printString_(object) + " for <= ");
        }
        if (object2 instanceof JunLispList) {
            return this.fatal_("unexpected argument " + this.printString_(object2) + " for <= ");
        }
        if (object instanceof Number && object2 instanceof Number && ((Number)object).longValue() <= ((Number)object2).longValue()) {
            return JunLispInterpreter.$((String)"t");
        }
        if (object instanceof String && object2 instanceof String && ((String)object).compareTo((String)object2) <= 0) {
            return JunLispInterpreter.$((String)"t");
        }
        return JunLispNil.NullList();
    }

    public Object subrLength_(Object[] objectArray) {
        Object object = objectArray[0];
        if (object instanceof JunLispCons) {
            return new Integer(((JunLispCons)((Object)object)).length());
        }
        return this.fatal_("unexpected argument " + this.printString_(object) + " for length");
    }

    public Object subrListp_(Object[] objectArray) {
        Object object = objectArray[0];
        if (object instanceof JunLispList) {
            return JunLispInterpreter.$((String)"t");
        }
        return JunLispNil.NullList();
    }

    public Object subrLt_(Object[] objectArray) {
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        if (object instanceof JunLispList) {
            return this.fatal_("unexpected argument " + this.printString_(object) + " for < ");
        }
        if (object2 instanceof JunLispList) {
            return this.fatal_("unexpected argument " + this.printString_(object2) + " for < ");
        }
        if (object instanceof Number && object2 instanceof Number && ((Number)object).longValue() < ((Number)object2).longValue()) {
            return JunLispInterpreter.$((String)"t");
        }
        if (object instanceof String && object2 instanceof String && ((String)object).compareTo((String)object2) < 0) {
            return JunLispInterpreter.$((String)"t");
        }
        return JunLispNil.NullList();
    }

    public Object subrMember_(Object[] objectArray) {
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        if (!(object2 instanceof JunLispCons)) {
            return this.fatal_("unexpected argument " + this.printString_(object2) + " for member");
        }
        return ((JunLispCons)((Object)object2)).member_(object);
    }

    public Object subrMemq_(Object[] objectArray) {
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        if (!(object2 instanceof JunLispCons)) {
            return this.fatal_("unexpected argument " + this.printString_(object2) + " for memq");
        }
        return ((JunLispCons)((Object)object2)).memq_(object);
    }

    public Object subrNconc_(Object[] objectArray) {
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        if (!(object instanceof JunLispCons)) {
            return this.fatal_("unexpected argument " + this.printString_(object) + " for nconc");
        }
        ((JunLispCons)((Object)object)).nconc_((JunLispList)((Object)object2));
        return object;
    }

    public Object subrNeq_(Object[] objectArray) {
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        JunLispNil junLispNil = object != object2 ? JunLispInterpreter.$((String)"t") : JunLispNil.NullList();
        return junLispNil;
    }

    public Object subrNequal_(Object[] objectArray) {
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        JunLispNil junLispNil = !object.equals(object2) ? JunLispInterpreter.$((String)"t") : JunLispNil.NullList();
        return junLispNil;
    }

    public Object subrNth_(Object[] objectArray) {
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        if (!(object instanceof Number)) {
            return this.fatal_("unexpected argument " + this.printString_(object) + " for nth");
        }
        if (!(object2 instanceof JunLispCons)) {
            return this.fatal_("unexpected argument " + this.printString_(object2) + " for nth");
        }
        return ((JunLispCons)((Object)object2)).nth_(((Number)object).intValue());
    }

    public Object subrNull_(Object[] objectArray) {
        Object object = objectArray[0];
        if (object instanceof JunLispNil) {
            return JunLispInterpreter.$((String)"t");
        }
        return JunLispNil.NullList();
    }

    public Object subrNumberp_(Object[] objectArray) {
        Object object = objectArray[0];
        if (object instanceof Number) {
            return JunLispInterpreter.$((String)"t");
        }
        return JunLispNil.NullList();
    }

    public JunLispList subrOblist() {
        JunLispList junLispList = JunLispNil.NullList();
        Object[] objectArray = this.lispTable.identifiers();
        int n = objectArray.length;
        for (int i = n - 1; i >= 0; --i) {
            Object object = objectArray[i];
            junLispList = JunLispCons.Head_tail_(object, (Object)junLispList);
        }
        return junLispList;
    }

    public Object subrPp_(Object[] objectArray) {
        JunLispCons junLispCons = (JunLispCons)((Object)objectArray[0]);
        String string = junLispCons.ppString();
        this.textCollector.print(string);
        return junLispCons;
    }

    public Object subrPrinc_(Object[] objectArray) {
        Object object = objectArray[0];
        if (object instanceof String) {
            this.textCollector.print(object);
        } else {
            this.textCollector.print(this.printString_(object));
        }
        return object;
    }

    public Object subrPrint_(Object[] objectArray) {
        Object object = this.subrPrinc_(objectArray);
        this.textCollector.println();
        return object;
    }

    public Object subrPutprop_(Object[] objectArray) {
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        Object object3 = objectArray[2];
        if (!(object instanceof StSymbol)) {
            return this.fatal_("unexpected argument " + this.printString_(object) + " for putprop");
        }
        if (!(object2 instanceof StSymbol)) {
            return this.fatal_("unexpected argument " + this.printString_(object2) + " for putprop");
        }
        return this.putprop_key_value_(object, object2, object3);
    }

    public Object subrRead() {
        String string = "                " + JunSystem.$String((String)"Input an S expression.") + "                ";
        String string2 = JunDialog.Request_(string, "");
        if (string2.length() == 0) {
            return JunLispNil.NullList();
        }
        return JunLispParser.Parse_(new StReadStream(string2));
    }

    public Object subrRemprop_(Object[] objectArray) {
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        if (!(object instanceof StSymbol)) {
            return this.fatal_("unexpected argument " + this.printString_(object) + " for remprop");
        }
        if (!(object2 instanceof StSymbol)) {
            return this.fatal_("unexpected argument " + this.printString_(object2) + " for remprop");
        }
        return this.remprop_key_(object, object2);
    }

    public Object subrReverse_(Object[] objectArray) {
        Object object = objectArray[0];
        if (!(object instanceof JunLispCons)) {
            return this.fatal_("unexpected argument " + this.printString_(object) + " for reverse");
        }
        return ((JunLispCons)((Object)object)).reverse();
    }

    public Object subrRplaca_(Object[] objectArray) {
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        if (!(object instanceof JunLispCons)) {
            return this.fatal_("unexpected argument " + this.printString_(object2) + " for rplaca");
        }
        ((JunLispCons)((Object)object)).rplaca_(object2);
        return object;
    }

    public Object subrRplacd_(Object[] objectArray) {
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        if (!(object instanceof JunLispCons)) {
            return this.fatal_("unexpected argument " + this.printString_(object2) + " for rplacd");
        }
        ((JunLispCons)((Object)object)).rplacd_(object2);
        return object;
    }

    public Object subrStringp_(Object[] objectArray) {
        Object object = objectArray[0];
        if (object instanceof String) {
            return JunLispInterpreter.$((String)"t");
        }
        return JunLispNil.NullList();
    }

    public Object subrSubrs() {
        JunLispList junLispList;
        JunLispList junLispList2 = JunLispNil.NullList();
        JunLispList junLispList3 = this.subrOblist();
        Object object = junLispList = ((JunLispCons)junLispList3).reverse();
        while (object instanceof JunLispCons) {
            Object object2 = ((JunLispCons)((Object)object)).head();
            JunLispList junLispList4 = (JunLispList)((Object)this.getprop_key_(object2, JunLispInterpreter.$((String)"subr")));
            if (!junLispList4.nullList()) {
                junLispList2 = JunLispCons.Head_tail_(object2, (Object)junLispList2);
            }
            object = ((JunLispCons)((Object)object)).tail();
        }
        return junLispList2;
    }

    public Object subrSymbolp_(Object[] objectArray) {
        Object object = objectArray[0];
        if (object instanceof StSymbol) {
            return JunLispInterpreter.$((String)"t");
        }
        return JunLispNil.NullList();
    }

    public Object subrTerpri() {
        this.textCollector.println();
        return JunLispInterpreter.$((String)"t");
    }

    public PrintStream textCollector() {
        return this.textCollector;
    }

    public void textCollector_(PrintStream printStream) {
        this.textCollector = printStream;
    }

    public StValueHolder textValue() {
        if (this.textValue == null) {
            this.textValue = new StValueHolder((Object)new String());
        }
        return this.textValue;
    }

    public void unbind() {
        StAssociation stAssociation = (StAssociation)this.bindStack.pop();
        while (stAssociation.key() != null) {
            if (stAssociation.value() != null) {
                this.putprop_key_value_(stAssociation.key(), JunLispInterpreter.$((String)"apval"), stAssociation.value());
            } else {
                this.remprop_key_(stAssociation.key(), JunLispInterpreter.$((String)"apval"));
            }
            stAssociation = (StAssociation)this.bindStack.pop();
        }
    }

    protected Object listEvaluate_(JunLispList junLispList) {
        if (junLispList.nullList()) {
            return junLispList;
        }
        Object object = ((JunLispCons)junLispList).head();
        Object object2 = ((JunLispCons)junLispList).tail();
        if (object instanceof JunLispCons) {
            Object object3 = object;
            JunLispCons junLispCons = (JunLispCons)((Object)object);
            if (junLispCons.head() instanceof StSymbol) {
                StSymbol stSymbol = (StSymbol)junLispCons.head();
                if (stSymbol == JunLispInterpreter.$((String)"lambda")) {
                    object3 = JunLispCons.Head_tail_(JunLispInterpreter.$((String)"lambda"), (Object)((JunLispList)((Object)object3)));
                    return this.exprEval_arguList_((JunLispList)((Object)object3), (JunLispList)((Object)object2));
                }
                if (stSymbol == JunLispInterpreter.$((String)"nlambda")) {
                    object3 = JunLispCons.Head_tail_(JunLispInterpreter.$((String)"nlambda"), (Object)((JunLispList)((Object)object3)));
                    return this.fexprEval_arguList_((JunLispList)((Object)object3), (JunLispList)((Object)object2));
                }
            }
            return this.fatal_("unexpected function " + this.printString_(object3));
        }
        if (!(object instanceof StSymbol)) {
            return this.fatal_("null function " + this.printString_(object));
        }
        Object object4 = this.getprop_key_(object, JunLispInterpreter.$((String)"fexpr"));
        if (!(object4 instanceof JunLispNil)) {
            return this.fexprEval_arguList_((JunLispList)((Object)object4), (JunLispList)((Object)object2));
        }
        object4 = this.getprop_key_(object, JunLispInterpreter.$((String)"expr"));
        if (!(object4 instanceof JunLispNil)) {
            return this.exprEval_arguList_((JunLispList)((Object)object4), (JunLispList)((Object)object2));
        }
        object4 = this.getprop_key_(object, JunLispInterpreter.$((String)"fsubr"));
        if (!(object4 instanceof JunLispNil)) {
            return this.fsubrEval_arguList_((JunLispList)((Object)object4), (JunLispList)((Object)object2));
        }
        object4 = this.getprop_key_(object, JunLispInterpreter.$((String)"subr"));
        if (!(object4 instanceof JunLispNil)) {
            return this.subrEval_arguList_((JunLispList)((Object)object4), (JunLispList)((Object)object2));
        }
        return this.fatal_("undefined function " + this.printString_(object));
    }

    protected String printString_(Object object) {
        return JunLispInterpreter.PrintString_(object);
    }

    protected String windowTitle() {
        return JunSystem.$String((String)"Lisp");
    }
}

