/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.image.support;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.image.BufferedImage;
import java.util.Map;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.colors.JunColorChoiceHBS;
import jp.co.sra.jun.goodies.colors.JunColorChoiceSBH;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.image.support.JunImageProcessor;
import jp.co.sra.jun.opengl.texture.JunOpenGLTextureTestExamples;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.smalltalk.StAssociation;
import jp.co.sra.smalltalk.StImage;

public class JunImageProcessorTestExamples
extends JunTestExamples {
    public static boolean Example01() {
        StImage stImage = new JunColorChoiceSBH().plate();
        StImage stImage2 = (StImage)new JunColorChoiceHBS().plate().copy();
        Rectangle rectangle = new Rectangle(25, 25, 55, 55);
        stImage2.copy_from_in_rule_(rectangle, new Point(0, 0), stImage, 3);
        stImage2._display();
        return true;
    }

    public static boolean Example02() {
        StImage stImage = (StImage)new StImage(JunOpenGLTextureTestExamples.ImageEarth()).copy();
        StImage stImage2 = new StImage((Image)JunCursors.StopCursorImage());
        Rectangle rectangle = new Rectangle(10, 10, 30, 30);
        stImage.tile_from_in_rule_(rectangle, new Point(0, 0), stImage2, 3);
        stImage._display();
        return true;
    }

    public static boolean Example03() {
        StImage stImage = new JunColorChoiceSBH().plate();
        StImage stImage2 = JunImageProcessor.Scale_factor_(stImage, new Jun2dPoint(2.5, 2.0));
        stImage2._display();
        return true;
    }

    public static boolean Example04() {
        StImage stImage = new StImage(JunSystem.LogoImage());
        StImage stImage2 = JunImageProcessor.Scale_factor_(stImage, new Jun2dPoint(2.5, 2.0));
        stImage2._display();
        return true;
    }

    public static boolean Example05() {
        StImage stImage = new StImage(512, 512);
        for (int i = 0; i < 66; ++i) {
            Rectangle rectangle = new Rectangle(i % 8 * 24, i / 8 * 24, 16, 16);
            stImage.copy_from_in_rule_(rectangle, new Point(0, 0), JunImageProcessor.MaskAt_(i), 3);
        }
        stImage._display();
        return true;
    }

    public static boolean Example06() {
        System.out.print(JunImageProcessor.Stipple_(0.5));
        return true;
    }

    public static boolean Example07() {
        StImage stImage = JunImageProcessorTestExamples._TestImage();
        JunImageProcessor.Fill_rectangle_color_(stImage, new Rectangle(20, 20, 60, 60), Color.pink);
        stImage._display();
        stImage = JunImageProcessorTestExamples._TestImage();
        JunImageProcessor.Fill_seed_color_(stImage, new Point(75, 75), Color.pink);
        stImage._display();
        return true;
    }

    public static boolean Example08() {
        StImage stImage = new StImage(JunOpenGLTextureTestExamples.ImageSmalltalkBalloon());
        Map.Entry[] entryArray = JunImageProcessor.ColorHistogram_(stImage);
        StImage stImage2 = new StImage(401, entryArray.length * 4);
        for (int i = 0; i < entryArray.length; ++i) {
            int n = (int)(((Number)entryArray[i].getValue()).floatValue() * 400.0f);
            if (n == 0) {
                n = 1;
            }
            Rectangle rectangle = new Rectangle(1, i * 4, n, 3);
            Color color = (Color)entryArray[i].getKey();
            stImage2 = JunImageProcessor.Fill_rectangle_color_(stImage2, rectangle, color);
        }
        stImage2._display();
        return true;
    }

    public static boolean Example09() {
        StImage stImage = new StImage(10, 10);
        stImage = new StImage(JunOpenGLTextureTestExamples.ImageSmalltalkBalloon());
        stImage = JunImageProcessor.Scale_factor_(stImage, new Jun2dPoint(2.0, 1.5));
        JunImageProcessor.Icon_size_(stImage, 128)._display();
        return true;
    }

    public static boolean Example10() {
        StImage stImage = new StImage(JunOpenGLTextureTestExamples.ImageSmalltalkBalloon());
        float[] fArray = JunImageProcessor.XSpectrum_(stImage);
        StImage stImage2 = new StImage(fArray.length, 100);
        for (int i = 0; i < fArray.length; ++i) {
            int n = (int)(fArray[i] * 100.0f);
            if (n == 0) {
                n = 1;
            }
            Rectangle rectangle = new Rectangle(i, 0, 1, n);
            stImage2 = JunImageProcessor.Fill_rectangle_color_(stImage2, rectangle, Color.black);
        }
        stImage2._display();
        return true;
    }

    public static boolean Example11() {
        StImage stImage = new StImage(JunOpenGLTextureTestExamples.ImageSmalltalkBalloon());
        float[] fArray = JunImageProcessor.YSpectrum_(stImage);
        StImage stImage2 = new StImage(100, fArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            int n = (int)(fArray[i] * 100.0f);
            if (n == 0) {
                n = 1;
            }
            Rectangle rectangle = new Rectangle(0, i, n, 1);
            stImage2 = JunImageProcessor.Fill_rectangle_color_(stImage2, rectangle, Color.black);
        }
        stImage2._display();
        return true;
    }

    public static boolean Example12() {
        JunImageProcessor.ColorPalette256Image_(new Point(8, 8))._display();
        JunImageProcessor.GrayPalette256Image_(new Point(8, 8))._display();
        return true;
    }

    public static boolean Example13() {
        StImage stImage = JunImageProcessorTestExamples._TestImage();
        stImage = JunImageProcessor.Shape_color_(stImage, Color.green);
        stImage._display();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean Example14() {
        Graphics graphics = null;
        StImage stImage = new StImage(JunSystem.LogoImage());
        StAssociation[] stAssociationArray = JunImageProcessor.BorderFollowing_(stImage);
        StImage stImage2 = new StImage(stImage.width() + 2, stImage.height() + 2);
        BufferedImage bufferedImage = stImage2.image();
        try {
            graphics = ((Image)bufferedImage).getGraphics();
            if (graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).setBackground(SystemColor.window);
            }
            graphics.setColor(Color.black);
            for (int i = 0; i < stAssociationArray.length; ++i) {
                StAssociation stAssociation = stAssociationArray[i];
                Point[] pointArray = (Point[])stAssociation.value();
                int[] nArray = new int[pointArray.length];
                int[] nArray2 = new int[pointArray.length];
                for (int j = 0; j < pointArray.length; ++j) {
                    nArray[j] = pointArray[j].x;
                    nArray2[j] = pointArray[j].y;
                }
                graphics.drawPolyline(nArray, nArray2, nArray.length);
            }
            new StImage((Image)bufferedImage)._display();
        }
        finally {
            graphics.dispose();
            bufferedImage.flush();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean Example15() {
        Graphics graphics = null;
        StImage stImage = new StImage(JunSystem.LogoImage());
        Object[] objectArray = JunImageProcessor.TraceBorder_(stImage);
        StImage stImage2 = new StImage(stImage.width() + 2, stImage.height() + 2);
        BufferedImage bufferedImage = stImage2.image();
        try {
            graphics = ((Image)bufferedImage).getGraphics();
            if (graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).setBackground(SystemColor.window);
            }
            graphics.setColor(Color.black);
            for (int i = 0; i < objectArray.length; ++i) {
                Point[] pointArray = (Point[])objectArray[i];
                int[] nArray = new int[pointArray.length];
                int[] nArray2 = new int[pointArray.length];
                for (int j = 0; j < pointArray.length; ++j) {
                    nArray[j] = pointArray[j].x;
                    nArray2[j] = pointArray[j].y;
                }
                graphics.drawPolyline(nArray, nArray2, nArray.length);
            }
            stImage2._display();
        }
        finally {
            graphics.dispose();
            bufferedImage.flush();
        }
        return true;
    }

    public static boolean Example16() {
        StImage stImage = new StImage(JunSystem.LogoImage());
        stImage = JunImageProcessor.MakeThin_(stImage);
        stImage._display();
        return true;
    }

    public static boolean Example17() {
        StImage stImage = StImage._FromUser();
        stImage._display();
        StImage stImage2 = stImage._convertToPalette_RenderedByNearistPaint(JunImageProcessor.GrayPalette256());
        stImage2._display();
        stImage2 = stImage._convertToPalette_RenderedByErrorDiffusion(JunImageProcessor.GrayPalette256());
        stImage2._display();
        return true;
    }

    public static boolean Example18() {
        StImage stImage = JunImageProcessor.Image_halftone_(StImage._FromUser(), 0.5);
        stImage._display();
        return true;
    }

    public static void main(String[] stringArray) {
        new JunImageProcessorTestExamples();
    }

    protected static StImage _TestImage() {
        int n = 50;
        int n2 = 50;
        int n3 = 0;
        StImage stImage = new StImage(n * 3, n2 * 3);
        Color[] colorArray = new Color[]{Color.black, Color.red, Color.green, Color.blue, Color.white, Color.yellow, Color.cyan, Color.magenta, Color.gray};
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                StImage stImage2 = new StImage(16, 16);
                int n4 = colorArray[n3].getRGB();
                for (int k = 0; k < stImage2.width(); ++k) {
                    for (int i2 = 0; i2 < stImage2.height(); ++i2) {
                        stImage2.setPixel(k, i2, n4);
                    }
                }
                stImage.tile_from_in_rule_(new Rectangle(n * j + 1, n2 * i + 1, n - 2, n2 - 2), new Point(0, 0), stImage2, 3);
                ++n3;
            }
        }
        return stImage;
    }
}

