/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.image.streams;

import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import jp.co.sra.jun.goodies.image.streams.JunGifImageStream;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.jun.goodies.image.support.JunImageProcessor;
import jp.co.sra.smalltalk.StImage;

public class JunSraGifImageStream
extends JunGifImageStream {
    protected static final byte ImageSeparator = 44;
    protected static final byte Extension = 33;
    protected static final byte Terminator = 59;
    protected static final byte GraphicControlLabel = -7;
    protected static final byte ApplicationExtensionLabel = -1;
    protected static final byte CommentExtensionLabel = -2;
    protected static final byte PlainTextExtensionLabel = 1;
    protected int width;
    protected int height;
    protected int bitsPerPixel;
    protected IndexColorModel colorModel;
    protected int rowByteSize;
    protected int xpos;
    protected int ypos;
    protected int pass;
    protected boolean interlace;
    protected int codeSize;
    protected int clearCode;
    protected int eoiCode;
    protected int freeCode;
    protected int maxCode;
    protected int remainBitCount;
    protected int bufByte;
    protected ByteBuffer bufStream;
    protected int transparentColorIndex = -1;
    protected StImage image8;

    public static JunImageStream On_(InputStream inputStream) throws IOException {
        return JunSraGifImageStream.On_((JunImageStream)new JunSraGifImageStream(), inputStream);
    }

    public static JunImageStream On_(OutputStream outputStream) throws IOException {
        return JunSraGifImageStream.On_((JunImageStream)new JunSraGifImageStream(), outputStream);
    }

    protected static int BitShift(int n, int n2) {
        if (n2 > 0) {
            return n << n2;
        }
        if (n2 < 0) {
            return n >> -n2;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextPutImage_(StImage stImage) throws IOException {
        try {
            byte[] byArray = this.bitsFor_(stImage);
            this.writeHeader();
            this.writeBlocks(byArray);
        }
        finally {
            this.close();
        }
    }

    protected void writeHeader() throws IOException {
        this.nextPutAll_("GIF89a".getBytes());
        this.writeWord_(this.width);
        this.writeWord_(this.height);
        int n = 128;
        n |= this.bitsPerPixel - 1 << 4;
        this.nextPut_(n |= this.bitsPerPixel - 1);
        if (this.transparentColorIndex >= 0) {
            this.nextPut_(this.transparentColorIndex);
        } else {
            this.nextPut_(0);
        }
        this.nextPut_(0);
        int n2 = 1 << this.bitsPerPixel;
        int[] nArray = new int[this.colorModel.getMapSize()];
        this.colorModel.getRGBs(nArray);
        for (int i = 0; i < n2; ++i) {
            if (i < nArray.length) {
                int n3 = nArray[i];
                this.nextPut_(n3 >> 16 & 0xFF);
                this.nextPut_(n3 >> 8 & 0xFF);
                this.nextPut_(n3 & 0xFF);
                continue;
            }
            this.nextPut_(0);
            this.nextPut_(0);
            this.nextPut_(0);
        }
    }

    protected void writeBlocks(byte[] byArray) throws IOException {
        if (this.transparentColorIndex >= 0) {
            this.writeGraphicControlExtensionBlock();
        }
        this.nextPut_(44);
        this.writeWord_(0);
        this.writeWord_(0);
        this.writeWord_(this.width);
        this.writeWord_(this.height);
        this.nextPut_(this.interlace ? 64 : 0);
        this.writeBitData_(byArray);
        this.nextPut_(59);
    }

    protected void writeGraphicControlExtensionBlock() throws IOException {
        this.nextPut_(33);
        this.nextPut_(-7);
        this.nextPut_(4);
        if (this.transparentColorIndex >= 0) {
            this.nextPut_(1);
        } else {
            this.nextPut_(0);
        }
        this.nextPut_(0);
        this.nextPut_(0);
        if (this.transparentColorIndex >= 0) {
            this.nextPut_(this.transparentColorIndex);
        } else {
            this.nextPut_(0);
        }
        this.nextPut_(0);
    }

    protected void writeBitData_(byte[] byArray) throws IOException {
        int n;
        int n2;
        this.pass = 0;
        this.xpos = 0;
        this.ypos = 0;
        this.rowByteSize = (this.width * 8 + 31) / 32 * 4;
        this.remainBitCount = 0;
        this.bufByte = 0;
        this.bufStream = ByteBuffer.allocate(256);
        int n3 = 12;
        int n4 = 1 << n3;
        int n5 = 5003;
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n5];
        int n6 = this.bitsPerPixel <= 1 ? 2 : this.bitsPerPixel;
        this.nextPut_(n6);
        this.setParameters_(n6);
        int n7 = 0;
        for (n2 = n5; n2 < 65536; n2 *= 2) {
            ++n7;
        }
        n7 = 8 - n7;
        for (int i = 0; i < n5; ++i) {
            nArray2[i] = -1;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>(this.height);
        this.progress_((float)hashSet.size() / (float)this.height);
        hashSet.add(new Integer(this.ypos));
        this.progress_((float)hashSet.size() / (float)this.height);
        this.writeCodeAndCheckCodeSize_(this.clearCode);
        int n8 = this.readPixelFrom_(byArray);
        while ((n = this.readPixelFrom_(byArray)) >= 0) {
            hashSet.add(new Integer(this.ypos));
            this.progress_((float)hashSet.size() / (float)this.height);
            n2 = (n << n3) + n8;
            int n9 = n << n7 ^ n8;
            if (nArray2[n9] == n2) {
                n8 = nArray[n9];
            } else {
                int n10;
                boolean bl = true;
                if (nArray2[n9] > 0) {
                    n10 = n5 - n9;
                    if (n9 == 0) {
                        n10 = 1;
                    }
                    do {
                        if ((n9 -= n10) < 0) {
                            n9 += n5;
                        }
                        if (nArray2[n9] != n2) continue;
                        n8 = nArray[n9];
                        bl = false;
                    } while (bl && nArray2[n9] > 0);
                }
                if (bl) {
                    this.writeCodeAndCheckCodeSize_(n8);
                    n8 = n;
                    if (this.freeCode < n4) {
                        nArray[n9] = this.freeCode++;
                        nArray2[n9] = n2;
                    } else {
                        this.writeCodeAndCheckCodeSize_(this.clearCode);
                        for (n10 = 0; n10 < n5; ++n10) {
                            nArray2[n10] = -1;
                        }
                        this.setParameters_(n6);
                    }
                }
            }
            hashSet.add(new Integer(this.ypos));
            this.progress_((float)hashSet.size() / (float)this.height);
        }
        nArray = null;
        nArray2 = null;
        this.writeCodeAndCheckCodeSize_(n8);
        this.writeCodeAndCheckCodeSize_(this.eoiCode);
        this.flushCode();
        this.nextPut_(0);
    }

    protected void writeWord_(int n) throws IOException {
        this.nextPut_(n & 0xFF);
        this.nextPut_(n >> 8 & 0xFF);
    }

    protected void writeCode_(int n) throws IOException {
        this.nextBitsPut_(n);
    }

    protected void writeCodeAndCheckCodeSize_(int n) throws IOException {
        this.writeCode_(n);
        this.checkCodeSize();
    }

    protected int readPixelFrom_(byte[] byArray) {
        if (this.ypos >= this.height) {
            return -1;
        }
        int n = byArray[this.ypos * this.rowByteSize + this.xpos] & 0xFF;
        this.updatePixelPosition();
        return n;
    }

    protected void flushCode() throws IOException {
        this.flushBits();
    }

    protected void nextBitsPut_(int n) throws IOException {
        int n2;
        int n3;
        int n4 = 0;
        if (this.remainBitCount == 0) {
            n3 = 8;
            n2 = n;
        } else {
            n3 = this.remainBitCount;
            n2 = this.bufByte + (n << 8 - this.remainBitCount);
        }
        while (n3 < this.codeSize) {
            this.nextBytePut_((byte)(JunSraGifImageStream.BitShift(n2, n4) & 0xFF));
            n4 -= 8;
            n3 += 8;
        }
        this.remainBitCount = n3 - this.codeSize;
        if (this.remainBitCount == 0) {
            this.nextBytePut_((byte)(JunSraGifImageStream.BitShift(n2, n4) & 0xFF));
        } else {
            this.bufByte = (byte)(JunSraGifImageStream.BitShift(n2, n4) & 0xFF);
        }
    }

    protected void flushBits() throws IOException {
        if (this.remainBitCount != 0) {
            this.nextBytePut_((byte)(this.bufByte & 0xFF));
            this.remainBitCount = 0;
        }
        this.flushBuffer();
    }

    protected void nextBytePut_(byte by) throws IOException {
        this.bufStream.put(by);
        if (this.bufStream.position() >= 254) {
            this.flushBuffer();
        }
    }

    protected void flushBuffer() throws IOException {
        if (this.bufStream.position() == 0) {
            return;
        }
        int n = this.bufStream.position();
        byte[] byArray = new byte[n];
        this.bufStream.position(0);
        this.bufStream.get(byArray);
        this.nextPut_(n);
        this.nextPutAll_(byArray);
        this.bufStream = ByteBuffer.allocate(256);
    }

    protected byte[] bitsFor_(StImage stImage) {
        this.image8 = stImage.bitsPerPixel() > 8 || !(stImage.colorModel() instanceof IndexColorModel) ? stImage._convertToPalette_RenderedByErrorDiffusion(JunImageProcessor.ColorPalette256()) : stImage;
        this.width = this.image8.width();
        this.height = this.image8.height();
        this.colorModel = (IndexColorModel)this.image8.colorModel();
        if (this.transparentColorIndex < 0) {
            this.transparentColorIndex = this.colorModel.getTransparentPixel();
        }
        this.bitsPerPixel = this.image8.bitsPerPixel();
        byte[] byArray = this.image8.getBits();
        this.interlace = false;
        return byArray;
    }

    protected void setParameters_(int n) {
        this.clearCode = 1 << n;
        this.eoiCode = this.clearCode + 1;
        this.freeCode = this.clearCode + 2;
        this.codeSize = n + 1;
        this.maxCode = (1 << this.codeSize) - 1;
    }

    protected void checkCodeSize() {
        if (this.freeCode > this.maxCode && this.codeSize < 12) {
            ++this.codeSize;
            this.maxCode = (1 << this.codeSize) - 1;
        }
    }

    protected void updatePixelPosition() {
        ++this.xpos;
        if (this.xpos < this.width) {
            return;
        }
        this.xpos = 0;
        if (!this.interlace) {
            ++this.ypos;
            return;
        }
        switch (this.pass) {
            case 0: {
                this.ypos += 8;
                if (this.ypos < this.height) break;
                ++this.pass;
                this.ypos = 4;
                break;
            }
            case 1: {
                this.ypos += 8;
                if (this.ypos < this.height) break;
                ++this.pass;
                this.ypos = 2;
                break;
            }
            case 2: {
                this.ypos += 4;
                if (this.ypos < this.height) break;
                ++this.pass;
                this.ypos = 1;
                break;
            }
            case 3: {
                this.ypos += 2;
                break;
            }
            default: {
                this.error_("can't happen");
            }
        }
    }
}

