/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.image.streams;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.co.sra.jun.goodies.image.streams.JunBmpImageStream;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.smalltalk.StImage;

public class JunSraBmpImageStream
extends JunBmpImageStream {
    protected int position = 0;
    private int bfType;
    private long bfSize;
    private int bfReserved1;
    private int bfReserved2;
    private long bfOffBits;
    private long biSize;
    private long biWidth;
    private long biHeight;
    private int biPlanes;
    private int biBitCount;
    private long biCompression;
    private long biSizeImage;
    private long biXPelsPerMeter;
    private long biYPelsPerMeter;
    private long biClrUsed;
    private long biClrImportant;
    private int[] imagePalette;

    public static JunImageStream On_(InputStream inputStream) throws IOException {
        return JunSraBmpImageStream.On_((JunImageStream)new JunSraBmpImageStream(), inputStream);
    }

    public static JunImageStream On_(OutputStream outputStream) throws IOException {
        throw new IOException("could not save image");
    }

    public StImage nextImage() throws IOException {
        boolean bl;
        if (this.inStream != null && (bl = this.readBitmapFileHeader())) {
            this.readBitmapInfoHeader();
            this.readImagePalette();
            boolean bl2 = this.readImageData();
            if (!bl2) {
                this.imageObject = null;
            }
        }
        return this.imageObject;
    }

    public void nextPutImage_(StImage stImage) throws IOException {
        throw new IOException("could not save image");
    }

    private int next() throws IOException {
        int n = -1;
        n = this.inStream.read();
        ++this.position;
        return n;
    }

    private long nextLong() throws IOException {
        int n = this.next();
        int n2 = this.next();
        int n3 = this.next();
        int n4 = this.next();
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    private long nextLSBLong() throws IOException {
        int n = this.next();
        int n2 = this.next();
        int n3 = this.next();
        int n4 = this.next();
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    private int nextLSBWord() throws IOException {
        int n = this.next();
        int n2 = this.next();
        return (n2 << 8) + n;
    }

    private int nextWord() throws IOException {
        int n = this.next();
        int n2 = this.next();
        return (n << 8) + n2;
    }

    protected void on_(OutputStream outputStream) throws IOException {
        throw new IOException("could not save image");
    }

    private boolean readBitmapFileHeader() throws IOException {
        int n = 16973;
        this.bfType = this.nextWord();
        if (n != this.bfType) {
            return false;
        }
        this.bfSize = this.nextLSBLong();
        this.bfReserved1 = this.nextLSBWord();
        this.bfReserved2 = this.nextLSBWord();
        this.bfOffBits = this.nextLSBLong();
        return true;
    }

    private void readBitmapInfoHeader() throws IOException {
        this.biSize = this.nextLSBLong();
        this.biWidth = this.nextLSBLong();
        this.biHeight = this.nextLSBLong();
        this.biPlanes = this.nextLSBWord();
        this.biBitCount = this.nextLSBWord();
        this.biCompression = this.nextLSBLong();
        this.biSizeImage = this.nextLSBLong();
        this.biXPelsPerMeter = this.nextLSBLong();
        this.biYPelsPerMeter = this.nextLSBLong();
        this.biClrUsed = this.nextLSBLong();
        this.biClrImportant = this.nextLSBLong();
    }

    private StImage readDepth1Data() throws IOException {
        System.out.print("1bit BMP detect");
        return null;
    }

    private StImage readDepth24Data() throws IOException {
        while ((long)this.position < this.bfOffBits) {
            this.next();
        }
        int n = (int)this.biWidth;
        int n2 = (int)this.biHeight;
        StImage stImage = new StImage(n, n2);
        for (int i = n2 - 1; i > -1; --i) {
            int n3 = 0;
            for (int j = 0; j < n; ++j) {
                int n4 = (this.next() << 0) + (this.next() << 8) + (this.next() << 16);
                stImage.setPixel(j, i, new Color(n4).getRGB());
                n3 += 3;
            }
            while (n3 % 4 != 0) {
                this.next();
                ++n3;
            }
        }
        return stImage;
    }

    private StImage readDepth8Data() throws IOException {
        int[] nArray = this.imagePalette;
        int n = (int)this.biWidth;
        int n2 = (int)this.biHeight;
        StImage stImage = new StImage(n, n2);
        for (int i = n2 - 1; i > -1; --i) {
            int n3 = 0;
            for (int j = 0; j < n; ++j) {
                int n4 = this.next();
                stImage.setPixel(j, i, nArray[n4]);
                ++n3;
            }
            while (n3 % 4 != 0) {
                this.next();
                ++n3;
            }
        }
        return stImage;
    }

    private void readDepth8Palette() throws IOException {
        long l = 1 << this.biBitCount;
        if (this.biClrUsed != 0L) {
            l = this.biClrUsed;
        }
        int[] nArray = new int[(int)l];
        int n = 0;
        while ((long)n < l) {
            int n2 = this.next() + (this.next() << 8) + (this.next() << 16);
            this.next();
            nArray[n] = 0xFF000000 | n2;
            ++n;
        }
        this.imagePalette = nArray;
    }

    private boolean readImageData() throws IOException {
        if (this.biCompression != 0L) {
            return false;
        }
        int n = this.biBitCount;
        this.imageObject = null;
        if (n == 24) {
            this.imageObject = this.readDepth24Data();
        }
        if (n == 8) {
            this.imageObject = this.readDepth8Data();
        }
        if (n == 1) {
            this.imageObject = this.readDepth1Data();
        }
        return this.imageObject != null;
    }

    private void readImagePalette() throws IOException {
        this.imagePalette = null;
        if (this.biBitCount == 8) {
            this.readDepth8Palette();
        }
    }
}

