/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.image.framework;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jp.co.sra.jun.goodies.image.framework.JunImageDisplayController;
import jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel;
import jp.co.sra.jun.goodies.image.framework.JunImageDisplayView;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StViewPanel;
import jp.co.sra.smalltalk.WindowSpecLayout;

public class JunImageDisplayViewAwt
extends JunAbstractViewPanel
implements JunImageDisplayView {
    protected boolean _scrollable;
    protected StViewPanel canvas;
    protected ScrollPane scrollPane;

    public JunImageDisplayViewAwt() {
    }

    public JunImageDisplayViewAwt(JunImageDisplayModel junImageDisplayModel) {
        super(junImageDisplayModel);
    }

    protected void initialize() {
        super.initialize();
        this.canvas = null;
        this.scrollPane = null;
        this._scrollable(false);
    }

    protected void buildComponent() {
        this.setLayout((LayoutManager)new WindowSpecLayout());
        this.add(this.scrollPane(), WindowSpecLayout.Position((float)0.0f, (int)0, (float)0.0f, (int)0, (float)1.0f, (int)0, (float)1.0f, (int)0));
        Dimension dimension = this.getModel().bounds().getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        dimension2.setSize(dimension2.width - 100, dimension2.height - 120);
        Insets insets = this.scrollPane().getInsets();
        if (dimension.width > dimension2.width || dimension.height > dimension2.height) {
            this._scrollable(true);
            this.setSize(new Dimension(Math.min(dimension.width, dimension2.width) + insets.left + insets.right, Math.min(dimension.height, dimension2.height) + insets.top + insets.bottom));
        } else {
            this._scrollable(false);
            this.setSize(new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom));
        }
    }

    public boolean _isScrollable() {
        return this._scrollable;
    }

    public void _scrollable(boolean bl) {
        this._scrollable = bl;
        if (this._scrollable) {
            this.remove(this.scrollPane);
            this.scrollPane = null;
            this.canvas.removeMouseMotionListener((MouseMotionListener)this.controller());
            this.canvas.removeMouseListener((MouseListener)this.controller());
            this.canvas = null;
            this.add(this.scrollPane(), WindowSpecLayout.Position((float)0.0f, (int)0, (float)0.0f, (int)0, (float)1.0f, (int)0, (float)1.0f, (int)0));
            this.addNotify();
            ((JunImageDisplayController)this.controller()).buildListener(this);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.doLayout();
        this.scrollPane().doLayout();
    }

    public Dimension getPreferredSize() {
        Point point = this.scrollPane().getLocation();
        Dimension dimension = this.scrollPane().getPreferredSize();
        return new Dimension(dimension.width + point.x * 2, dimension.height + point.y * 2);
    }

    public Rectangle _getViewportBounds() {
        return new Rectangle(this.scrollPane().getScrollPosition(), this.scrollPane().getViewportSize());
    }

    protected StController defaultController() {
        return new JunImageDisplayController();
    }

    public JunImageDisplayModel getModel() {
        return (JunImageDisplayModel)this.model();
    }

    public void update_(DependentEvent dependentEvent) {
        if (!this.topComponent().isShowing()) {
            return;
        }
        if (dependentEvent.getAspect() == JunImageDisplayViewAwt.$((String)"redisplay")) {
            this.canvas().repaint();
        } else {
            super.update_(dependentEvent);
        }
    }

    public StViewPanel canvas() {
        if (this.canvas == null) {
            this.canvas = new StViewPanel(){

                public StModel model() {
                    return JunImageDisplayViewAwt.this.model();
                }

                public Dimension getPreferredSize() {
                    return JunImageDisplayViewAwt.this.getModel() == null ? Toolkit.getDefaultToolkit().getScreenSize() : JunImageDisplayViewAwt.this.getModel().bounds().getSize();
                }

                public void displayOn_(Graphics graphics) {
                    if (JunImageDisplayViewAwt.this.getModel().displayImage() == null) {
                        return;
                    }
                    JunImageDisplayViewAwt.this.getModel().displayImage().displayOn_(graphics);
                }

                public void _showPopupMenu(int n, int n2) {
                    PopupMenu popupMenu = JunImageDisplayViewAwt.this.popupMenuView();
                    if (popupMenu != null) {
                        popupMenu.show((Component)((Object)this), n, n2);
                    }
                }
            };
        }
        return this.canvas;
    }

    public Component _canvasComponent() {
        return this.canvas().toComponent();
    }

    public ScrollPane scrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new ScrollPane(this._isScrollable() ? 1 : 2){

                public Dimension getPreferredSize() {
                    Dimension dimension = JunImageDisplayViewAwt.this.getModel().bounds().getSize();
                    Insets insets = this.getInsets();
                    return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
                }
            };
            this.scrollPane.add((Component)this.canvas());
        }
        return this.scrollPane;
    }
}

