/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.freehand;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import jp.co.sra.jun.goodies.freehand.JunFreehandPage;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StView;

public class JunFreehandController
extends JunAbstractController
implements MouseListener,
MouseMotionListener {
    private static final int _DeltaTime = 20;
    protected Point _currentPoint;
    protected Point _previousPoint;
    protected Vector _pointCollection;
    protected long _previousTime;
    protected Vector _timeCollection;

    public JunFreehandPage getModel() {
        return (JunFreehandPage)this.model();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseDragged(MouseEvent mouseEvent) {
        this._currentPoint = mouseEvent.getPoint();
        if (this._previousPoint == null || this._currentPoint.equals(this._previousPoint)) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l - this._previousTime <= 20L) {
            return;
        }
        this._pointCollection.add(this._currentPoint);
        this._previousPoint = this._currentPoint;
        this._timeCollection.add(new Long(l));
        this._previousTime = l;
        Point[] pointArray = null;
        int n = this._pointCollection.size();
        pointArray = n >= 4 ? new Point[]{(Point)this._pointCollection.get(n - 4), (Point)this._pointCollection.get(n - 3), (Point)this._pointCollection.get(n - 2), (Point)this._pointCollection.get(n - 1)} : (n >= 3 ? new Point[]{(Point)this._pointCollection.get(n - 3), (Point)this._pointCollection.get(n - 2), (Point)this._pointCollection.get(n - 1)} : new Point[]{(Point)this._pointCollection.get(n - 2), (Point)this._pointCollection.get(n - 1)});
        Graphics2D graphics2D = null;
        try {
            graphics2D = this._graphics();
            this.getModel()._drawPolyline((Graphics)graphics2D, pointArray);
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
                graphics2D = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(MouseEvent mouseEvent) {
        this._flush();
        this._currentPoint = this._previousPoint = mouseEvent.getPoint();
        this._pointCollection = new Vector(1024);
        this._pointCollection.add(this._currentPoint);
        this._timeCollection = new Vector(1024);
        this._previousTime = System.currentTimeMillis();
        this._timeCollection.add(new Long(this._previousTime));
        Graphics2D graphics2D = null;
        try {
            graphics2D = this._graphics();
            this.getModel()._drawDotbox(graphics2D, new StRectangle(this._currentPoint.x, this._currentPoint.y, this._currentPoint.x + 1, this._currentPoint.y + 1).expandedBy_(Math.max(this.getModel().nibWidth() / 2, 0)));
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
                graphics2D = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        Graphics2D graphics2D = null;
        try {
            graphics2D = this._graphics();
            this.getModel()._drawPolyline((Graphics)graphics2D, this._pointCollection);
            this.getModel()._drawDotbox(graphics2D, new StRectangle(this._currentPoint.x, this._currentPoint.y, this._currentPoint.x + 1, this._currentPoint.y + 1).expandedBy_(Math.max(this.getModel().nibWidth() / 2, 0)));
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
                graphics2D = null;
            }
        }
        this.getModel().pointCollection_boundingBox_timeCollection_(this._pointCollection, this._component().getBounds(), this._timeCollection);
        this._flush();
    }

    protected Component _component() {
        return (Component)this.view();
    }

    protected void _flush() {
        this._currentPoint = null;
        this._previousPoint = null;
        this._pointCollection = null;
        this._previousTime = 0L;
        this._timeCollection = null;
    }

    protected Graphics2D _graphics() {
        Graphics2D graphics2D = (Graphics2D)this._component().getGraphics();
        graphics2D.setPaint(this.getModel().nibColor());
        graphics2D.setStroke(this.getModel()._stroke(this.getModel().nibWidth()));
        return graphics2D;
    }

    protected void buildListener(StView stView) {
        Component component = (Component)stView;
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }
}

