/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.fourier;

import jp.co.sra.jun.goodies.fourier.JunFourierTransformation;

public class JunDiscreteFourierTransformation
extends JunFourierTransformation {
    protected double[] sourceData;
    protected double[] realData;
    protected double[] imaginaryData;
    protected double[] inverseData;

    public JunDiscreteFourierTransformation(double[] dArray) {
        this.sourceData_(dArray);
    }

    public JunDiscreteFourierTransformation(double[] dArray, double[] dArray2) {
        this.realData_(dArray);
        this.imaginaryData_(dArray2);
    }

    protected void initialize() {
        super.initialize();
        this.sourceData = null;
        this.realData = null;
        this.imaginaryData = null;
        this.inverseData = null;
    }

    public double[] sourceData() {
        return this.sourceData;
    }

    public void sourceData_(double[] dArray) {
        this.sourceData = dArray;
        this.realData = null;
        this.imaginaryData = null;
        this.inverseData = null;
    }

    public double[] realData() {
        if (this.realData == null) {
            this.computeRealAndImaginaryData();
        }
        return this.realData;
    }

    public void realData_(double[] dArray) {
        this.realData = dArray;
        this.inverseData = null;
    }

    public double[] imaginaryData() {
        if (this.imaginaryData == null) {
            this.computeRealAndImaginaryData();
        }
        return this.imaginaryData;
    }

    public void imaginaryData_(double[] dArray) {
        this.imaginaryData = dArray;
        this.inverseData = null;
    }

    public double[] inverseData() {
        if (this.inverseData == null) {
            this.computeInverseData();
        }
        return this.inverseData;
    }

    protected void computeRealAndImaginaryData() {
        double[] dArray = this.sourceData();
        int n = dArray.length;
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double d = Math.PI * 2 / (double)n;
        for (int i = 0; i < n; ++i) {
            dArray2[i] = 0.0;
            dArray3[i] = 0.0;
            for (int j = 0; j < n; ++j) {
                double d2 = dArray[j];
                double d3 = 0.0;
                double d4 = d * (double)i * (double)j;
                int n2 = i;
                dArray2[n2] = dArray2[n2] + (d2 * Math.cos(d4) - d3 * Math.sin(d4));
                int n3 = i;
                dArray3[n3] = dArray3[n3] + (d2 * Math.sin(d4) + d3 * Math.cos(d4));
            }
        }
        this.realData = dArray2;
        this.imaginaryData = dArray3;
    }

    protected void computeInverseData() {
        int n = 200;
        double[] dArray = this.realData();
        double[] dArray2 = this.imaginaryData();
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        double d = Math.PI * 2 / (double)n * -1.0;
        int n2 = 0;
        while (n2 < n) {
            dArray3[n2] = 0.0;
            dArray4[n2] = 0.0;
            for (int i = 0; i < n; ++i) {
                double d2 = dArray[i];
                double d3 = dArray2[i];
                double d4 = d * (double)n2 * (double)i;
                int n3 = n2;
                dArray3[n3] = dArray3[n3] + (d2 * Math.cos(d4) - d3 * Math.sin(d4));
                int n4 = n2;
                dArray4[n4] = dArray4[n4] + (d2 * Math.sin(d4) + d3 * Math.cos(d4));
            }
            int n5 = n2;
            dArray3[n5] = dArray3[n5] / (double)n;
            int n6 = n2++;
            dArray4[n6] = dArray4[n6] / (double)n;
        }
        this.inverseData = dArray3;
    }
}

