/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.font;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.List;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import jp.co.sra.jun.goodies.display.JunDisplayViewAwt;
import jp.co.sra.jun.goodies.font.JunFontModel;
import jp.co.sra.jun.goodies.font.JunFontView;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;
import jp.co.sra.smalltalk.WindowSpecLayout;

public class JunFontViewAwt
extends JunAbstractViewPanel
implements JunFontView {
    protected JunDisplayViewAwt displayView;
    protected List fontNameList;
    protected List fontSizeList;

    public JunFontViewAwt(JunFontModel junFontModel) {
        super(junFontModel);
    }

    protected void buildComponent() {
        this.setLayout((LayoutManager)new WindowSpecLayout());
        this.add((Component)((Object)this.displayView()), WindowSpecLayout.Position((float)0.0f, (int)1, (float)0.0f, (int)1, (float)1.0f, (int)-1, (float)0.0f, (int)79));
        this.add(this.fontNameList(), WindowSpecLayout.Position((float)0.0f, (int)1, (float)0.0f, (int)80, (float)0.7f, (int)-1, (float)1.0f, (int)-1));
        this.add(this.fontSizeList(), WindowSpecLayout.Position((float)0.7f, (int)0, (float)0.0f, (int)80, (float)1.0f, (int)-1, (float)1.0f, (int)-1));
        this.setSize(350, 250);
    }

    public void addNotify() {
        super.addNotify();
        this.topComponent().addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                super.windowOpened(windowEvent);
                JunFontViewAwt.this.updateFontNameList();
                JunFontViewAwt.this.updateFontSizeList();
            }
        });
    }

    public JunFontModel getFontModel() {
        return (JunFontModel)this.model();
    }

    protected JunDisplayViewAwt displayView() {
        if (this.displayView == null) {
            this.displayView = new JunDisplayViewAwt(this.getFontModel().displayModel());
        }
        return this.displayView;
    }

    protected List fontNameList() {
        if (this.fontNameList == null) {
            this.fontNameList = new List();
            this.fontNameList.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        JunFontViewAwt.this.getFontModel().setFontNameIndex(((Number)itemEvent.getItem()).intValue());
                    }
                }
            });
        }
        return this.fontNameList;
    }

    protected List fontSizeList() {
        if (this.fontSizeList == null) {
            this.fontSizeList = new List();
            this.fontSizeList.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        JunFontViewAwt.this.getFontModel().setFontSizeIndex(((Number)itemEvent.getItem()).intValue());
                    }
                }
            });
        }
        return this.fontSizeList;
    }

    protected void updateFontNameList() {
        int n;
        this.fontNameList.removeAll();
        String[] stringArray = this.getFontModel().fontNames();
        for (n = 0; n < stringArray.length; ++n) {
            this.fontNameList.add(stringArray[n]);
        }
        n = this.getFontModel().getFontNameIndex();
        if (n >= 0) {
            this.fontNameList.select(n);
            this.fontNameList.makeVisible(n);
        }
    }

    protected void updateFontSizeList() {
        int n;
        this.fontSizeList.removeAll();
        int[] nArray = this.getFontModel().fontSizes();
        for (n = 0; n < nArray.length; ++n) {
            this.fontSizeList.add(String.valueOf(nArray[n]));
        }
        n = this.getFontModel().getFontSizeIndex();
        if (n >= 0) {
            this.fontSizeList.select(n);
            this.fontSizeList.makeVisible(n);
        }
    }
}

