/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.drawing.map;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.ImageObserver;
import java.util.HashMap;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingElement;
import jp.co.sra.jun.goodies.drawing.element.JunLinkElement;
import jp.co.sra.jun.goodies.drawing.element.JunPathElement;
import jp.co.sra.jun.goodies.drawing.map.JunDrawingMapController;
import jp.co.sra.jun.goodies.drawing.map.JunDrawingMapModel;
import jp.co.sra.jun.goodies.drawing.map.JunDrawingMapView;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StViewCanvas;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenuViewAwt;

public class JunDrawingMapViewAwt
extends JunAbstractViewPanel
implements JunDrawingMapView {
    protected int editMode;
    protected StViewCanvas canvas;
    protected ScrollPane scrollPane;
    protected transient HashMap popupMenuTable;
    protected transient Image offScreenImage;
    protected transient Dimension offScreenSize;

    public JunDrawingMapViewAwt() {
    }

    public JunDrawingMapViewAwt(JunDrawingMapModel junDrawingMapModel) {
        super(junDrawingMapModel);
    }

    protected void initialize() {
        super.initialize();
        this.editMode = 0;
        this.canvas = null;
        this.scrollPane = null;
        this.popupMenuTable = null;
        this.offScreenImage = null;
        this.offScreenSize = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeOffScreen() {
        if (this.offScreenImage == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.offScreenImage.getGraphics().create();
        try {
            graphics2D.setColor(this.canvas().getBackground());
            graphics2D.setClip(0, 0, this.offScreenSize.width, this.offScreenSize.height);
            graphics2D.fillRect(0, 0, this.offScreenSize.width, this.offScreenSize.height);
            graphics2D.translate(-this.scrollPane().getScrollPosition().x, -this.scrollPane().getScrollPosition().y);
            if (this.getDrawingMapModel().isZooming()) {
                Jun2dPoint jun2dPoint = this.getDrawingMapModel().scalePoint();
                graphics2D.scale(jun2dPoint.x(), jun2dPoint.y());
            }
            this.displayCanvasOn_(graphics2D);
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
                graphics2D = null;
            }
        }
    }

    public int editMode() {
        return this.editMode;
    }

    public void editMode_(int n) {
        if (this.editMode != n) {
            int n2 = this.editMode;
            this.editMode = n;
            this.firePropertyChange("editMode", n2, n);
            if (this.getDrawingMapController().startPoint() != null) {
                this.canvas().repaint();
                this.getDrawingMapController().initializeTemporaryVariables();
            }
        }
    }

    public Rectangle areaOfElements_(JunDrawingElement[] junDrawingElementArray) {
        Rectangle rectangle = null;
        for (int i = 0; i < junDrawingElementArray.length; ++i) {
            if (rectangle == null) {
                rectangle = new Rectangle(junDrawingElementArray[i].bounds());
                continue;
            }
            rectangle.add(junDrawingElementArray[i].bounds());
        }
        return rectangle;
    }

    public JunDrawingMapModel getDrawingMapModel() {
        return (JunDrawingMapModel)this.model();
    }

    public JunDrawingMapController getDrawingMapController() {
        return (JunDrawingMapController)this.canvas().controller();
    }

    protected void buildComponent() {
        this.setLayout(new BorderLayout());
        this.add(this.scrollPane(), "Center");
        this.scrollPane().setSize(300, 200);
    }

    public StViewCanvas canvas() {
        if (this.canvas == null) {
            this.canvas = new StViewCanvas((StModel)this.getDrawingMapModel()){

                protected StController defaultController() {
                    return new JunDrawingMapController();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void displayOn_(Graphics graphics) {
                    JunDrawingMapViewAwt junDrawingMapViewAwt = JunDrawingMapViewAwt.this;
                    Image image = junDrawingMapViewAwt.offScreen();
                    if (image != null) {
                        Rectangle rectangle = graphics.getClipBounds();
                        Graphics2D graphics2D = junDrawingMapViewAwt.graphicsWithZoomFrom_(image);
                        try {
                            if (rectangle != null) {
                                if (junDrawingMapViewAwt.getDrawingMapModel().isZooming()) {
                                    Jun2dPoint jun2dPoint = junDrawingMapViewAwt.getDrawingMapModel().scalePoint();
                                    rectangle = new Rectangle((int)Math.floor((double)rectangle.x / jun2dPoint.x()), (int)Math.floor((double)rectangle.y / jun2dPoint.y()), (int)Math.ceil((double)rectangle.width / jun2dPoint.x()), (int)Math.ceil((double)rectangle.height / jun2dPoint.y()));
                                }
                                graphics2D.setColor(junDrawingMapViewAwt.canvas().getBackground());
                                graphics2D.setClip(rectangle);
                                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                            }
                            junDrawingMapViewAwt.displayCanvasOn_(graphics2D);
                        }
                        finally {
                            if (graphics2D != null) {
                                graphics2D.dispose();
                                graphics2D = null;
                            }
                        }
                        junDrawingMapViewAwt.displayCanvasOn_scaledImage_unscaledClip_(graphics, image, null);
                    } else {
                        Graphics2D graphics2D = (Graphics2D)image.getGraphics().create();
                        try {
                            if (junDrawingMapViewAwt.getDrawingMapModel().isZooming()) {
                                Jun2dPoint jun2dPoint = junDrawingMapViewAwt.getDrawingMapModel().scalePoint();
                                graphics2D.scale(jun2dPoint.x(), jun2dPoint.y());
                            }
                            junDrawingMapViewAwt.displayCanvasOn_(graphics2D);
                        }
                        finally {
                            if (graphics2D != null) {
                                graphics2D.dispose();
                                graphics2D = null;
                            }
                        }
                    }
                }

                public void _showPopupMenu(int n, int n2) {
                    PopupMenu popupMenu = JunDrawingMapViewAwt.this.popupMenuView(n, n2);
                    if (popupMenu != null) {
                        popupMenu.show((Component)((Object)this), n, n2);
                    }
                }

                public void update(Graphics graphics) {
                    graphics.setClip(0, 0, this.getWidth(), this.getHeight());
                    this.displayOn_(graphics);
                }

                public void update_(DependentEvent dependentEvent) {
                }
            };
            this.canvas.setBackground(Color.white);
        }
        return this.canvas;
    }

    protected ScrollPane scrollPane() {
        if (this.scrollPane == null) {
            final JunDrawingMapViewAwt junDrawingMapViewAwt = this;
            this.scrollPane = new ScrollPane(0);
            this.scrollPane.setBackground(Color.white);
            this.scrollPane.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    junDrawingMapViewAwt.updateCanvasSize_(junDrawingMapViewAwt.canvas().getSize());
                }
            });
            this.scrollPane.add((Component)this.canvas());
            this.updateCanvasSize_(this.canvas().getSize());
        }
        return this.scrollPane;
    }

    public Point centerPointOnScrollPane() {
        Point point = this.scrollPane().getScrollPosition();
        Dimension dimension = this.scrollPane().getViewportSize();
        return new Point(point.x + dimension.width / 2, point.y + dimension.height / 2);
    }

    public void displayCanvasOn_(Graphics graphics) {
        if (!this.canvas().isShowing()) {
            return;
        }
        StDisplayable stDisplayable = this.getDrawingMapModel().displayObject();
        if (stDisplayable != null) {
            stDisplayable.displayOn_(graphics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayCanvasOn_scaledImage_unscaledClip_(Graphics graphics, Image image, Rectangle rectangle) {
        if (graphics == null) {
            return;
        }
        Graphics graphics2 = graphics.create();
        try {
            Object object;
            Cloneable cloneable;
            if (rectangle != null) {
                cloneable = new Rectangle(rectangle);
                if (this.getDrawingMapModel().isZooming()) {
                    object = this.getDrawingMapModel().scalePoint();
                    ((Rectangle)cloneable).setBounds((int)Math.floor((double)rectangle.x * ((Jun2dPoint)((Object)object)).x()), (int)Math.floor((double)rectangle.y * ((Jun2dPoint)((Object)object)).y()), (int)Math.ceil((double)rectangle.width * ((Jun2dPoint)((Object)object)).x()), (int)Math.ceil((double)rectangle.height * ((Jun2dPoint)((Object)object)).y()));
                }
                graphics2.setClip(((Rectangle)cloneable).x, ((Rectangle)cloneable).y, ((Rectangle)cloneable).width + 1, ((Rectangle)cloneable).height + 1);
            }
            cloneable = this.scrollPane().getScrollPosition();
            object = this.scrollPane().getViewportSize();
            graphics2.drawImage(image, ((Point)cloneable).x, ((Point)cloneable).y, ((Dimension)object).width, ((Dimension)object).height, (ImageObserver)((Object)this));
        }
        finally {
            if (graphics2 != null) {
                graphics2.dispose();
                graphics2 = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _invalidateRectangle_repairNow_(Rectangle rectangle, boolean bl) {
        Object object;
        if (rectangle == null) {
            return;
        }
        Rectangle rectangle2 = null;
        if (this.getDrawingMapModel().isZooming()) {
            object = this.getDrawingMapModel().scalePoint();
            rectangle2 = new Rectangle((int)Math.floor((double)rectangle.x * ((Jun2dPoint)((Object)object)).x()), (int)Math.floor((double)rectangle.y * ((Jun2dPoint)((Object)object)).y()), (int)Math.ceil((double)rectangle.width * ((Jun2dPoint)((Object)object)).x()), (int)Math.ceil((double)rectangle.height * ((Jun2dPoint)((Object)object)).y()));
            rectangle2.grow(5, 5);
        } else {
            rectangle2 = rectangle;
        }
        object = this.canvas().getGraphics();
        if (object == null) {
            return;
        }
        try {
            ((Graphics)object).setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            this.canvas().displayOn_((Graphics)object);
        }
        finally {
            if (object != null) {
                ((Graphics)object).dispose();
                object = null;
            }
        }
    }

    public Image createOffScreen() {
        this.initializeOffScreen();
        return this.offScreen();
    }

    public Image offScreen() {
        Dimension dimension = this.scrollPane().getViewportSize();
        if (!dimension.equals(this.offScreenSize) || this.offScreenImage == null) {
            this.offScreenImage = this.createImage(dimension.width, dimension.height);
            this.offScreenSize = dimension;
            this.initializeOffScreen();
        }
        return this.offScreenImage;
    }

    public Graphics2D graphicsWithZoomFrom_(Image image) {
        Graphics2D graphics2D = (Graphics2D)image.getGraphics().create();
        graphics2D.translate(-this.scrollPane().getScrollPosition().x, -this.scrollPane().getScrollPosition().y);
        if (this.getDrawingMapModel().isZooming()) {
            Jun2dPoint jun2dPoint = this.getDrawingMapModel().scalePoint();
            graphics2D.scale(jun2dPoint.x(), jun2dPoint.y());
        }
        return graphics2D;
    }

    public void updateVertexMenuIndication(JunDrawingElement junDrawingElement) {
        StMenu stMenu = (StMenu)this.getDrawingMapModel().popupMenuFor_(junDrawingElement).atNameKey_(JunDrawingMapViewAwt.$((String)"vertexMenu"));
        if (stMenu == null) {
            return;
        }
        JunPathElement junPathElement = null;
        if (junDrawingElement.isPath()) {
            junPathElement = (JunPathElement)junDrawingElement;
        } else if (junDrawingElement.isLink()) {
            junPathElement = ((JunLinkElement)junDrawingElement).pathElement();
        } else {
            return;
        }
        Point point = this.getDrawingMapController().popupMenuPoint();
        StMenuItem stMenuItem = stMenu.atNameKey_(JunDrawingMapViewAwt.$((String)"addVertex"));
        if (stMenuItem != null) {
            if (point != null && junPathElement.containsPoint_(point)) {
                stMenuItem.beEnabled(true);
            } else {
                stMenuItem.beEnabled(false);
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunDrawingMapViewAwt.$((String)"removeVertex"))) != null) {
            if (point != null && junPathElement.containsPointInControllArea_(point) && junPathElement.points().size() > 2) {
                stMenuItem.beEnabled(true);
            } else {
                stMenuItem.beEnabled(false);
            }
        }
    }

    public PopupMenu popupMenuView(int n, int n2) {
        StSymbol stSymbol;
        JunDrawingElement junDrawingElement = this.getDrawingMapModel().mapObject().currentElement();
        StSymbol stSymbol2 = stSymbol = junDrawingElement != null ? junDrawingElement._className() : null;
        if (!this.popupMenuTable().containsKey(stSymbol)) {
            PopupMenu popupMenu = new StPopupMenuViewAwt(this.getDrawingMapModel().popupMenuFor_(junDrawingElement)).toPopupMenu();
            this.popupMenuTable().put(stSymbol, popupMenu);
            this.canvas().add(popupMenu);
        }
        this.updateVertexMenuIndication(junDrawingElement);
        return (PopupMenu)this.popupMenuTable().get(stSymbol);
    }

    public HashMap popupMenuTable() {
        if (this.popupMenuTable == null) {
            this.popupMenuTable = new HashMap();
        }
        return this.popupMenuTable;
    }

    public void update_(DependentEvent dependentEvent) {
        if (!this.isShowing()) {
            return;
        }
        this.getDrawingMapModel().updateMenuIndication();
        StSymbol stSymbol = dependentEvent.getAspect();
        if (stSymbol == JunDrawingMapViewAwt.$((String)"redisplay")) {
            if (dependentEvent.getParameter() == null) {
                this.updateCanvasSize_(this.canvas().getSize());
            } else {
                this._invalidateRectangle_repairNow_((Rectangle)dependentEvent.getParameter(), true);
            }
            return;
        }
        if (stSymbol == JunDrawingMapViewAwt.$((String)"bounds")) {
            this.updateCanvasSize_(this.scrollPane().getViewportSize());
            return;
        }
        if (stSymbol == JunDrawingMapViewAwt.$((String)"selection")) {
            if (dependentEvent.getParameter() == null) {
                Rectangle rectangle = this.areaOfElements_(this.getDrawingMapModel().mapObject()._componentElements());
                if (rectangle != null) {
                    rectangle.grow(3, 3);
                }
                this._invalidateRectangle_repairNow_(rectangle, true);
            } else {
                this._invalidateRectangle_repairNow_((Rectangle)dependentEvent.getParameter(), true);
            }
            return;
        }
        if (stSymbol == JunDrawingMapViewAwt.$((String)"location")) {
            this.updateCanvasSize_(this.canvas().getSize());
            return;
        }
        if (stSymbol == JunDrawingMapViewAwt.$((String)"zoom")) {
            this.offScreenImage = null;
            this.offScreenSize = null;
            this.updateCanvasSize_(this.scrollPane().getViewportSize());
            return;
        }
        super.update_(dependentEvent);
    }

    protected void updateCanvasSize_(Dimension dimension) {
        Dimension dimension2 = this.getDrawingMapModel().scaledSize();
        Dimension dimension3 = new Dimension(Math.max(dimension2.width, dimension.width), Math.max(dimension2.height, dimension.height));
        if (!this.canvas().getSize().equals(dimension3)) {
            this.canvas().setSize(dimension3);
            this.scrollPane().doLayout();
            this.offScreenImage = null;
            this.offScreenSize = null;
        }
        Rectangle rectangle = new Rectangle(this.scrollPane().getScrollPosition(), this.scrollPane().getViewportSize());
        if (this.getDrawingMapModel().isZooming()) {
            Jun2dPoint jun2dPoint = this.getDrawingMapModel().scalePoint();
            rectangle = new Rectangle((int)Math.floor((double)rectangle.x / jun2dPoint.x()), (int)Math.floor((double)rectangle.y / jun2dPoint.y()), (int)Math.ceil((double)rectangle.width / jun2dPoint.x()), (int)Math.ceil((double)rectangle.height / jun2dPoint.y()));
            rectangle.grow(5, 5);
        }
        this._invalidateRectangle_repairNow_(rectangle, true);
    }
}

