/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.drawing.element;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Map;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual;
import jp.co.sra.jun.goodies.drawing.element.JunRectangularElement;
import jp.co.sra.jun.goodies.drawing.properties.JunDrawingElementPropertiesModel;
import jp.co.sra.jun.goodies.drawing.properties.JunRectangularShapePropertiesModel;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.smalltalk.StBlockClosure;

public abstract class JunRectangularShapeElement
extends JunRectangularElement {
    protected Color foregroundColor;
    protected Color backgroundColor;
    protected int lineWidth;
    protected transient Shape shape;
    protected transient BasicStroke stroke;
    protected transient JunRectangularShapePropertiesModel propertiesModel;
    public static final int MIN_LINE_WIDTH = 0;
    public static final int MAX_LINE_WIDTH = 20;

    public JunRectangularShapeElement() {
    }

    public JunRectangularShapeElement(JunLispList junLispList) {
        super(junLispList);
    }

    protected void initialize() {
        super.initialize();
        this.foregroundColor = Color.black;
        this.backgroundColor = Color.white;
        this.lineWidth = 1;
        this.shape = null;
        this.stroke = null;
        this.propertiesModel = null;
    }

    public void release() {
        super.release();
        if (this.propertiesModel != null) {
            this.propertiesModel.closeRequest();
            this.propertiesModel = null;
        }
    }

    public JunDrawingVisual postCopy(Map map) {
        super.postCopy(map);
        this.foregroundColor_(new Color(this.foregroundColor.getRGB(), true));
        if (this.backgroundColor != null) {
            this.backgroundColor_(new Color(this.backgroundColor.getRGB(), true));
        }
        this.flushBounds();
        this.shape = null;
        this.stroke = null;
        this.propertiesModel = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayOn_(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle != null && !rectangle.intersects(this.bounds())) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            Shape shape = this.shape();
            if (this.backgroundColor() != null) {
                graphics2D.setColor(this.backgroundColor());
                graphics2D.fill(shape);
            }
            if (this.foregroundColor() != null && this.lineWidth() > 0) {
                graphics2D.setColor(this.foregroundColor());
                graphics2D.setStroke(new BasicStroke(this.lineWidth()));
                graphics2D.draw(shape);
            }
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
    }

    protected void flushBounds() {
        super.flushBounds();
        this.stroke = null;
        this.shape = null;
    }

    public boolean isShape() {
        return true;
    }

    public boolean containsPoint_(Point point) {
        if (this.backgroundColor() == null) {
            return this.stroke().createStrokedShape(this.shape()).contains(point);
        }
        return this.shape().contains(point) || this.stroke().createStrokedShape(this.shape()).contains(point);
    }

    public boolean intersects_(Rectangle rectangle) {
        if (this.backgroundColor() == null) {
            return this.stroke().createStrokedShape(this.shape()).intersects(rectangle);
        }
        return this.shape().intersects(rectangle) || this.stroke().createStrokedShape(this.shape()).intersects(rectangle);
    }

    public Color foregroundColor() {
        return this.foregroundColor;
    }

    public void foregroundColor_(Color color) {
        this.foregroundColor = color;
    }

    public Color backgroundColor() {
        return this.backgroundColor;
    }

    public void backgroundColor_(Color color) {
        this.backgroundColor = color;
    }

    public int lineWidth() {
        return this.lineWidth;
    }

    public void lineWidth_(int n) {
        this.lineWidth = Math.min(Math.max(n, 0), 20);
        this.flushBounds();
    }

    public JunDrawingElementPropertiesModel propertiesModel() {
        if (this.propertiesModel == null) {
            this.propertiesModel = new JunRectangularShapePropertiesModel(this);
        }
        return this.propertiesModel;
    }

    protected abstract Shape shape();

    protected BasicStroke stroke() {
        if (this.stroke == null) {
            this.stroke = new BasicStroke(this.lineWidth());
        }
        return this.stroke;
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons = super.toLispList();
        junLispCons.add_((Object)this.foregroundColorToLispList());
        junLispCons.add_((Object)this.backgroundColorToLispList());
        junLispCons.add_((Object)this.lineWidthToLispList());
        return junLispCons;
    }

    protected JunLispCons foregroundColorToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunRectangularShapeElement.$((String)"foregroundColor"));
        junLispCons.tail_(this.foregroundColor());
        return junLispCons;
    }

    protected JunLispCons backgroundColorToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunRectangularShapeElement.$((String)"backgroundColor"));
        junLispCons.tail_(this.backgroundColor());
        return junLispCons;
    }

    protected JunLispCons lineWidthToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunRectangularShapeElement.$((String)"lineWidth"));
        junLispCons.tail_(new Integer(this.lineWidth()));
        return junLispCons;
    }

    public void fromLispList_(JunLispList junLispList) {
        super.fromLispList_(junLispList);
        this.foregroundColorFromLispList_(junLispList);
        this.backgroundColorFromLispList_(junLispList);
        this.lineWidthFromLispList_(junLispList);
    }

    protected void foregroundColorFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 1.$((String)"foregroundColor"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        this.foregroundColor_((Color)junLispList2.tail());
    }

    protected void backgroundColorFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 2.$((String)"backgroundColor"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        this.backgroundColor_((Color)junLispList2.tail());
    }

    protected void lineWidthFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 3.$((String)"lineWidth"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        this.lineWidth_(((Number)junLispList2.tail()).intValue());
    }
}

