/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.drawing.element;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingElement;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual;
import jp.co.sra.jun.goodies.drawing.element.JunNodeElement;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;

public abstract class JunCompositeElement
extends JunNodeElement {
    protected ArrayList componentElements;
    protected transient Rectangle preferredBounds;

    public JunCompositeElement() {
    }

    public JunCompositeElement(JunLispList junLispList) {
        super(junLispList);
    }

    protected void initialize() {
        super.initialize();
        this.componentElements = null;
        this.preferredBounds = null;
    }

    protected void initializeComponentElements() {
        this.flushComponentElements();
    }

    public ArrayList componentElements() {
        if (this.componentElements == null) {
            this.componentElements = new ArrayList();
        }
        return this.componentElements;
    }

    public void componentElements_(ArrayList arrayList) {
        this.componentElements = arrayList;
        if (this.componentElements != null && this.componentElements.size() > 0) {
            JunDrawingElement[] junDrawingElementArray = this._componentElements();
            for (int i = 0; i < junDrawingElementArray.length; ++i) {
                junDrawingElementArray[i].parent_(this);
            }
        }
        this.flushBounds();
    }

    public JunDrawingElement[] _componentElements() {
        JunDrawingElement[] junDrawingElementArray = new JunDrawingElement[this.componentElementSize()];
        this.componentElements().toArray(junDrawingElementArray);
        return junDrawingElementArray;
    }

    public JunDrawingElement componentElementAt_(int n) {
        if (this.componentElements().isEmpty()) {
            return null;
        }
        if (n < 0 || this.componentElementSize() <= n) {
            return null;
        }
        return (JunDrawingElement)this.componentElements().get(n);
    }

    public int componentElementIndexOf_(JunDrawingElement junDrawingElement) {
        return this.componentElements().indexOf(junDrawingElement);
    }

    public int componentElementSize() {
        return this.componentElements().size();
    }

    public boolean addElement_(JunDrawingElement junDrawingElement) {
        if (junDrawingElement == null || this.componentElements().contains(junDrawingElement)) {
            return false;
        }
        this.flushBounds();
        junDrawingElement.parent_(this);
        return this.componentElements().add(junDrawingElement);
    }

    public void addElement_beforeIndex_(JunDrawingElement junDrawingElement, int n) {
        if (junDrawingElement == null || this.componentElements().contains(junDrawingElement)) {
            return;
        }
        junDrawingElement.parent_(this);
        if (0 <= n && n < this.componentElementSize()) {
            this.componentElements().add(n, junDrawingElement);
        } else {
            this.componentElements().add(junDrawingElement);
        }
        this.flushBounds();
    }

    public Rectangle preferredBounds() {
        if (this.preferredBounds == null) {
            JunDrawingElement[] junDrawingElementArray = this._componentElements();
            for (int i = 0; i < junDrawingElementArray.length; ++i) {
                if (this.preferredBounds == null) {
                    this.preferredBounds = new Rectangle(junDrawingElementArray[i].bounds());
                    continue;
                }
                this.preferredBounds.add(junDrawingElementArray[i].bounds());
            }
        }
        return this.preferredBounds;
    }

    public void controllPointAt_put_(StSymbol stSymbol, Point point) {
        int n;
        Rectangle rectangle = this.bounds();
        Point point2 = this.controllPointAt_(stSymbol);
        boolean bl = stSymbol == JunDrawingElement.CONTROLL_POINT_TOP_LEFT || stSymbol == JunDrawingElement.CONTROLL_POINT_TOP_RIGHT;
        boolean bl2 = stSymbol == JunDrawingElement.CONTROLL_POINT_TOP_LEFT || stSymbol == JunDrawingElement.CONTROLL_POINT_BOTTOM_LEFT;
        int n2 = Math.max(point.x, 0) - point2.x;
        int n3 = Math.max(point.y, 0) - point2.y;
        int n4 = bl2 ? Math.max(rectangle.x + n2, 0) : rectangle.x;
        int n5 = bl ? Math.max(rectangle.y + n3, 0) : rectangle.y;
        int n6 = bl2 ? rectangle.width + (rectangle.x - n4) : Math.max(rectangle.width + n2, this.defaultMinimumExtent().width);
        int n7 = n = bl ? rectangle.height + (rectangle.y - n5) : Math.max(rectangle.height + n3, this.defaultMinimumExtent().height);
        if (n6 < this.defaultMinimumExtent().width) {
            n4 += n6 - this.defaultMinimumExtent().width;
            n6 = this.defaultMinimumExtent().width;
        }
        if (n < this.defaultMinimumExtent().height) {
            n5 += n - this.defaultMinimumExtent().height;
            n = this.defaultMinimumExtent().height;
        }
        this.bounds_(new Rectangle(n4, n5, n6, n));
    }

    public JunDrawingVisual postCopy(Map map) {
        super.postCopy(map);
        ArrayList arrayList = new ArrayList();
        JunDrawingElement[] junDrawingElementArray = this._componentElements();
        for (int i = 0; i < junDrawingElementArray.length; ++i) {
            arrayList.add(map.containsKey(junDrawingElementArray[i]) ? map.get(junDrawingElementArray[i]) : junDrawingElementArray[i].copy(map));
        }
        this.componentElements_(arrayList);
        return this;
    }

    public void displayOn_(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null || rectangle.intersects(this.bounds())) {
            JunDrawingElement[] junDrawingElementArray = this._componentElements();
            for (int i = 0; i < junDrawingElementArray.length; ++i) {
                junDrawingElementArray[i].displayOn_(graphics);
            }
        }
    }

    public Object elementsDo_(StBlockClosure stBlockClosure) {
        JunDrawingElement[] junDrawingElementArray = this._componentElements();
        for (int i = 0; i < junDrawingElementArray.length; ++i) {
            stBlockClosure.value_((Object)junDrawingElementArray[i]);
            if (!junDrawingElementArray[i].isComposite()) continue;
            ((JunCompositeElement)junDrawingElementArray[i]).elementsDo_(stBlockClosure);
        }
        return this;
    }

    public JunDrawingElement findElement_(long l) {
        JunDrawingElement junDrawingElement = super.findElement_(l);
        if (junDrawingElement != null) {
            return junDrawingElement;
        }
        Iterator iterator = this.componentElements().iterator();
        while (iterator.hasNext()) {
            junDrawingElement = ((JunDrawingElement)iterator.next()).findElement_(l);
            if (junDrawingElement == null) continue;
            return junDrawingElement;
        }
        return null;
    }

    protected void flushBounds() {
        this.preferredBounds = null;
    }

    protected void flushComponentElements() {
        this.componentElements = null;
    }

    public boolean removeElement_(JunDrawingElement junDrawingElement) {
        if (!this.componentElements().contains(junDrawingElement)) {
            return false;
        }
        boolean bl = this.componentElements().remove(junDrawingElement);
        junDrawingElement.parent_(null);
        this.flushBounds();
        return bl;
    }

    public JunDrawingElement which_(Point point) {
        ListIterator listIterator = this.componentElements().listIterator(this.componentElementSize());
        while (listIterator.hasPrevious()) {
            JunDrawingElement junDrawingElement = (JunDrawingElement)listIterator.previous();
            if (!junDrawingElement.containsPoint_(point)) continue;
            return junDrawingElement;
        }
        return null;
    }

    public boolean isComposite() {
        return true;
    }

    public boolean isEmpty() {
        return this.componentElements().isEmpty();
    }

    public boolean isRectangular() {
        return true;
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons = super.toLispList();
        JunLispCons junLispCons2 = this.componentElementsToLispList();
        if (junLispCons2 != null) {
            junLispCons.add_((Object)junLispCons2);
        }
        return junLispCons;
    }

    protected JunLispCons componentElementsToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunCompositeElement.$((String)"componentElements"));
        JunDrawingElement[] junDrawingElementArray = this._componentElements();
        for (int i = 0; i < junDrawingElementArray.length; ++i) {
            junLispCons.add_((Object)junDrawingElementArray[i].toLispList());
        }
        return junLispCons;
    }

    public void fromLispList_(JunLispList junLispList) {
        super.fromLispList_(junLispList);
        this.componentElementsFromLispList_(junLispList);
    }

    protected void componentElementsFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 1.$((String)"componentElements"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        this.flushComponentElements();
        Object[] objectArray = ((JunLispList)((Object)junLispList2.tail())).asArray();
        for (int i = 0; i < objectArray.length; ++i) {
            JunDrawingElement junDrawingElement = JunDrawingElement.FromLispList_((JunLispList)((Object)objectArray[i]));
            this.addElement_(junDrawingElement);
        }
    }
}

