/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.drawing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import jp.co.sra.jun.goodies.button.JunButtonModel;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.drawing.JunDrawingView;
import jp.co.sra.jun.goodies.drawing.JunDrawingViewAwt;
import jp.co.sra.jun.goodies.drawing.JunDrawingViewSwing;
import jp.co.sra.jun.goodies.drawing.map.JunDrawingMap;
import jp.co.sra.jun.goodies.drawing.map.JunDrawingMapModel;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.smalltalk.DependentListener;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuItem;

public class JunDrawing
extends JunApplicationModel {
    protected JunDrawingMapModel mapModel;
    protected JunButtonModel selectButton;
    protected JunButtonModel brushButton;
    protected JunButtonModel cameraButton;
    protected JunButtonModel ellipseButton;
    protected JunButtonModel linkButton;
    protected JunButtonModel pathButton;
    protected JunButtonModel rectangleButton;
    protected JunButtonModel roundRectangleButton;
    protected JunButtonModel textButton;
    protected JunButtonModel textboxButton;
    protected StMenuBar _menuBar;

    public JunDrawing() {
    }

    public JunDrawing(JunDrawingMap junDrawingMap) {
        this.mapObject_(junDrawingMap);
    }

    protected void initialize() {
        super.initialize();
        this.mapModel = null;
        this.selectButton = null;
        this.brushButton = null;
        this.cameraButton = null;
        this.ellipseButton = null;
        this.linkButton = null;
        this.pathButton = null;
        this.rectangleButton = null;
        this.roundRectangleButton = null;
        this.textButton = null;
        this.textboxButton = null;
        this._menuBar = null;
    }

    public void release() {
        super.release();
        this.mapModel().release();
    }

    public JunDrawingMap mapObject() {
        return this.mapModel().mapObject();
    }

    public void mapObject_(JunDrawingMap junDrawingMap) {
        this.mapModel().mapObject_(junDrawingMap);
    }

    public JunDrawingMapModel mapModel() {
        if (this.mapModel == null) {
            this.mapModel = new JunDrawingMapModel(null);
        }
        return this.mapModel;
    }

    public JunDrawingView getDrawingView() {
        DependentListener[] dependentListenerArray = this.dependents();
        for (int i = 0; i < dependentListenerArray.length; ++i) {
            DependentListener dependentListener = dependentListenerArray[i];
            if (!(dependentListener instanceof StView) || ((StView)dependentListener).model() != this || !(dependentListener instanceof JunDrawingView)) continue;
            return (JunDrawingView)dependentListener;
        }
        return null;
    }

    public JunButtonModel selectButton() {
        if (this.selectButton == null) {
            this.selectButton = new JunButtonModel(false, JunCursors.NormalCursorImage(), new StBlockClosure(){

                public Object value_(Object object) {
                    JunDrawing.this.getDrawingView().drawingMapView().editMode_(0);
                    return null;
                }
            });
        }
        return this.selectButton;
    }

    public JunButtonModel brushButton() {
        if (this.brushButton == null) {
            this.brushButton = new JunButtonModel(false, JunCursors.BrushCursorImage(), new StBlockClosure(){

                public Object value_(Object object) {
                    JunDrawing.this.getDrawingView().drawingMapView().editMode_(8);
                    return null;
                }
            });
        }
        return this.brushButton;
    }

    public JunButtonModel cameraButton() {
        if (this.cameraButton == null) {
            this.cameraButton = new JunButtonModel(false, JunCursors.CameraCursorImage(), new StBlockClosure(){

                public Object value_(Object object) {
                    JunDrawing.this.getDrawingView().drawingMapView().editMode_(3);
                    return null;
                }
            });
        }
        return this.cameraButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JunButtonModel ellipseButton() {
        if (this.ellipseButton == null) {
            BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            try {
                graphics2D.setColor(Color.black);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.drawOval(0, 0, 15, 15);
            }
            finally {
                graphics2D.dispose();
            }
            this.ellipseButton = new JunButtonModel(false, bufferedImage, new StBlockClosure(){

                public Object value_(Object object) {
                    JunDrawing.this.getDrawingView().drawingMapView().editMode_(6);
                    return null;
                }
            });
        }
        return this.ellipseButton;
    }

    public JunButtonModel linkButton() {
        if (this.linkButton == null) {
            this.linkButton = new JunButtonModel(false, JunCursors.ArrowCursorImage(), new StBlockClosure(){

                public Object value_(Object object) {
                    JunDrawing.this.getDrawingView().drawingMapView().editMode_(9);
                    return null;
                }
            });
        }
        return this.linkButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JunButtonModel pathButton() {
        if (this.pathButton == null) {
            BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            try {
                graphics2D.setColor(Color.black);
                graphics2D.drawLine(1, 8, 14, 8);
            }
            finally {
                graphics2D.dispose();
            }
            this.pathButton = new JunButtonModel(false, bufferedImage, new StBlockClosure(){

                public Object value_(Object object) {
                    JunDrawing.this.getDrawingView().drawingMapView().editMode_(7);
                    return null;
                }
            });
        }
        return this.pathButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JunButtonModel rectangleButton() {
        if (this.rectangleButton == null) {
            BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            try {
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(0, 0, 15, 15);
            }
            finally {
                graphics2D.dispose();
            }
            this.rectangleButton = new JunButtonModel(false, bufferedImage, new StBlockClosure(){

                public Object value_(Object object) {
                    JunDrawing.this.getDrawingView().drawingMapView().editMode_(4);
                    return null;
                }
            });
        }
        return this.rectangleButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JunButtonModel roundRectangleButton() {
        if (this.roundRectangleButton == null) {
            BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            try {
                int[] nArray = new int[]{3, 12, 15, 15, 12, 3, 0, 0, 3};
                int[] nArray2 = new int[]{0, 0, 3, 12, 15, 15, 12, 3, 0};
                graphics2D.setColor(Color.black);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.drawPolygon(new Polygon(nArray, nArray2, nArray.length));
            }
            finally {
                graphics2D.dispose();
            }
            this.roundRectangleButton = new JunButtonModel(false, bufferedImage, new StBlockClosure(){

                public Object value_(Object object) {
                    JunDrawing.this.getDrawingView().drawingMapView().editMode_(5);
                    return null;
                }
            });
        }
        return this.roundRectangleButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JunButtonModel textButton() {
        if (this.textButton == null) {
            BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            try {
                graphics2D.setColor(Color.black);
                graphics2D.setStroke(new BasicStroke(2.0f));
                graphics2D.drawLine(2, 2, 14, 2);
                graphics2D.drawLine(8, 2, 8, 14);
            }
            finally {
                graphics2D.dispose();
            }
            this.textButton = new JunButtonModel(false, bufferedImage, new StBlockClosure(){

                public Object value_(Object object) {
                    JunDrawing.this.getDrawingView().drawingMapView().editMode_(1);
                    return null;
                }
            });
        }
        return this.textButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JunButtonModel textboxButton() {
        if (this.textboxButton == null) {
            BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            try {
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(0, 0, 15, 15);
                graphics2D.setStroke(new BasicStroke(2.0f));
                graphics2D.drawLine(4, 4, 12, 4);
                graphics2D.drawLine(8, 4, 8, 12);
            }
            finally {
                graphics2D.dispose();
            }
            this.textboxButton = new JunButtonModel(false, bufferedImage, new StBlockClosure(){

                public Object value_(Object object) {
                    JunDrawing.this.getDrawingView().drawingMapView().editMode_(2);
                    return null;
                }
            });
        }
        return this.textboxButton;
    }

    public StView defaultView() {
        if (JunDrawing.GetDefaultViewMode() == 0) {
            return new JunDrawingViewAwt(this);
        }
        return new JunDrawingViewSwing(this);
    }

    protected String windowTitle() {
        return JunDrawing.$String((String)"Drawing");
    }

    public void updateMenuIndication() {
        this.mapModel().updateMenuIndication();
    }

    public JunDrawing newMap() {
        JunDrawing junDrawing = new JunDrawing(new JunDrawingMap());
        junDrawing.open();
        return junDrawing;
    }

    public void quitDoing() {
        this.closeRequest();
    }

    public StMenuBar _menuBar() {
        if (this._menuBar == null) {
            this._menuBar = new StMenuBar();
            this._menuBar.add(this._createFileMenu());
            this._menuBar.add((StMenu)this.mapModel()._menuBar().atNameKey_(JunDrawing.$((String)"viewMenu")));
            this._menuBar.add((StMenu)this.mapModel()._menuBar().atNameKey_(JunDrawing.$((String)"elementMenu")));
            this._menuBar.add((StMenu)this.mapModel()._menuBar().atNameKey_(JunDrawing.$((String)"miscMenu")));
        }
        return this._menuBar;
    }

    public StMenu _createFileMenu() {
        StMenu stMenu = (StMenu)this.mapModel()._menuBar().atNameKey_(JunDrawing.$((String)"fileMenu"));
        StMenu stMenu2 = new StMenu((Object)JunDrawing.$String((String)"File"), JunDrawing.$((String)"fileMenu"));
        stMenu2.add(new StMenuItem((Object)JunDrawing.$String((String)"New"), JunDrawing.$((String)"newMap"), (MenuListener)new MenuPerformer((StObject)this, "newMap"), 78, 2));
        stMenu2.add(stMenu.atNameKey_(JunDrawing.$((String)"openMap")));
        stMenu2.addSeparator();
        stMenu2.add(stMenu.atNameKey_(JunDrawing.$((String)"saveMap")));
        stMenu2.add(stMenu.atNameKey_(JunDrawing.$((String)"saveAsMap")));
        stMenu2.addSeparator();
        stMenu2.add(new StMenuItem((Object)JunDrawing.$String((String)"Close"), JunDrawing.$((String)"quitDoing"), (MenuListener)new MenuPerformer((StObject)this, "quitDoing")));
        return stMenu2;
    }

    public void updateToolbar_(int n) {
        this.selectButton().value_(false);
        this.textButton().value_(false);
        this.textboxButton().value_(false);
        this.cameraButton().value_(false);
        this.rectangleButton().value_(false);
        this.roundRectangleButton().value_(false);
        this.ellipseButton().value_(false);
        this.pathButton().value_(false);
        this.brushButton().value_(false);
        this.linkButton().value_(false);
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.textButton().value_(true);
                break;
            }
            case 2: {
                this.textboxButton().value_(true);
                break;
            }
            case 3: {
                this.cameraButton().value_(true);
                break;
            }
            case 4: {
                this.rectangleButton().value_(true);
                break;
            }
            case 5: {
                this.roundRectangleButton().value_(true);
                break;
            }
            case 6: {
                this.ellipseButton().value_(true);
                break;
            }
            case 7: {
                this.pathButton().value_(true);
                break;
            }
            case 8: {
                this.brushButton().value_(true);
                break;
            }
            case 9: {
                this.linkButton().value_(true);
            }
        }
    }
}

