/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.catalog;

import java.io.File;
import java.util.Arrays;
import jp.co.sra.jun.goodies.catalog.JunVisualCatalog;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer;
import jp.co.sra.jun.goodies.utilities.JunStringUtility;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.qt4jun.JunQTMovie;
import jp.co.sra.smalltalk.StBlockClosure;

public class JunMovieCatalog
extends JunVisualCatalog {
    protected double[] visualClip;

    public JunMovieCatalog() {
    }

    public JunMovieCatalog(File file) {
        super(file);
    }

    public JunMovieCatalog(File file, File file2) {
        super(file, file2);
    }

    public static JunVisualCatalog Dive_(File file) {
        return JunMovieCatalog._Dive_catalog_(file, new JunMovieCatalog());
    }

    public static JunVisualCatalog Dive_block_(File file, StBlockClosure stBlockClosure) {
        return JunMovieCatalog._Dive_block_catalog_(file, stBlockClosure, new JunMovieCatalog());
    }

    protected void initialize() {
        super.initialize();
        this.visualClip = null;
    }

    public double[] visualClip() {
        return this.visualClip;
    }

    public void visualClip_(double[] dArray) {
        this.visualClip = dArray;
    }

    public String defaultTitleString() {
        return "Movie Catalog";
    }

    public String defaultVisualCatalogDirectoryName() {
        return "MovieCatalog";
    }

    public String defaultVisualClipDirectoryName() {
        return "movies";
    }

    public File[] visualClipFiles() {
        File[] fileArray = this.originalVisualFiles();
        File[] fileArray2 = new File[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            File file;
            String string = fileArray[i].getName();
            fileArray2[i] = file = new File(this.visualClipDirectory(), string);
        }
        return fileArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeVisualClipFiles() {
        this.progressValue.value_(0.0f);
        int n = 1;
        File[] fileArray = this.originalVisualFiles();
        File[] fileArray2 = this.visualClipFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            String string = JunMovieCatalog.$String((String)"Movie:") + " " + fileArray2[i].getName();
            this.progressMessage.value_((Object)JunStringUtility._ContractString_to_(string, this.defaultContractLength()));
            if (!fileArray[i].equals(fileArray2[i])) {
                JunMoviePlayer junMoviePlayer = null;
                try {
                    junMoviePlayer = new JunMoviePlayer(fileArray[i]);
                    junMoviePlayer.trackerModel().enableMarkers();
                    if (this.visualClip() == null) {
                        junMoviePlayer.trackerModel().lastMarker_(1.0);
                        junMoviePlayer.trackerModel().firstMarker_(0.0);
                    } else {
                        junMoviePlayer.trackerModel().lastMarker_(this.visualClip()[1]);
                        junMoviePlayer.trackerModel().firstMarker_(this.visualClip()[0]);
                    }
                    this.saveMovie_into_(junMoviePlayer, fileArray2[i]);
                }
                finally {
                    if (junMoviePlayer != null) {
                        junMoviePlayer.release();
                        junMoviePlayer = null;
                    }
                }
            }
            this.progressValue.value_((float)n / (float)this.numberOfVisuals());
            ++n;
        }
    }

    public boolean incluesExtensions_(String string) {
        String string2 = string.toLowerCase();
        return Arrays.asList(JunSystem.DefaultMovieExtensions()).contains(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveMovie_into_(JunMoviePlayer junMoviePlayer, File file) {
        int n = 0;
        int n2 = 0;
        if (junMoviePlayer.isIntervalNotEmpty()) {
            n = Math.round((float)(junMoviePlayer.trackerModel().firstMarker() * (double)junMoviePlayer.movieHandle().duration()));
            n2 = Math.round((float)((junMoviePlayer.trackerModel().lastMarker() - junMoviePlayer.trackerModel().firstMarker()) * (double)junMoviePlayer.movieHandle().duration()));
        } else {
            n = 0;
            n2 = junMoviePlayer.movieHandle().duration();
        }
        JunQTMovie junQTMovie = null;
        JunCursors junCursors = new JunCursors(JunCursors.ExecuteCursor());
        try {
            junCursors._show();
            junMoviePlayer.movieHandle().selection_duration_(n, n2);
            junQTMovie = junMoviePlayer.movieHandle().copyMovie();
        }
        finally {
            junCursors._restore();
        }
        if (junQTMovie == null) {
            return;
        }
        junCursors = new JunCursors(JunCursors.WriteCursor());
        try {
            junCursors._show();
            junQTMovie.flattenToFile(file);
        }
        finally {
            junQTMovie.release();
            junCursors._restore();
        }
    }
}

