/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.calendar;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.Iterator;
import java.util.Vector;
import jp.co.sra.jun.goodies.calendar.JunCalendarDateController;
import jp.co.sra.jun.goodies.calendar.JunCalendarDateModel;
import jp.co.sra.jun.goodies.calendar.JunCalendarDateView;
import jp.co.sra.jun.system.framework.JunAbstractViewCanvas;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;

public class JunCalendarDateViewAwt
extends JunAbstractViewCanvas
implements JunCalendarDateView {
    protected Vector frames;

    public JunCalendarDateViewAwt(JunApplicationModel junApplicationModel) {
        super(junApplicationModel);
    }

    public Vector frames() {
        if (this.frames == null) {
            this.makeFrames();
        }
        return this.frames;
    }

    private void makeFrames() {
        Vector<Object[]> vector = new Vector<Object[]>();
        int n = this.getSize().width / 7;
        int n2 = this.getSize().height / 8;
        StRectangle stRectangle = StRectangle.Origin_extent_((Point)new Point(0, 0), (Point)new Point(12, 16));
        int n3 = n * 1;
        int n4 = 0;
        StRectangle stRectangle2 = StRectangle.Origin_extent_((Point)new Point(n3, n4), (Point)new Point(n * 2, n2));
        vector.add(new Object[]{JunCalendarDateViewAwt.$((String)"year"), stRectangle2});
        stRectangle = stRectangle.align_with_(stRectangle.rightCenter(), stRectangle2.leftCenter());
        vector.add(new Object[]{JunCalendarDateViewAwt.$((String)"button"), JunCalendarDateViewAwt.$((String)"yearDown"), stRectangle});
        stRectangle = stRectangle.align_with_(stRectangle.leftCenter(), stRectangle2.rightCenter());
        vector.add(new Object[]{JunCalendarDateViewAwt.$((String)"button"), JunCalendarDateViewAwt.$((String)"yearUp"), stRectangle});
        n3 = n * 4;
        n4 = 0;
        stRectangle2 = StRectangle.Origin_extent_((Point)new Point(n3, n4), (Point)new Point(n * 2, n2));
        vector.add(new Object[]{JunCalendarDateViewAwt.$((String)"month"), stRectangle2});
        stRectangle = stRectangle.align_with_(stRectangle.rightCenter(), stRectangle2.leftCenter());
        vector.add(new Object[]{JunCalendarDateViewAwt.$((String)"button"), JunCalendarDateViewAwt.$((String)"monthDown"), stRectangle});
        stRectangle = stRectangle.align_with_(stRectangle.leftCenter(), stRectangle2.rightCenter());
        vector.add(new Object[]{JunCalendarDateViewAwt.$((String)"button"), JunCalendarDateViewAwt.$((String)"monthUp"), stRectangle});
        n3 = 0;
        n4 = n2 * 1;
        for (int i = 0; i < this.getModel().weekdayNames().length; ++i) {
            stRectangle2 = StRectangle.Origin_extent_((Point)new Point(n3, n4), (Point)new Point(n, n2));
            vector.add(new Object[]{JunCalendarDateViewAwt.$((String)"weekday"), new Integer(i), stRectangle2});
            n3 += n;
        }
        int[][] nArray = this.getModel().calendarMatrix();
        n4 = n2 * 2;
        n2 = (this.getBounds().height - n4) / nArray.length;
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray2 = nArray[i];
            n3 = 0;
            for (int j = 0; j < nArray[i].length; ++j) {
                if (nArray2[j] != 0) {
                    stRectangle2 = StRectangle.Origin_extent_((Point)new Point(n3, n4), (Point)new Point(n, n2));
                    vector.add(new Object[]{JunCalendarDateViewAwt.$((String)"day"), new Point(j, i), stRectangle2});
                }
                n3 += n;
            }
            n4 += n2;
        }
        this.frames = vector;
    }

    public void displayOn_(Graphics graphics) {
        this.displayBordersOn_(graphics);
        this.displayObjectsOn_(graphics);
    }

    public void displayBordersOn_(Graphics graphics) {
        Iterator iterator = this.frames().iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            StSymbol stSymbol = (StSymbol)objectArray[0];
            StRectangle stRectangle = (StRectangle)objectArray[objectArray.length - 1];
            StRectangle stRectangle2 = new StRectangle(graphics.getClipBounds());
            if (!stRectangle2.intersects_(stRectangle) || stSymbol != JunCalendarDateViewAwt.$((String)"year") && stSymbol != JunCalendarDateViewAwt.$((String)"month") && stSymbol != JunCalendarDateViewAwt.$((String)"day")) continue;
            graphics.setColor(veryLightGray);
            graphics.fillRect(stRectangle.x(), stRectangle.y(), stRectangle.width(), stRectangle.height());
            StRectangle stRectangle3 = stRectangle.insetBy_(StRectangle.Origin_corner_((Point)new Point(1, 1), (Point)new Point(2, 2)));
            graphics.setColor(veryDarkGray);
            graphics.drawRect(stRectangle3.x(), stRectangle3.y(), stRectangle3.width(), stRectangle3.height());
            if (stSymbol == JunCalendarDateViewAwt.$((String)"year") || stSymbol == JunCalendarDateViewAwt.$((String)"month")) {
                stRectangle3 = stRectangle.insetBy_(StRectangle.Origin_corner_((Point)new Point(2, 2), (Point)new Point(3, 3)));
                graphics.setColor(Color.black);
                graphics.drawRect(stRectangle3.x(), stRectangle3.y(), stRectangle3.width(), stRectangle3.height());
            }
            if (stSymbol != JunCalendarDateViewAwt.$((String)"day")) continue;
            Point point = (Point)objectArray[1];
            int n = this.getModel().atPoint_(point);
            if (this.getModel().day() != n) continue;
            stRectangle3 = stRectangle.insetBy_(StRectangle.Origin_corner_((Point)new Point(2, 2), (Point)new Point(3, 3)));
            graphics.setColor(Color.black);
            graphics.drawRect(stRectangle3.x(), stRectangle3.y(), stRectangle3.width(), stRectangle3.height());
        }
    }

    public void displayObjectsOn_(Graphics graphics) {
        Iterator iterator = this.frames().iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            StSymbol stSymbol = (StSymbol)objectArray[0];
            StRectangle stRectangle = (StRectangle)objectArray[objectArray.length - 1];
            if (stSymbol == JunCalendarDateViewAwt.$((String)"year")) {
                this.displayOn_year_clip_(graphics, stSymbol, stRectangle);
            }
            if (stSymbol == JunCalendarDateViewAwt.$((String)"month")) {
                this.displayOn_month_clip_(graphics, stSymbol, stRectangle);
            }
            if (stSymbol == JunCalendarDateViewAwt.$((String)"weekday")) {
                this.displayOn_weekday_clip_(graphics, (Integer)objectArray[1], stRectangle);
            }
            if (stSymbol == JunCalendarDateViewAwt.$((String)"day")) {
                this.displayOn_day_clip_(graphics, (Point)objectArray[1], stRectangle);
            }
            if (stSymbol != JunCalendarDateViewAwt.$((String)"button")) continue;
            this.displayOn_button_clip_(graphics, (StSymbol)objectArray[1], stRectangle);
        }
    }

    public void displayOn_year_clip_(Graphics graphics, StSymbol stSymbol, StRectangle stRectangle) {
        int n = this.getModel().year();
        StComposedText stComposedText = new StComposedText(String.valueOf(n));
        StRectangle stRectangle2 = new StRectangle(stComposedText.bounds());
        StRectangle stRectangle3 = stRectangle2.align_with_(stRectangle2.center(), stRectangle.center());
        StRectangle stRectangle4 = new StRectangle(graphics.getClipBounds());
        if (stRectangle4.intersects_(stRectangle3)) {
            graphics.setColor(Color.black);
            stComposedText.displayOn_at_(graphics, stRectangle3.origin());
        }
    }

    public void displayOn_month_clip_(Graphics graphics, StSymbol stSymbol, StRectangle stRectangle) {
        int n = this.getModel().month();
        StComposedText stComposedText = new StComposedText(String.valueOf(n));
        StRectangle stRectangle2 = new StRectangle(stComposedText.bounds());
        StRectangle stRectangle3 = stRectangle2.align_with_(stRectangle2.center(), stRectangle.center());
        StRectangle stRectangle4 = new StRectangle(graphics.getClipBounds());
        if (stRectangle4.intersects_(stRectangle3)) {
            graphics.setColor(Color.black);
            stComposedText.displayOn_at_(graphics, stRectangle3.origin());
        }
    }

    public void displayOn_day_clip_(Graphics graphics, Point point, StRectangle stRectangle) {
        int n = this.getModel().atPoint_(point);
        StComposedText stComposedText = new StComposedText(String.valueOf(n));
        StRectangle stRectangle2 = new StRectangle(stComposedText.bounds());
        StRectangle stRectangle3 = stRectangle2.align_with_(stRectangle2.center(), stRectangle.center());
        StRectangle stRectangle4 = new StRectangle(graphics.getClipBounds());
        if (stRectangle4.intersects_(stRectangle3)) {
            graphics.setColor(Color.black);
            if (point.x == 0) {
                graphics.setColor(Color.red);
            }
            if (point.x == 6) {
                graphics.setColor(Color.blue);
            }
            stComposedText.displayOn_at_(graphics, stRectangle3.origin());
        }
    }

    public void displayOn_weekday_clip_(Graphics graphics, Integer n, StRectangle stRectangle) {
        String string = this.getModel().weekdayNames()[n];
        StComposedText stComposedText = new StComposedText(string);
        StRectangle stRectangle2 = new StRectangle(stComposedText.bounds());
        StRectangle stRectangle3 = stRectangle2.align_with_(stRectangle2.center(), stRectangle.center());
        StRectangle stRectangle4 = new StRectangle(graphics.getClipBounds());
        if (stRectangle4.intersects_(stRectangle3)) {
            graphics.setColor(Color.black);
            if (n == 0) {
                graphics.setColor(Color.red);
            }
            if (n == 6) {
                graphics.setColor(Color.blue);
            }
            stComposedText.displayOn_at_(graphics, stRectangle3.origin());
        }
    }

    public void displayOn_button_clip_(Graphics graphics, StSymbol stSymbol, StRectangle stRectangle) {
        StRectangle stRectangle2 = stRectangle;
        StRectangle stRectangle3 = new StRectangle(graphics.getClipBounds());
        if (stRectangle3.intersects_(stRectangle2)) {
            Polygon polygon;
            if (stSymbol == JunCalendarDateViewAwt.$((String)"yearDown") || stSymbol == JunCalendarDateViewAwt.$((String)"monthDown")) {
                polygon = new Polygon();
                polygon.addPoint(stRectangle2.topRight().x, stRectangle2.topRight().y);
                polygon.addPoint(stRectangle2.bottomRight().x, stRectangle2.bottomRight().y);
                polygon.addPoint(stRectangle2.leftCenter().x, stRectangle2.leftCenter().y);
                polygon.addPoint(stRectangle2.topRight().x, stRectangle2.topRight().y);
            } else {
                polygon = new Polygon();
                polygon.addPoint(stRectangle2.topLeft().x, stRectangle2.topLeft().y);
                polygon.addPoint(stRectangle2.bottomLeft().x, stRectangle2.bottomLeft().y);
                polygon.addPoint(stRectangle2.rightCenter().x, stRectangle2.rightCenter().y);
                polygon.addPoint(stRectangle2.topLeft().x, stRectangle2.topLeft().y);
            }
            graphics.setColor(veryLightGray);
            graphics.fillPolygon(polygon);
            stRectangle2 = stRectangle2.insetBy_(new StRectangle(1, 1, 2, 2));
            if (stSymbol == JunCalendarDateViewAwt.$((String)"yearDown") || stSymbol == JunCalendarDateViewAwt.$((String)"monthDown")) {
                polygon = new Polygon();
                polygon.addPoint(stRectangle2.topRight().x, stRectangle2.topRight().y);
                polygon.addPoint(stRectangle2.bottomRight().x, stRectangle2.bottomRight().y);
                polygon.addPoint(stRectangle2.leftCenter().x, stRectangle2.leftCenter().y);
                polygon.addPoint(stRectangle2.topRight().x, stRectangle2.topRight().y);
            } else {
                polygon = new Polygon();
                polygon.addPoint(stRectangle2.topLeft().x, stRectangle2.topLeft().y);
                polygon.addPoint(stRectangle2.bottomLeft().x, stRectangle2.bottomLeft().y);
                polygon.addPoint(stRectangle2.rightCenter().x, stRectangle2.rightCenter().y);
                polygon.addPoint(stRectangle2.topLeft().x, stRectangle2.topLeft().y);
            }
            graphics.setColor(veryDarkGray);
            graphics.drawPolygon(polygon);
        }
    }

    public void update_(DependentEvent dependentEvent) {
        this.makeFrames();
        if (!this.isShowing()) {
            return;
        }
        if (dependentEvent.getAspect() == JunCalendarDateViewAwt.$((String)"day")) {
            this.repaint();
        }
        if (dependentEvent.getAspect() == JunCalendarDateViewAwt.$((String)"month")) {
            this.repaint();
        }
        if (dependentEvent.getAspect() == JunCalendarDateViewAwt.$((String)"year")) {
            this.repaint();
        }
        super.update_(dependentEvent);
    }

    protected void buildComponent() {
        this.setSize(300, 200);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.makeFrames();
    }

    public JunCalendarDateModel getModel() {
        return (JunCalendarDateModel)this.model();
    }

    protected StController defaultController() {
        return new JunCalendarDateController();
    }

    protected StModel defaultModel() {
        return new JunCalendarDateModel();
    }
}

