/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.transformations;

import java.io.IOException;
import java.io.Writer;
import jp.co.sra.jun.collections.sequences.JunDoubleMatrix;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.transformations.JunTransformation;

public class Jun2dTransformation
extends JunTransformation {
    protected double a;
    protected double b;
    protected double p;
    protected double c;
    protected double d;
    protected double q;
    protected double m;
    protected double n;
    protected double s;

    public static Jun2dTransformation FromArray_(double[] dArray) {
        Jun2dTransformation jun2dTransformation = new Jun2dTransformation();
        jun2dTransformation.a = dArray[0];
        jun2dTransformation.b = dArray[1];
        jun2dTransformation.p = dArray[2];
        jun2dTransformation.c = dArray[3];
        jun2dTransformation.d = dArray[4];
        jun2dTransformation.q = dArray[5];
        jun2dTransformation.m = dArray[6];
        jun2dTransformation.n = dArray[7];
        jun2dTransformation.s = dArray[8];
        return jun2dTransformation;
    }

    public static Jun2dTransformation MirrorX() {
        Jun2dTransformation jun2dTransformation = Jun2dTransformation.Unity();
        jun2dTransformation.a = -1.0;
        return jun2dTransformation;
    }

    public static Jun2dTransformation MirrorY() {
        Jun2dTransformation jun2dTransformation = Jun2dTransformation.Unity();
        jun2dTransformation.d = -1.0;
        return jun2dTransformation;
    }

    public static Jun2dTransformation Rotate_(JunAngle junAngle) {
        return Jun2dTransformation.RotateZ_(junAngle);
    }

    public static Jun2dTransformation Rotate_around_(JunAngle junAngle, Jun2dPoint jun2dPoint) {
        JunAngle junAngle2 = (JunAngle)junAngle.copy();
        Jun2dPoint jun2dPoint2 = new Jun2dPoint(jun2dPoint);
        Jun2dTransformation jun2dTransformation = Jun2dTransformation.Translate_(jun2dPoint2.negated());
        Jun2dTransformation jun2dTransformation2 = Jun2dTransformation.Rotate_(junAngle2);
        Jun2dTransformation jun2dTransformation3 = Jun2dTransformation.Translate_(jun2dPoint2);
        Jun2dTransformation jun2dTransformation4 = jun2dTransformation.product_(jun2dTransformation2);
        jun2dTransformation4 = jun2dTransformation4.product_(jun2dTransformation3);
        return jun2dTransformation4;
    }

    public static Jun2dTransformation RotateZ_(JunAngle junAngle) {
        double d = junAngle.cos();
        double d2 = junAngle.sin();
        Jun2dTransformation jun2dTransformation = Jun2dTransformation.Unity();
        jun2dTransformation.a = d;
        jun2dTransformation.b = d2;
        jun2dTransformation.c = -d2;
        jun2dTransformation.d = d;
        return jun2dTransformation;
    }

    public static Jun2dTransformation RotateZ_(double d) {
        return Jun2dTransformation.RotateZ_(JunAngle.FromRad_(d));
    }

    public static Jun2dTransformation Scale_(double d) {
        Jun2dTransformation jun2dTransformation = Jun2dTransformation.Unity();
        jun2dTransformation.a = d;
        jun2dTransformation.d = d;
        return jun2dTransformation;
    }

    public static Jun2dTransformation Scale_(Jun2dPoint jun2dPoint) {
        Jun2dTransformation jun2dTransformation = Jun2dTransformation.Unity();
        jun2dTransformation.a = jun2dPoint.x();
        jun2dTransformation.d = jun2dPoint.y();
        return jun2dTransformation;
    }

    public static Jun2dTransformation Translate_(double d) {
        Jun2dTransformation jun2dTransformation = Jun2dTransformation.Unity();
        jun2dTransformation.m = d;
        jun2dTransformation.n = d;
        return jun2dTransformation;
    }

    public static Jun2dTransformation Translate_(Jun2dPoint jun2dPoint) {
        Jun2dTransformation jun2dTransformation = Jun2dTransformation.Unity();
        jun2dTransformation.m = jun2dPoint.x();
        jun2dTransformation.n = jun2dPoint.y();
        return jun2dTransformation;
    }

    public static Jun2dTransformation Unity() {
        Jun2dTransformation jun2dTransformation = new Jun2dTransformation();
        jun2dTransformation.a = 1.0;
        jun2dTransformation.b = 0.0;
        jun2dTransformation.p = 0.0;
        jun2dTransformation.c = 0.0;
        jun2dTransformation.d = 1.0;
        jun2dTransformation.q = 0.0;
        jun2dTransformation.m = 0.0;
        jun2dTransformation.n = 0.0;
        jun2dTransformation.s = 1.0;
        return jun2dTransformation;
    }

    public static Jun2dTransformation Zero() {
        Jun2dTransformation jun2dTransformation = new Jun2dTransformation();
        jun2dTransformation.a = 0.0;
        jun2dTransformation.b = 0.0;
        jun2dTransformation.p = 0.0;
        jun2dTransformation.c = 0.0;
        jun2dTransformation.d = 0.0;
        jun2dTransformation.q = 0.0;
        jun2dTransformation.m = 0.0;
        jun2dTransformation.n = 0.0;
        jun2dTransformation.s = 0.0;
        return jun2dTransformation;
    }

    public double a() {
        return this.a;
    }

    public double b() {
        return this.b;
    }

    public double c() {
        return this.c;
    }

    public double d() {
        return this.d;
    }

    public double m() {
        return this.m;
    }

    public double n() {
        return this.n;
    }

    public double p() {
        return this.p;
    }

    public double q() {
        return this.q;
    }

    public double s() {
        return this.s;
    }

    public Jun2dPoint applyToPoint_(JunPoint junPoint) {
        double d = junPoint.x();
        double d2 = junPoint.y();
        double d3 = d * this.a + d2 * this.c + this.m;
        double d4 = d * this.b + d2 * this.d + this.n;
        double d5 = d * this.p + d2 * this.q + this.s;
        if (d5 == 0.0) {
            d5 = 1.0E-12;
        }
        return new Jun2dPoint(d3 / d5, d4 / d5);
    }

    public double[] asArray() {
        double[] dArray = new double[]{this.a, this.b, this.p, this.c, this.d, this.q, this.m, this.n, this.s};
        return dArray;
    }

    public JunDoubleMatrix asMatrix() {
        return new JunDoubleMatrix(3, this.asArray());
    }

    public boolean equal_(Object object) {
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Jun2dTransformation jun2dTransformation = (Jun2dTransformation)((Object)object);
        return this.isEqualNumber_to_(this.a, jun2dTransformation.a) && this.isEqualNumber_to_(this.b, jun2dTransformation.b) && this.isEqualNumber_to_(this.p, jun2dTransformation.p) && this.isEqualNumber_to_(this.c, jun2dTransformation.c) && this.isEqualNumber_to_(this.d, jun2dTransformation.d) && this.isEqualNumber_to_(this.q, jun2dTransformation.q) && this.isEqualNumber_to_(this.m, jun2dTransformation.m) && this.isEqualNumber_to_(this.n, jun2dTransformation.n) && this.isEqualNumber_to_(this.s, jun2dTransformation.s);
    }

    public boolean equals(Object object) {
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Jun2dTransformation jun2dTransformation = (Jun2dTransformation)((Object)object);
        return this.a == jun2dTransformation.a && this.b == jun2dTransformation.b && this.p == jun2dTransformation.p && this.c == jun2dTransformation.c && this.d == jun2dTransformation.d && this.q == jun2dTransformation.q && this.m == jun2dTransformation.m && this.n == jun2dTransformation.n && this.s == jun2dTransformation.s;
    }

    public Jun2dTransformation inverse() {
        return Jun2dTransformation.FromArray_(this.asMatrix().inverse().asArrayOfDouble());
    }

    public JunTransformation _inverse() {
        return this.inverse();
    }

    public boolean is2d() {
        return true;
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write("2dTransformation (");
        writer.write(this.a + " " + this.b + " " + this.p);
        writer.write(" ,  ");
        writer.write(this.c + " " + this.d + " " + this.q);
        writer.write(" ,  ");
        writer.write(this.m + " " + this.n + " " + this.s);
        writer.write(41);
    }

    public Jun2dTransformation product_(Jun2dTransformation jun2dTransformation) {
        Jun2dTransformation jun2dTransformation2 = new Jun2dTransformation();
        jun2dTransformation2.a = this.a * jun2dTransformation.a + this.b * jun2dTransformation.c + this.p * jun2dTransformation.m;
        jun2dTransformation2.b = this.a * jun2dTransformation.b + this.b * jun2dTransformation.d + this.p * jun2dTransformation.n;
        jun2dTransformation2.p = this.a * jun2dTransformation.p + this.b * jun2dTransformation.q + this.p * jun2dTransformation.s;
        jun2dTransformation2.c = this.c * jun2dTransformation.a + this.d * jun2dTransformation.c + this.q * jun2dTransformation.m;
        jun2dTransformation2.d = this.c * jun2dTransformation.b + this.d * jun2dTransformation.d + this.q * jun2dTransformation.n;
        jun2dTransformation2.q = this.c * jun2dTransformation.p + this.d * jun2dTransformation.q + this.q * jun2dTransformation.s;
        jun2dTransformation2.m = this.m * jun2dTransformation.a + this.n * jun2dTransformation.c + this.s * jun2dTransformation.m;
        jun2dTransformation2.n = this.m * jun2dTransformation.b + this.n * jun2dTransformation.d + this.s * jun2dTransformation.n;
        jun2dTransformation2.s = this.m * jun2dTransformation.p + this.n * jun2dTransformation.q + this.s * jun2dTransformation.s;
        return jun2dTransformation2;
    }

    public Jun2dTransformation transform_(Jun2dTransformation jun2dTransformation) {
        return this.product_(jun2dTransformation);
    }
}

