/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.surfaces;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.utilities.JunControlUtility;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;

public class JunPlaneTestExamples
extends JunTestExamples {
    public static boolean Example1() {
        JunPlane junPlane = new JunPlane(new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(0.0, 10.0, 0.0), new Jun3dPoint(10.0, 20.0, 30.0));
        System.out.println(junPlane.printString());
        return true;
    }

    public static boolean Example2() {
        final JunPlane junPlane = new JunPlane(new Jun3dPoint(-2.0, -2.0, -2.0), new Jun3dPoint(0.0, 2.0, 0.0), new Jun3dPoint(2.0, 0.0, 0.0));
        Jun3dPoint jun3dPoint = new Jun3dPoint(0.0, 0.0, 300.0);
        Jun3dPoint jun3dPoint2 = new Jun3dPoint(0.0, 0.0, 0.0);
        Jun3dPoint jun3dPoint3 = new Jun3dPoint(40.0, 40.0, 40.0);
        Jun3dPoint jun3dPoint4 = new Jun3dPoint(200.0, 200.0, 0.0);
        final Jun3dTransformation jun3dTransformation = Jun3dTransformation.Translate_(jun3dPoint2.negated());
        final Jun3dTransformation jun3dTransformation2 = Jun3dTransformation.Scale_(jun3dPoint3);
        final Jun3dTransformation jun3dTransformation3 = Jun3dTransformation.Perspective_(jun3dPoint);
        final Jun3dTransformation jun3dTransformation4 = Jun3dTransformation.Translate_(jun3dPoint4);
        final Canvas canvas = new Canvas();
        canvas.setBounds(0, 0, 400, 400);
        Frame frame = new Frame();
        frame.setTitle("Jun3dLine");
        frame.setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().dispose();
            }
        });
        frame.add(canvas);
        frame.pack();
        StApplicationModel._ShowAtMousePoint((Window)frame);
        new Thread(){

            public void run() {
                final Graphics2D graphics2D = (Graphics2D)canvas.getGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (int i = 0; i <= 360; i += 4) {
                    Jun3dTransformation jun3dTransformation5 = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(i));
                    Jun3dTransformation jun3dTransformation22 = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(i));
                    Jun3dTransformation jun3dTransformation32 = Jun3dTransformation.RotateX_(JunAngle.FromDeg_(i));
                    Jun3dTransformation jun3dTransformation42 = jun3dTransformation.product_(jun3dTransformation2).product_(jun3dTransformation5).product_(jun3dTransformation22).product_(jun3dTransformation32).product_(jun3dTransformation3).product_(jun3dTransformation4);
                    final Point point = Jun3dPoint.Zero().transform_(jun3dTransformation4).asPoint();
                    final JunPlane junPlane2 = junPlane.transform_(jun3dTransformation42);
                    JunControlUtility.Do_forMilliseconds_(new StBlockClosure(){

                        public Object value() {
                            graphics2D.clearRect(0, 0, canvas.getWidth(), canvas.getHeight());
                            graphics2D.setColor(Color.blue);
                            graphics2D.drawArc(point.x, point.y, 2, 2, 0, 360);
                            graphics2D.setColor(Color.red);
                            Point[][] pointArray = junPlane2.asPointArrays();
                            for (int i = 0; i < pointArray.length; ++i) {
                                int[] nArray = new int[pointArray[i].length];
                                int[] nArray2 = new int[pointArray[i].length];
                                for (int j = 0; j < pointArray[i].length; ++j) {
                                    nArray[j] = pointArray[i][j].x;
                                    nArray2[j] = pointArray[i][j].y;
                                }
                                graphics2D.drawPolyline(nArray, nArray2, nArray.length);
                            }
                            return null;
                        }
                    }, 100);
                }
            }
        }.start();
        return true;
    }

    public static boolean Example3() {
        Jun3dLine jun3dLine = new Jun3dLine(new Jun3dPoint(1.0, 1.0, 1.0), new Jun3dPoint(0.5, 0.5, 0.5));
        ArrayList<Jun3dLine> arrayList = new ArrayList<Jun3dLine>();
        int n = 1;
        for (int i = 0; i <= 350; i += 10) {
            arrayList.add(jun3dLine.first().to_(jun3dLine.atT_(0.5 + (double)n / 36.0 * 0.5)).transform_(Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(i), new Jun3dPoint(0.0, 0.0, 0.0).to_(new Jun3dPoint(1.0, 1.0, 2.0)))));
            ++n;
        }
        JunPlane junPlane = new JunPlane(new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(1.0, 0.0, 0.0), new Jun3dPoint(0.0, 1.0, 0.0));
        ArrayList<JunPlane> arrayList2 = new ArrayList<JunPlane>();
        for (int i = 0; i <= 360; i += 5) {
            arrayList2.add(junPlane.transform_(Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(i), new Jun3dPoint(0.0, 0.0, 0.0).to_(new Jun3dPoint(1.0, 1.0, 0.0)))));
        }
        final Jun3dLine[] jun3dLineArray = arrayList.toArray(new Jun3dLine[arrayList.size()]);
        JunPlane[] junPlaneArray = arrayList2.toArray(new JunPlane[arrayList2.size()]);
        JunOpenGLDisplayModel junOpenGLDisplayModel = new JunOpenGLDisplayModel();
        junOpenGLDisplayModel.openIn_(new Rectangle(100, 100, 600, 600));
        for (int i = 0; i < junPlaneArray.length; ++i) {
            final JunPlane junPlane2 = junPlaneArray[i];
            final JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
            JunControlUtility.Do_forMilliseconds_(new StBlockClosure(){

                public Object value() {
                    for (int i = 0; i < jun3dLineArray.length; ++i) {
                        Jun3dLine jun3dLine = jun3dLineArray[i];
                        Jun3dLine jun3dLine2 = junPlane2.reflectingLineWithLine_(jun3dLine);
                        junOpenGL3dCompoundObject.add_(JunOpenGL3dObject.ArrowLine_color_lineWidth_(jun3dLine, Color.getHSBColor((float)i / (float)jun3dLineArray.length, 1.0f, 1.0f), 2.0f));
                        JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dObject.CircleBy_radius_upVector_(10.0, 2.5, junPlane2.normalVector()).translatedBy_(junPlane2.first());
                        junOpenGL3dObject.polygonsDo_(new StBlockClosure(){

                            public Object value_(Object object) {
                                JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)object);
                                junOpenGL3dObject.paint_(StColorValue.VeryLightGray);
                                junOpenGL3dObject.halftone_(0.5);
                                return null;
                            }
                        });
                        junOpenGL3dCompoundObject.add_(junOpenGL3dObject);
                        Jun3dPoint jun3dPoint = junPlane2.intersectingPointWithLine_(jun3dLine);
                        if (jun3dPoint != null) {
                            junOpenGL3dCompoundObject.add_(new JunOpenGL3dPolyline(new Jun3dPoint[]{jun3dLine.last(), jun3dPoint}, Color.gray));
                        }
                        if ((jun3dPoint = junPlane2.intersectingPointWithLine_(jun3dLine2)) != null) {
                            junOpenGL3dCompoundObject.add_(new JunOpenGL3dPolyline(new Jun3dPoint[]{jun3dPoint, jun3dLine2.first()}, Color.gray));
                        }
                        junOpenGL3dCompoundObject.add_(JunOpenGL3dObject.ArrowLine_color_lineWidth_(jun3dLine2, Color.getHSBColor((float)i / (float)jun3dLineArray.length, 1.0f, 1.0f), 2.0f));
                    }
                    return null;
                }
            }, 25);
            junOpenGLDisplayModel.displayObject_(junOpenGL3dCompoundObject);
            junOpenGLDisplayModel.resetView();
        }
        return true;
    }

    public static void main(String[] stringArray) {
        new JunPlaneTestExamples();
    }

    public static boolean Test1() {
        JunPlane junPlane = new JunPlane(new Jun3dPoint(-2.0, -2.0, 0.0), new Jun3dPoint(0.0, 2.0, 0.0), new Jun3dPoint(2.0, 0.0, 0.0));
        Jun3dLine jun3dLine = new Jun3dLine(new Jun3dPoint(0.0, 0.0, -2.0), new Jun3dPoint(0.0, 0.0, 2.0));
        Jun3dPoint jun3dPoint = junPlane.intersectingPointWithLine_(jun3dLine);
        return jun3dPoint.x() == 0.0 && jun3dPoint.y() == 0.0 && jun3dPoint.z() == 0.0;
    }

    public static boolean Test2() {
        JunPlane junPlane = new JunPlane(new Jun3dPoint(0.0, 0.0, 0.0), new Jun3dPoint(1.0, 0.0, 0.0), new Jun3dPoint(0.0, 1.0, 0.0));
        Jun3dLine jun3dLine = new Jun3dLine(new Jun3dPoint(0.0, 0.0, -2.0), new Jun3dPoint(0.0, 0.0, -1.0));
        Jun3dPoint jun3dPoint = junPlane.intersectingPointWithLine_(jun3dLine);
        return jun3dPoint.x() == 0.0 && jun3dPoint.y() == 0.0 && jun3dPoint.z() == 0.0;
    }

    public static boolean Test3() {
        JunPlane junPlane = new JunPlane(new Jun3dPoint(-2.0, -2.0, 0.0), new Jun3dPoint(2.0, 0.0, 0.0), new Jun3dPoint(-2.0, 2.0, 0.0));
        Jun3dPoint jun3dPoint = junPlane.normalUnitVector();
        return jun3dPoint.x() == 0.0 && jun3dPoint.y() == 0.0 && jun3dPoint.z() == 1.0;
    }

    public static boolean Test4() {
        JunPlane junPlane = new JunPlane(new Jun3dPoint(2.0, 0.0, 0.0), new Jun3dPoint(0.0, 2.0, 0.0), new Jun3dPoint(0.0, 0.0, 2.0));
        Jun3dPoint jun3dPoint = junPlane.normalUnitVector();
        return jun3dPoint.x() == 0.5773502691896258 && jun3dPoint.y() == 0.5773502691896258 && jun3dPoint.z() == 0.5773502691896258;
    }

    public static boolean Test5() {
        JunPlane junPlane = new JunPlane(new Jun3dPoint(-2.0, -2.0, 0.0), new Jun3dPoint(0.0, 2.0, 0.0), new Jun3dPoint(2.0, 0.0, 0.0));
        Jun3dLine jun3dLine = new Jun3dLine(new Jun3dPoint(0.0, 0.0, -2.0), new Jun3dPoint(0.0, 0.0, 2.0));
        JunAngle junAngle = junPlane.angleWithLine_(jun3dLine);
        return junAngle.deg() == -90.0;
    }

    public static boolean Test6() {
        JunPlane junPlane = new JunPlane(1.0, 1.0, 1.0, 1.0);
        System.out.println(junPlane.printString());
        junPlane.asJunOpenGL3dObject().showWithUnitAxes();
        return true;
    }

    public static boolean Test7() {
        JunPlane junPlane = new JunPlane(new Jun3dPoint(-2.0, -2.0, 0.0), new Jun3dPoint(0.0, 2.0, 0.0), new Jun3dPoint(2.0, 0.0, 0.0));
        JunPlane junPlane2 = new JunPlane(new Jun3dPoint(0.0, -2.0, -2.0), new Jun3dPoint(0.0, 2.0, 0.0), new Jun3dPoint(0.0, 0.0, 2.0));
        Jun3dLine jun3dLine = junPlane.intersectingLineWithPlane_(junPlane2);
        System.out.println((Object)jun3dLine);
        return true;
    }

    public static boolean Test8() {
        JunPlane junPlane = new JunPlane(new Jun3dPoint(-2.0, -2.0, -2.0), new Jun3dPoint(0.0, 2.0, 0.0), new Jun3dPoint(2.0, 0.0, 0.0));
        JunPlane junPlane2 = new JunPlane(new Jun3dPoint(-2.0, -2.0, -2.0), new Jun3dPoint(0.0, 2.0, 0.0), new Jun3dPoint(0.0, 0.0, 2.0));
        JunPlane junPlane3 = new JunPlane(new Jun3dPoint(-2.0, -2.0, -2.0), new Jun3dPoint(2.0, 0.0, 0.0), new Jun3dPoint(0.0, 0.0, 2.0));
        Jun3dPoint jun3dPoint = junPlane.intersectingPointWithPlane_wihtPlane_(junPlane2, junPlane3);
        System.out.println((Object)jun3dPoint);
        return true;
    }
}

