/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.surfaces;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBall;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.pluralities.Jun3dBoundingBalls;
import jp.co.sra.jun.geometry.pluralities.Jun3dBoundingBoxes;
import jp.co.sra.jun.geometry.pluralities.Jun3dTriangles;
import jp.co.sra.jun.geometry.surfaces.Jun3dCircle;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.geometry.surfaces.JunTriangle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.smalltalk.StSymbol;

public class Jun3dTriangle
extends JunTriangle {
    protected Jun3dPoint p1;
    protected Jun3dPoint p2;
    protected Jun3dPoint p3;

    private Jun3dTriangle() {
    }

    public Jun3dTriangle(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3) {
        this.setP1_(jun3dPoint);
        this.setP2_(jun3dPoint2);
        this.setP3_(jun3dPoint3);
    }

    public static Jun3dTriangle First_second_third_(JunPoint junPoint, JunPoint junPoint2, JunPoint junPoint3) {
        return Jun3dTriangle.On_on_on_(junPoint, junPoint2, junPoint3);
    }

    public static Jun3dTriangle On_on_on_(JunPoint junPoint, JunPoint junPoint2, JunPoint junPoint3) {
        Jun3dPoint jun3dPoint = Jun3dPoint.Coerce_(junPoint);
        Jun3dPoint jun3dPoint2 = Jun3dPoint.Coerce_(junPoint2);
        Jun3dPoint jun3dPoint3 = Jun3dPoint.Coerce_(junPoint3);
        if (jun3dPoint.equals((Object)jun3dPoint2) || jun3dPoint.equals((Object)jun3dPoint3) || jun3dPoint2.equals((Object)jun3dPoint3)) {
            return null;
        }
        return new Jun3dTriangle(jun3dPoint, jun3dPoint2, jun3dPoint3);
    }

    public static Jun3dTriangle On_normalVector_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        return Jun3dTriangle.On_normalVector_distance_(jun3dPoint, jun3dPoint2, 1.0);
    }

    public static Jun3dTriangle On_normalVector_distance_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, double d) {
        return Jun3dTriangle.On_normalVector_distance_rightVector_(jun3dPoint, jun3dPoint2, d, new Jun3dPoint(1.0, 0.0, 0.0));
    }

    public static Jun3dTriangle On_normalVector_distance_rightVector_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, double d, Jun3dPoint jun3dPoint3) {
        JunPlane junPlane = JunPlane.On_normalVector_(jun3dPoint, jun3dPoint2);
        Jun3dLine jun3dLine = jun3dPoint.to_(jun3dPoint.plus_(jun3dPoint2));
        Jun3dLine jun3dLine2 = jun3dLine.translatedBy_(jun3dPoint3);
        Jun3dPoint jun3dPoint4 = junPlane.intersectingPointWithLine_(jun3dLine2);
        if (Math.abs(jun3dPoint.x() - jun3dPoint4.x()) < Jun3dTriangle.Accuracy() && Math.abs(jun3dPoint.y() - jun3dPoint4.y()) < Jun3dTriangle.Accuracy() && Math.abs(jun3dPoint.z() - jun3dPoint4.z()) < Jun3dTriangle.Accuracy()) {
            Jun3dPoint[] jun3dPointArray = new Jun3dPoint[]{junPlane.p1(), junPlane.p2(), junPlane.p3()};
            TreeMap<Double, Jun3dPoint> treeMap = new TreeMap<Double, Jun3dPoint>();
            for (int i = 0; i < jun3dPointArray.length; ++i) {
                treeMap.put(new Double(jun3dPointArray[i].distance_(jun3dPoint)), jun3dPointArray[i]);
            }
            jun3dPoint4 = (Jun3dPoint)((Object)treeMap.get(treeMap.lastKey()));
        }
        jun3dLine2 = jun3dPoint.to_(jun3dPoint4).normalized();
        jun3dPoint4 = jun3dLine2.atT_(d);
        return Jun3dTriangle.On_on_on_(jun3dPoint4, jun3dPoint4.transform_(Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(120.0), jun3dLine)), jun3dPoint4.transform_(Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(240.0), jun3dLine)));
    }

    public static Jun3dTriangle On_vertical_(Jun3dPoint jun3dPoint, Jun3dLine jun3dLine) {
        return Jun3dTriangle.On_vertical_distance_(jun3dPoint, jun3dLine, 1.0);
    }

    public static Jun3dTriangle On_vertical_distance_(Jun3dPoint jun3dPoint, Jun3dLine jun3dLine, double d) {
        return Jun3dTriangle.On_normalVector_distance_(jun3dPoint, jun3dLine.normalVector(), d);
    }

    public Jun3dBoundingBall boundingBall() {
        return this.asBoundingBall();
    }

    public Jun3dBoundingBox boundingBox() {
        return this.asBoundingBox();
    }

    public Jun3dPoint first() {
        return this.p1();
    }

    public Jun3dPoint middle() {
        return this.p2();
    }

    public Jun3dPoint last() {
        return this.p3();
    }

    public Jun3dPoint p1() {
        return this.p1;
    }

    protected JunPoint _p1() {
        return this.p1();
    }

    public Jun3dPoint p2() {
        return this.p2;
    }

    protected JunPoint _p2() {
        return this.p2();
    }

    public Jun3dPoint p3() {
        return this.p3;
    }

    public Jun3dPoint[] points() {
        return new Jun3dPoint[]{this.p1(), this.p2(), this.p3()};
    }

    protected JunPoint _p3() {
        return this.p3();
    }

    public Jun3dPoint second() {
        return this.p2();
    }

    public Jun3dPoint third() {
        return this.p3();
    }

    public boolean equal_(Object object) {
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Jun3dTriangle jun3dTriangle = (Jun3dTriangle)((Object)object);
        return this.first().equal_((Object)jun3dTriangle.first()) && this.second().equal_((Object)jun3dTriangle.second()) && this.third().equal_((Object)jun3dTriangle.third());
    }

    public boolean equals(Object object) {
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Jun3dTriangle jun3dTriangle = (Jun3dTriangle)((Object)object);
        return this.first().equals((Object)jun3dTriangle.first()) && this.second().equals((Object)jun3dTriangle.second()) && this.third().equals((Object)jun3dTriangle.third());
    }

    public Jun3dLine[] asArrayOfLines() {
        return this.asArrayOf3dLines();
    }

    public Jun3dLine[] asArrayOf3dLines() {
        return new Jun3dLine[0];
    }

    public Jun3dPoint[] asArrayOfPoints() {
        return new Jun3dPoint[]{this.first(), this.second(), this.third()};
    }

    public Jun3dTriangle[] asArrayOfTriangles() {
        return this.asArrayOf3dTriangles();
    }

    public Jun3dTriangle[] asArrayOf3dTriangles() {
        return new Jun3dTriangle[]{this};
    }

    public Jun3dBoundingBall asBoundingBall() {
        return new Jun3dBoundingBall(new Jun3dPoint[]{this.p1(), this.p2(), this.p3()});
    }

    public Jun3dBoundingBalls asBoundingBalls() {
        Jun3dBoundingBalls jun3dBoundingBalls = new Jun3dBoundingBalls();
        ArrayList<Jun3dBoundingBall> arrayList = new ArrayList<Jun3dBoundingBall>();
        arrayList.add(this.asBoundingBall());
        jun3dBoundingBalls.boundingBalls_(arrayList);
        return jun3dBoundingBalls;
    }

    public Jun3dBoundingBox asBoundingBox() {
        return new Jun3dBoundingBox(new Jun3dPoint[]{this.p1(), this.p2(), this.p3()});
    }

    public Jun3dBoundingBoxes asBoundingBoxes() {
        Jun3dBoundingBoxes jun3dBoundingBoxes = new Jun3dBoundingBoxes();
        ArrayList<Jun3dBoundingBox> arrayList = new ArrayList<Jun3dBoundingBox>();
        arrayList.add(this.asBoundingBox());
        jun3dBoundingBoxes.boundingBoxes_(arrayList);
        return jun3dBoundingBoxes;
    }

    public Jun3dCircle asCircle() {
        Jun3dPoint jun3dPoint = this.centerOfCircumcircle();
        return new Jun3dCircle(jun3dPoint, jun3dPoint.distance_(this.p1()), this.normalVector());
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        JunOpenGL3dPolygon junOpenGL3dPolygon = new JunOpenGL3dPolygon(new Jun3dPoint[]{this.p1(), this.p2(), this.p3()});
        junOpenGL3dPolygon.paint_(this.defaultColor());
        return junOpenGL3dPolygon;
    }

    public JunOpenGL3dObject asJunOpenGL3dObjectWithPoints() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.add_(this.asJunOpenGL3dObject());
        JunOpenGL3dObject junOpenGL3dObject = this.p1().asJunOpenGL3dObject();
        junOpenGL3dObject.paint_(Color.red);
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject);
        JunOpenGL3dObject junOpenGL3dObject2 = this.p2().asJunOpenGL3dObject();
        junOpenGL3dObject2.paint_(Color.green);
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject2);
        JunOpenGL3dObject junOpenGL3dObject3 = this.p3().asJunOpenGL3dObject();
        junOpenGL3dObject3.paint_(Color.blue);
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject3);
        return junOpenGL3dCompoundObject;
    }

    public JunPlane asPlane() {
        return new JunPlane(this.p1(), this.p2(), this.p3());
    }

    public Jun3dPoint[] asPointArray() {
        return new Jun3dPoint[]{this.first(), this.second(), this.third(), this.first()};
    }

    public Jun3dTriangle asTriangle() {
        return this;
    }

    public Jun3dTriangles asTriangles() {
        ArrayList<Jun3dTriangle> arrayList = new ArrayList<Jun3dTriangle>();
        arrayList.add(this);
        return new Jun3dTriangles(arrayList);
    }

    public Jun3dPoint[] pointsDividedBy_(JunPlane junPlane) {
        Collection collection = (Collection)this.tableDividedBy_(junPlane).get(Jun3dTriangle.$((String)"points"));
        return collection.toArray(new Jun3dPoint[collection.size()]);
    }

    public Jun3dTriangle[] positivesDividedBy_(JunPlane junPlane) {
        Collection collection = (Collection)this.tableDividedBy_(junPlane).get(Jun3dTriangle.$((String)"positives"));
        return collection.toArray(new Jun3dTriangle[collection.size()]);
    }

    public Jun3dTriangle[] negativesDividedBy_(JunPlane junPlane) {
        Collection collection = (Collection)this.tableDividedBy_(junPlane).get(Jun3dTriangle.$((String)"negatives"));
        return collection.toArray(new Jun3dTriangle[collection.size()]);
    }

    public Jun3dTriangle[] zerosDividedBy_(JunPlane junPlane) {
        Collection collection = (Collection)this.tableDividedBy_(junPlane).get(Jun3dTriangle.$((String)"zeros"));
        return collection.toArray(new Jun3dTriangle[collection.size()]);
    }

    public Jun3dTriangle[] diviedBy_(JunPlane junPlane) {
        Map map = this.tableDividedBy_(junPlane);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll((Collection)map.get(Jun3dTriangle.$((String)"zeros")));
        arrayList.addAll((Collection)map.get(Jun3dTriangle.$((String)"positives")));
        return arrayList.toArray(new Jun3dTriangle[arrayList.size()]);
    }

    public Map tableDividedBy_(JunPlane junPlane) {
        int n;
        ArrayList<Jun3dTriangle> arrayList = new ArrayList<Jun3dTriangle>(3);
        ArrayList<Jun3dTriangle> arrayList2 = new ArrayList<Jun3dTriangle>(3);
        ArrayList<Jun3dTriangle> arrayList3 = new ArrayList<Jun3dTriangle>(3);
        ArrayList<Jun3dPoint> arrayList4 = new ArrayList<Jun3dPoint>(3);
        JunPlane junPlane2 = this.asPlane();
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[]{this.p1(), this.p2(), this.p3()};
        int[] nArray = new int[jun3dPointArray.length];
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (n = 0; n < jun3dPointArray.length; ++n) {
            nArray[n] = jun3dPointArray[n].whichSideOf_(junPlane);
            if (nArray[n] > 0) {
                bl = true;
                continue;
            }
            if (nArray[n] < 0) {
                bl2 = true;
                continue;
            }
            bl3 = true;
        }
        if (bl3) {
            if (!bl && !bl2) {
                arrayList3.add(this);
                for (n = 0; n < jun3dPointArray.length; ++n) {
                    arrayList4.add(jun3dPointArray[n]);
                }
            } else if (bl && bl2) {
                Jun3dPoint jun3dPoint;
                Jun3dPoint jun3dPoint2 = null;
                ArrayList<Jun3dPoint> arrayList5 = new ArrayList<Jun3dPoint>(2);
                for (int i = 0; i < jun3dPointArray.length; ++i) {
                    jun3dPoint = jun3dPointArray[i];
                    int n2 = nArray[i];
                    if (n2 == 0) {
                        arrayList4.add(jun3dPoint);
                        jun3dPoint2 = jun3dPoint;
                        continue;
                    }
                    arrayList5.add(jun3dPoint);
                }
                Jun3dPoint jun3dPoint3 = (Jun3dPoint)((Object)arrayList5.get(0));
                Jun3dLine jun3dLine = new Jun3dLine(jun3dPoint3, jun3dPoint = (Jun3dPoint)((Object)arrayList5.get(arrayList5.size() - 1)));
                Jun3dPoint jun3dPoint4 = junPlane.intersectingPointWithLine_(jun3dLine);
                if (jun3dPoint4 != null) {
                    arrayList4.add(jun3dPoint4);
                    Jun3dTriangle jun3dTriangle = Jun3dTriangle.On_on_on_(jun3dPoint2, jun3dPoint4, jun3dPoint3);
                    if (jun3dTriangle != null) {
                        if (jun3dPoint2.plus_(jun3dTriangle.normalVector()).whichSideOf_(junPlane2) < 0) {
                            jun3dTriangle = jun3dTriangle.reversed();
                        }
                        if (nArray[Arrays.asList(jun3dPointArray).indexOf((Object)jun3dPoint3)] > 0) {
                            arrayList.add(jun3dTriangle);
                        } else {
                            arrayList2.add(jun3dTriangle);
                        }
                    }
                    if ((jun3dTriangle = Jun3dTriangle.On_on_on_(jun3dPoint2, jun3dPoint4, jun3dPoint)) != null) {
                        if (jun3dPoint2.plus_(jun3dTriangle.normalVector()).whichSideOf_(junPlane2) < 0) {
                            jun3dTriangle = jun3dTriangle.reversed();
                        }
                        if (nArray[Arrays.asList(jun3dPointArray).indexOf((Object)jun3dPoint)] > 0) {
                            arrayList.add(jun3dTriangle);
                        } else {
                            arrayList2.add(jun3dTriangle);
                        }
                    }
                }
            } else {
                if (bl) {
                    arrayList.add(this);
                }
                if (bl2) {
                    arrayList2.add(this);
                }
                for (n = 0; n < jun3dPointArray.length; ++n) {
                    if (nArray[n] != 0) continue;
                    arrayList4.add(jun3dPointArray[n]);
                }
            }
        } else if (bl && bl2) {
            Jun3dPoint jun3dPoint;
            int n3;
            Jun3dPoint jun3dPoint5;
            Jun3dPoint jun3dPoint6;
            ArrayList<Jun3dPoint> arrayList6 = new ArrayList<Jun3dPoint>(2);
            ArrayList<Jun3dPoint> arrayList7 = new ArrayList<Jun3dPoint>(2);
            for (int i = 0; i < jun3dPointArray.length; ++i) {
                jun3dPoint6 = jun3dPointArray[i];
                int n4 = nArray[i];
                if (n4 > 0) {
                    arrayList6.add(jun3dPoint6);
                    continue;
                }
                arrayList7.add(jun3dPoint6);
            }
            if (arrayList6.size() == 1) {
                jun3dPoint5 = (Jun3dPoint)((Object)arrayList6.get(0));
                n3 = 1;
                jun3dPoint6 = (Jun3dPoint)((Object)arrayList7.get(0));
                jun3dPoint = (Jun3dPoint)((Object)arrayList7.get(arrayList7.size() - 1));
            } else {
                jun3dPoint5 = (Jun3dPoint)((Object)arrayList7.get(0));
                n3 = -1;
                jun3dPoint6 = (Jun3dPoint)((Object)arrayList6.get(0));
                jun3dPoint = (Jun3dPoint)((Object)arrayList6.get(arrayList6.size() - 1));
            }
            Jun3dLine jun3dLine = new Jun3dLine(jun3dPoint5, jun3dPoint6);
            Jun3dPoint jun3dPoint7 = junPlane.intersectingPointWithLine_(jun3dLine);
            jun3dLine = new Jun3dLine(jun3dPoint5, jun3dPoint);
            Jun3dPoint jun3dPoint8 = junPlane.intersectingPointWithLine_(jun3dLine);
            if (jun3dPoint7 != null && jun3dPoint8 != null) {
                arrayList4.add(jun3dPoint7);
                arrayList4.add(jun3dPoint8);
                Jun3dTriangle jun3dTriangle = Jun3dTriangle.On_on_on_(jun3dPoint5, jun3dPoint7, jun3dPoint8);
                if (jun3dTriangle != null) {
                    if (jun3dPoint5.plus_(jun3dTriangle.normalVector()).whichSideOf_(junPlane2) < 0) {
                        jun3dTriangle = jun3dTriangle.reversed();
                    }
                    if (n3 > 0) {
                        arrayList.add(jun3dTriangle);
                    } else {
                        arrayList2.add(jun3dTriangle);
                    }
                }
                jun3dTriangle = Jun3dTriangle.On_on_on_(jun3dPoint6, jun3dPoint7, jun3dPoint);
                Jun3dTriangle jun3dTriangle2 = Jun3dTriangle.On_on_on_(jun3dPoint6, jun3dPoint8, jun3dPoint);
                if (jun3dTriangle != null && jun3dTriangle2 != null) {
                    if (jun3dTriangle.area() <= jun3dTriangle2.area()) {
                        jun3dTriangle2 = Jun3dTriangle.On_on_on_(jun3dPoint7, jun3dPoint, jun3dPoint8);
                    } else {
                        jun3dTriangle = Jun3dTriangle.On_on_on_(jun3dPoint7, jun3dPoint6, jun3dPoint8);
                    }
                }
                if (jun3dTriangle != null) {
                    if (jun3dTriangle.p1().plus_(jun3dTriangle.normalVector()).whichSideOf_(junPlane2) < 0) {
                        jun3dTriangle = jun3dTriangle.reversed();
                    }
                    if (n3 > 0) {
                        arrayList2.add(jun3dTriangle);
                    } else {
                        arrayList.add(jun3dTriangle);
                    }
                }
                if (jun3dTriangle2 != null) {
                    if (jun3dTriangle2.p1().plus_(jun3dTriangle2.normalVector()).whichSideOf_(junPlane2) < 0) {
                        jun3dTriangle2 = jun3dTriangle2.reversed();
                    }
                    if (n3 > 0) {
                        arrayList2.add(jun3dTriangle2);
                    } else {
                        arrayList.add(jun3dTriangle2);
                    }
                }
            } else if (n3 > 0) {
                arrayList2.add(this);
            } else {
                arrayList.add(this);
            }
        } else {
            if (bl) {
                arrayList.add(this);
            }
            if (bl2) {
                arrayList2.add(this);
            }
        }
        HashMap<StSymbol, ArrayList<JunGeometry>> hashMap = new HashMap<StSymbol, ArrayList<JunGeometry>>();
        hashMap.put(Jun3dTriangle.$((String)"positives"), arrayList);
        hashMap.put(Jun3dTriangle.$((String)"negatives"), arrayList2);
        hashMap.put(Jun3dTriangle.$((String)"zeros"), arrayList3);
        hashMap.put(Jun3dTriangle.$((String)"points"), arrayList4);
        return hashMap;
    }

    public double area() {
        if (!this.hasArea()) {
            return 0.0;
        }
        double d = this.p1().distance_(this.p2());
        double d2 = this.p2().distance_(this.p3());
        double d3 = this.p3().distance_(this.p1());
        double d4 = (d + d2 + d3) / 2.0;
        double d5 = Math.sqrt(d4 * (d4 - d) * (d4 - d2) * (d4 - d3));
        return d5;
    }

    public double areaWithSign() {
        return this.areaWithSignFromPoint_(new Jun3dPoint(0.0, 0.0, Math.max(Math.max(this.p1().z(), this.p2().z()), this.p3().z()) + 1.0));
    }

    public double areaWithSignFromPoint_(Jun3dPoint jun3dPoint) {
        double d = this.area() * (double)this.asPlane().whichSide_(jun3dPoint);
        return d;
    }

    public Jun3dPoint centerOfCircumcircle() {
        return this.circumcircle().center();
    }

    public Jun3dPoint centerOfIncircle() {
        return this.incircle().center();
    }

    public Jun3dCircle circumcircle() {
        Jun3dPoint jun3dPoint = this.asPlane().normalUnitVector();
        Jun3dPoint jun3dPoint2 = this.p1().center_(this.p2());
        Jun3dLine jun3dLine = new Jun3dLine(jun3dPoint2, jun3dPoint2.plus_(jun3dPoint));
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(90.0), this.p1().to_(this.p2()));
        jun3dLine = jun3dLine.transform_(jun3dTransformation);
        jun3dPoint2 = this.p1().center_(this.p3());
        Jun3dLine jun3dLine2 = new Jun3dLine(jun3dPoint2, jun3dPoint2.plus_(jun3dPoint));
        jun3dTransformation = Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(90.0), this.p1().to_(this.p3));
        jun3dLine2 = jun3dLine2.transform_(jun3dTransformation);
        Jun3dPoint jun3dPoint3 = jun3dLine.intersectingPointWithLine_(jun3dLine2);
        double d = jun3dPoint3.distance_(this.p1());
        return new Jun3dCircle(jun3dPoint3, d, this.normalVector());
    }

    public Jun3dTriangle[] detailedTriangles() {
        Jun3dPoint[] jun3dPointArray;
        Jun3dTriangle[] jun3dTriangleArray = new Jun3dTriangle[4];
        jun3dPointArray = new Jun3dPoint[]{this.p1(), this.p2(), this.p3(), jun3dPointArray[0].center_(jun3dPointArray[1]), jun3dPointArray[1].center_(jun3dPointArray[2]), jun3dPointArray[2].center_(jun3dPointArray[0])};
        jun3dTriangleArray[0] = new Jun3dTriangle(jun3dPointArray[0], jun3dPointArray[3], jun3dPointArray[5]);
        jun3dTriangleArray[1] = new Jun3dTriangle(jun3dPointArray[3], jun3dPointArray[1], jun3dPointArray[4]);
        jun3dTriangleArray[2] = new Jun3dTriangle(jun3dPointArray[4], jun3dPointArray[2], jun3dPointArray[5]);
        jun3dTriangleArray[3] = new Jun3dTriangle(jun3dPointArray[3], jun3dPointArray[4], jun3dPointArray[5]);
        return jun3dTriangleArray;
    }

    public Jun3dTriangle[] detailedTrianglesLevel_(int n) {
        if (n <= 0) {
            return new Jun3dTriangle[]{this};
        }
        ArrayList<Jun3dTriangle> arrayList = new ArrayList<Jun3dTriangle>();
        Jun3dTriangle[] jun3dTriangleArray = this.detailedTriangles();
        for (int i = 0; i < jun3dTriangleArray.length; ++i) {
            Jun3dTriangle[] jun3dTriangleArray2 = jun3dTriangleArray[i].detailedTrianglesLevel_(n - 1);
            for (int j = 0; j < jun3dTriangleArray2.length; ++j) {
                arrayList.add(jun3dTriangleArray2[j]);
            }
        }
        return arrayList.toArray(new Jun3dTriangle[arrayList.size()]);
    }

    public Jun3dCircle incircle() {
        double d = this.peripheryOfTriangle();
        if (d < this.Accuracy()) {
            throw new IllegalStateException("unexpected triangle");
        }
        double d2 = this.p1().distance_(this.p2());
        double d3 = this.p2().distance_(this.p3());
        double d4 = this.p3().distance_(this.p1());
        double d5 = (d3 * this.p1().x() + d4 * this.p2().x() + d2 * this.p3().x()) / d;
        double d6 = (d3 * this.p1().y() + d4 * this.p2().y() + d2 * this.p3().y()) / d;
        double d7 = (d3 * this.p1().z() + d4 * this.p2().z() + d2 * this.p3().z()) / d;
        Jun3dPoint jun3dPoint = new Jun3dPoint(d5, d6, d7);
        double d8 = this.peripheryOfTriangle() / 2.0;
        if (d8 < this.Accuracy()) {
            throw new IllegalStateException("unexpected triangle");
        }
        double d9 = Math.sqrt((d8 - this.p1().distance_(this.p2())) * (d8 - this.p2().distance_(this.p3())) * (d8 - this.p3().distance_(this.p1())) / d8);
        return new Jun3dCircle(jun3dPoint, d9, this.normalVector());
    }

    public Jun3dPoint normalUnitVector() {
        return this.asPlane().normalUnitVector();
    }

    public Jun3dPoint normalVector() {
        return this.asPlane().normalVector();
    }

    public double peripheryOfTriangle() {
        double d = 0.0;
        d += this.p1().distance_(this.p2());
        d += this.p2().distance_(this.p3());
        return d += this.p3().distance_(this.p1());
    }

    public JunPlane[] threePlanes() {
        JunPlane junPlane;
        JunPlane[] junPlaneArray = new JunPlane[3];
        Jun3dLine jun3dLine = this.p1().to_(this.p2());
        Jun3dPoint jun3dPoint = jun3dLine.nearestPointFromPoint_(this.p3());
        junPlaneArray[0] = junPlane = jun3dPoint.plane_(jun3dPoint.to_(this.p3).normalVector());
        jun3dLine = this.p1().to_(this.p3());
        jun3dPoint = jun3dLine.nearestPointFromPoint_(this.p2());
        junPlaneArray[1] = junPlane = jun3dPoint.plane_(jun3dPoint.to_(this.p2).normalVector());
        jun3dLine = this.p2().to_(this.p3());
        jun3dPoint = jun3dLine.nearestPointFromPoint_(this.p1());
        junPlaneArray[2] = junPlane = jun3dPoint.plane_(jun3dPoint.to_(this.p1).normalVector());
        return junPlaneArray;
    }

    public Jun3dTriangle reversed() {
        return Jun3dTriangle.On_on_on_(this.p3(), this.p2(), this.p1());
    }

    public Jun3dTriangles subdivide() {
        return this.subdivide4();
    }

    public Jun3dTriangles subdivide4() {
        return new Jun3dTriangles(this.detailedTriangles());
    }

    public Jun3dTriangles subdivide4Level_(int n) {
        return new Jun3dTriangles(this.detailedTrianglesLevel_(n));
    }

    public Jun3dTriangles subdivideLevel_(int n) {
        return this.subdivide4Level_(n);
    }

    public boolean containsPoint_(Jun3dPoint jun3dPoint) {
        JunPlane[] junPlaneArray = this.threePlanes();
        for (int i = 0; i < junPlaneArray.length; ++i) {
            if (jun3dPoint.whichSideOf_(junPlaneArray[i]) >= 0) continue;
            return false;
        }
        return this.asPlane().distanceFromPoint_(jun3dPoint) < this.Accuracy();
    }

    public boolean is3d() {
        return true;
    }

    public Jun3dTriangle rotatedBy_(JunAngle junAngle) {
        return this.transform_(Jun3dTransformation.Rotate_(junAngle));
    }

    public Jun3dTriangle scaledBy_(double d) {
        return this.transform_(Jun3dTransformation.Scale_(d));
    }

    public Jun3dTriangle scaledBy_(Jun3dPoint jun3dPoint) {
        return this.transform_(Jun3dTransformation.Scale_(jun3dPoint));
    }

    public Jun3dTriangle transform_(Jun3dTransformation jun3dTransformation) {
        return Jun3dTriangle.On_on_on_(this.p1().transform_(jun3dTransformation), this.p2().transform_(jun3dTransformation), this.p3().transform_(jun3dTransformation));
    }

    public Jun3dTriangle translatedBy_(double d) {
        return this.transform_(Jun3dTransformation.Translate_(d));
    }

    public Jun3dTriangle translatedBy_(Jun3dPoint jun3dPoint) {
        return this.transform_(Jun3dTransformation.Translate_(jun3dPoint));
    }

    protected void setP1_(JunPoint junPoint) {
        this.p1 = Jun3dPoint.Coerce_(junPoint);
    }

    protected void setP2_(JunPoint junPoint) {
        this.p2 = Jun3dPoint.Coerce_(junPoint);
    }

    protected void setP3_(JunPoint junPoint) {
        this.p3 = Jun3dPoint.Coerce_(junPoint);
    }
}

