/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.surfaces;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBall;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.pluralities.Jun2dBoundingBalls;
import jp.co.sra.jun.geometry.pluralities.Jun2dBoundingBoxes;
import jp.co.sra.jun.geometry.pluralities.Jun2dTriangles;
import jp.co.sra.jun.geometry.surfaces.Jun2dCircle;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.geometry.surfaces.JunTriangle;
import jp.co.sra.jun.geometry.transformations.Jun2dTransformation;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;

public class Jun2dTriangle
extends JunTriangle {
    protected Jun2dPoint p1;
    protected Jun2dPoint p2;
    protected Jun2dPoint p3;

    private Jun2dTriangle() {
    }

    public Jun2dTriangle(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2, Jun2dPoint jun2dPoint3) {
        this.setP1_(jun2dPoint);
        this.setP2_(jun2dPoint2);
        this.setP3_(jun2dPoint3);
    }

    public static Jun2dTriangle First_second_third_(JunPoint junPoint, JunPoint junPoint2, JunPoint junPoint3) {
        return Jun2dTriangle.On_on_on_(junPoint, junPoint2, junPoint3);
    }

    public static Jun2dTriangle On_on_on_(JunPoint junPoint, JunPoint junPoint2, JunPoint junPoint3) {
        Jun2dPoint jun2dPoint = Jun2dPoint.Coerce_(junPoint);
        Jun2dPoint jun2dPoint2 = Jun2dPoint.Coerce_(junPoint2);
        Jun2dPoint jun2dPoint3 = Jun2dPoint.Coerce_(junPoint3);
        if (jun2dPoint.equals((Object)jun2dPoint2) || jun2dPoint.equals((Object)jun2dPoint3) || jun2dPoint2.equals((Object)jun2dPoint3)) {
            return null;
        }
        return new Jun2dTriangle(jun2dPoint, jun2dPoint2, jun2dPoint3);
    }

    public Jun2dBoundingBall boundingBall() {
        return this.asBoundingBall();
    }

    public Jun2dBoundingBox boundingBox() {
        return this.asBoundingBox();
    }

    public Jun2dPoint first() {
        return this.p1();
    }

    public Jun2dPoint middle() {
        return this.p2();
    }

    public Jun2dPoint last() {
        return this.p3();
    }

    public Jun2dPoint p1() {
        return this.p1;
    }

    protected JunPoint _p1() {
        return this.p1();
    }

    public Jun2dPoint p2() {
        return this.p2;
    }

    protected JunPoint _p2() {
        return this.p2();
    }

    public Jun2dPoint p3() {
        return this.p3;
    }

    public Jun2dPoint[] points() {
        return new Jun2dPoint[]{this.p1(), this.p2(), this.p3()};
    }

    protected JunPoint _p3() {
        return this.p3();
    }

    public Jun2dPoint second() {
        return this.p2();
    }

    public Jun2dPoint third() {
        return this.p3();
    }

    public boolean equal_(Object object) {
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Jun2dTriangle jun2dTriangle = (Jun2dTriangle)((Object)object);
        return this.first().equal_((Object)jun2dTriangle.first()) && this.second().equal_((Object)jun2dTriangle.second()) && this.third().equal_((Object)jun2dTriangle.third());
    }

    public boolean equals(Object object) {
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Jun2dTriangle jun2dTriangle = (Jun2dTriangle)((Object)object);
        return this.first().equals((Object)jun2dTriangle.first()) && this.second().equals((Object)jun2dTriangle.second()) && this.third().equals((Object)jun2dTriangle.third());
    }

    public Jun2dLine[] asArrayOfLines() {
        return this.asArrayOf2dLines();
    }

    public Jun2dLine[] asArrayOf2dLines() {
        return new Jun2dLine[]{this.p1().to_(this.p2()), this.p2().to_(this.p3()), this.p3().to_(this.p1())};
    }

    public JunPlane[] asArrayOfPlanes() {
        return new JunPlane[]{this.asPlane()};
    }

    public Jun2dPoint[] asArrayOfPoints() {
        return new Jun2dPoint[]{this.first(), this.second(), this.third()};
    }

    public Jun2dTriangle[] asArrayOfTriangles() {
        return new Jun2dTriangle[]{this};
    }

    public Jun2dBoundingBall asBoundingBall() {
        return new Jun2dBoundingBall(new Jun2dPoint[]{this.p1(), this.p2(), this.p3()});
    }

    public Jun2dBoundingBalls asBoundingBalls() {
        Jun2dBoundingBalls jun2dBoundingBalls = new Jun2dBoundingBalls();
        ArrayList<Jun2dBoundingBall> arrayList = new ArrayList<Jun2dBoundingBall>();
        arrayList.add(this.asBoundingBall());
        jun2dBoundingBalls.boundingBalls_(arrayList);
        return jun2dBoundingBalls;
    }

    public Jun2dBoundingBox asBoundingBox() {
        return new Jun2dBoundingBox(new Jun2dPoint[]{this.p1(), this.p2(), this.p3()});
    }

    public Jun2dBoundingBoxes asBoundingBoxes() {
        Jun2dBoundingBoxes jun2dBoundingBoxes = new Jun2dBoundingBoxes();
        ArrayList<Jun2dBoundingBox> arrayList = new ArrayList<Jun2dBoundingBox>();
        arrayList.add(this.asBoundingBox());
        jun2dBoundingBoxes.boundingBoxes_(arrayList);
        return jun2dBoundingBoxes;
    }

    public Jun2dCircle asCircle() {
        Jun2dPoint jun2dPoint = this.centerOfCircumcircle();
        return new Jun2dCircle(jun2dPoint, jun2dPoint.distance_(this.p1()));
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        JunOpenGL3dPolygon junOpenGL3dPolygon = new JunOpenGL3dPolygon(new Jun3dPoint[]{Jun3dPoint.Coerce_(this.p1()), Jun3dPoint.Coerce_(this.p2()), Jun3dPoint.Coerce_(this.p3())});
        junOpenGL3dPolygon.paint_(this.defaultColor());
        return junOpenGL3dPolygon;
    }

    public JunOpenGL3dObject asJunOpenGL3dObjectWithPoints() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject.add_(this.asJunOpenGL3dObject());
        JunOpenGL3dObject junOpenGL3dObject = this.p1().asJunOpenGL3dObject();
        junOpenGL3dObject.paint_(Color.red);
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject);
        JunOpenGL3dObject junOpenGL3dObject2 = this.p2().asJunOpenGL3dObject();
        junOpenGL3dObject2.paint_(Color.green);
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject2);
        JunOpenGL3dObject junOpenGL3dObject3 = this.p3().asJunOpenGL3dObject();
        junOpenGL3dObject3.paint_(Color.blue);
        junOpenGL3dCompoundObject.add_(junOpenGL3dObject3);
        return junOpenGL3dCompoundObject;
    }

    public JunPlane asPlane() {
        return new JunPlane(this.p1(), this.p2(), this.p3());
    }

    public Jun2dPoint[] asPointArray() {
        return new Jun2dPoint[]{this.first(), this.second(), this.third(), this.first()};
    }

    public Jun2dTriangle asTriangle() {
        return this;
    }

    public Jun2dTriangles asTriangles() {
        ArrayList<Jun2dTriangle> arrayList = new ArrayList<Jun2dTriangle>();
        arrayList.add(this);
        return new Jun2dTriangles(arrayList);
    }

    public Jun2dPoint[] pointsDividedBy_(Jun2dLine jun2dLine) {
        Collection collection = (Collection)this.tableDividedBy_(jun2dLine).get(Jun2dTriangle.$((String)"points"));
        return collection.toArray(new Jun2dPoint[collection.size()]);
    }

    public Jun2dTriangle[] positivesDividedBy_(Jun2dLine jun2dLine) {
        Collection collection = (Collection)this.tableDividedBy_(jun2dLine).get(Jun2dTriangle.$((String)"positives"));
        return collection.toArray(new Jun2dTriangle[collection.size()]);
    }

    public Jun2dTriangle[] negativesDividedBy_(Jun2dLine jun2dLine) {
        Collection collection = (Collection)this.tableDividedBy_(jun2dLine).get(Jun2dTriangle.$((String)"negatives"));
        return collection.toArray(new Jun2dTriangle[collection.size()]);
    }

    public Jun2dTriangle[] zerosDividedBy_(Jun2dLine jun2dLine) {
        Collection collection = (Collection)this.tableDividedBy_(jun2dLine).get(Jun2dTriangle.$((String)"zeros"));
        return collection.toArray(new Jun2dTriangle[collection.size()]);
    }

    public Jun2dTriangle[] diviedBy_(Jun2dLine jun2dLine) {
        Map map = this.tableDividedBy_(jun2dLine);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll((Collection)map.get(Jun2dTriangle.$((String)"zeros")));
        arrayList.addAll((Collection)map.get(Jun2dTriangle.$((String)"positives")));
        return arrayList.toArray(new Jun2dTriangle[arrayList.size()]);
    }

    public Map tableDividedBy_(Jun2dLine jun2dLine) {
        JunGeometry junGeometry;
        JunPlane junPlane = new JunPlane(jun2dLine.from().as3dPoint(), jun2dLine.to().as3dPoint(), new Jun3dPoint(0.0, 0.0, 1.0));
        Map map = Jun3dTriangle.On_on_on_(this.p1().as3dPoint(), this.p2().as3dPoint(), this.p3.as3dPoint()).tableDividedBy_(junPlane);
        ArrayList<JunGeometry> arrayList = new ArrayList<JunGeometry>();
        Iterator iterator = ((List)map.get(Jun2dTriangle.$((String)"positives"))).iterator();
        while (iterator.hasNext()) {
            junGeometry = (Jun3dTriangle)((Object)iterator.next());
            arrayList.add(new Jun2dTriangle(((Jun3dTriangle)junGeometry).p1().as2dPoint(), ((Jun3dTriangle)junGeometry).p2().as2dPoint(), ((Jun3dTriangle)junGeometry).p3().as2dPoint()));
        }
        map.put(Jun2dTriangle.$((String)"positives"), arrayList);
        arrayList = new ArrayList();
        iterator = ((List)map.get(Jun2dTriangle.$((String)"negatives"))).iterator();
        while (iterator.hasNext()) {
            junGeometry = (Jun3dTriangle)((Object)iterator.next());
            arrayList.add(new Jun2dTriangle(((Jun3dTriangle)junGeometry).p1().as2dPoint(), ((Jun3dTriangle)junGeometry).p2().as2dPoint(), ((Jun3dTriangle)junGeometry).p3().as2dPoint()));
        }
        map.put(Jun2dTriangle.$((String)"negatives"), arrayList);
        arrayList = new ArrayList();
        iterator = ((List)map.get(Jun2dTriangle.$((String)"points"))).iterator();
        while (iterator.hasNext()) {
            junGeometry = (Jun3dPoint)((Object)iterator.next());
            arrayList.add(((Jun3dPoint)junGeometry).as2dPoint());
        }
        map.put(Jun2dTriangle.$((String)"points"), arrayList);
        return map;
    }

    public double area() {
        if (!this.hasArea()) {
            return 0.0;
        }
        double d = this.p1().distance_(this.p2());
        double d2 = this.p2().distance_(this.p3());
        double d3 = this.p3().distance_(this.p1());
        double d4 = (d + d2 + d3) / 2.0;
        double d5 = Math.sqrt(d4 * (d4 - d) * (d4 - d2) * (d4 - d3));
        return d5;
    }

    public double areaWithSign() {
        double d = 0.0;
        d += (this.first().x() - this.second().x()) * (this.first().y() + this.second().y());
        d += (this.second().x() - this.third().x()) * (this.second().y() + this.third().y());
        d += (this.third().x() - this.first().x()) * (this.third().y() + this.first().y());
        return d /= 2.0;
    }

    public Jun2dPoint centerOfCircumcircle() {
        return this.circumcircle().center();
    }

    public Jun2dPoint centerOfIncircle() {
        return this.incircle().center();
    }

    public Jun2dCircle circumcircle() {
        Jun3dPoint jun3dPoint = this.asPlane().normalUnitVector();
        Jun3dPoint jun3dPoint2 = Jun3dPoint.Coerce_(this.p1().center_(this.p2()));
        Jun3dLine jun3dLine = new Jun3dLine(jun3dPoint2, jun3dPoint2.plus_(jun3dPoint));
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(90.0), Jun3dPoint.Coerce_(this.p1()).to_(this.p2()));
        jun3dLine = jun3dLine.transform_(jun3dTransformation);
        jun3dPoint2 = Jun3dPoint.Coerce_(this.p1().center_(this.p3()));
        Jun3dLine jun3dLine2 = new Jun3dLine(jun3dPoint2, jun3dPoint2.plus_(jun3dPoint));
        jun3dTransformation = Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(90.0), this.p1().to_(this.p3));
        jun3dLine2 = jun3dLine2.transform_(jun3dTransformation);
        Jun3dPoint jun3dPoint3 = jun3dLine.intersectingPointWithLine_(jun3dLine2);
        double d = jun3dPoint3.distance_(Jun3dPoint.Coerce_(this.p1()));
        return new Jun2dCircle(Jun2dPoint.Coerce_(jun3dPoint3), d);
    }

    public Jun2dTriangle[] detailedTriangles() {
        Jun2dPoint[] jun2dPointArray;
        Jun2dTriangle[] jun2dTriangleArray = new Jun2dTriangle[4];
        jun2dPointArray = new Jun2dPoint[]{this.p1(), this.p2(), this.p3(), jun2dPointArray[0].center_(jun2dPointArray[1]), jun2dPointArray[1].center_(jun2dPointArray[2]), jun2dPointArray[2].center_(jun2dPointArray[0])};
        jun2dTriangleArray[0] = new Jun2dTriangle(jun2dPointArray[0], jun2dPointArray[3], jun2dPointArray[5]);
        jun2dTriangleArray[1] = new Jun2dTriangle(jun2dPointArray[3], jun2dPointArray[1], jun2dPointArray[4]);
        jun2dTriangleArray[2] = new Jun2dTriangle(jun2dPointArray[4], jun2dPointArray[2], jun2dPointArray[5]);
        jun2dTriangleArray[3] = new Jun2dTriangle(jun2dPointArray[3], jun2dPointArray[4], jun2dPointArray[5]);
        return jun2dTriangleArray;
    }

    public Jun2dTriangle[] detailedTrianglesLevel_(int n) {
        if (n <= 0) {
            return new Jun2dTriangle[]{this};
        }
        ArrayList<Jun2dTriangle> arrayList = new ArrayList<Jun2dTriangle>();
        Jun2dTriangle[] jun2dTriangleArray = this.detailedTriangles();
        for (int i = 0; i < jun2dTriangleArray.length; ++i) {
            Jun2dTriangle[] jun2dTriangleArray2 = jun2dTriangleArray[i].detailedTrianglesLevel_(n - 1);
            for (int j = 0; j < jun2dTriangleArray2.length; ++j) {
                arrayList.add(jun2dTriangleArray2[j]);
            }
        }
        return arrayList.toArray(new Jun2dTriangle[arrayList.size()]);
    }

    public Jun2dCircle incircle() {
        double d = this.peripheryOfTriangle();
        if (d < this.Accuracy()) {
            throw new IllegalStateException("unexpected triangle");
        }
        double d2 = this.p1().distance_(this.p2());
        double d3 = this.p2().distance_(this.p3());
        double d4 = this.p3().distance_(this.p1());
        double d5 = (d3 * this.p1().x() + d4 * this.p2().x() + d2 * this.p3().x()) / d;
        double d6 = (d3 * this.p1().y() + d4 * this.p2().y() + d2 * this.p3().y()) / d;
        Jun2dPoint jun2dPoint = new Jun2dPoint(d5, d6);
        double d7 = this.peripheryOfTriangle() / 2.0;
        if (d7 < this.Accuracy()) {
            throw new IllegalStateException("unexpected triangle");
        }
        double d8 = Math.sqrt((d7 - this.p1().distance_(this.p2())) * (d7 - this.p2().distance_(this.p3())) * (d7 - this.p3().distance_(this.p1())) / d7);
        return new Jun2dCircle(jun2dPoint, d8);
    }

    public Jun3dPoint normalUnitVector() {
        return this.asPlane().normalUnitVector();
    }

    public Jun3dPoint normalVector() {
        return this.asPlane().normalVector();
    }

    public double peripheryOfTriangle() {
        double d = 0.0;
        d += this.p1().distance_(this.p2());
        d += this.p2().distance_(this.p3());
        return d += this.p3().distance_(this.p1());
    }

    public Jun2dLine[] threeLines() {
        Jun2dLine jun2dLine = this.p1().to_(this.p2());
        Jun2dLine[] jun2dLineArray = new Jun2dLine[]{jun2dLine, jun2dLine = this.p2().to_(this.p3()), jun2dLine = this.p3().to_(this.p1())};
        return jun2dLineArray;
    }

    public Jun2dTriangle reversed() {
        return Jun2dTriangle.On_on_on_(this.p3(), this.p2(), this.p1());
    }

    public Jun2dTriangles subdivide() {
        return this.subdivide4();
    }

    public Jun2dTriangles subdivide4() {
        return new Jun2dTriangles(this.detailedTriangles());
    }

    public Jun2dTriangles subdivide4Level_(int n) {
        return new Jun2dTriangles(this.detailedTrianglesLevel_(n));
    }

    public Jun2dTriangles subdivideLevel_(int n) {
        return this.subdivide4Level_(n);
    }

    public boolean containsPoint_(Jun2dPoint jun2dPoint) {
        Jun2dLine[] jun2dLineArray = this.threeLines();
        for (int i = 0; i < jun2dLineArray.length; ++i) {
            if (jun2dPoint.whichSideOf_(jun2dLineArray[i]) >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean is2d() {
        return true;
    }

    public Jun2dTriangle rotatedBy_(JunAngle junAngle) {
        return this.transform_(Jun2dTransformation.Rotate_(junAngle));
    }

    public Jun2dTriangle scaledBy_(double d) {
        return this.transform_(Jun2dTransformation.Scale_(d));
    }

    public Jun2dTriangle scaledBy_(Jun2dPoint jun2dPoint) {
        return this.transform_(Jun2dTransformation.Scale_(jun2dPoint));
    }

    public Jun2dTriangle transform_(Jun2dTransformation jun2dTransformation) {
        return Jun2dTriangle.On_on_on_(this.p1().transform_(jun2dTransformation), this.p2().transform_(jun2dTransformation), this.p3().transform_(jun2dTransformation));
    }

    public Jun2dTriangle translatedBy_(double d) {
        return this.transform_(Jun2dTransformation.Translate_(d));
    }

    public Jun2dTriangle translatedBy_(Jun2dPoint jun2dPoint) {
        return this.transform_(Jun2dTransformation.Translate_(jun2dPoint));
    }

    protected void setP1_(JunPoint junPoint) {
        this.p1 = Jun2dPoint.Coerce_(junPoint);
    }

    protected void setP2_(JunPoint junPoint) {
        this.p2 = Jun2dPoint.Coerce_(junPoint);
    }

    protected void setP3_(JunPoint junPoint) {
        this.p3 = Jun2dPoint.Coerce_(junPoint);
    }
}

