/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.forms;

import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.system.framework.JunAbstractObject;

public class JunForm2dRegion
extends JunAbstractObject {
    protected Jun2dPoint[] originalPoints;
    protected Jun2dBoundingBox boundingBox;
    protected Jun2dPoint[] processingPoints;
    protected Jun2dLine[] lineSegments;

    public JunForm2dRegion() {
    }

    public JunForm2dRegion(Jun2dPoint[] jun2dPointArray) {
        this();
        this.points_(jun2dPointArray);
    }

    protected void initialize() {
        super.initialize();
        this.originalPoints = null;
        this.boundingBox = null;
        this.processingPoints = null;
        this.lineSegments = null;
    }

    public Jun2dPoint[] points() {
        return this.originalPoints;
    }

    public void points_(Jun2dPoint[] jun2dPointArray) {
        if (jun2dPointArray == null) {
            jun2dPointArray = new Jun2dPoint[]{};
        }
        ArrayList<Jun2dPoint> arrayList = new ArrayList<Jun2dPoint>(jun2dPointArray.length);
        Jun2dBoundingBox jun2dBoundingBox = null;
        if (jun2dPointArray.length > 0) {
            jun2dBoundingBox = Jun2dBoundingBox.Origin_extent_(jun2dPointArray[0], new Jun2dPoint(1.0, 1.0));
            arrayList.add(jun2dPointArray[0]);
        }
        for (int i = 1; i < jun2dPointArray.length; ++i) {
            jun2dBoundingBox = jun2dBoundingBox.merge_(Jun2dBoundingBox.Origin_extent_(jun2dPointArray[i], new Jun2dPoint(1.0, 1.0)));
            arrayList.add(jun2dPointArray[i]);
        }
        if (jun2dPointArray.length > 0 && !jun2dPointArray[0].equal_((Object)jun2dPointArray[jun2dPointArray.length - 1])) {
            arrayList.add(jun2dPointArray[0]);
        }
        this.originalPoints = arrayList.toArray(new Jun2dPoint[arrayList.size()]);
        this.boundingBox = jun2dBoundingBox;
        this.processingPoints = null;
        this.lineSegments = null;
    }

    public Jun2dBoundingBox boundingBox() {
        if (this.boundingBox == null) {
            this.boundingBox = new Jun2dBoundingBox();
        }
        return this.boundingBox;
    }

    public Rectangle bounds() {
        if (this.boundingBox() == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return new Rectangle(0, 0, (int)Math.round(this.boundingBox().width()), (int)Math.round(this.boundingBox().height()));
    }

    public Jun2dPoint[] pointsWithoutLast() {
        if (this.processingPoints == null) {
            this.processingPoints = new Jun2dPoint[this.points().length - 1];
            System.arraycopy(this.points(), 0, this.processingPoints, 0, this.processingPoints.length);
        }
        return this.processingPoints;
    }

    public Jun2dLine[] segments() {
        if (this.lineSegments == null) {
            Jun2dPoint[] jun2dPointArray = this.points();
            this.lineSegments = new Jun2dLine[jun2dPointArray.length - 1];
            for (int i = 0; i < jun2dPointArray.length - 1; ++i) {
                this.lineSegments[i] = new Jun2dLine(jun2dPointArray[i], jun2dPointArray[i + 1]);
            }
        }
        return this.lineSegments;
    }

    public boolean containsPoint_(Jun2dPoint jun2dPoint) {
        if (!this.boundingBox().containsPoint_(jun2dPoint)) {
            return false;
        }
        if (this._indexOfPointCloseEnoughTo(jun2dPoint) >= 0) {
            return true;
        }
        Jun2dLine[] jun2dLineArray = this.segments();
        for (int i = 0; i < jun2dLineArray.length; ++i) {
            if (!jun2dLineArray[i].lineSegmentContainsPoint_(jun2dPoint)) continue;
            return true;
        }
        ArrayList<Jun2dPoint> arrayList = new ArrayList<Jun2dPoint>();
        Jun2dLine jun2dLine = new Jun2dLine(jun2dPoint, new Jun2dPoint(jun2dPoint.x() + this.defaultSoFarX(), jun2dPoint.y()));
        for (int i = 0; i < jun2dLineArray.length; ++i) {
            int n;
            Jun2dPoint jun2dPoint2 = jun2dLine.lineSegmentIntersectingPointWithLineSegment_(jun2dLineArray[i]);
            if (jun2dPoint2 != null && (n = this._indexOfPointCloseEnoughTo(jun2dPoint2)) >= 0) {
                int n2 = n;
                Jun2dPoint jun2dPoint3 = jun2dPoint2;
                n2 = n2 <= 0 ? this.pointsWithoutLast().length - 1 : n2 - 1;
                Jun2dPoint jun2dPoint4 = this.pointsWithoutLast()[n2];
                while (jun2dPoint4.y() == jun2dPoint.y()) {
                    jun2dPoint3 = jun2dPoint4;
                    n2 = n2 <= 0 ? this.pointsWithoutLast().length - 1 : n2 - 1;
                    jun2dPoint4 = this.pointsWithoutLast()[n2];
                }
                n2 = n;
                Jun2dPoint jun2dPoint5 = jun2dPoint2;
                n2 = n2 >= this.pointsWithoutLast().length - 1 ? 0 : n2 + 1;
                Jun2dPoint jun2dPoint6 = this.pointsWithoutLast()[n2];
                while (jun2dPoint6.y() == jun2dPoint.y()) {
                    jun2dPoint5 = jun2dPoint6;
                    n2 = n2 >= this.pointsWithoutLast().length - 1 ? 0 : n2 + 1;
                    jun2dPoint6 = this.pointsWithoutLast()[n2];
                }
                jun2dPoint2 = jun2dPoint3.min_(jun2dPoint5);
                if (jun2dPoint4.y() >= jun2dPoint.y() && jun2dPoint6.y() >= jun2dPoint.y()) {
                    jun2dPoint2 = null;
                }
                if (jun2dPoint4.y() <= jun2dPoint.y() && jun2dPoint6.y() <= jun2dPoint.y()) {
                    jun2dPoint2 = null;
                }
            }
            if (jun2dPoint2 == null || arrayList.contains((Object)jun2dPoint2)) continue;
            arrayList.add(jun2dPoint2);
        }
        return arrayList.size() % 2 == 1;
    }

    public boolean containsLineSegment_(Jun2dLine jun2dLine) {
        ArrayList<Jun2dPoint> arrayList = new ArrayList<Jun2dPoint>();
        Jun2dLine[] jun2dLineArray = this.segments();
        for (int i = 0; i < jun2dLineArray.length; ++i) {
            Jun2dPoint jun2dPoint = jun2dLine.lineSegmentIntersectingPointWithLineSegment_(jun2dLineArray[i]);
            if (jun2dPoint == null) continue;
            arrayList.add(jun2dPoint);
        }
        Jun2dPoint[] jun2dPointArray = arrayList.toArray(new Jun2dPoint[arrayList.size()]);
        arrayList = new ArrayList();
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            if (this._indexOfPointCloseEnoughTo(jun2dPointArray[i]) >= 0) continue;
            arrayList.add(jun2dPointArray[i]);
        }
        if (!arrayList.isEmpty()) {
            return false;
        }
        if (!this.containsPoint_(jun2dLine.atT_(0.25))) {
            return false;
        }
        if (!this.containsPoint_(jun2dLine.atT_(0.5))) {
            return false;
        }
        return this.containsPoint_(jun2dLine.atT_(0.75));
    }

    protected double defaultAccuracy() {
        return Jun2dLine.Accuracy() * 10.0;
    }

    protected double defaultSoFarX() {
        return 29999.0;
    }

    public GeneralPath toGeneralPath() {
        Jun2dPoint[] jun2dPointArray = this.points();
        if (jun2dPointArray == null || jun2dPointArray.length == 0) {
            return null;
        }
        GeneralPath generalPath = new GeneralPath(0, jun2dPointArray.length);
        generalPath.moveTo((float)jun2dPointArray[0].x(), (float)jun2dPointArray[0].y());
        for (int i = 1; i < jun2dPointArray.length; ++i) {
            generalPath.lineTo((float)jun2dPointArray[i].x(), (float)jun2dPointArray[i].y());
        }
        return generalPath;
    }

    protected int _indexOfPointCloseEnoughTo(Jun2dPoint jun2dPoint) {
        double d = this.defaultAccuracy();
        Jun2dPoint[] jun2dPointArray = this.pointsWithoutLast();
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            if (!(jun2dPoint.distance_(jun2dPointArray[i]) < d)) continue;
            return i;
        }
        return -1;
    }
}

