/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.boxtree;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.boxtree.Jun2dBoundingBoxNodeTestExamples;
import jp.co.sra.jun.geometry.boxtree.Jun2dBoundingBoxTree;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.utilities.JunControlUtility;
import jp.co.sra.jun.goodies.utilities.JunImageUtility;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPrimitiveObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dVertex;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StInterval;

public class Jun2dBoundingBoxTreeTestExamples
extends Jun2dBoundingBoxNodeTestExamples {
    public static boolean Example1() {
        Jun2dBoundingBoxTree jun2dBoundingBoxTree = new Jun2dBoundingBoxTree(Jun2dBoundingBoxTreeTestExamples.ExamplePointCollectionOf2dLine());
        Jun2dBoundingBoxTreeTestExamples.ExampleDisplay_levelInterval_(jun2dBoundingBoxTree, new StInterval(2.0, 16.0));
        return true;
    }

    public static boolean Example2() {
        Jun2dBoundingBoxTree jun2dBoundingBoxTree = new Jun2dBoundingBoxTree(Jun2dBoundingBoxTreeTestExamples.ExamplePointCollectionOf2dSinCurve());
        Jun2dBoundingBoxTreeTestExamples.ExampleDisplay_levelInterval_(jun2dBoundingBoxTree, new StInterval(2.0, 16.0));
        return true;
    }

    public static boolean Example3() {
        Jun2dBoundingBoxTree jun2dBoundingBoxTree = new Jun2dBoundingBoxTree(Jun2dBoundingBoxTreeTestExamples.ExamplePointCollectionOf2dHalfBall());
        Jun2dBoundingBoxTreeTestExamples.ExampleDisplay_levelInterval_(jun2dBoundingBoxTree, new StInterval(5.0, 16.0));
        return true;
    }

    public static boolean Example4() {
        Jun2dBoundingBoxTree jun2dBoundingBoxTree = new Jun2dBoundingBoxTree(Jun2dBoundingBoxTreeTestExamples.ExampleSegmentCollectionOf2dLine());
        Jun2dBoundingBoxTreeTestExamples.ExampleDisplay_levelInterval_(jun2dBoundingBoxTree, new StInterval(2.0, 16.0));
        return true;
    }

    public static boolean Example5() {
        Jun2dBoundingBoxTree jun2dBoundingBoxTree = new Jun2dBoundingBoxTree(Jun2dBoundingBoxTreeTestExamples.ExampleSegmentCollectionOf2dSinCurve());
        Jun2dBoundingBoxTreeTestExamples.ExampleDisplay_levelInterval_(jun2dBoundingBoxTree, new StInterval(2.0, 16.0));
        return true;
    }

    public static boolean Example6() {
        Jun2dBoundingBoxTree jun2dBoundingBoxTree = new Jun2dBoundingBoxTree(Jun2dBoundingBoxTreeTestExamples.ExamplePatchCollectionOf2dHalfBall());
        Jun2dBoundingBoxTreeTestExamples.ExampleDisplay_levelInterval_(jun2dBoundingBoxTree, new StInterval(5.0, 16.0));
        return true;
    }

    public static boolean Example7() {
        Jun2dBoundingBoxTree jun2dBoundingBoxTree = new Jun2dBoundingBoxTree(Jun2dBoundingBoxTreeTestExamples.ExamplePatchCollectionOf2dHalfBall());
        jun2dBoundingBoxTree.rootNode().messageToSubdivide_(Jun2dBoundingBoxTreeTestExamples.$((String)"subdivide"));
        jun2dBoundingBoxTree.rootNode().compareWithBlock_(new StBlockClosure(){

            public Object value_value_(Object object, Object object2) {
                int n;
                Jun2dTriangle jun2dTriangle = (Jun2dTriangle)((Object)object);
                Jun2dBoundingBox jun2dBoundingBox = (Jun2dBoundingBox)((Object)object2);
                HashSet<Jun2dPoint> hashSet = new HashSet<Jun2dPoint>();
                Jun2dTriangle[] jun2dTriangleArray = jun2dTriangle.detailedTrianglesLevel_(1);
                for (int i = 0; i < jun2dTriangleArray.length; ++i) {
                    Jun2dPoint[] jun2dPointArray = jun2dTriangleArray[i].points();
                    for (n = 0; n < jun2dPointArray.length; ++n) {
                        hashSet.add(jun2dPointArray[n]);
                    }
                }
                Jun2dPoint[] jun2dPointArray = hashSet.toArray(new Jun2dPoint[hashSet.size()]);
                boolean bl = false;
                for (n = 0; n < jun2dPointArray.length; ++n) {
                    if (!jun2dBoundingBox.containsPoint_(jun2dPointArray[n])) continue;
                    bl = true;
                    break;
                }
                return new Boolean(bl);
            }
        });
        Jun2dBoundingBoxTreeTestExamples.ExampleDisplay_levelInterval_(jun2dBoundingBoxTree, new StInterval(2.0, 5.0));
        return true;
    }

    public static boolean Example8() {
        Jun2dBoundingBoxTree jun2dBoundingBoxTree = new Jun2dBoundingBoxTree(Jun2dBoundingBoxTreeTestExamples.ExamplePatchCollectionOf2dPolyline());
        jun2dBoundingBoxTree.rootNode().messageToSubdivide_(Jun2dBoundingBoxTreeTestExamples.$((String)"subdivide"));
        Jun2dBoundingBoxTreeTestExamples.ExampleDisplay_levelInterval_(jun2dBoundingBoxTree, new StInterval(1.0, 6.0));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Jun2dBoundingBoxTree ExampleDisplay_levelInterval_(Jun2dBoundingBoxTree jun2dBoundingBoxTree, StInterval stInterval) {
        JunOpenGLDisplayModel junOpenGLDisplayModel = new JunOpenGLDisplayModel();
        junOpenGLDisplayModel.openIn_(new Rectangle(200, 100, 606, 426));
        ((Frame)junOpenGLDisplayModel.getWindow()).setTitle("Bounding Box Tree");
        int n = (int)Math.round(stInterval.start());
        while ((double)n <= stInterval.last()) {
            JunCursors junCursors = new JunCursors(Cursor.getPredefinedCursor(3));
            try {
                junCursors._show();
                jun2dBoundingBoxTree.subdividedNodesLevel_(n);
            }
            finally {
                junCursors._restore();
            }
            Jun2dBoundingBoxTreeTestExamples.ExampleDisplay_with_(junOpenGLDisplayModel, jun2dBoundingBoxTree);
            StImage stImage = StImage._OfArea((Rectangle)junOpenGLDisplayModel.getWindow().getBounds());
            try {
                JunImageUtility.WriteImage_to_(stImage, new File(String.valueOf(n) + ".bmp"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            n += (int)stInterval.step();
        }
        return jun2dBoundingBoxTree;
    }

    protected static void ExampleDisplay_with_(final JunOpenGLDisplayModel junOpenGLDisplayModel, final Jun2dBoundingBoxTree jun2dBoundingBoxTree) {
        final JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject2 = new JunOpenGL3dCompoundObject();
        JunGeometry[] junGeometryArray = jun2dBoundingBoxTree.containedObjects();
        for (int i = 0; i < junGeometryArray.length; ++i) {
            JunOpenGL3dPrimitiveObject junOpenGL3dPrimitiveObject;
            Object object;
            Jun2dPoint[] jun2dPointArray;
            JunGeometry junGeometry;
            JunOpenGL3dObject junOpenGL3dObject;
            JunOpenGL3dObject junOpenGL3dObject2 = null;
            if (junGeometryArray[i].isPoint()) {
                junOpenGL3dObject = (JunOpenGL3dVertex)junGeometryArray[i].asJunOpenGL3dObjectColor_(Color.gray);
                ((JunOpenGL3dVertex)junOpenGL3dObject).size_(3.0f);
                junOpenGL3dObject2 = junOpenGL3dObject;
            }
            if (junGeometryArray[i].isLine()) {
                junOpenGL3dObject = new JunOpenGL3dCompoundObject();
                junGeometry = (Jun2dLine)junGeometryArray[i];
                jun2dPointArray = (Jun2dPoint[])junGeometry.asJunOpenGL3dObjectColor_(Color.black);
                jun2dPointArray.lineWidth_(2.0f);
                junOpenGL3dObject = jun2dPointArray.asCompoundObject();
                object = (JunOpenGL3dVertex)((Jun2dLine)junGeometry).from().asJunOpenGL3dObjectColor_(Color.black);
                ((JunOpenGL3dVertex)((Object)object)).size_(3.0f);
                ((JunOpenGL3dCompoundObject)junOpenGL3dObject).add_((JunOpenGL3dObject)((Object)object));
                junOpenGL3dPrimitiveObject = (JunOpenGL3dVertex)((Jun2dLine)junGeometry).last().asJunOpenGL3dObjectColor_(Color.black);
                ((JunOpenGL3dVertex)junOpenGL3dPrimitiveObject).size_(3.0f);
                ((JunOpenGL3dCompoundObject)junOpenGL3dObject).add_(junOpenGL3dPrimitiveObject);
                junOpenGL3dObject2 = junOpenGL3dObject;
            }
            if (junGeometryArray[i].isTriangle()) {
                junOpenGL3dObject = new JunOpenGL3dCompoundObject();
                junGeometry = (Jun2dTriangle)junGeometryArray[i];
                jun2dPointArray = ((Jun2dTriangle)junGeometry).asPointArray();
                object = new Jun3dPoint[jun2dPointArray.length];
                for (int j = 0; j < jun2dPointArray.length; ++j) {
                    object[j] = jun2dPointArray[j].as3dPoint();
                }
                junOpenGL3dPrimitiveObject = new JunOpenGL3dPolyline((Jun3dPoint[])object);
                junOpenGL3dPrimitiveObject.paint_(Color.gray);
                ((JunOpenGL3dPolyline)junOpenGL3dPrimitiveObject).lineWidth_(1.0f);
                ((JunOpenGL3dCompoundObject)junOpenGL3dObject).add_(junOpenGL3dPrimitiveObject);
                JunOpenGL3dVertex junOpenGL3dVertex = (JunOpenGL3dVertex)((Jun2dTriangle)junGeometry).p3().asJunOpenGL3dObjectColor_(Color.black);
                junOpenGL3dVertex.size_(3.0f);
                ((JunOpenGL3dCompoundObject)junOpenGL3dObject).add_(junOpenGL3dVertex);
                JunOpenGL3dVertex junOpenGL3dVertex2 = (JunOpenGL3dVertex)((Jun2dTriangle)junGeometry).p3().asJunOpenGL3dObjectColor_(Color.black);
                junOpenGL3dVertex2.size_(3.0f);
                ((JunOpenGL3dCompoundObject)junOpenGL3dObject).add_(junOpenGL3dVertex2);
                JunOpenGL3dVertex junOpenGL3dVertex3 = (JunOpenGL3dVertex)((Jun2dTriangle)junGeometry).p3().asJunOpenGL3dObjectColor_(Color.black);
                junOpenGL3dVertex3.size_(3.0f);
                ((JunOpenGL3dCompoundObject)junOpenGL3dObject).add_(junOpenGL3dVertex3);
                junOpenGL3dObject2 = junOpenGL3dObject;
            }
            if (junOpenGL3dObject2 == null) continue;
            junOpenGL3dCompoundObject2.add_(junOpenGL3dObject2);
        }
        junOpenGL3dCompoundObject.add_(junOpenGL3dCompoundObject2);
        junOpenGL3dCompoundObject.add_(jun2dBoundingBoxTree.asJunOpenGL3dObject());
        Jun3dPoint jun3dPoint = jun2dBoundingBoxTree.boundingBox().extent().as3dPoint();
        jun3dPoint = new Jun3dPoint(jun3dPoint.x(), jun3dPoint.y(), Math.max(jun3dPoint.x(), jun3dPoint.y()));
        junOpenGL3dCompoundObject2 = (JunOpenGL3dCompoundObject)JunOpenGL3dObject.XyUnitArrows().scaledBy_(jun3dPoint);
        junOpenGL3dCompoundObject.add_(junOpenGL3dCompoundObject2);
        JunControlUtility.Do_forMilliseconds_(new StBlockClosure(){

            public Object value() {
                junOpenGLDisplayModel.displayObject_(junOpenGL3dCompoundObject);
                junOpenGLDisplayModel.resetView();
                System.out.print("level ");
                System.out.print(Integer.toString(jun2dBoundingBoxTree.levelNumber()));
                System.out.print(" -> ");
                System.out.print(Integer.toString(jun2dBoundingBoxTree.subdividedNodes().length));
                System.out.println(jun2dBoundingBoxTree.subdividedNodes().length > 1 ? " boxes" : " box");
                return null;
            }
        }, 2000);
    }

    public static void main(String[] stringArray) {
        new Jun2dBoundingBoxTreeTestExamples();
    }
}

