/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.boundaries;

import java.io.IOException;
import java.io.Writer;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.boundaries.JunBoundingBox;
import jp.co.sra.jun.geometry.boundaries.JunBoundingObject;
import jp.co.sra.smalltalk.StObject;

public abstract class JunBoundingBall
extends JunBoundingObject {
    protected JunPoint center;
    protected double radius;

    protected void initialize() {
        super.initialize();
        this.center = null;
        this.radius = 0.0;
    }

    public double radius() {
        return this.radius;
    }

    public void radius_(double d) {
        this.radius = Math.abs(d);
    }

    public double width() {
        return this._boundingBox().width();
    }

    public double height() {
        return this._boundingBox().height();
    }

    public abstract double depth();

    protected JunPoint _center() {
        return this.center;
    }

    protected void _center(JunPoint junPoint) {
        this.center = junPoint;
    }

    protected abstract JunBoundingBox _boundingBox();

    public boolean equal_(Object object) {
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        JunBoundingBall junBoundingBall = (JunBoundingBall)((Object)object);
        return this.center.equal_((Object)junBoundingBall.center) && this.isEqualNumber_to_(this.radius, junBoundingBall.radius);
    }

    public boolean equals(Object object) {
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        JunBoundingBall junBoundingBall = (JunBoundingBall)((Object)object);
        return this.center.equals((Object)junBoundingBall.center) && this.radius == junBoundingBall.radius;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.radius);
        int n = (int)(l ^ l >> 32);
        return this.center.hashCode() | n;
    }

    public StObject postCopy() {
        super.postCopy();
        this.center = (JunPoint)this.center.copy();
        this.radius = this.radius();
        return this;
    }

    public void storeOn_(Writer writer) throws IOException {
        writer.write("(");
        this._center().printOn_(writer);
        writer.write(" ball:");
        writer.write(String.valueOf(this.radius()));
        writer.write(")");
    }

    public boolean isBoundingBall() {
        return true;
    }
}

