/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.boundaries;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.boundaries.JunBoundingBall;
import jp.co.sra.jun.geometry.boundaries.JunBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.pluralities.Jun3dBoundingBalls;
import jp.co.sra.jun.geometry.pluralities.Jun3dBoundingBoxes;
import jp.co.sra.jun.geometry.transformations.JunTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.smalltalk.StBlockClosure;

public class Jun3dBoundingBall
extends JunBoundingBall {
    public Jun3dBoundingBall(Jun3dPoint jun3dPoint, double d) {
        this.center_(jun3dPoint);
        this.radius_(d);
    }

    public Jun3dBoundingBall(Jun3dPoint[] jun3dPointArray) {
        if (jun3dPointArray == null || jun3dPointArray.length == 0) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            d += jun3dPointArray[i].x();
            d2 += jun3dPointArray[i].y();
            d3 += jun3dPointArray[i].z();
        }
        Jun3dPoint jun3dPoint = new Jun3dPoint(d / (double)jun3dPointArray.length, d2 / (double)jun3dPointArray.length, d3 / (double)jun3dPointArray.length);
        double d4 = 0.0;
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            double d5 = jun3dPoint.distance_(jun3dPointArray[i]);
            if (!(d5 > d4)) continue;
            d4 = d5;
        }
        this.center_(jun3dPoint);
        this.radius_(d4);
    }

    protected void initialize() {
        super.initialize();
        this.center = Jun3dPoint.Zero();
    }

    public Jun3dPoint center() {
        return (Jun3dPoint)this._center();
    }

    public void center_(Jun3dPoint jun3dPoint) {
        this._center(jun3dPoint);
    }

    public double area() {
        return Math.PI * 4 * Math.pow(this.radius(), 2.0);
    }

    public double depth() {
        return this.boundingBox().depth();
    }

    public Jun3dBoundingBalls detailedBoundingBalls() {
        return this.octaBoundingBalls();
    }

    public Jun3dBoundingBoxes detailedBoundingBoxes() {
        return this.octaBoundingBoxes();
    }

    public Jun3dBoundingBalls octaBoundingBalls() {
        Jun3dBoundingBalls jun3dBoundingBalls = new Jun3dBoundingBalls();
        jun3dBoundingBalls.addAll_(this.boundingBox().octaBoundingBalls());
        return jun3dBoundingBalls;
    }

    public Jun3dBoundingBoxes octaBoundingBoxes() {
        Jun3dBoundingBoxes jun3dBoundingBoxes = new Jun3dBoundingBoxes();
        jun3dBoundingBoxes.addAll_(this.boundingBox().octaBoundingBoxes());
        return jun3dBoundingBoxes;
    }

    public double volume() {
        return Math.PI * 4 * Math.pow(this.radius(), 3.0) / 3.0;
    }

    public Jun3dBoundingBall boundingBall() {
        return this;
    }

    public Jun3dBoundingBox boundingBox() {
        return Jun3dBoundingBox.Origin_extent_(this.center(), Jun3dPoint.Zero()).expandedBy_(this.radius());
    }

    protected JunBoundingBox _boundingBox() {
        return this.boundingBox();
    }

    public void add_(Jun3dPoint jun3dPoint) {
        if (this.center().distance_(jun3dPoint) > this.radius()) {
            Jun3dBoundingBall jun3dBoundingBall = this.merge_(new Jun3dBoundingBall(jun3dPoint, 0.0));
            this.center_(jun3dBoundingBall.center());
            this.radius_(jun3dBoundingBall.radius());
        }
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dObject.Ball_radius_center_(3, this.radius(), this.center());
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                ((JunOpenGL3dObject)((Object)object)).paint_alpha_(Jun3dBoundingBall.this.defaultColor(), Jun3dBoundingBall.this.defaultAlpha());
                return null;
            }
        });
        return junOpenGL3dObject;
    }

    public Jun3dBoundingBall expandedBy_(double d) {
        return new Jun3dBoundingBall(this.center(), this.radius() + d);
    }

    public Jun3dBoundingBall insetBy_(double d) {
        return new Jun3dBoundingBall(this.center(), this.radius() - d);
    }

    public Jun3dBoundingBall merge_(Jun3dBoundingBall jun3dBoundingBall) {
        double d = this.center().distance_(jun3dBoundingBall.center());
        if (d + jun3dBoundingBall.radius() < this.radius()) {
            return (Jun3dBoundingBall)this.copy();
        }
        if (d + this.radius() < jun3dBoundingBall.radius()) {
            return (Jun3dBoundingBall)jun3dBoundingBall.copy();
        }
        Jun3dLine jun3dLine = new Jun3dLine(this.center(), jun3dBoundingBall.center());
        Jun3dPoint jun3dPoint = jun3dLine.atT_(0.0 - this.radius() / d);
        Jun3dPoint jun3dPoint2 = jun3dLine.atT_(1.0 + jun3dBoundingBall.radius() / d);
        return new Jun3dBoundingBall(jun3dPoint.center_(jun3dPoint2), jun3dPoint.distance_(jun3dPoint2) / 2.0);
    }

    public boolean contains_(Jun3dBoundingBall jun3dBoundingBall) {
        double d = this.center().distance_(jun3dBoundingBall.center());
        return d <= this.radius() && d + jun3dBoundingBall.radius() <= this.radius();
    }

    public boolean containsPoint_(Jun3dPoint jun3dPoint) {
        return this.center().distance_(jun3dPoint) <= this.radius() || this.touchesPoint_(jun3dPoint);
    }

    public boolean intersects_(Jun3dBoundingBall jun3dBoundingBall) {
        return this.center().distance_(jun3dBoundingBall.center()) <= this.radius() + jun3dBoundingBall.radius();
    }

    public boolean touchesPoint_(Jun3dPoint jun3dPoint) {
        double d = this.center().distance_(jun3dPoint);
        return this.isEqualNumber_to_(d, this.radius());
    }

    public boolean is3d() {
        return true;
    }

    public boolean touches_(Jun3dBoundingBall jun3dBoundingBall) {
        if (this.isEqualPoint_to_(this.center(), jun3dBoundingBall.center()) && this.isEqualNumber_to_(this.radius(), jun3dBoundingBall.radius())) {
            return true;
        }
        double d = this.center().distance_(jun3dBoundingBall.center());
        if (d <= this.radius()) {
            return this.isEqualNumber_to_(this.radius(), d + jun3dBoundingBall.radius());
        }
        if (d <= jun3dBoundingBall.radius()) {
            return this.isEqualNumber_to_(jun3dBoundingBall.radius(), d + this.radius());
        }
        return this.isEqualNumber_to_(d, this.radius() + jun3dBoundingBall.radius());
    }

    public JunGeometry transform_(JunTransformation junTransformation) {
        Jun3dLine jun3dLine = new Jun3dLine(this.center(), this.center().plus_(new Jun2dPoint(this.radius(), 0.0)));
        jun3dLine = (Jun3dLine)jun3dLine.transform_(junTransformation);
        return new Jun3dBoundingBall(jun3dLine.from(), jun3dLine.from().distance_(jun3dLine.to()));
    }

    public Jun3dBoundingBall rounded() {
        return new Jun3dBoundingBall(this.center().rounded(), Math.round(this.radius()));
    }

    public Jun3dBoundingBall truncated() {
        double d = this.radius() >= 0.0 ? Math.ceil(this.radius()) : Math.floor(this.radius());
        return new Jun3dBoundingBall(this.center().truncated(), d);
    }
}

