/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.boundaries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.Vector;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.surfaces.Jun2dPolygon;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;

public class Jun2dPolygonalBoundary
extends JunGeometry {
    protected TreeSet polygons;

    public Jun2dPolygonalBoundary() {
    }

    public Jun2dPolygonalBoundary(Jun2dPolygon[] jun2dPolygonArray) {
        this.setPolygons_(jun2dPolygonArray);
    }

    protected void initialize() {
        super.initialize();
        this.polygons = new TreeSet(new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Jun2dPolygon)((Object)object)).area() > ((Jun2dPolygon)((Object)object2)).area() ? -1 : 1;
            }
        });
    }

    public Jun2dPolygon[] polygons() {
        return this.polygons.toArray(new Jun2dPolygon[this.polygons.size()]);
    }

    public double area() {
        double d = 0.0;
        Jun2dPolygon[] jun2dPolygonArray = this.polygons();
        for (int i = 0; i < jun2dPolygonArray.length; ++i) {
            d += jun2dPolygonArray[i].signedArea();
        }
        return d;
    }

    public void add_(Jun2dPolygon jun2dPolygon) {
        this.polygons.add(jun2dPolygon);
    }

    public void addHole_(Jun2dPolygon jun2dPolygon) {
        this.add_(jun2dPolygon.asNegativePolygon());
    }

    public void addPolygon_(Jun2dPolygon jun2dPolygon) {
        this.add_(jun2dPolygon.asPositivePolygon());
    }

    public boolean equal_(Object object) {
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Jun2dPolygonalBoundary jun2dPolygonalBoundary = (Jun2dPolygonalBoundary)((Object)object);
        int n = this.polygons.size();
        if (n != jun2dPolygonalBoundary.polygons.size()) {
            return false;
        }
        Jun2dPolygon[] jun2dPolygonArray = this.polygons.toArray(new Jun2dPolygon[n]);
        Jun2dPolygon[] jun2dPolygonArray2 = jun2dPolygonalBoundary.polygons.toArray(new Jun2dPolygon[n]);
        for (int i = 0; i < n; ++i) {
            if (jun2dPolygonArray[i].equal_((Object)jun2dPolygonArray2[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Jun2dPolygonalBoundary jun2dPolygonalBoundary = (Jun2dPolygonalBoundary)((Object)object);
        int n = this.polygons.size();
        if (n != jun2dPolygonalBoundary.polygons.size()) {
            return false;
        }
        Jun2dPolygon[] jun2dPolygonArray = this.polygons.toArray(new Jun2dPolygon[n]);
        Jun2dPolygon[] jun2dPolygonArray2 = jun2dPolygonalBoundary.polygons.toArray(new Jun2dPolygon[n]);
        for (int i = 0; i < n; ++i) {
            if (jun2dPolygonArray[i].equals((Object)jun2dPolygonArray2[i])) continue;
            return false;
        }
        return true;
    }

    public Jun2dPolygon[] asArrayOfPolygons() {
        final ArrayList arrayList = new ArrayList();
        this.asArrayOfPolygonsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                arrayList.add(object);
                return null;
            }
        });
        return arrayList.toArray(new Jun2dPolygon[arrayList.size()]);
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        final ArrayList arrayList = new ArrayList();
        this.asJunOpenGL3dObjectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                arrayList.add(object);
                return null;
            }
        });
        JunOpenGL3dObject junOpenGL3dObject = arrayList.size() == 1 ? (JunOpenGL3dObject)((Object)arrayList.get(0)) : new JunOpenGL3dCompoundObject(arrayList);
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                ((JunOpenGL3dObject)((Object)object)).paint_alpha_(Jun2dPolygonalBoundary.this.defaultColor(), Float.NaN);
                return null;
            }
        });
        return junOpenGL3dObject;
    }

    public Object asArrayOfPolygonsDo_(StBlockClosure stBlockClosure) {
        Object object;
        Object object2;
        Jun2dPolygon jun2dPolygon;
        int n;
        Jun2dPolygon[] jun2dPolygonArray;
        ArrayList<Jun2dPolygon[]> arrayList = new ArrayList<Jun2dPolygon[]>();
        ArrayList<Jun2dPolygon[]> arrayList2 = new ArrayList<Jun2dPolygon[]>();
        Jun2dPolygon[] jun2dPolygonArray2 = this.polygons.toArray(new Jun2dPolygon[this.polygons.size()]);
        for (int i = 0; i < jun2dPolygonArray2.length; ++i) {
            jun2dPolygonArray = jun2dPolygonArray2[i];
            if (jun2dPolygonArray.isPositive()) {
                arrayList.add(jun2dPolygonArray);
                continue;
            }
            arrayList2.add(jun2dPolygonArray);
        }
        Jun2dPolygon[] jun2dPolygonArray3 = arrayList.toArray(new Jun2dPolygon[arrayList.size()]);
        Arrays.sort(jun2dPolygonArray3, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Jun2dPolygon)((Object)object)).area() < ((Jun2dPolygon)((Object)object2)).area() ? -1 : 1;
            }
        });
        jun2dPolygonArray = arrayList2.toArray(new Jun2dPolygon[arrayList2.size()]);
        HashMap hashMap = new HashMap(jun2dPolygonArray3.length);
        for (n = 0; n < jun2dPolygonArray3.length; ++n) {
            hashMap.put(jun2dPolygonArray3[n], new Vector());
        }
        for (n = 0; n < jun2dPolygonArray.length; ++n) {
            jun2dPolygon = jun2dPolygonArray[n];
            object2 = null;
            for (int i = 0; i < jun2dPolygonArray3.length; ++i) {
                object = jun2dPolygonArray3[i];
                if (!object.containsPoint_(jun2dPolygon.pointAt_(0))) continue;
                object2 = object;
                break;
            }
            if (object2 == null) continue;
            ((Vector)hashMap.get(object2)).addElement(jun2dPolygon);
        }
        for (n = 0; n < jun2dPolygonArray3.length; ++n) {
            jun2dPolygon = jun2dPolygonArray3[n];
            object2 = (Vector)hashMap.get((Object)jun2dPolygon);
            Jun2dPolygon jun2dPolygon2 = jun2dPolygon;
            if (!object2.isEmpty()) {
                jun2dPolygon2 = this._polygonFrom_withHoles_(jun2dPolygon, (Vector)object2);
            }
            if ((object = stBlockClosure.value_((Object)jun2dPolygon2)) == null) continue;
            return object;
        }
        return null;
    }

    public Object asConvexPolygonsDo_(final StBlockClosure stBlockClosure) {
        return this.asArrayOfPolygonsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                return ((Jun2dPolygon)((Object)object)).asConvexPolygonsDo_(stBlockClosure);
            }
        });
    }

    public Object asJunOpenGL3dObjectsDo_(final StBlockClosure stBlockClosure) {
        return this.asConvexPolygonsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                stBlockClosure.value_((Object)((Jun2dPolygon)((Object)object)).asJunOpenGL3dObject());
                return null;
            }
        });
    }

    public Jun2dPolygonalBoundary scaledBy_(Jun2dPoint jun2dPoint) {
        Jun2dPolygon[] jun2dPolygonArray = this.polygons.toArray(new Jun2dPolygon[this.polygons.size()]);
        Jun2dPolygon[] jun2dPolygonArray2 = new Jun2dPolygon[jun2dPolygonArray.length];
        if (jun2dPoint.x() * jun2dPoint.y() > 0.0) {
            for (int i = 0; i < jun2dPolygonArray.length; ++i) {
                jun2dPolygonArray2[i] = jun2dPolygonArray[i].scaledBy_(jun2dPoint);
            }
        } else {
            for (int i = 0; i < jun2dPolygonArray.length; ++i) {
                jun2dPolygonArray2[i] = jun2dPolygonArray[i].scaledBy_(jun2dPoint).reversed();
            }
        }
        return new Jun2dPolygonalBoundary(jun2dPolygonArray2);
    }

    public Jun2dPolygonalBoundary translatedBy_(Jun2dPoint jun2dPoint) {
        Jun2dPolygon[] jun2dPolygonArray = this.polygons.toArray(new Jun2dPolygon[this.polygons.size()]);
        Jun2dPolygon[] jun2dPolygonArray2 = new Jun2dPolygon[jun2dPolygonArray.length];
        for (int i = 0; i < jun2dPolygonArray.length; ++i) {
            jun2dPolygonArray2[i] = jun2dPolygonArray[i].translatedBy_(jun2dPoint);
        }
        return new Jun2dPolygonalBoundary(jun2dPolygonArray2);
    }

    protected void setPolygons_(Jun2dPolygon[] jun2dPolygonArray) {
        for (int i = 0; i < jun2dPolygonArray.length; ++i) {
            this.add_(jun2dPolygonArray[i]);
        }
    }

    protected Jun2dPolygon _polygonFrom_withHoles_(Jun2dPolygon jun2dPolygon, Vector vector) {
        Jun2dPolygon[] jun2dPolygonArray = new Jun2dPolygon[vector.size()];
        vector.copyInto((Object[])jun2dPolygonArray);
        Vector<Jun2dPoint[]> vector2 = new Vector<Jun2dPoint[]>(jun2dPolygonArray.length + 1);
        vector2.addElement(jun2dPolygon.points());
        for (int i = 0; i < jun2dPolygonArray.length; ++i) {
            vector2.addElement(jun2dPolygonArray[i].points());
        }
        while (vector2.size() > 1) {
            int n;
            Object object;
            Jun2dPoint[] jun2dPointArray = (Jun2dPoint[])vector2.lastElement();
            vector2.removeElementAt(vector2.size() - 1);
            int n2 = 0;
            Jun2dPoint jun2dPoint = jun2dPointArray[0];
            for (int i = 1; i < jun2dPointArray.length; ++i) {
                Jun2dPoint jun2dPoint2 = jun2dPointArray[i];
                if (!(jun2dPoint2.y() > jun2dPoint.y())) continue;
                jun2dPoint = jun2dPoint2;
                n2 = i;
            }
            Jun2dPoint jun2dPoint3 = null;
            int n3 = -1;
            int n4 = -1;
            for (int i = 0; i < vector2.size(); ++i) {
                object = (Jun2dPoint[])vector2.elementAt(i);
                for (n = 0; n < ((Jun2dPoint[])object).length; ++n) {
                    Jun2dPoint jun2dPoint4 = object[n];
                    Jun2dPoint jun2dPoint5 = object[(n + 1) % ((Jun2dPoint[])object).length];
                    if (!(jun2dPoint4.x() > jun2dPoint5.x()) || !(jun2dPoint4.x() > jun2dPoint.x()) || !(jun2dPoint5.x() <= jun2dPoint.x())) continue;
                    double d = (jun2dPoint.x() - jun2dPoint4.x()) * (jun2dPoint5.y() - jun2dPoint4.y()) / (jun2dPoint5.x() - jun2dPoint4.x()) + jun2dPoint4.y();
                    if (!(jun2dPoint.y() <= d) || jun2dPoint3 != null && !(d <= jun2dPoint3.y())) continue;
                    jun2dPoint3 = new Jun2dPoint(jun2dPoint.x(), d);
                    n3 = n;
                    n4 = i;
                }
            }
            if (jun2dPoint3 == null) {
                throw SmalltalkException.Error((String)"internal error");
            }
            Jun2dPoint[] jun2dPointArray2 = (Jun2dPoint[])vector2.elementAt(n4);
            vector2.removeElementAt(n4);
            object = new Vector();
            for (n = 0; n <= n2; ++n) {
                ((Vector)object).addElement(jun2dPointArray[n]);
            }
            if (!jun2dPoint3.equals((Object)jun2dPointArray2[(n3 + 1) % jun2dPointArray2.length])) {
                ((Vector)object).addElement(jun2dPoint3);
            }
            for (n = n3 + 1; n < jun2dPointArray2.length; ++n) {
                ((Vector)object).addElement(jun2dPointArray2[n]);
            }
            for (n = 0; n <= n3; ++n) {
                ((Vector)object).addElement(jun2dPointArray2[n]);
            }
            if (!jun2dPoint3.equals((Object)jun2dPointArray2[n3])) {
                ((Vector)object).addElement(jun2dPoint3);
            }
            for (n = n2; n < jun2dPointArray.length; ++n) {
                ((Vector)object).addElement(jun2dPointArray[n]);
            }
            Jun2dPoint[] jun2dPointArray3 = new Jun2dPoint[((Vector)object).size()];
            ((Vector)object).copyInto((Object[])jun2dPointArray3);
            if (n4 == 0) {
                vector2.insertElementAt(jun2dPointArray3, 0);
                continue;
            }
            vector2.addElement(jun2dPointArray3);
        }
        return new Jun2dPolygon((Jun2dPoint[])vector2.firstElement());
    }
}

