/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.dxf.support;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jp.co.sra.jun.dxf.support.JunCADModel;
import jp.co.sra.jun.dxf.support.JunDXFScanner;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dNurbsCurve;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolylineLoop;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPrimitiveObject;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StReadStream;
import jp.co.sra.smalltalk.StSymbol;

public class JunDXFParser
extends JunDXFScanner {
    protected static Color[] ColorTable = null;
    protected Hashtable layers;
    protected String layer;
    protected Hashtable dxfNames;
    protected Hashtable itemCount;
    protected boolean happy;
    protected Object[] item;
    protected Vector definedObjects;
    protected boolean doNurbs = false;
    protected Hashtable settings = null;
    protected Vector outside = null;
    protected Hashtable layerColors = null;

    public static Vector CalculateARC_radius_from_to_(Jun3dPoint jun3dPoint, double d, double d2, double d3) {
        double d4;
        double d5;
        double d6 = jun3dPoint.x();
        double d7 = jun3dPoint.y();
        double d8 = Math.PI * 2;
        double d9 = d2 * d8 / 360.0;
        double d10 = d3 * d8 / 360.0;
        if (d10 == 0.0) {
            d10 = d8;
        }
        Vector<Jun3dPoint> vector = new Vector<Jun3dPoint>(8);
        double d11 = d9;
        double d12 = d10;
        double d13 = d10 - d9;
        double d14 = d13 - Math.floor(d13 / d8) * d8;
        double d15 = d14 / 8.0;
        if (d11 > d12) {
            d12 += d8;
        }
        while (d11 < d12) {
            d5 = d6 + Math.cos(d11) * d;
            d4 = d7 + Math.sin(d11) * d;
            vector.add(new Jun3dPoint(d5, d4, 0.0));
            d11 += d15;
        }
        d5 = d6 + Math.cos(d12) * d;
        d4 = d7 + Math.sin(d12) * d;
        vector.add(new Jun3dPoint(d5, d4, 0.0));
        return vector;
    }

    public static JunDXFParser OnSmart_(File file) {
        JunDXFParser junDXFParser = new JunDXFParser();
        try {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            StringWriter stringWriter = new StringWriter();
            while ((n = ((Reader)bufferedReader).read()) > 0) {
                stringWriter.write(n);
            }
            junDXFParser.onSmart_(new StReadStream(stringWriter.toString()));
        }
        catch (IOException iOException) {
            return null;
        }
        junDXFParser.parse();
        return junDXFParser;
    }

    protected static Color ColorAt_(int n) {
        int n2 = n;
        if (ColorTable == null) {
            ColorTable = new Color[]{Color.red, Color.yellow, Color.green, Color.cyan, Color.blue, new Color(0.624954f, 0.125015f, 0.874985f), Color.white, Color.black};
        }
        if (n2 < 1 || 7 < n2) {
            n2 = 7;
        }
        return ColorTable[n2 - 1];
    }

    public boolean parse3DFACE() {
        String string = Integer.toString(this.mark);
        String string2 = "";
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        boolean bl = false;
        ArrayList<Jun3dPoint> arrayList = new ArrayList<Jun3dPoint>(4);
        this.nextPair();
        if (this.dataString.equals("EOF")) {
            return false;
        }
        while (this.groupCode != 0) {
            switch (this.groupCode) {
                case 10: {
                    d = this.dataNumber.doubleValue();
                    break;
                }
                case 20: {
                    d2 = this.dataNumber.doubleValue();
                    break;
                }
                case 30: {
                    d3 = this.dataNumber.doubleValue();
                    break;
                }
                case 11: {
                    d4 = this.dataNumber.doubleValue();
                    break;
                }
                case 21: {
                    d5 = this.dataNumber.doubleValue();
                    break;
                }
                case 31: {
                    d6 = this.dataNumber.doubleValue();
                    break;
                }
                case 12: {
                    d7 = this.dataNumber.doubleValue();
                    break;
                }
                case 22: {
                    d8 = this.dataNumber.doubleValue();
                    break;
                }
                case 32: {
                    d9 = this.dataNumber.doubleValue();
                    break;
                }
                case 13: {
                    bl = true;
                    d10 = this.dataNumber.doubleValue();
                    break;
                }
                case 23: {
                    bl = true;
                    d11 = this.dataNumber.doubleValue();
                    break;
                }
                case 33: {
                    bl = true;
                    d12 = this.dataNumber.doubleValue();
                }
            }
            this.nextPair();
            if (!this.dataString.equals("EOF")) continue;
            return false;
        }
        arrayList.add(new Jun3dPoint(d, d2, d3));
        arrayList.add(new Jun3dPoint(d4, d5, d6));
        arrayList.add(new Jun3dPoint(d7, d8, d9));
        if (bl) {
            arrayList.add(new Jun3dPoint(d10, d11, d12));
        }
        JunOpenGL3dPolygon junOpenGL3dPolygon = new JunOpenGL3dPolygon(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.count_(JunDXFParser.$((String)"vertex"));
        }
        this.unNextPair();
        junOpenGL3dPolygon.name_(string);
        this.item = new Object[]{string2, junOpenGL3dPolygon};
        this.count_(JunDXFParser.$((String)"polygon"));
        return true;
    }

    public boolean parseARC() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        String string = String.valueOf(this.mark);
        this.nextPair();
        if (this.dataString.equals("EOF")) {
            return false;
        }
        while (this.groupCode != 0) {
            switch (this.groupCode) {
                case 8: {
                    this.layer = this.dataString;
                    break;
                }
                case 10: {
                    d = this.dataNumber.doubleValue();
                    break;
                }
                case 20: {
                    d2 = this.dataNumber.doubleValue();
                    break;
                }
                case 30: {
                    d3 = this.dataNumber.doubleValue();
                    break;
                }
                case 40: {
                    d4 = this.dataNumber.doubleValue();
                    break;
                }
                case 50: {
                    d5 = this.dataNumber.doubleValue();
                    break;
                }
                case 51: {
                    d6 = this.dataNumber.doubleValue();
                }
            }
            this.nextPair();
            if (!this.dataString.equals("EOF")) continue;
            return false;
        }
        JunOpenGL3dPolyline junOpenGL3dPolyline = new JunOpenGL3dPolyline(JunDXFParser.CalculateARC_radius_from_to_(new Jun3dPoint(d, d2, d3), d4, d5, d6));
        this.unNextPair();
        junOpenGL3dPolyline.name_(string);
        this.item = new Object[]{this.layer, junOpenGL3dPolyline};
        this.count_(JunDXFParser.$((String)"arc"));
        return true;
    }

    public boolean parseBlock() {
        while (this.groupCode != 0 || !this.dataString.equals("ENDBLK")) {
            this.nextPair();
            if (this.groupCode != 3 || this.dataString.charAt(0) == '$') continue;
            this.newDxfDefinition_(this.dataString);
        }
        return true;
    }

    public boolean parseBlocks() {
        while (this.groupCode != 0 || !this.dataString.equals("ENDSEC")) {
            this.nextPair();
            if (this.groupCode != 0 || !this.dataString.equals("BLOCK")) continue;
            this.parseBlock();
        }
        return true;
    }

    public boolean parseCIRCLE() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray = new double[]{1.0, 0.707107, 1.0, 0.707107, 1.0, 0.707107, 1.0, 0.707107, 1.0};
        double[] dArray2 = new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 2.0, 2.0, 3.0, 3.0, 4.0, 4.0, 4.0};
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[9];
        String string = String.valueOf(this.mark);
        this.nextPair();
        if (this.dataString.equals("EOF")) {
            return false;
        }
        while (this.groupCode != 0) {
            switch (this.groupCode) {
                case 8: {
                    this.layer = this.dataString;
                    break;
                }
                case 10: {
                    d = this.dataNumber.doubleValue();
                    break;
                }
                case 20: {
                    d2 = this.dataNumber.doubleValue();
                    break;
                }
                case 30: {
                    break;
                }
                case 40: {
                    d3 = this.dataNumber.doubleValue();
                }
            }
            this.nextPair();
            if (!this.dataString.equals("EOF")) continue;
            return false;
        }
        JunOpenGL3dPrimitiveObject junOpenGL3dPrimitiveObject = null;
        if (this.doNurbs()) {
            jun3dPointArray[0] = new Jun3dPoint(d, d2 - d3, 0.0);
            jun3dPointArray[1] = new Jun3dPoint(d + d3, d2 - d3, 0.0);
            jun3dPointArray[2] = new Jun3dPoint(d + d3, d2, 0.0);
            jun3dPointArray[3] = new Jun3dPoint(d + d3, d2 + d3, 0.0);
            jun3dPointArray[4] = new Jun3dPoint(d, d2 + d3, 0.0);
            jun3dPointArray[5] = new Jun3dPoint(d - d3, d2 + d3, 0.0);
            jun3dPointArray[6] = new Jun3dPoint(d - d3, d2, 0.0);
            jun3dPointArray[7] = new Jun3dPoint(d - d3, d2 - d3, 0.0);
            jun3dPointArray[8] = new Jun3dPoint(d, d2 - d3, 0.0);
            junOpenGL3dPrimitiveObject = new JunOpenGL3dNurbsCurve(jun3dPointArray, dArray, dArray2);
        } else {
            double d4 = Math.PI;
            double d5 = Math.PI * 2;
            double d6 = d4 / 16.0;
            double d7 = 0.0;
            double d8 = d5;
            Vector<Jun3dPoint> vector = new Vector<Jun3dPoint>(16);
            for (double d9 = d7; d9 < d8 + d6; d9 += d6) {
                double d10 = d + Math.cos(d9) * d3;
                double d11 = d2 + Math.sin(d9) * d3;
                vector.add(new Jun3dPoint(d10, d11, 0.0));
            }
            junOpenGL3dPrimitiveObject = new JunOpenGL3dPolyline(vector);
        }
        this.unNextPair();
        junOpenGL3dPrimitiveObject.name_(string);
        this.item = new Object[]{this.layer, junOpenGL3dPrimitiveObject};
        this.count_(JunDXFParser.$((String)"circle"));
        return true;
    }

    public boolean parseClasses() {
        while (this.groupCode != 0 || !this.dataString.equals("ENDSEC")) {
            this.nextPair();
        }
        return true;
    }

    public boolean parsedOk() {
        return this.happy;
    }

    public boolean parseEntities() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(5);
        hashtable.put("POLYLINE", "parsePOLYLINE");
        hashtable.put("LINE", "parseLINE");
        hashtable.put("ARC", "parseARC");
        hashtable.put("CIRCLE", "parseCIRCLE");
        hashtable.put("INSERT", "parseINSERT");
        hashtable.put("3DFACE", "parse3DFACE");
        this.definedObjects = new Vector(10);
        this.setBoundingBox();
        while (!this.dataString.equals("ENDSEC")) {
            String string;
            boolean bl = false;
            this.nextPair();
            if (this.groupCode != 0 || (string = (String)hashtable.get(this.dataString)) == null) continue;
            try {
                Boolean bl2 = (Boolean)this.perform_(string);
                bl = bl2;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl) continue;
            this.addLayeredItem_(this.item);
            this.count_(JunDXFParser.$((String)"entities"));
        }
        this.nextPair();
        return true;
    }

    public boolean parseENTITYCOLOR() {
        Number number = null;
        this.nextPair();
        if (this.dataString.equals("EOF")) {
            return false;
        }
        while (this.groupCode != 0 && this.groupCode != 9) {
            if (this.groupCode == 62) {
                number = this.dataNumber;
            }
            this.nextPair();
            if (!this.dataString.equals("EOF")) continue;
            return false;
        }
        this.item = new Object[]{number};
        this.unNextPair();
        return true;
    }

    public boolean parseEXTMAX() {
        this.parseEXTMINMAX();
        this.settings().put("EXTMAX", this.item[0]);
        this.count_(JunDXFParser.$((String)"settings"));
        return true;
    }

    public boolean parseEXTMIN() {
        this.parseEXTMINMAX();
        this.settings().put("EXTMIN", this.item[0]);
        this.count_(JunDXFParser.$((String)"settings"));
        return true;
    }

    public boolean parseHeader() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(3);
        hashtable.put("$EXTMIN", "parseEXTMIN");
        hashtable.put("$EXTMAX", "parseEXTMAX");
        hashtable.put("$CECOLOR", "parseENTITYCOLOR");
        while (this.groupCode != 0 || !this.dataString.equals("ENDSEC")) {
            String string;
            if (this.groupCode == 9 && (string = (String)hashtable.get(this.dataString)) != null) {
                try {
                    this.perform_(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.nextPair();
        }
        return true;
    }

    public boolean parseINSERT() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        String string = "";
        String string2 = String.valueOf(this.mark);
        this.nextPair();
        if (this.dataString.equals("EOF")) {
            return false;
        }
        while (this.groupCode != 0) {
            switch (this.groupCode) {
                case 2: {
                    string = this.dataString;
                    break;
                }
                case 8: {
                    this.layer = this.dataString;
                    break;
                }
                case 10: {
                    d = this.dataNumber.doubleValue();
                    break;
                }
                case 20: {
                    d2 = this.dataNumber.doubleValue();
                    break;
                }
                case 30: {
                    d3 = this.dataNumber.doubleValue();
                    break;
                }
                case 41: {
                    d7 = this.dataNumber.doubleValue();
                    break;
                }
                case 42: {
                    d8 = this.dataNumber.doubleValue();
                    break;
                }
                case 43: {
                    d9 = this.dataNumber.doubleValue();
                    break;
                }
                case 50: {
                    d10 = this.dataNumber.doubleValue();
                }
            }
            this.nextPair();
            if (!this.dataString.equals("EOF")) continue;
            return false;
        }
        JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)this.dxfNames.get(string));
        junOpenGL3dObject = junOpenGL3dObject.scaledBy_(new Jun3dPoint(d7, d8, d9));
        if (d10 != 0.0) {
            junOpenGL3dObject = junOpenGL3dObject.rotatedBy_(JunAngle.FromDeg_(d10));
        }
        junOpenGL3dObject = junOpenGL3dObject.translatedBy_(new Jun3dPoint(d, d2, d3));
        if (d4 != 0.0 || d5 != 0.0 || d6 != 0.0) {
            junOpenGL3dObject = this.applyExtrusion_to_(new Jun3dPoint(d4, d5, d6), junOpenGL3dObject);
        }
        this.unNextPair();
        junOpenGL3dObject.name_(string2);
        this.item = new Object[]{this.layer, junOpenGL3dObject};
        this.count_(JunDXFParser.$((String)"insert"));
        return true;
    }

    public boolean parseLAYER() {
        String string = "";
        Number number = new Integer(0);
        this.nextPair();
        if (this.dataString.equals("EOF")) {
            return false;
        }
        while (this.groupCode != 0) {
            switch (this.groupCode) {
                case 62: {
                    number = this.dataNumber;
                    break;
                }
                case 2: {
                    string = this.dataString;
                }
            }
            this.nextPair();
            if (!this.dataString.equals("EOF")) continue;
            return false;
        }
        this.setLayerColor_to_(string, (int)number);
        this.count_(JunDXFParser.$((String)"layers"));
        this.item = new Object[]{string, number};
        this.unNextPair();
        return true;
    }

    public boolean parseLINE() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n = 0;
        String string = String.valueOf(this.mark);
        this.nextPair();
        if (this.dataString.equals("EOF")) {
            return false;
        }
        while (this.groupCode != 0) {
            switch (this.groupCode) {
                case 62: {
                    n = this.dataNumber.intValue();
                    break;
                }
                case 8: {
                    this.layer = this.dataString;
                    break;
                }
                case 10: {
                    d = this.dataNumber.doubleValue();
                    break;
                }
                case 20: {
                    d2 = this.dataNumber.doubleValue();
                    break;
                }
                case 30: {
                    d3 = this.dataNumber.doubleValue();
                    break;
                }
                case 11: {
                    d4 = this.dataNumber.doubleValue();
                    break;
                }
                case 21: {
                    d5 = this.dataNumber.doubleValue();
                    break;
                }
                case 31: {
                    d6 = this.dataNumber.doubleValue();
                }
            }
            this.nextPair();
            if (!this.dataString.equals("EOF")) continue;
            return false;
        }
        JunOpenGL3dPolyline junOpenGL3dPolyline = new JunOpenGL3dPolyline(new Jun3dPoint[]{new Jun3dPoint(d, d2, d3), new Jun3dPoint(d4, d5, d6)});
        if (n > 0) {
            junOpenGL3dPolyline.paint_(this.paintColor_(n));
        }
        this.unNextPair();
        junOpenGL3dPolyline.name_(string);
        this.item = new Object[]{this.layer, junOpenGL3dPolyline};
        this.count_(JunDXFParser.$((String)"line"));
        return true;
    }

    public boolean parseObjects() {
        while (this.groupCode != 0 || !this.dataString.equals("ENDSEC")) {
            this.nextPair();
        }
        return true;
    }

    public boolean parsePOLYLINE() {
        JunOpenGL3dObject junOpenGL3dObject;
        String string = String.valueOf(this.mark);
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "";
        Vector<Object> vector = new Vector<Object>(10);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        this.nextPair();
        while (!this.dataString.equals("SEQEND") && !this.dataString.equals("EOF")) {
            bl2 = false;
            switch (this.groupCode) {
                case 8: {
                    string2 = this.dataString;
                    break;
                }
                case 70: {
                    bl = (this.dataNumber.longValue() & 1L) == 1L;
                    break;
                }
                case 210: {
                    d = this.dataNumber.doubleValue();
                    break;
                }
                case 220: {
                    d2 = this.dataNumber.doubleValue();
                    break;
                }
                case 230: {
                    d3 = this.dataNumber.doubleValue();
                }
            }
            if (this.dataString.equals("VERTEX")) {
                bl2 = this.parseVERTEX();
                if (!bl2) continue;
                vector.add(this.itemValue());
                continue;
            }
            this.nextPair();
        }
        JunOpenGL3dPolyline junOpenGL3dPolyline = junOpenGL3dObject = bl ? new JunOpenGL3dPolylineLoop(vector) : new JunOpenGL3dPolyline(vector);
        if (d != 0.0 || d2 != 0.0 || d3 != 0.0) {
            junOpenGL3dObject = this.applyExtrusion_to_(new Jun3dPoint(d, d2, d3), junOpenGL3dObject);
        }
        junOpenGL3dObject.name_(string);
        this.item = new Object[]{string2, junOpenGL3dObject};
        this.count_(JunDXFParser.$((String)"polyline"));
        return true;
    }

    public boolean parseTables() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(1);
        hashtable.put("LAYER", "parseLAYER");
        while (!this.dataString.equals("ENDSEC")) {
            String string;
            this.nextPair();
            if (this.groupCode != 0 || (string = (String)hashtable.get(this.dataString)) == null) continue;
            try {
                this.perform_(string);
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public boolean parseVERTEX() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        this.nextPair();
        if (this.dataString.equals("EOF")) {
            return false;
        }
        while (this.groupCode != 0) {
            switch (this.groupCode) {
                case 8: {
                    this.layer = this.dataString;
                    break;
                }
                case 10: {
                    d = this.dataNumber.doubleValue();
                    break;
                }
                case 20: {
                    d2 = this.dataNumber.doubleValue();
                    break;
                }
                case 30: {
                    d3 = this.dataNumber.doubleValue();
                }
            }
            this.nextPair();
            if (!this.dataString.equals("EOF")) continue;
            return false;
        }
        this.item = new Object[]{this.layer, new Jun3dPoint(d, d2, d3)};
        this.count_(JunDXFParser.$((String)"vertex"));
        return true;
    }

    public void showCAD() {
        JunCADModel junCADModel = new JunCADModel();
        junCADModel.open();
        junCADModel.openParser_(this);
    }

    protected void addLayeredItem_(Object[] objectArray) {
        String string = (String)objectArray[0];
        JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)objectArray[1]);
        if (junOpenGL3dObject.isCompound() && ((JunOpenGL3dCompoundObject)junOpenGL3dObject).components().length == 0) {
            throw SmalltalkException.Error((String)"internal error");
        }
        if (!this.layers.containsKey(string)) {
            this.layers.put(string, new JunOpenGL3dCompoundObject());
        }
        if (this.contained_(junOpenGL3dObject)) {
            ((JunOpenGL3dCompoundObject)this.layers.get(string)).add_(junOpenGL3dObject);
        } else {
            this.outside().add(junOpenGL3dObject);
            this.count_(JunDXFParser.$((String)"outside"));
        }
    }

    protected JunOpenGL3dObject applyExtrusion_to_(Jun3dPoint jun3dPoint, JunOpenGL3dObject junOpenGL3dObject) {
        Jun3dPoint jun3dPoint2 = new Jun3dPoint(0.0, 0.0, 1.0);
        Jun3dPoint jun3dPoint3 = jun3dPoint.unitVector();
        Jun3dPoint jun3dPoint4 = jun3dPoint2.product_(jun3dPoint3);
        Jun3dLine jun3dLine = new Jun3dLine(Jun3dPoint.Zero(), jun3dPoint4);
        double d = Math.acos(jun3dPoint2.dotProduct_(jun3dPoint3));
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.Rotate_around_(JunAngle.FromRad_(d), jun3dLine);
        return junOpenGL3dObject.transform_(jun3dTransformation);
    }

    protected boolean contained_(JunOpenGL3dObject junOpenGL3dObject) {
        Jun3dBoundingBox jun3dBoundingBox = (Jun3dBoundingBox)((Object)this.settings().get("box"));
        if (jun3dBoundingBox == null) {
            return true;
        }
        return jun3dBoundingBox.contains_(junOpenGL3dObject.boundingBox());
    }

    protected void count_(StSymbol stSymbol) {
        Number number = (Number)this.itemCount.get(stSymbol);
        if (number == null) {
            this.itemCount.put(stSymbol, new Integer(1));
        } else {
            this.itemCount.put(stSymbol, new Integer(number.intValue() + 1));
        }
    }

    protected boolean doNurbs() {
        return this.doNurbs;
    }

    protected void initCounts() {
        this.itemCount = new Hashtable(10);
    }

    protected void initialize() {
        super.initialize();
        this.initParser();
        this.initCounts();
    }

    protected void initParser() {
        this.layers = new Hashtable(20);
        this.dxfNames = new Hashtable(20);
    }

    protected Object itemKey() {
        return this.item[0];
    }

    protected Object itemValue() {
        return this.item[1];
    }

    protected Hashtable layerColors() {
        if (this.layerColors == null) {
            this.layerColors = new Hashtable(50);
        }
        return this.layerColors;
    }

    protected Color layerColorsAt_(String string) {
        Color color = (Color)this.layerColors().get(string);
        if (color == null) {
            color = Color.blue;
        }
        return color;
    }

    protected Hashtable layers() {
        return this.layers;
    }

    protected boolean newDxfDefinition_(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(4);
        hashtable.put("POLYLINE", "parsePOLYLINE");
        hashtable.put("LINE", "parseLINE");
        hashtable.put("ARC", "parseARC");
        hashtable.put("CIRCLE", "parseCIRCLE");
        this.definedObjects = new Vector(10);
        while (!this.dataString.equals("ENDBLK")) {
            String string2;
            boolean bl = false;
            this.nextPair();
            if (this.groupCode != 0 || (string2 = (String)hashtable.get(this.dataString)) == null) continue;
            try {
                Boolean bl2 = (Boolean)this.perform_(string2);
                bl = bl2;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl) continue;
            this.definedObjects.add(this.item[1]);
        }
        this.count_(JunDXFParser.$((String)"names"));
        this.dxfNames.put(string, new JunOpenGL3dCompoundObject(this.definedObjects));
        return true;
    }

    protected Vector outside() {
        if (this.outside == null) {
            this.outside = new Vector(50);
        }
        return this.outside;
    }

    protected Color paintColor_(int n) {
        int n2 = n;
        if (n2 < 1 || 7 < n2) {
            n2 = 1;
        }
        return JunDXFParser.ColorAt_(n2);
    }

    protected void parse() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(5);
        hashtable.put("HEADER", "parseHeader");
        hashtable.put("CLASSES", "parseClasses");
        hashtable.put("TABLES", "parseTables");
        hashtable.put("BLOCKS", "parseBlocks");
        hashtable.put("ENTITIES", "parseEntities");
        hashtable.put("OBJECTS", "parseObjects");
        this.happy = false;
        this.nextPair();
        while (!this.dataString.equals("EOF")) {
            if (this.groupCode != 0) {
                this.failBlock.value_((Object)"invalid groupcode (not 0)");
                return;
            }
            if (!this.dataString.equals("SECTION")) {
                this.failBlock.value_((Object)"invalid section string (not SECTION)");
                return;
            }
            this.nextPair();
            if (this.groupCode != 2) {
                this.failBlock.value_((Object)"invalid section groupcode (not 2)");
                return;
            }
            boolean bl = true;
            String string = (String)hashtable.get(this.dataString);
            try {
                Boolean bl2 = (Boolean)this.perform_(string);
                bl = bl2;
            }
            catch (Exception exception) {
                bl = false;
            }
            if (bl) {
                this.count_(JunDXFParser.$((String)"sections"));
            }
            this.nextPair();
        }
        this.setLayerNames();
        this.updateLayerColors();
        this.happy = true;
    }

    protected boolean parseEXTMINMAX() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        this.nextPair();
        if (this.dataString.equals("EOF")) {
            return false;
        }
        while (this.groupCode != 0 && this.groupCode != 9) {
            switch (this.groupCode) {
                case 10: {
                    d = this.dataNumber.doubleValue();
                    break;
                }
                case 20: {
                    d2 = this.dataNumber.doubleValue();
                    break;
                }
                case 30: {
                    d3 = this.dataNumber.doubleValue();
                }
            }
            this.nextPair();
            if (!this.dataString.equals("EOF")) continue;
            return false;
        }
        Jun3dPoint jun3dPoint = new Jun3dPoint(d, d2, d3);
        this.item = new Object[]{jun3dPoint};
        this.unNextPair();
        return true;
    }

    protected void setBoundingBox() {
        Jun3dPoint jun3dPoint = (Jun3dPoint)((Object)this.settings().get("EXTMIN"));
        Jun3dPoint jun3dPoint2 = (Jun3dPoint)((Object)this.settings().get("EXTMAX"));
        if (jun3dPoint != null && jun3dPoint2 != null) {
            this.settings().put("box", Jun3dBoundingBox.Origin_corner_(jun3dPoint, jun3dPoint2));
        }
    }

    protected void setLayerColor_to_(String string, int n) {
        this.layerColors().put(string, JunDXFParser.ColorAt_(n));
    }

    protected void setLayerNames() {
        Enumeration enumeration = this.layers().keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)this.layers().get(string));
            junOpenGL3dObject.name_(string);
        }
    }

    protected Hashtable settings() {
        if (this.settings == null) {
            this.settings = new Hashtable(10);
        }
        return this.settings;
    }

    protected void updateLayerColors() {
        Enumeration enumeration = this.layers().keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            JunOpenGL3dObject junOpenGL3dObject = (JunOpenGL3dObject)((Object)this.layers().get(string));
            junOpenGL3dObject.paint_(this.layerColorsAt_(string));
        }
    }
}

