/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.delaunay.twoD;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayProcessor;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.smalltalk.StBlockClosure;

public class Jun2dDelaunayProcessorTestExamples
extends JunTestExamples {
    public static boolean Example1() {
        class CanvasExample
        extends Canvas
        implements Runnable {
            protected Jun2dBoundingBox bounds;
            protected Jun2dDelaunayProcessor processor;
            protected Thread thread;

            CanvasExample() {
            }

            public void run() {
                while (this.thread != null) {
                    this.repaint();
                    CanvasExample canvasExample = this;
                    canvasExample.thread.yield();
                }
            }

            public void start() {
                this.thread = new Thread(this);
                this.thread.setPriority(1);
                this.thread.start();
            }

            public void stop() {
                this.thread = null;
            }

            public void paint(Graphics graphics) {
                if (this.processor == null) {
                    Jun2dPoint jun2dPoint = new Jun2dPoint(0.0, 0.0);
                    Jun2dPoint jun2dPoint2 = new Jun2dPoint(this.getSize().width, this.getSize().height);
                    this.bounds = Jun2dBoundingBox.Origin_extent_(jun2dPoint, jun2dPoint2).expandedBy_(-2.0);
                    this.processor = new Jun2dDelaunayProcessor(this.bounds);
                    this.bounds = this.bounds.expandedBy_(-10.0);
                }
                double d = Math.random() * this.bounds.width() + this.bounds.origin().x();
                double d2 = Math.random() * this.bounds.height() + this.bounds.origin().y();
                this.processor.insertPoint_(new Jun2dPoint(d, d2));
                graphics.setClip(0, 0, this.getSize().width, this.getSize().height);
                graphics.clearRect(0, 0, this.getSize().width, this.getSize().height);
                this.processor.displayOn_(graphics);
            }
        }
        final CanvasExample canvasExample = new CanvasExample();
        Frame frame = new Frame();
        frame.setSize(400, 400);
        frame.setLayout(new BorderLayout());
        frame.add((Component)canvasExample, "Center");
        frame.addWindowListener(new WindowAdapter(){
            {
            }

            public void windowClosing(WindowEvent windowEvent) {
                canvasExample.stop();
                windowEvent.getWindow().dispose();
            }
        });
        frame.setVisible(true);
        canvasExample.start();
        return true;
    }

    public static boolean Example2() {
        Frame frame = new Frame();
        Canvas canvas = new Canvas(){

            public void paint(final Graphics graphics) {
                Jun2dPoint jun2dPoint = new Jun2dPoint(0.0, 0.0);
                Jun2dPoint jun2dPoint2 = new Jun2dPoint(this.getSize().width, this.getSize().height);
                Jun2dBoundingBox jun2dBoundingBox = Jun2dBoundingBox.Origin_extent_(jun2dPoint, jun2dPoint2).expandedBy_(-2.0);
                Jun2dDelaunayProcessor jun2dDelaunayProcessor = new Jun2dDelaunayProcessor(jun2dBoundingBox);
                jun2dBoundingBox = jun2dBoundingBox.expandedBy_(-10.0);
                Jun2dPoint jun2dPoint3 = new Jun2dPoint((int)jun2dBoundingBox.center().x(), (int)jun2dBoundingBox.center().y());
                double d = Math.min(jun2dBoundingBox.height(), jun2dBoundingBox.width()) / 4.0;
                JunPoint[] junPointArray = new Jun2dPoint[]{new Jun2dPoint(-0.3, 1.0).multipliedBy_(d).plus_(jun2dPoint3), new Jun2dPoint(0.3, 1.0).multipliedBy_(d).plus_(jun2dPoint3), new Jun2dPoint(0.3, 0.0).multipliedBy_(d).plus_(jun2dPoint3), new Jun2dPoint(0.2, 0.0).multipliedBy_(d).plus_(jun2dPoint3), new Jun2dPoint(0.2, 0.9).multipliedBy_(d).plus_(jun2dPoint3), new Jun2dPoint(0.05, 0.9).multipliedBy_(d).plus_(jun2dPoint3), new Jun2dPoint(0.05, -1.0).multipliedBy_(d).plus_(jun2dPoint3), new Jun2dPoint(-0.05, -1.0).multipliedBy_(d).plus_(jun2dPoint3), new Jun2dPoint(-0.05, 0.9).multipliedBy_(d).plus_(jun2dPoint3), new Jun2dPoint(-0.2, 0.9).multipliedBy_(d).plus_(jun2dPoint3), new Jun2dPoint(-0.2, 0.0).multipliedBy_(d).plus_(jun2dPoint3), new Jun2dPoint(-0.3, 0.0).multipliedBy_(d).plus_(jun2dPoint3)};
                jun2dDelaunayProcessor.insertPolygon_(junPointArray);
                graphics.setClip(0, 0, this.getSize().width, this.getSize().height);
                graphics.clearRect(0, 0, this.getSize().width, this.getSize().height);
                graphics.setColor(Color.blue);
                jun2dDelaunayProcessor.insideTrianglesDo_(new StBlockClosure(){

                    public Object value_value_value_(Object object, Object object2, Object object3) {
                        Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)object);
                        Jun2dPoint jun2dPoint2 = (Jun2dPoint)((Object)object2);
                        Jun2dPoint jun2dPoint3 = (Jun2dPoint)((Object)object3);
                        int[] nArray = new int[]{(int)jun2dPoint.x(), (int)jun2dPoint2.x(), (int)jun2dPoint3.x()};
                        int[] nArray2 = new int[]{(int)jun2dPoint.y(), (int)jun2dPoint2.y(), (int)jun2dPoint3.y()};
                        int n = 3;
                        graphics.fillPolygon(nArray, nArray2, n);
                        return null;
                    }
                });
                graphics.setColor(Color.black);
                jun2dDelaunayProcessor.displayOn_(graphics);
            }
        };
        frame.setSize(400, 400);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().dispose();
            }
        });
        frame.setLayout(new BorderLayout());
        frame.add((Component)canvas, "Center");
        frame.setVisible(true);
        return true;
    }

    public static boolean Example3() {
        Frame frame = new Frame();
        frame.setSize(400, 400);
        frame.setLayout(new BorderLayout());
        Canvas canvas = new Canvas(){

            public void paint(final Graphics graphics) {
                double d;
                double d2;
                double d3;
                int n;
                final Dimension dimension = this.getSize();
                Jun2dPoint jun2dPoint = new Jun2dPoint(0.0, 0.0);
                Jun2dPoint jun2dPoint2 = new Jun2dPoint(dimension.width, dimension.height);
                Jun2dBoundingBox jun2dBoundingBox = Jun2dBoundingBox.Origin_extent_(jun2dPoint, jun2dPoint2).expandedBy_(-2.0);
                Jun2dDelaunayProcessor jun2dDelaunayProcessor = new Jun2dDelaunayProcessor(jun2dBoundingBox);
                jun2dBoundingBox = jun2dBoundingBox.expandedBy_(-30.0);
                graphics.setClip(0, 0, dimension.width, dimension.height);
                graphics.clearRect(0, 0, dimension.width, dimension.height);
                jun2dDelaunayProcessor.displayOn_(graphics);
                Jun2dPoint jun2dPoint3 = jun2dBoundingBox.center();
                double d4 = Math.min(jun2dBoundingBox.height(), jun2dBoundingBox.width()) / 2.0;
                JunPoint[] junPointArray = new Jun2dPoint[100];
                for (n = 0; n < 100; ++n) {
                    d3 = (double)n / 100.0;
                    d2 = Math.PI * 2 * d3;
                    d = (Math.random() * 0.2 + 0.8) * d4;
                    junPointArray[n] = new Jun2dPoint(Math.cos(d2) * d, Math.sin(d2) * d).plus_(jun2dPoint3);
                }
                jun2dDelaunayProcessor.insertPolygon_interim_(junPointArray, new StBlockClosure(){

                    public Object value_(Object object) {
                        Jun2dDelaunayProcessor jun2dDelaunayProcessor = (Jun2dDelaunayProcessor)((Object)object);
                        graphics.clearRect(0, 0, dimension.width, dimension.height);
                        jun2dDelaunayProcessor.displayOn_(graphics);
                        return null;
                    }
                });
                for (n = 0; n < 100; ++n) {
                    d3 = (double)n / 100.0;
                    d2 = Math.PI * 2 * d3;
                    d = (Math.random() * 0.5 + 0.3) * d4;
                    junPointArray[n] = new Jun2dPoint(Math.cos(d2) * d, Math.sin(d2) * d).plus_(jun2dPoint3);
                }
                jun2dDelaunayProcessor.insertPolygon_interim_(junPointArray, new StBlockClosure(){

                    public Object value_(Object object) {
                        Jun2dDelaunayProcessor jun2dDelaunayProcessor = (Jun2dDelaunayProcessor)((Object)object);
                        graphics.clearRect(0, 0, dimension.width, dimension.height);
                        jun2dDelaunayProcessor.displayOn_(graphics);
                        return null;
                    }
                });
                graphics.clearRect(0, 0, dimension.width, dimension.height);
                graphics.setColor(Color.blue);
                jun2dDelaunayProcessor.insideTrianglesDo_(new StBlockClosure(){

                    public Object value_value_value_(Object object, Object object2, Object object3) {
                        Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)object);
                        Jun2dPoint jun2dPoint2 = (Jun2dPoint)((Object)object2);
                        Jun2dPoint jun2dPoint3 = (Jun2dPoint)((Object)object3);
                        int[] nArray = new int[]{(int)jun2dPoint.x(), (int)jun2dPoint2.x(), (int)jun2dPoint3.x()};
                        int[] nArray2 = new int[]{(int)jun2dPoint.y(), (int)jun2dPoint2.y(), (int)jun2dPoint3.y()};
                        int n = 3;
                        graphics.fillPolygon(nArray, nArray2, n);
                        return null;
                    }
                });
                graphics.setColor(Color.black);
                jun2dDelaunayProcessor.displayOn_(graphics);
            }
        };
        frame.add((Component)canvas, "Center");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().dispose();
            }
        });
        frame.setVisible(true);
        return true;
    }

    public static boolean Example4() {
        Frame frame = new Frame();
        frame.setSize(400, 400);
        frame.setLayout(new BorderLayout());
        Canvas canvas = new Canvas(){

            public void paint(final Graphics graphics) {
                double d;
                double d2;
                double d3;
                int n;
                final Dimension dimension = this.getSize();
                Jun2dPoint jun2dPoint = new Jun2dPoint(0.0, 0.0);
                Jun2dPoint jun2dPoint2 = new Jun2dPoint(dimension.width, dimension.height);
                Jun2dBoundingBox jun2dBoundingBox = Jun2dBoundingBox.Origin_extent_(jun2dPoint, jun2dPoint2).expandedBy_(-2.0);
                Jun2dDelaunayProcessor jun2dDelaunayProcessor = new Jun2dDelaunayProcessor(jun2dBoundingBox);
                jun2dBoundingBox = jun2dBoundingBox.expandedBy_(-30.0);
                graphics.setClip(0, 0, dimension.width, dimension.height);
                graphics.clearRect(0, 0, dimension.width, dimension.height);
                jun2dDelaunayProcessor.displayOn_(graphics);
                Jun2dPoint jun2dPoint3 = jun2dBoundingBox.center();
                double d4 = Math.min(jun2dBoundingBox.height(), jun2dBoundingBox.width()) / 2.0;
                JunPoint[] junPointArray = new Jun2dPoint[100];
                for (n = 0; n < 100; ++n) {
                    d3 = (double)n / 100.0;
                    d2 = Math.PI * 2 * d3;
                    d = (Math.random() * 0.2 + 0.3) * d4;
                    junPointArray[n] = new Jun2dPoint(Math.cos(d2) * d, Math.sin(d2) * d).plus_(new Jun2dPoint(jun2dPoint3.x() * 0.9, jun2dPoint3.y()));
                }
                jun2dDelaunayProcessor.insertPolygon_interim_(junPointArray, new StBlockClosure(){

                    public Object value_(Object object) {
                        Jun2dDelaunayProcessor jun2dDelaunayProcessor = (Jun2dDelaunayProcessor)((Object)object);
                        graphics.clearRect(0, 0, dimension.width, dimension.height);
                        jun2dDelaunayProcessor.displayOn_(graphics);
                        return null;
                    }
                });
                for (n = 0; n < 100; ++n) {
                    d3 = (double)n / 100.0;
                    d2 = Math.PI * 2 * d3;
                    d = (Math.random() * 0.2 + 0.3) * d4;
                    junPointArray[n] = new Jun2dPoint(Math.cos(d2) * d, Math.sin(d2) * d).plus_(new Jun2dPoint(jun2dPoint3.x() * 1.1, jun2dPoint3.y()));
                }
                jun2dDelaunayProcessor.insertPolygon_interim_(junPointArray, new StBlockClosure(){

                    public Object value_(Object object) {
                        Jun2dDelaunayProcessor jun2dDelaunayProcessor = (Jun2dDelaunayProcessor)((Object)object);
                        graphics.clearRect(0, 0, dimension.width, dimension.height);
                        jun2dDelaunayProcessor.displayOn_(graphics);
                        return null;
                    }
                });
                graphics.clearRect(0, 0, dimension.width, dimension.height);
                graphics.setColor(Color.blue);
                jun2dDelaunayProcessor.insideTrianglesDo_(new StBlockClosure(){

                    public Object value_value_value_(Object object, Object object2, Object object3) {
                        Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)object);
                        Jun2dPoint jun2dPoint2 = (Jun2dPoint)((Object)object2);
                        Jun2dPoint jun2dPoint3 = (Jun2dPoint)((Object)object3);
                        int[] nArray = new int[]{(int)jun2dPoint.x(), (int)jun2dPoint2.x(), (int)jun2dPoint3.x()};
                        int[] nArray2 = new int[]{(int)jun2dPoint.y(), (int)jun2dPoint2.y(), (int)jun2dPoint3.y()};
                        int n = 3;
                        graphics.fillPolygon(nArray, nArray2, n);
                        return null;
                    }
                });
                graphics.setColor(Color.black);
                jun2dDelaunayProcessor.displayOn_(graphics);
            }
        };
        frame.add((Component)canvas, "Center");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().dispose();
            }
        });
        frame.setVisible(true);
        return true;
    }

    public static boolean Example5() {
        Frame frame = new Frame();
        frame.setSize(400, 400);
        frame.setLayout(new BorderLayout());
        Canvas canvas = new Canvas(){

            public void paint(final Graphics graphics) {
                final Dimension dimension = this.getSize();
                Jun2dPoint jun2dPoint = new Jun2dPoint(0.0, 0.0);
                Jun2dPoint jun2dPoint2 = new Jun2dPoint(dimension.width, dimension.height);
                Jun2dBoundingBox jun2dBoundingBox = Jun2dBoundingBox.Origin_extent_(jun2dPoint, jun2dPoint2).expandedBy_(-2.0);
                Jun2dDelaunayProcessor jun2dDelaunayProcessor = new Jun2dDelaunayProcessor(jun2dBoundingBox);
                jun2dBoundingBox = jun2dBoundingBox.expandedBy_(-30.0);
                graphics.setClip(0, 0, dimension.width, dimension.height);
                graphics.clearRect(0, 0, dimension.width, dimension.height);
                jun2dDelaunayProcessor.displayOn_(graphics);
                Jun2dPoint jun2dPoint3 = jun2dBoundingBox.center();
                double d = Math.min(jun2dBoundingBox.height(), jun2dBoundingBox.width()) / 2.0;
                JunPoint[] junPointArray = new Jun2dPoint[40];
                for (int i = 0; i < 40; ++i) {
                    junPointArray[i] = new Jun2dPoint((Math.random() * 2.0 - 1.0) * d + jun2dPoint3.x(), (Math.random() * 2.0 - 1.0) * d + jun2dPoint3.y());
                }
                jun2dDelaunayProcessor.insertPolygon_interim_(junPointArray, new StBlockClosure(){

                    public Object value_(Object object) {
                        Jun2dDelaunayProcessor jun2dDelaunayProcessor = (Jun2dDelaunayProcessor)((Object)object);
                        graphics.clearRect(0, 0, dimension.width, dimension.height);
                        jun2dDelaunayProcessor.displayOn_(graphics);
                        return null;
                    }
                });
                graphics.clearRect(0, 0, dimension.width, dimension.height);
                graphics.setColor(Color.blue);
                jun2dDelaunayProcessor.insideTrianglesDo_(new StBlockClosure(){

                    public Object value_value_value_(Object object, Object object2, Object object3) {
                        Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)object);
                        Jun2dPoint jun2dPoint2 = (Jun2dPoint)((Object)object2);
                        Jun2dPoint jun2dPoint3 = (Jun2dPoint)((Object)object3);
                        int[] nArray = new int[]{(int)jun2dPoint.x(), (int)jun2dPoint2.x(), (int)jun2dPoint3.x()};
                        int[] nArray2 = new int[]{(int)jun2dPoint.y(), (int)jun2dPoint2.y(), (int)jun2dPoint3.y()};
                        int n = 3;
                        graphics.fillPolygon(nArray, nArray2, n);
                        return null;
                    }
                });
                graphics.setColor(Color.black);
                jun2dDelaunayProcessor.displayOn_(graphics);
            }
        };
        frame.add((Component)canvas, "Center");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().dispose();
            }
        });
        frame.setVisible(true);
        return true;
    }

    public static void main(String[] stringArray) {
        new Jun2dDelaunayProcessorTestExamples();
    }
}

