/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.delaunay.twoD;

import java.awt.Graphics;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayElement;
import jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayHalfEdge;
import jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayVertex;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StValueHolder;

public class Jun2dDelaunayLoop
extends Jun2dDelaunayElement {
    protected Jun2dDelaunayHalfEdge halfEdge;

    public double area() {
        Jun2dDelaunayVertex jun2dDelaunayVertex = this.halfEdge.vertex();
        Jun2dDelaunayVertex jun2dDelaunayVertex2 = this.halfEdge.next().vertex();
        Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = this.halfEdge.next().next();
        double d = 0.0;
        do {
            d += jun2dDelaunayHalfEdge.vertex().areaWith_with_(jun2dDelaunayVertex, jun2dDelaunayVertex2);
        } while ((jun2dDelaunayHalfEdge = jun2dDelaunayHalfEdge.next()) != this.halfEdge);
        return d;
    }

    public Vector asArrayOfJun2dPoint() {
        final Vector vector = new Vector();
        this.verticesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayVertex jun2dDelaunayVertex = (Jun2dDelaunayVertex)((Object)object);
                vector.addElement(jun2dDelaunayVertex.asJun2dPoint());
                return null;
            }
        });
        return vector;
    }

    public Vector asArrayOfJun3dPoint() {
        final Vector vector = new Vector();
        this.verticesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayVertex jun2dDelaunayVertex = (Jun2dDelaunayVertex)((Object)object);
                vector.addElement(jun2dDelaunayVertex.asJun3dPoint());
                return null;
            }
        });
        return vector;
    }

    public Jun2dDelaunayVertex center() {
        final StValueHolder stValueHolder = new StValueHolder();
        final StValueHolder stValueHolder2 = new StValueHolder();
        final StValueHolder stValueHolder3 = new StValueHolder();
        stValueHolder.value_(0.0);
        stValueHolder2.value_(0.0);
        stValueHolder3.value_(0);
        this.verticesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayVertex jun2dDelaunayVertex = (Jun2dDelaunayVertex)((Object)object);
                stValueHolder.value_(stValueHolder._doubleValue() + jun2dDelaunayVertex.x());
                stValueHolder2.value_(stValueHolder2._doubleValue() + jun2dDelaunayVertex.y());
                stValueHolder3.value_(stValueHolder3._intValue() + 1);
                return null;
            }
        });
        return new Jun2dDelaunayVertex(stValueHolder._doubleValue() / stValueHolder3._doubleValue(), stValueHolder2._doubleValue() / stValueHolder3._doubleValue());
    }

    public boolean contains_(Jun2dDelaunayVertex jun2dDelaunayVertex) {
        return this.containsX_y_(jun2dDelaunayVertex.x(), jun2dDelaunayVertex.y());
    }

    public boolean containsX_y_(final double d, final double d2) {
        if (this.area() > 1.0E-12) {
            final StValueHolder stValueHolder = new StValueHolder();
            final StValueHolder stValueHolder2 = new StValueHolder();
            final StValueHolder stValueHolder3 = new StValueHolder();
            final StValueHolder stValueHolder4 = new StValueHolder();
            stValueHolder.value_(this.halfEdge.vertex().x());
            stValueHolder2.value_(this.halfEdge.vertex().x());
            stValueHolder3.value_(this.halfEdge.vertex().y());
            stValueHolder4.value_(this.halfEdge.vertex().y());
            this.verticesDo_(new StBlockClosure(){

                public Object value_(Object object) {
                    Jun2dDelaunayVertex jun2dDelaunayVertex = (Jun2dDelaunayVertex)((Object)object);
                    double d = jun2dDelaunayVertex.x();
                    double d2 = jun2dDelaunayVertex.y();
                    if (d < stValueHolder._doubleValue()) {
                        stValueHolder.value_(d);
                    }
                    if (stValueHolder2._doubleValue() < d) {
                        stValueHolder2.value_(d);
                    }
                    if (d2 < stValueHolder3._doubleValue()) {
                        stValueHolder3.value_(d2);
                    }
                    if (stValueHolder4._doubleValue() < d2) {
                        stValueHolder4.value_(d2);
                    }
                    return null;
                }
            });
            if (stValueHolder._doubleValue() - 1.0E-12 <= d && d <= stValueHolder2._doubleValue() + 1.0E-12 && stValueHolder3._doubleValue() - 1.0E-12 <= d2 && d2 <= stValueHolder4._doubleValue() + 1.0E-12) {
                Object object = this.halfEdgesDo_(new StBlockClosure(){

                    public Object value_(Object object) {
                        Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                        Jun2dDelaunayVertex jun2dDelaunayVertex = jun2dDelaunayHalfEdge.pair().vertex();
                        Jun2dDelaunayVertex jun2dDelaunayVertex2 = jun2dDelaunayHalfEdge.vertex();
                        if ((jun2dDelaunayVertex.x() - d) * (jun2dDelaunayVertex2.y() - d2) - (jun2dDelaunayVertex.y() - d2) * (jun2dDelaunayVertex2.x() - d) < 0.0) {
                            return Boolean.FALSE;
                        }
                        return null;
                    }
                });
                return object != Boolean.FALSE;
            }
        }
        return false;
    }

    public void displayOn_(final Graphics graphics) {
        this.halfEdgesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                jun2dDelaunayHalfEdge.displayOn_(graphics);
                return null;
            }
        });
    }

    public Object edgesDo_(final StBlockClosure stBlockClosure) {
        return this.halfEdge.do_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                Object object2 = stBlockClosure.value_((Object)jun2dDelaunayHalfEdge.edge());
                if (object2 != null) {
                    return object2;
                }
                return null;
            }
        });
    }

    public Jun2dDelaunayHalfEdge farestHalfEdgeFromVertex_(Jun2dDelaunayVertex jun2dDelaunayVertex) {
        Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = this.halfEdge;
        double d = this.halfEdge.vertex().squaredDistance_(jun2dDelaunayVertex);
        Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge2 = this.halfEdge.next();
        do {
            double d2;
            if (!(d < (d2 = jun2dDelaunayHalfEdge2.vertex().squaredDistance_(jun2dDelaunayVertex)))) continue;
            d = d2;
            jun2dDelaunayHalfEdge = jun2dDelaunayHalfEdge2;
        } while ((jun2dDelaunayHalfEdge2 = jun2dDelaunayHalfEdge2.next()) != this.halfEdge);
        return jun2dDelaunayHalfEdge;
    }

    public Jun2dDelaunayHalfEdge halfEdge() {
        return this.halfEdge;
    }

    public void halfEdge_(Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge) {
        this.halfEdge = jun2dDelaunayHalfEdge;
    }

    public Object halfEdgesDo_(StBlockClosure stBlockClosure) {
        return this.halfEdge.do_(stBlockClosure);
    }

    public boolean hasBoundaryVertex() {
        Object object = this.verticesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayVertex jun2dDelaunayVertex = (Jun2dDelaunayVertex)((Object)object);
                if (jun2dDelaunayVertex.isBoundaryVertex()) {
                    return Boolean.TRUE;
                }
                return null;
            }
        });
        return object == Boolean.TRUE;
    }

    public boolean intersectsWithLineSegmentFrom_to_(final Jun2dDelaunayVertex jun2dDelaunayVertex, final Jun2dDelaunayVertex jun2dDelaunayVertex2) {
        Object object = this.halfEdge.do_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                if (jun2dDelaunayHalfEdge.intersectsWithLineSegmentFrom_to_(jun2dDelaunayVertex, jun2dDelaunayVertex2)) {
                    return Boolean.TRUE;
                }
                return null;
            }
        });
        return object == Boolean.TRUE;
    }

    public boolean isTriangle() {
        return this.halfEdge.next().next().next() == this.halfEdge;
    }

    public Jun2dDelaunayHalfEdge nearestHalfEdgeFromVertex_(Jun2dDelaunayVertex jun2dDelaunayVertex) {
        Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = this.halfEdge;
        double d = this.halfEdge.vertex().squaredDistance_(jun2dDelaunayVertex);
        Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge2 = this.halfEdge.next();
        do {
            double d2;
            if (!((d2 = jun2dDelaunayHalfEdge2.vertex().squaredDistance_(jun2dDelaunayVertex)) < d)) continue;
            d = d2;
            jun2dDelaunayHalfEdge = jun2dDelaunayHalfEdge2;
        } while ((jun2dDelaunayHalfEdge2 = jun2dDelaunayHalfEdge2.next()) != this.halfEdge);
        return jun2dDelaunayHalfEdge;
    }

    public Object neighborsDo_(final StBlockClosure stBlockClosure) {
        return this.halfEdge.do_(new StBlockClosure(){

            public Object value_(Object object) {
                Object object2;
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                Jun2dDelaunayLoop jun2dDelaunayLoop = jun2dDelaunayHalfEdge.pair().loop();
                if (jun2dDelaunayLoop != null && (object2 = stBlockClosure.value_((Object)jun2dDelaunayLoop)) != null) {
                    return object2;
                }
                return null;
            }
        });
    }

    public JunPoint point1() {
        return this.halfEdge.vertex().point();
    }

    public JunPoint point2() {
        return this.halfEdge.next().vertex().point();
    }

    public JunPoint point3() {
        return this.halfEdge.next().next().vertex().point();
    }

    public void printOn_(final Writer writer) throws IOException {
        writer.write("Loop(");
        this.verticesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayVertex jun2dDelaunayVertex = (Jun2dDelaunayVertex)((Object)object);
                try {
                    writer.write(Double.toString(jun2dDelaunayVertex.x()));
                    writer.write("@");
                    writer.write(Double.toString(jun2dDelaunayVertex.y()));
                    writer.write(" ");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        });
        writer.write(")");
    }

    public Object verticesDo_(final StBlockClosure stBlockClosure) {
        return this.halfEdge.do_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                Object object2 = stBlockClosure.value_((Object)jun2dDelaunayHalfEdge.vertex());
                if (object2 != null) {
                    return object2;
                }
                return null;
            }
        });
    }

    protected Jun2dDelaunayHalfEdge nearestHalfEdgeFromX_y_(double d, double d2) {
        Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = this.halfEdge;
        double d3 = this.halfEdge.edge().squaredDistanceFromX_y_(d, d2);
        Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge2 = this.halfEdge.next();
        do {
            double d4;
            if (!((d4 = jun2dDelaunayHalfEdge2.edge().squaredDistanceFromX_y_(d, d2)) < d3)) continue;
            d3 = d4;
            jun2dDelaunayHalfEdge = jun2dDelaunayHalfEdge2;
        } while ((jun2dDelaunayHalfEdge2 = jun2dDelaunayHalfEdge2.next()) != this.halfEdge);
        return jun2dDelaunayHalfEdge;
    }
}

