/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.delaunay.twoD;

import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import java.io.Writer;
import jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayElement;
import jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayHalfEdge;
import jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayLoop;
import jp.co.sra.jun.delaunay.twoD.Jun2dDelaunayVertex;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;

public class Jun2dDelaunayEdge
extends Jun2dDelaunayElement {
    protected Jun2dDelaunayHalfEdge halfEdge12;
    protected Jun2dDelaunayHalfEdge halfEdge21;
    protected boolean constrained;
    protected boolean dirty;

    public boolean arrange() {
        if (this.constrained || !this.dirty) {
            return false;
        }
        this.setClean();
        if (this.loop12() == null || this.loop21() == null) {
            return false;
        }
        Jun2dDelaunayVertex jun2dDelaunayVertex = this.halfEdge12().next().vertex();
        Jun2dDelaunayVertex jun2dDelaunayVertex2 = this.halfEdge21().next().vertex();
        if (this.vertex1().areaWith_with_(jun2dDelaunayVertex2, jun2dDelaunayVertex) >= 0.0 && this.vertex2().areaWith_with_(jun2dDelaunayVertex, jun2dDelaunayVertex2) >= 0.0) {
            boolean bl;
            if (this.loop12().area() < 1.0E-12 || this.loop21().area() < 1.0E-12) {
                bl = true;
            } else {
                double d = this.vertex2().cosOfAngleWith_with_(this.vertex1(), jun2dDelaunayVertex2);
                d = Math.max(this.vertex1().cosOfAngleWith_with_(jun2dDelaunayVertex2, this.vertex2()), d);
                d = Math.max(this.vertex1().cosOfAngleWith_with_(this.vertex2(), jun2dDelaunayVertex), d);
                d = Math.max(this.vertex2().cosOfAngleWith_with_(jun2dDelaunayVertex, this.vertex1()), d);
                double d2 = jun2dDelaunayVertex.cosOfAngleWith_with_(jun2dDelaunayVertex2, this.vertex2());
                d2 = Math.max(jun2dDelaunayVertex2.cosOfAngleWith_with_(this.vertex2(), jun2dDelaunayVertex), d2);
                d2 = Math.max(jun2dDelaunayVertex.cosOfAngleWith_with_(this.vertex1(), jun2dDelaunayVertex2), d2);
                d2 = Math.max(jun2dDelaunayVertex2.cosOfAngleWith_with_(jun2dDelaunayVertex, this.vertex1()), d2);
                boolean bl2 = bl = d2 < d;
            }
            if (bl) {
                this.basicArrange();
                return true;
            }
        }
        return false;
    }

    public void basicArrange() {
        if (this.constrained) {
            throw SmalltalkException.Halt((String)"constrained");
        }
        Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = this.halfEdge12().next();
        Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge2 = jun2dDelaunayHalfEdge.next();
        Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge3 = this.halfEdge21().next();
        Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge4 = jun2dDelaunayHalfEdge3.next();
        this.halfEdge12().vertex_(jun2dDelaunayHalfEdge2.pair().vertex());
        this.halfEdge12().next_(jun2dDelaunayHalfEdge2);
        jun2dDelaunayHalfEdge2.next_(jun2dDelaunayHalfEdge3);
        jun2dDelaunayHalfEdge3.next_(this.halfEdge12());
        this.halfEdge21().vertex_(jun2dDelaunayHalfEdge4.pair().vertex());
        this.halfEdge21().next_(jun2dDelaunayHalfEdge4);
        jun2dDelaunayHalfEdge4.next_(jun2dDelaunayHalfEdge);
        jun2dDelaunayHalfEdge.next_(this.halfEdge21());
        jun2dDelaunayHalfEdge4.vertex().halfEdge_(jun2dDelaunayHalfEdge4);
        jun2dDelaunayHalfEdge2.vertex().halfEdge_(jun2dDelaunayHalfEdge2);
        Jun2dDelaunayLoop jun2dDelaunayLoop = this.loop12();
        Jun2dDelaunayLoop jun2dDelaunayLoop2 = this.loop21();
        jun2dDelaunayLoop.halfEdge_(this.halfEdge12());
        jun2dDelaunayLoop2.halfEdge_(this.halfEdge21());
        final Jun2dDelaunayLoop jun2dDelaunayLoop3 = jun2dDelaunayLoop;
        jun2dDelaunayLoop.halfEdgesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                jun2dDelaunayHalfEdge.loop_(jun2dDelaunayLoop3);
                return null;
            }
        });
        final Jun2dDelaunayLoop jun2dDelaunayLoop4 = jun2dDelaunayLoop2;
        jun2dDelaunayLoop2.halfEdgesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dDelaunayHalfEdge jun2dDelaunayHalfEdge = (Jun2dDelaunayHalfEdge)((Object)object);
                jun2dDelaunayHalfEdge.loop_(jun2dDelaunayLoop4);
                return null;
            }
        });
        this.halfEdge12().prev().edge().setDirty();
        this.halfEdge12().next().edge().setDirty();
        this.halfEdge21().next().edge().setDirty();
        this.halfEdge21().prev().edge().setDirty();
    }

    public boolean contains_(Jun2dDelaunayVertex jun2dDelaunayVertex) {
        return this.containsX_y_(jun2dDelaunayVertex.x(), jun2dDelaunayVertex.y());
    }

    public boolean containsX_y_(double d, double d2) {
        return this.squaredDistanceFromX_y_(d, d2) < 1.0E-12;
    }

    public void disableArrange() {
        this.constrained = true;
    }

    public void displayOn_(Graphics graphics) {
        if (this.constrained) {
            Color color = graphics.getColor();
            graphics.setColor(Color.red);
            this.halfEdge12.displayOn_(graphics);
            graphics.setColor(color);
        } else {
            this.halfEdge12.displayOn_(graphics);
        }
    }

    public void enableArrange() {
        this.constrained = false;
    }

    public Jun2dDelaunayHalfEdge halfEdge12() {
        return this.halfEdge12;
    }

    public Jun2dDelaunayHalfEdge halfEdge21() {
        return this.halfEdge21;
    }

    protected void initialize() {
        this.halfEdge12 = new Jun2dDelaunayHalfEdge();
        this.halfEdge21 = new Jun2dDelaunayHalfEdge();
        this.halfEdge12.setEdge_(this);
        this.halfEdge21.setEdge_(this);
        this.halfEdge12.setPair_(this.halfEdge21);
        this.halfEdge21.setPair_(this.halfEdge12);
        this.constrained = false;
        this.dirty = true;
    }

    public Jun2dDelaunayVertex intersectionWith_(Jun2dDelaunayEdge jun2dDelaunayEdge) {
        return this.intersectionWithLineSegmentFrom_to_(jun2dDelaunayEdge.vertex1(), jun2dDelaunayEdge.vertex2());
    }

    public boolean intersectsWithLineSegmentFrom_to_(Jun2dDelaunayVertex jun2dDelaunayVertex, Jun2dDelaunayVertex jun2dDelaunayVertex2) {
        return this.halfEdge12.intersectsWithLineSegmentFrom_to_(jun2dDelaunayVertex, jun2dDelaunayVertex2);
    }

    public boolean isArrangeable() {
        if (this.isConstrained()) {
            return false;
        }
        Jun2dDelaunayVertex jun2dDelaunayVertex = this.halfEdge12().next().vertex;
        Jun2dDelaunayVertex jun2dDelaunayVertex2 = this.halfEdge21().next().vertex;
        return this.vertex1().areaWith_with_(jun2dDelaunayVertex2, jun2dDelaunayVertex) >= 0.0 && this.vertex2().areaWith_with_(jun2dDelaunayVertex, jun2dDelaunayVertex2) >= 0.0;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double lengthSquared() {
        return this.vertex1().dotProduct_(this.vertex2());
    }

    public Jun2dDelaunayLoop loop12() {
        return this.halfEdge12.loop();
    }

    public void loop12_(Jun2dDelaunayLoop jun2dDelaunayLoop) {
        this.halfEdge12.loop_(jun2dDelaunayLoop);
    }

    public Jun2dDelaunayLoop loop21() {
        return this.halfEdge21.loop();
    }

    public void loop21_(Jun2dDelaunayLoop jun2dDelaunayLoop) {
        this.halfEdge21.loop_(jun2dDelaunayLoop);
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write("Edge(");
        writer.write(Double.toString(this.vertex1().x()));
        writer.write("@");
        writer.write(Double.toString(this.vertex1().y()));
        writer.write(" ");
        writer.write(Double.toString(this.vertex2().x()));
        writer.write("@");
        writer.write(Double.toString(this.vertex2().y()));
        writer.write(")");
    }

    public boolean recursiveArrange() {
        if (this.arrange()) {
            this.halfEdge12().prev().edge().recursiveArrange();
            this.halfEdge12().next().edge().recursiveArrange();
            this.halfEdge21().next().edge().recursiveArrange();
            this.halfEdge21().prev().edge().recursiveArrange();
            return true;
        }
        return false;
    }

    public Jun2dDelaunayVertex vertex1() {
        return this.halfEdge21.vertex();
    }

    public void vertex1_(Jun2dDelaunayVertex jun2dDelaunayVertex) {
        this.halfEdge21.vertex_(jun2dDelaunayVertex);
    }

    public Jun2dDelaunayVertex vertex2() {
        return this.halfEdge12.vertex();
    }

    public void vertex2_(Jun2dDelaunayVertex jun2dDelaunayVertex) {
        this.halfEdge12.vertex_(jun2dDelaunayVertex);
    }

    protected double distanceFromX_y_(double d, double d2) {
        return Math.sqrt(this.squaredDistanceFromX_y_(d, d2));
    }

    protected Jun2dDelaunayVertex intersectionWithLineSegmentFrom_to_(Jun2dDelaunayVertex jun2dDelaunayVertex, Jun2dDelaunayVertex jun2dDelaunayVertex2) {
        double d;
        Jun2dDelaunayVertex jun2dDelaunayVertex3 = this.vertex1();
        Jun2dDelaunayVertex jun2dDelaunayVertex4 = this.vertex2();
        Jun2dDelaunayVertex jun2dDelaunayVertex5 = jun2dDelaunayVertex;
        Jun2dDelaunayVertex jun2dDelaunayVertex6 = jun2dDelaunayVertex2;
        if (Math.max(jun2dDelaunayVertex3.x(), jun2dDelaunayVertex4.x()) < Math.min(jun2dDelaunayVertex5.x(), jun2dDelaunayVertex6.x())) {
            return null;
        }
        if (Math.max(jun2dDelaunayVertex5.x(), jun2dDelaunayVertex6.x()) < Math.min(jun2dDelaunayVertex3.x(), jun2dDelaunayVertex4.x())) {
            return null;
        }
        if (Math.max(jun2dDelaunayVertex3.y(), jun2dDelaunayVertex4.y()) < Math.min(jun2dDelaunayVertex5.y(), jun2dDelaunayVertex6.y())) {
            return null;
        }
        if (Math.max(jun2dDelaunayVertex5.y(), jun2dDelaunayVertex6.y()) < Math.min(jun2dDelaunayVertex3.y(), jun2dDelaunayVertex4.y())) {
            return null;
        }
        double d2 = jun2dDelaunayVertex4.x() - jun2dDelaunayVertex3.x();
        double d3 = jun2dDelaunayVertex4.y() - jun2dDelaunayVertex3.y();
        double d4 = jun2dDelaunayVertex6.x() - jun2dDelaunayVertex5.x();
        double d5 = d4 * d3 - d2 * (d = jun2dDelaunayVertex6.y() - jun2dDelaunayVertex5.y());
        if (Math.abs(d5) < 1.0E-12) {
            return null;
        }
        double d6 = (d4 * (jun2dDelaunayVertex5.y() - jun2dDelaunayVertex3.y()) - d * (jun2dDelaunayVertex5.x() - jun2dDelaunayVertex3.x())) / d5;
        if (!(-1.0E-12 <= d6) || !(d6 <= 1.000000000001)) {
            return null;
        }
        double d7 = (d3 * (jun2dDelaunayVertex3.x() - jun2dDelaunayVertex5.x()) - d2 * (jun2dDelaunayVertex3.y() - jun2dDelaunayVertex5.y())) / d5;
        if (!(-1.0E-12 <= d7) || !(d7 <= 1.000000000001)) {
            return null;
        }
        return new Jun2dDelaunayVertex(d2 * d6 + jun2dDelaunayVertex3.x(), d3 * d6 + jun2dDelaunayVertex3.y(), jun2dDelaunayVertex3.z() != Double.NaN ? (jun2dDelaunayVertex4.z() != Double.NaN ? (jun2dDelaunayVertex4.z() - jun2dDelaunayVertex3.z()) * d6 + jun2dDelaunayVertex3.z() : jun2dDelaunayVertex3.z()) : (jun2dDelaunayVertex4.z() != Double.NaN ? jun2dDelaunayVertex4.z() : Double.NaN));
    }

    protected void setClean() {
        this.dirty = false;
    }

    protected void setDirty() {
        this.dirty = true;
    }

    protected double squaredDistanceFromX_y_(double d, double d2) {
        Jun2dDelaunayVertex jun2dDelaunayVertex = this.vertex1();
        Jun2dDelaunayVertex jun2dDelaunayVertex2 = this.vertex2();
        double d3 = jun2dDelaunayVertex2.x() - jun2dDelaunayVertex.x();
        double d4 = jun2dDelaunayVertex2.y() - jun2dDelaunayVertex.y();
        double d5 = Math.pow(d3, 2.0) + Math.pow(d4, 2.0);
        if (d5 < 1.0E-12) {
            return (Math.pow(jun2dDelaunayVertex.x() - d, 2.0) + Math.pow(jun2dDelaunayVertex.y() - d2, 2.0)) / 1.0E-12;
        }
        double d6 = d - jun2dDelaunayVertex.x();
        double d7 = d2 - jun2dDelaunayVertex.y();
        double d8 = (d3 * d6 + d4 * d7) / d5;
        d8 = Math.max(Math.min(d8, 1.0), 0.0);
        double d9 = d3 * d8 + jun2dDelaunayVertex.x();
        double d10 = d4 * d8 + jun2dDelaunayVertex.y();
        return Math.pow(d - d9, 2.0) + Math.pow(d2 - d10, 2.0);
    }
}

