/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.collections.support;

import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.smalltalk.SmalltalkException;

public class JunCorrelation
extends JunAbstractObject {
    public static final double ACCURACY = 1.0E-5;
    protected Number[] collectionX = null;
    protected Number[] collectionY = null;
    protected boolean nMinusOne = true;
    protected double meanX = Double.NaN;
    protected double meanY = Double.NaN;
    protected double varianceX = Double.NaN;
    protected double varianceY = Double.NaN;
    protected double standardDeviationX = Double.NaN;
    protected double standardDeviationY = Double.NaN;
    protected double covariance = Double.NaN;
    protected double coefficient = Double.NaN;
    protected double[] _collectionX = null;
    protected double[] _collectionY = null;

    public JunCorrelation(double[] dArray, double[] dArray2) {
        this.collectionX_(dArray);
        this.collectionY_(dArray2);
    }

    public JunCorrelation(float[] fArray, float[] fArray2) {
        this.collectionX_(fArray);
        this.collectionY_(fArray2);
    }

    public JunCorrelation(int[] nArray, int[] nArray2) {
        this.collectionX_(nArray);
        this.collectionY_(nArray2);
    }

    public JunCorrelation(long[] lArray, long[] lArray2) {
        this.collectionX_(lArray);
        this.collectionY_(lArray2);
    }

    public double coefficient() {
        if (Double.isNaN(this.coefficient)) {
            double d = this.standardDeviationX() * this.standardDeviationY();
            if (d <= 1.0E-5) {
                d = 1.0E-5;
            }
            this.coefficient = this.covariance() / d;
        }
        return this.coefficient;
    }

    public double[] collectionX() {
        if (this._collectionX == null) {
            this._collectionX = new double[this.collectionX.length];
            for (int i = 0; i < this.collectionX.length; ++i) {
                this._collectionX[i] = this.collectionX[i].doubleValue();
            }
        }
        return this._collectionX;
    }

    public void collectionX_(double[] dArray) {
        Number[] numberArray = new Double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            numberArray[i] = new Double(dArray[i]);
        }
        this.collectionX_(numberArray);
        this._collectionX = dArray;
    }

    public void collectionX_(float[] fArray) {
        Number[] numberArray = new Float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            numberArray[i] = new Float(fArray[i]);
        }
        this.collectionX_(numberArray);
    }

    public void collectionX_(int[] nArray) {
        Number[] numberArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            numberArray[i] = new Integer(nArray[i]);
        }
        this.collectionX_(numberArray);
    }

    public void collectionX_(long[] lArray) {
        Number[] numberArray = new Long[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            numberArray[i] = new Long(lArray[i]);
        }
        this.collectionX_(numberArray);
    }

    public void collectionX_(Number[] numberArray) {
        this.collectionX = numberArray;
        this._collectionX = null;
        this.meanX = Double.NaN;
        this.varianceX = Double.NaN;
        this.covariance = Double.NaN;
        this.coefficient = Double.NaN;
    }

    public double[] collectionY() {
        if (this._collectionY == null) {
            this._collectionY = new double[this.collectionY.length];
            for (int i = 0; i < this.collectionY.length; ++i) {
                this._collectionY[i] = this.collectionY[i].doubleValue();
            }
        }
        return this._collectionY;
    }

    public void collectionY_(double[] dArray) {
        Number[] numberArray = new Double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            numberArray[i] = new Double(dArray[i]);
        }
        this.collectionY_(numberArray);
        this._collectionX = dArray;
    }

    public void collectionY_(float[] fArray) {
        Number[] numberArray = new Float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            numberArray[i] = new Float(fArray[i]);
        }
        this.collectionY_(numberArray);
    }

    public void collectionY_(int[] nArray) {
        Number[] numberArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            numberArray[i] = new Integer(nArray[i]);
        }
        this.collectionY_(numberArray);
    }

    public void collectionY_(long[] lArray) {
        Number[] numberArray = new Long[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            numberArray[i] = new Long(lArray[i]);
        }
        this.collectionY_(numberArray);
    }

    public void collectionY_(Number[] numberArray) {
        this.collectionY = numberArray;
        this._collectionY = null;
        this.meanY = Double.NaN;
        this.varianceY = Double.NaN;
        this.covariance = Double.NaN;
        this.coefficient = Double.NaN;
    }

    public double covariance() {
        if (Double.isNaN(this.covariance)) {
            double[] dArray;
            double d = 0.0;
            double[] dArray2 = this.collectionX();
            if (dArray2.length != (dArray = this.collectionY()).length) {
                throw new SmalltalkException("no match error");
            }
            int n = dArray2.length;
            for (int i = 0; i < n; ++i) {
                double d2 = dArray2[i] - this.meanX();
                double d3 = dArray[i] - this.meanY();
                d += d2 * d3;
            }
            this.covariance = d / (double)(this.nMinusOne() ? n - 1 : n);
        }
        return this.covariance;
    }

    public double meanX() {
        if (Double.isNaN(this.meanX)) {
            double d = 0.0;
            double[] dArray = this.collectionX();
            for (int i = 0; i < dArray.length; ++i) {
                d += dArray[i];
            }
            this.meanX = d / (double)dArray.length;
        }
        return this.meanX;
    }

    public double meanY() {
        if (Double.isNaN(this.meanY)) {
            double d = 0.0;
            double[] dArray = this.collectionY();
            for (int i = 0; i < dArray.length; ++i) {
                d += dArray[i];
            }
            this.meanY = d / (double)dArray.length;
        }
        return this.meanY;
    }

    public boolean nMinusOne() {
        return this.nMinusOne;
    }

    public void nMinusOne_(boolean bl) {
        this.nMinusOne = bl;
    }

    public double standardDeviationX() {
        if (Double.isNaN(this.standardDeviationX)) {
            this.standardDeviationX = Math.sqrt(this.varianceX());
        }
        return this.standardDeviationX;
    }

    public double standardDeviationY() {
        if (Double.isNaN(this.standardDeviationY)) {
            this.standardDeviationY = Math.sqrt(this.varianceY());
        }
        return this.standardDeviationY;
    }

    public double varianceX() {
        if (Double.isNaN(this.varianceX)) {
            double d = 0.0;
            double[] dArray = this.collectionX();
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                double d2 = dArray[i] - this.meanX();
                d += d2 * d2;
            }
            this.varianceX = d / (double)(this.nMinusOne() ? n - 1 : n);
        }
        return this.varianceX;
    }

    public double varianceY() {
        if (Double.isNaN(this.varianceY)) {
            double d = 0.0;
            double[] dArray = this.collectionY();
            int n = dArray.length;
            for (int i = 0; i < dArray.length; ++i) {
                double d2 = dArray[i] - this.meanY();
                d += d2 * d2;
            }
            this.varianceY = d / (double)(this.nMinusOne() ? n - 1 : n);
        }
        return this.varianceY;
    }
}

